/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.maihe.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.maihe.domain.dis.DisChannelReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractproDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsGoodsRelReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.sg.SgSendgoodsLogReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhGoodsBean;
import com.yqbsoft.laser.service.ext.maihe.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.maihe.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.maihe.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.oc.OcEsbContractRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.oc.OcRefundRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.oc.OcSapContractRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.sg.SgSendgoodsLogRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.sg.SgSendgoodsRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.wh.WhFreightFeeRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.request.wh.WhStockStateFeeRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oc.EsbContractResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oc.OcContractResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oc.OcRefundResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oc.SapContractResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.sg.SgSendgoodsLogResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.sg.SgSendgoodsResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.wh.WhFreightFeeResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.wh.WhStockStateResponse;
import com.yqbsoft.laser.service.ext.maihe.service.BusOrderService;
import com.yqbsoft.laser.service.ext.maihe.supbase.OrderBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusOrderServiceImpl
extends OrderBaseService
implements BusOrderService {
    private String SYS_CODE = "maihe.BusOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusOrderServiceImpl.class);
    private String ddcode = "order";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusOrder(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractDomain");
            return "error";
        }
        String tenantCode = ocContractDomain.getTenantCode();
        OcContractRequest ocContractRequest = new OcContractRequest();
        ocContractRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        this.makeOcContractReDomain(ocContractDomain);
        ocContractRequest.setOrgTenantCode(ocContractDomain.getTenantCode());
        String t = this.getTenantCodeBuUrl(ocContractRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            ocContractDomain.setTenantCode(t);
        }
        logger.info(this.SYS_CODE + ".sendSaveExGoods.req", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractRequest));
        OcContractResponse ocContractResponse = this.restTempfacade.execute(ocContractRequest);
        if (null == ocContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse");
            return "error";
        }
        if (!ocContractResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrder.ocContractResponse", (Object)ocContractResponse.getMsg());
            return ocContractResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String getFreight(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getFreight.param");
            return "error";
        }
        WhFreightFeeRequest whFreightFeeRequest = new WhFreightFeeRequest();
        whFreightFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        whFreightFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whFreightFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whFreightFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whFreightFeeRequest.getSendMap().put("areaStr", areaStr);
        whFreightFeeRequest.getSendMap().put("memberCode", memberCode);
        whFreightFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhFreightFeeResponse whFreightFeeResponse = this.restTempfacade.execute(whFreightFeeRequest);
        if (null == whFreightFeeResponse) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponse");
            return "error";
        }
        if (!whFreightFeeResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getFreight.whFreightFeeResponsemsg", (Object)whFreightFeeResponse.getMsg());
            return whFreightFeeResponse.getMsg();
        }
        return whFreightFeeResponse.getFreightFee().toString();
    }

    @Override
    public List<WhGoodsBean> getNewStockById(List<WhGoodsBean> whGoodsBeanList, String areaStr, String memberCode, String tenantCode) throws ApiException {
        if (ListUtil.isEmpty(whGoodsBeanList) || StringUtils.isBlank((String)areaStr) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getNewStockById.param");
            return null;
        }
        WhStockStateFeeRequest whStockStateFeeRequest = new WhStockStateFeeRequest();
        whStockStateFeeRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        whStockStateFeeRequest.setOrgTenantCode(tenantCode);
        String t = this.getTenantCodeBuUrl(whStockStateFeeRequest.getHost());
        if (StringUtils.isBlank((String)t)) {
            t = tenantCode;
        }
        whStockStateFeeRequest.getSendMap().put("whGoodsBeanList", JsonUtil.buildNormalBinder().toJson(whGoodsBeanList));
        whStockStateFeeRequest.getSendMap().put("areaStr", areaStr);
        whStockStateFeeRequest.getSendMap().put("memberCode", memberCode);
        whStockStateFeeRequest.getSendMap().put("tenantCode", tenantCode);
        WhStockStateResponse whStockStateResponse = this.restTempfacade.execute(whStockStateFeeRequest);
        if (null == whStockStateResponse) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse");
            return null;
        }
        if (!whStockStateResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".getNewStockById.whStockStateResponse", (Object)whStockStateResponse.getMsg());
            return null;
        }
        return whStockStateResponse.getWhGoodsBeanList();
    }

    private void makeOcContractReDomain(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return;
        }
        String memberCcode = ocContractDomain.getMemberCcode();
        if (StringUtils.isBlank((String)memberCcode)) {
            return;
        }
        DisChannelReDomain disChannelReDomain = this.getDisChannelByMemberCcode(memberCcode, ocContractDomain.getTenantCode());
        if (null == disChannelReDomain) {
            return;
        }
        ocContractDomain.setChannelCode(disChannelReDomain.getChannelOcode());
    }

    @Override
    public String sendSaveBusRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefund.ocRefundDomain");
            return "error";
        }
        String tenantCode = ocRefundDomain.getTenantCode();
        OcRefundRequest ocRefundRequest = new OcRefundRequest();
        ocRefundRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundRequest, (Object)ocRefundDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.e", (Object)e);
            return "error";
        }
        OcRefundResponse ocRefundResponse = this.restTempfacade.execute(ocRefundRequest);
        if (null == ocRefundResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse");
            return "error";
        }
        if (!ocRefundResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusRefund.ocRefundResponse", (Object)ocRefundResponse.getMsg());
            return ocRefundResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoods(SgSendgoodsReDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoods.sgSendgoodsDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        SgSendgoodsRequest sgSendgoodsRequest = new SgSendgoodsRequest();
        sgSendgoodsRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsRequest, (Object)sgSendgoodsDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.e", (Object)e);
            return "error";
        }
        SgSendgoodsResponse sgSendgoodsResponse = this.restTempfacade.execute(sgSendgoodsRequest);
        if (null == sgSendgoodsResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse");
            return "error";
        }
        if (!sgSendgoodsResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusWarehouse.sgSendgoodsResponse", (Object)sgSendgoodsResponse.getMsg());
            return sgSendgoodsResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusSendgoodsLog(SgSendgoodsLogReDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogDomain");
            return "error";
        }
        String tenantCode = sgSendgoodsLogDomain.getTenantCode();
        SgSendgoodsLogRequest sgSendgoodsLogRequest = new SgSendgoodsLogRequest();
        sgSendgoodsLogRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsLogRequest, (Object)sgSendgoodsLogDomain);
        }
        catch (Exception e) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.e", (Object)e);
            return "error";
        }
        SgSendgoodsLogResponse sgSendgoodsLogResponse = this.restTempfacade.execute(sgSendgoodsLogRequest);
        if (null == sgSendgoodsLogResponse) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse");
            return "error";
        }
        if (!sgSendgoodsLogResponse.getSuccess().booleanValue()) {
            logger.info(this.SYS_CODE + ".sendSaveBusSendgoodsLog.sgSendgoodsLogResponse", (Object)sgSendgoodsLogResponse.getMsg());
            return sgSendgoodsLogResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundToEsb(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefundToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbRefundUrl", "EsbRefundUrl");
        String EsbWarehouseCode = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, String> entryOrder = new HashMap<String, String>();
        entryOrder.put("entryOrderCode", ocRefundDomain.getRefundCode());
        entryOrder.put("orderType", "THRK");
        entryOrder.put("warehouseCode", EsbWarehouseCode);
        entryOrder.put("ownerCode", EsbOwnerCode);
        HashMap orderLines = new HashMap();
        ArrayList orderLineList = new ArrayList();
        List<OcRefundGoodsDomain> refundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        for (OcRefundGoodsDomain goods : refundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ownerCode", EsbOwnerCode);
                    orderLine.put("itemName", rsGoodsRelReDomain.getGoodsName());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("ownerCode", EsbOwnerCode);
            orderLine.put("itemName", goods.getGoodsName());
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getRefundGoodsNum());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("entryOrder", entryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendSaveBusRefundConfirmToEsb(OcRefundReDomain ocRefundDomain) {
        logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.ocRefundDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String KUNNR = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getDdFlag(ocRefundDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocSapContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcRefundGoodsDomain> ocRefundGoodsList = ocRefundDomain.getOcRefundGoodsDomainList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        for (OcRefundGoodsDomain goods : ocRefundGoodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocRefundDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG02");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("FKDAT", date);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    BigDecimal multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    orderLine.put("ACTPR", rsGoodsRelReDomain.getPricesetNprice());
                    orderLine.put("WRBTR", rsGoodsRelReDomain.getPricesetNprice().multiply(multiply));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocRefundDomain.getRefundCode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG02");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocSapContractRequest.setMap(map);
        ocSapContractRequest.setClientsecret(esbSecret);
        ocSapContractRequest.setClientid(esbKey);
        ocSapContractRequest.setHost(url);
        SapContractResponse sapContractResponse = invoicefacade.execute(ocSapContractRequest);
        if (null == sapContractResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusRefundConfirmToEsb.esbContractResponse");
            return "error";
        }
        if (!sapContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainToEsb(OcContractReDomain ocContractDomain) {
        String[] split;
        logger.error(this.SYS_CODE + ".sendContractDomainToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOrderUrl", "EsbOrderUrl");
        String EsbWarehouseCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        String EsbSourcePlatformCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSourcePlatformCode", "EsbSourcePlatformCode");
        String EsbLogisticsCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbLogisticsCode", "EsbLogisticsCode");
        String EsbShopNick = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbShopNick", "EsbShopNick");
        String EsbSenderInfo = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSenderInfo", "EsbSenderInfo");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap request = new HashMap();
        HashMap<String, Object> deliveryOrder = new HashMap<String, Object>();
        deliveryOrder.put("deliveryOrderCode", ocContractDomain.getContractBillcode());
        deliveryOrder.put("orderType", "XSDD");
        deliveryOrder.put("warehouseCode", EsbWarehouseCode);
        deliveryOrder.put("ownerCode", EsbOwnerCode);
        deliveryOrder.put("sourcePlatformCode", EsbSourcePlatformCode);
        deliveryOrder.put("logisticsCode", EsbLogisticsCode);
        deliveryOrder.put("shopNick", EsbShopNick);
        HashMap orderLines = new HashMap();
        Map senderInfo = new HashMap();
        if (StringUtils.isNotBlank((String)EsbSenderInfo)) {
            senderInfo = (Map)JsonUtil.buildNormalBinder().getJsonToMap(EsbSenderInfo, String.class, Object.class);
            deliveryOrder.put("senderInfo", senderInfo);
        }
        HashMap<String, String> receiverInfo = new HashMap<String, String>();
        receiverInfo.put("name", ocContractDomain.getGoodsReceiptMem());
        receiverInfo.put("mobile", ocContractDomain.getGoodsReceiptPhone());
        if (ListUtil.isNotEmpty(ocContractDomain.getOcContractproDomainList())) {
            for (OcContractproDomain ocContractproDomain : ocContractDomain.getOcContractproDomainList()) {
                String[] umAddressReDomain;
                if (!"address".equals(ocContractproDomain.getContractproKey()) || null == (umAddressReDomain = (UmAddressReDomain)JsonUtil.buildNormalBinder().getJsonToObject(ocContractproDomain.getContractproValue(), UmAddressReDomain.class))) continue;
                receiverInfo.put("province", umAddressReDomain.getProvinceName());
                receiverInfo.put("city", umAddressReDomain.getCityName());
                String detailAddress = "";
                if (StringUtils.isNotBlank((String)umAddressReDomain.getProvinceName())) {
                    detailAddress = umAddressReDomain.getProvinceName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getCityName())) {
                    detailAddress = detailAddress + umAddressReDomain.getCityName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getAreaName())) {
                    detailAddress = detailAddress + umAddressReDomain.getAreaName();
                }
                if (StringUtils.isNotBlank((String)umAddressReDomain.getRoadName())) {
                    detailAddress = detailAddress + umAddressReDomain.getRoadName();
                }
                receiverInfo.put("detailAddress", detailAddress);
            }
        }
        if (null == receiverInfo.get("detailAddress") && (split = ocContractDomain.getGoodsReceiptArrdess().split(",")).length > 3) {
            receiverInfo.put("province", split[0]);
            receiverInfo.put("city", split[1]);
            String detailAddress = "";
            for (String str : split) {
                detailAddress = detailAddress + str;
            }
            receiverInfo.put("detailAddress", detailAddress);
        }
        deliveryOrder.put("receiverInfo", receiverInfo);
        ArrayList orderLineList = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("itemCode", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("planQty", goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum()));
                    orderLineList.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("itemCode", goods.getSkuNo());
            orderLine.put("planQty", goods.getGoodsCamount());
            orderLineList.add(orderLine);
        }
        orderLines.put("orderLine", orderLineList);
        request.put("deliveryOrder", deliveryOrder);
        request.put("orderLines", orderLines);
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String sendContractDomainEndToEsb(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendContractDomainEndToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOderCancelUrl", "EsbOderCancelUrl");
        String EsbWarehouseCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWarehouseCode", "EsbWarehouseCode");
        String EsbOwnerCode = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOwnerCode", "EsbOwnerCode");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcEsbContractRequest ocEsbContractRequest = new OcEsbContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("warehouseCode", EsbWarehouseCode);
        request.put("ownerCode", EsbOwnerCode);
        request.put("orderCode", ocContractDomain.getContractBillcode());
        request.put("orderType", "XSDD");
        request.put("cancelType", "out");
        map.put("request", request);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        EsbContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    private static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyMMdd");
        return df.format(new Date());
    }

    @Override
    public String sendContractDomainConfirmToEsb(OcContractReDomain ocContractDomain) {
        logger.error(this.SYS_CODE + ".sendContractDomainConfirmToEsb.ocContractDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return "error";
        }
        String esbKey = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKey", "EsbKey");
        String esbSecret = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbSecret", "EsbSecret");
        String url = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbOutConfirmUrl", "EsbOutConfirmUrl");
        String KUNNR = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbKUNNR", "EsbKUNNR");
        String NAME1 = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbNAME1", "EsbNAME1");
        String LGORT = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbLGORT", "EsbLGORT");
        String WERKS = this.getDdFlag(ocContractDomain.getTenantCode(), "EsbWERKS", "EsbWERKS");
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        int POSEX = 0;
        for (OcContractGoodsDomain goods : goodsList) {
            if ("5".equals(goods.getGoodsPro())) {
                HashMap<String, Object> relmap = new HashMap<String, Object>();
                relmap.put("tenantCode", ocContractDomain.getTenantCode());
                relmap.put("goodsCode", goods.getGoodsCode());
                relmap.put("goodsRelType", "3");
                QueryResult<RsGoodsRelReDomain> relQueryResult = this.queryGoodsRelPage(relmap);
                if (null == relQueryResult && ListUtil.isEmpty((Collection)relQueryResult.getList())) {
                    logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse,relQueryResult is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
                    return "error";
                }
                for (RsGoodsRelReDomain rsGoodsRelReDomain : relQueryResult.getList()) {
                    HashMap<String, Object> orderLine = new HashMap<String, Object>();
                    orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
                    orderLine.put("POSEX", ++POSEX);
                    orderLine.put("AUART", "ZG01");
                    orderLine.put("KUNNR", KUNNR);
                    orderLine.put("NAME1", NAME1);
                    orderLine.put("FKDAT", date);
                    orderLine.put("MATNR", rsGoodsRelReDomain.getSkuNo());
                    orderLine.put("ARKTX", rsGoodsRelReDomain.getGoodsName());
                    BigDecimal multiply = goods.getGoodsCamount().multiply(rsGoodsRelReDomain.getGoodsRelNum());
                    orderLine.put("KWMENG", multiply);
                    orderLine.put("ACTPR", rsGoodsRelReDomain.getPricesetNprice());
                    orderLine.put("WRBTR", rsGoodsRelReDomain.getPricesetNprice().multiply(multiply));
                    orderLine.put("WERKS", WERKS);
                    orderLine.put("LGORT", LGORT);
                    list.add(orderLine);
                }
                continue;
            }
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", ++POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse esbContractResponse = invoicefacade.execute(ocEsbContractRequest);
        if (null == esbContractResponse) {
            logger.error(this.SYS_CODE + ".sendInvoice.esbContractResponse");
            return "error";
        }
        if (!esbContractResponse.getSuccess().booleanValue()) {
            return "error";
        }
        return "success";
    }

    public static void main(String[] args) {
        String esbKey = "WYDS-TRMF98BC";
        String esbSecret = "WYDS#@YFD";
        String url = "https://ipaasqas.rifeng.com.cn:31443/298153907928989696/SAP/ZR_SEND_ORDER_TO_SAP_C/1.0.0";
        String POSEX = "1";
        String KUNNR = "105911";
        String NAME1 = "\u7f8e\u5c45\u5e97";
        String LGORT = "9100";
        String WERKS = "1101";
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setGoodsReceiptArrdess("\u9655\u897f,\u5b9d\u9e21\u5e02,\u9648\u4ed3\u533a,\u78fb\u6eaa\u9547,\u6d4b\u8bd5");
        ocContractDomain.setGoodsReceiptMem("\u6d4b\u8bd5\u7528\u6237");
        ocContractDomain.setGoodsReceiptPhone("15515425755");
        ocContractDomain.setContractBillcode("DS2022081515040000003");
        ArrayList<OcContractGoodsDomain> goodsDomains = new ArrayList<OcContractGoodsDomain>();
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setSkuNo("1100012026");
        ocContractGoodsDomain.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain);
        OcContractGoodsDomain ocContractGoodsDomain2 = new OcContractGoodsDomain();
        ocContractGoodsDomain2.setSkuNo("1100020379");
        ocContractGoodsDomain2.setGoodsName("\u660e\u6746\u6dcb\u6d74\u82b1\u6d12");
        ocContractGoodsDomain2.setPricesetNprice(new BigDecimal(99));
        ocContractGoodsDomain2.setGoodsCamount(new BigDecimal("1"));
        goodsDomains.add(ocContractGoodsDomain2);
        ocContractDomain.setGoodsList(goodsDomains);
        Esbfacade invoicefacade = new Esbfacade(url, esbKey, esbSecret, null);
        OcSapContractRequest ocEsbContractRequest = new OcSapContractRequest();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        String date = BusOrderServiceImpl.getDate();
        for (OcContractGoodsDomain goods : goodsList) {
            HashMap<String, Object> orderLine = new HashMap<String, Object>();
            orderLine.put("BSTKD", ocContractDomain.getContractBillcode());
            orderLine.put("POSEX", POSEX);
            orderLine.put("AUART", "ZG01");
            orderLine.put("KUNNR", KUNNR);
            orderLine.put("NAME1", NAME1);
            orderLine.put("FKDAT", date);
            orderLine.put("MATNR", goods.getSkuNo());
            orderLine.put("ARKTX", goods.getGoodsName());
            orderLine.put("KWMENG", goods.getGoodsCamount());
            orderLine.put("ACTPR", goods.getPricesetNprice());
            orderLine.put("WRBTR", goods.getPricesetNprice().multiply(goods.getGoodsCamount()));
            orderLine.put("WERKS", WERKS);
            orderLine.put("LGORT", LGORT);
            list.add(orderLine);
        }
        map.put("list", list);
        System.out.println(JsonUtil.buildNormalBinder().toJson(map));
        ocEsbContractRequest.setMap(map);
        ocEsbContractRequest.setClientsecret(esbSecret);
        ocEsbContractRequest.setClientid(esbKey);
        ocEsbContractRequest.setHost(url);
        SapContractResponse execute = invoicefacade.execute(ocEsbContractRequest);
        if (null == execute) {
            System.out.println("null");
        }
        if (!execute.getSuccess().booleanValue()) {
            System.out.println("error");
        }
        System.out.println(execute.getDataObj());
    }
}

