/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.maihe.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.maihe.api.ExStoreService;
import com.yqbsoft.laser.service.ext.maihe.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.crp.CrpUrechargeDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.crp.CrpUrechargelistDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.pm.PmPromotionDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebPointsReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebPointsUsersDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebUpointsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.reb.RebUpointsListDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsBrandDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.vd.VdFaccountOuterDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.vd.VdFaccountOuterDtDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.vd.VdFaccountOuterSubset;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhOpstoreDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhOpstoreReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhWarehouseDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.wh.WhWarehouseReDomain;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oa.OaActiveResponse;
import com.yqbsoft.laser.service.ext.maihe.supbase.StoreBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ExStoreServiceImpl
extends StoreBaseService
implements ExStoreService {
    private String SYS_CODE = "maihe.ExStoreServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExStoreServiceImpl.class);

    @Override
    public String sendSaveExWarehouse(WhWarehouseDomain whWarehouseDomain) {
        if (null == whWarehouseDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.whWarehouseDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.whWarehouseDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkWarehouse(whWarehouseDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.msg", msg);
        }
        String tenantCode = whWarehouseDomain.getTenantCode();
        whWarehouseDomain.setMemberCode(this.getTeananMemberCode(tenantCode));
        whWarehouseDomain.setMemberName("\u5e73\u53f0");
        try {
            String warehouseCode = this.saveWarehouse(whWarehouseDomain);
            if (StringUtils.isBlank((String)warehouseCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExWarehouse.warehouseCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.warehouseCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(warehouseCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExWarehouse.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExWarehouse.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExOpstore(WhOpstoreDomain whOpstoreDomain) {
        if (null == whOpstoreDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkOpstore(whOpstoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.checkOpstore");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.checkOpstore", msg);
        }
        try {
            msg = this.makeWhOpstoreDomain(whOpstoreDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExOpstore.makeWhOpstoreDomain", (Object)msg);
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.makeWhOpstoreDomain", msg);
            }
            String opstoreCode = this.sendSaveOpstore(whOpstoreDomain);
            if (StringUtils.isBlank((String)opstoreCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOpstore.opstoreCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.opstoreCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(opstoreCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.e1", e.getMessage());
        }
    }

    @Override
    public WhWarehouseReDomain queryExOpstore(String warehouseCode, String warehouseOcode, String tenantCode) {
        return this.getWarehouse(warehouseCode, warehouseOcode, tenantCode);
    }

    @Override
    public String activeAudit(String data) {
        logger.info(this.SYS_CODE + ".activeAudit", (Object)data);
        if (StringUtils.isEmpty((String)data)) {
            logger.error(this.SYS_CODE + ".activeAudit.resStream", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.resStream", "\u6570\u636e\u4e3a\u7a7a");
        }
        OaActiveResponse oaActiveResponse = (OaActiveResponse)JsonUtil.buildNormalBinder().getJsonToObject(data, OaActiveResponse.class);
        if (null == oaActiveResponse) {
            logger.error(this.SYS_CODE + ".activeAudit.oaActiveResponse", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.oaActiveResponse", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)oaActiveResponse.getRouterlogCode())) {
            logger.error(this.SYS_CODE + ".activeAudit.oaActiveResponse", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.oaActiveResponse", "\u6d41\u6c34\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)oaActiveResponse.getDataState())) {
            logger.error(this.SYS_CODE + ".activeAudit.oaActiveResponse", (Object)data);
            return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.oaActiveResponse", "\u5ba1\u6838\u72b6\u6001\u4e3a\u7a7a");
        }
        String tenantCode = "796758877233610836";
        LogRouterlogDomain logRouterlogDomain = this.queryLog(oaActiveResponse.getRouterlogCode(), tenantCode);
        if (null == logRouterlogDomain) {
            logger.error(this.SYS_CODE + ".activeAudit.queryLog.isnull");
            return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.queryLog.msg", "DMS\u672a\u627e\u5230\u6d41\u6c34\u4fe1\u606f");
        }
        if ("10".equals(logRouterlogDomain.getRouterlogType())) {
            RebUpointsListDomain rebUpointsList = this.getRebUpointsList(logRouterlogDomain.getRouterlogMespid(), tenantCode);
            if (null == rebUpointsList) {
                logger.error(this.SYS_CODE + ".activeAudit.getRebUpointsList.isnull");
                return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.getRebUpointsList.msg", "DMS\u672a\u627e\u5230\u8fd4\u5229\u53d1\u653e\u5355\u4fe1\u606f");
            }
            this.updateUpointsListState(rebUpointsList.getUpointsListId(), Integer.valueOf(oaActiveResponse.getDataState()), null, new HashMap<String, Object>());
            if ("2".equals(oaActiveResponse.getDataState())) {
                return this.makeSuccessReturn("\u64cd\u4f5c\u6210\u529f");
            }
            RsBrandDomain brandByName = this.getBrandByName(rebUpointsList.getUpointsListOpcode1(), rebUpointsList.getTenantCode());
            if (brandByName == null) {
                return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.getBrandByName.msg", "DMS\u672a\u627e\u5230\u54c1\u724c\u4fe1\u606f");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("memberCode", brandByName.getMemberCode());
            map.put("userinfoCode", rebUpointsList.getUpointsClearCode());
            QueryResult<RebUpointsDomain> rebUpointsDomainQueryResult = this.queryUpointsPage(map);
            if (rebUpointsDomainQueryResult == null || CollectionUtils.isEmpty((Collection)rebUpointsDomainQueryResult.getList())) {
                RebUpointsDomain rebUpointsDomain = (RebUpointsDomain)rebUpointsDomainQueryResult.getList().get(0);
                BigDecimal oldUpointsNum = rebUpointsDomain.getUpointsNum();
                rebUpointsDomain.setUpointsNum(rebUpointsDomain.getUpointsNum().add(rebUpointsList.getUpointsBfonum()));
                RebUpointsListDomain rebUpointsListDomain = new RebUpointsListDomain();
                rebUpointsListDomain.setUpointsType("4");
                rebUpointsListDomain.setUpointsBfnum(oldUpointsNum);
                rebUpointsListDomain.setUpointsAfnum(rebUpointsDomain.getUpointsNum());
                rebUpointsListDomain.setUpointsListNum(rebUpointsList.getUpointsBfonum());
                rebUpointsListDomain.setUpointsListDirection("2");
                rebUpointsListDomain.setPointsRuleCode(rebUpointsList.getUpointsListCode());
                rebUpointsListDomain.setTenantCode(rebUpointsDomain.getTenantCode());
                rebUpointsListDomain.setUpointsListOpcode(rebUpointsList.getUpointsListOpcode());
                rebUpointsListDomain.setUpointsListOpcode1(rebUpointsList.getUpointsListOpcode1());
                this.saveUpointsList(rebUpointsListDomain);
                this.updateUpoints(rebUpointsDomain);
            }
        } else if ("3".equals(logRouterlogDomain.getRouterlogType()) || "1".equals(logRouterlogDomain.getRouterlogType()) || "2".equals(logRouterlogDomain.getRouterlogType())) {
            RebPointsReDomain rebPointsDomain = this.getPointsByCode(logRouterlogDomain.getRouterlogMespid(), tenantCode);
            if (null == rebPointsDomain) {
                logger.error(this.SYS_CODE + ".activeAudit.getPointsByCode.isnull");
                return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.getPointsByCode.msg", "DMS\u672a\u627e\u5230\u5355\u636e\u4fe1\u606f");
            }
            if (rebPointsDomain.getDataState() != 0) {
                logger.error(this.SYS_CODE + ".activeAudit.getPointsByCode.dataState", (Object)rebPointsDomain.getDataState());
                return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.getPointsByCode.dataState", "DMS\u6d3b\u52a8\u8d39\u7528\u6838\u9500\u5ba1\u6838\u5df2\u5ba1\u6838\u901a\u8fc7");
            }
            this.updatePointsState(rebPointsDomain.getPointsId(), Integer.valueOf(oaActiveResponse.getDataState()), null, new HashMap<String, Object>());
            if ("2".equals(oaActiveResponse.getDataState())) {
                return this.makeSuccessReturn("\u64cd\u4f5c\u6210\u529f");
            }
            if ("3".equals(logRouterlogDomain.getRouterlogType())) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("pointsCode", rebPointsDomain.getPointsCode());
                map.put("tenantCode", rebPointsDomain.getTenantCode());
                QueryResult<RebPointsUsersDomain> rebPointsUsersDomainQueryResult = this.queryRebPointsUsersPage(map);
                if (rebPointsUsersDomainQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebPointsUsersDomainQueryResult.getList())) {
                    for (RebPointsUsersDomain rebPointsUsersDomain : rebPointsUsersDomainQueryResult.getList()) {
                        HashMap<String, Object> vdMap;
                        RsBrandDomain brandByName = this.getBrandByName(rebPointsDomain.getFchannelClassifyName(), rebPointsDomain.getTenantCode());
                        if (brandByName == null) {
                            return this.makeErrorReturn(this.SYS_CODE + ".activeAudit.getBrandByName.msg", "DMS\u672a\u627e\u5230\u54c1\u724c\u4fe1\u606f");
                        }
                        if (rebPointsUsersDomain.getPointsuserUserRatio1() != null && rebPointsUsersDomain.getPointsuserUserRatio1().compareTo(BigDecimal.ZERO) != 0) {
                            vdMap = new HashMap<String, Object>();
                            vdMap.put("merchantCode", rebPointsUsersDomain.getPointsUserOp());
                            vdMap.put("memberCode", brandByName.getMemberCode());
                            vdMap.put("faccountType", "201");
                            QueryResult<VdFaccountOuterDomain> vdFaccountInfoQueryResult = this.queryFaccountOuterPage(vdMap);
                            if (vdFaccountInfoQueryResult != null && CollectionUtils.isNotEmpty((Collection)vdFaccountInfoQueryResult.getList())) {
                                logger.info(this.SYS_CODE + ".queryFaccountOuterPage", (Object)JsonUtil.buildNormalBinder().toJson((Object)vdFaccountInfoQueryResult.getList()));
                                VdFaccountOuterDomain vdFaccountOuterDomain = (VdFaccountOuterDomain)vdFaccountInfoQueryResult.getList().get(0);
                                BigDecimal oldFaccountAmount = vdFaccountOuterDomain.getFaccountAmount();
                                vdFaccountOuterDomain.setFaccountAmount(vdFaccountOuterDomain.getFaccountAmount().add(rebPointsUsersDomain.getPointsuserUserRatio1()));
                                this.updateFaccountOuter(vdFaccountOuterDomain);
                                HashMap<String, Object> vdSubMap = new HashMap<String, Object>();
                                vdSubMap.put("faccountOuterNo", vdFaccountOuterDomain.getFaccountOuterNo());
                                vdSubMap.put("fundType", vdFaccountOuterDomain.getFundType());
                                QueryResult<VdFaccountOuterSubset> vdFaccountOuterSubsetQueryResult = this.queryFaccountOuterSubsetPage(vdSubMap);
                                if (vdFaccountOuterSubsetQueryResult != null && !CollectionUtils.isEmpty((Collection)vdFaccountOuterSubsetQueryResult.getList())) {
                                    VdFaccountOuterSubset vdFaccountOuterSubset = (VdFaccountOuterSubset)vdFaccountOuterSubsetQueryResult.getList().get(0);
                                    vdFaccountOuterSubset.setFaccountAmount(vdFaccountOuterSubset.getFaccountAmount().add(rebPointsUsersDomain.getPointsuserUserRatio1()));
                                    this.updateFaccountOuterSubset(vdFaccountOuterSubset);
                                }
                                VdFaccountOuterDtDomain vdFaccountOuterDtDomain = new VdFaccountOuterDtDomain();
                                try {
                                    vdFaccountOuterDtDomain.setFaccountingDate(DateUtils.parseDateToString((Date)new Date(), (String)"yyyyMMdd"));
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                }
                                vdFaccountOuterDtDomain.setFaccountOuterNo(vdFaccountOuterDomain.getFaccountOuterNo());
                                vdFaccountOuterDtDomain.setFaccountOuterName("\u57fa\u672c\u6237");
                                vdFaccountOuterDtDomain.setFaccountTitileCode("2001002001");
                                vdFaccountOuterDtDomain.setPaymentOrderMemo(rebPointsDomain.getPointsCode());
                                vdFaccountOuterDtDomain.setCurrencyCode("01");
                                vdFaccountOuterDtDomain.setFundType("01");
                                if (rebPointsUsersDomain.getPointsuserUserRatio1().compareTo(BigDecimal.ZERO) > 0) {
                                    vdFaccountOuterDtDomain.setOrderDc("2");
                                } else {
                                    vdFaccountOuterDtDomain.setOrderDc("1");
                                }
                                vdFaccountOuterDtDomain.setOrderAmount(rebPointsUsersDomain.getPointsuserUserRatio1());
                                vdFaccountOuterDtDomain.setFaccountBfamount(oldFaccountAmount);
                                vdFaccountOuterDtDomain.setFaccountAfamount(vdFaccountOuterDomain.getFaccountAmount());
                                vdFaccountOuterDtDomain.setTenantCode(vdFaccountOuterDomain.getTenantCode());
                                vdFaccountOuterDtDomain.setBusinessType("1");
                                vdFaccountOuterDtDomain.setTxnDscpt(vdFaccountOuterDomain.getFaccountReqno());
                                vdFaccountOuterDtDomain.setMemberCode(brandByName.getMemberCode());
                                vdFaccountOuterDtDomain.setMemberName(brandByName.getBrandName());
                                this.saveFaccountOuterDt(vdFaccountOuterDtDomain);
                            }
                        }
                        if (rebPointsUsersDomain.getPointsuserUserRatio3() != null && rebPointsUsersDomain.getPointsuserUserRatio3().compareTo(BigDecimal.ZERO) != 0) {
                            vdMap = new HashMap();
                            vdMap.put("userinfoCode", rebPointsUsersDomain.getPointsUserOp());
                            vdMap.put("memberCode", brandByName.getMemberCode());
                            QueryResult<RebUpointsDomain> rebUpointsDomainQueryResult = this.queryUpointsPage(vdMap);
                            if (rebUpointsDomainQueryResult != null && CollectionUtils.isNotEmpty((Collection)rebUpointsDomainQueryResult.getList())) {
                                RebUpointsDomain rebUpointsDomain = (RebUpointsDomain)rebUpointsDomainQueryResult.getList().get(0);
                                BigDecimal oldUpointsNum = rebUpointsDomain.getUpointsNum();
                                rebUpointsDomain.setUpointsNum(rebUpointsDomain.getUpointsNum().add(rebPointsUsersDomain.getPointsuserUserRatio3()));
                                this.updateUpoints(rebUpointsDomain);
                                RebUpointsListDomain rebUpointsListDomain = new RebUpointsListDomain();
                                rebUpointsListDomain.setUpointsType("1");
                                rebUpointsListDomain.setUpointsBfnum(oldUpointsNum);
                                rebUpointsListDomain.setUpointsAfnum(rebUpointsDomain.getUpointsNum());
                                if (rebPointsUsersDomain.getPointsuserUserRatio3().compareTo(BigDecimal.ZERO) > 0) {
                                    rebUpointsListDomain.setUpointsListDirection("2");
                                } else {
                                    rebUpointsListDomain.setUpointsListDirection("1");
                                }
                                rebUpointsListDomain.setUpointsListNum(rebPointsUsersDomain.getPointsuserUserRatio3());
                                rebUpointsListDomain.setPointsRuleCode(rebPointsDomain.getPointsCode());
                                rebUpointsListDomain.setTenantCode(rebPointsDomain.getTenantCode());
                                rebUpointsListDomain.setUpointsListOpcode(rebPointsDomain.getFchannelClassifyCode());
                                rebUpointsListDomain.setUpointsListOpcode1(rebPointsDomain.getFchannelClassifyName());
                                rebUpointsListDomain.setUpointsListOpcode2(rebUpointsDomain.getPointsUserqua());
                                rebUpointsListDomain.setUpointsClearCode(rebPointsUsersDomain.getPointsUserOp());
                                this.saveUpointsList(rebUpointsListDomain);
                            }
                        }
                        if (rebPointsUsersDomain.getPointsuserUserRatio2() == null || rebPointsUsersDomain.getPointsuserUserRatio2().compareTo(BigDecimal.ZERO) == 0) continue;
                        HashMap<String, Object> crpMap = new HashMap<String, Object>();
                        crpMap.put("userinfoCode", rebPointsUsersDomain.getPointsUserOp());
                        crpMap.put("tenantCode", rebPointsDomain.getTenantCode());
                        crpMap.put("memberCode", brandByName.getMemberCode());
                        QueryResult<CrpUrechargeDomain> queryResult = this.queryCrpUrechargePage(crpMap);
                        if (queryResult == null || !CollectionUtils.isNotEmpty((Collection)queryResult.getList())) continue;
                        CrpUrechargeDomain crpUrechargeDomain = (CrpUrechargeDomain)queryResult.getList().get(0);
                        BigDecimal smoney = crpUrechargeDomain.getRechargeSmoney();
                        crpUrechargeDomain.setRechargeAllmoney(crpUrechargeDomain.getRechargeAllmoney().add(rebPointsUsersDomain.getPointsuserUserRatio2()));
                        crpUrechargeDomain.setRechargeSmoney(crpUrechargeDomain.getRechargeSmoney().add(rebPointsUsersDomain.getPointsuserUserRatio2()));
                        this.updateCrpUrechargeByPriKey(crpUrechargeDomain);
                        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
                        if (rebPointsUsersDomain.getPointsuserUserRatio2().compareTo(BigDecimal.ZERO) > 0) {
                            crpUrechargelistDomain.setUrechargelistDir("2");
                        } else {
                            crpUrechargelistDomain.setUrechargelistDir("1");
                        }
                        crpUrechargelistDomain.setRechargeOpno(rebPointsDomain.getPointsCode());
                        crpUrechargelistDomain.setRechargeAllmoney(smoney);
                        crpUrechargelistDomain.setRechargeSmoney(crpUrechargeDomain.getRechargeSmoney());
                        crpUrechargelistDomain.setRechargeType("1");
                        crpUrechargelistDomain.setUserinfoCode(rebPointsUsersDomain.getPointsUserOp());
                        crpUrechargelistDomain.setRechargeOpno3(brandByName.getBrandName());
                        crpUrechargelistDomain.setRechargeOpno4(crpUrechargeDomain.getRechargeName1());
                        crpUrechargelistDomain.setTenantCode(crpUrechargeDomain.getTenantCode());
                        this.saveCrpUrechargelist(crpUrechargelistDomain);
                    }
                }
            }
        } else if ("4".equals(logRouterlogDomain.getRouterlogType())) {
            if (logRouterlogDomain.getRouterlogMespid().startsWith("E")) {
                if ("2".equals(oaActiveResponse.getDataState())) {
                    this.updateEActiveStatus(logRouterlogDomain.getTenantCode(), logRouterlogDomain.getRouterlogMespid().substring(1), 2, 0);
                } else {
                    this.updateEActiveStatus(logRouterlogDomain.getTenantCode(), logRouterlogDomain.getRouterlogMespid().substring(1), 1, 0);
                }
            } else {
                PmPromotionDomain pmPromotionDomain = this.getPromotionByCode(logRouterlogDomain.getRouterlogMespid(), tenantCode);
                if ("2".equals(oaActiveResponse.getDataState())) {
                    this.updateActiveStatus(pmPromotionDomain.getPromotionId(), 5, 0);
                } else {
                    this.updateActiveStatus(pmPromotionDomain.getPromotionId(), 4, 0);
                }
            }
        }
        return this.makeSuccessReturn("\u64cd\u4f5c\u6210\u529f");
    }

    private RsBrandDomain getBrandByName(String brandName, String tenantCode) {
        if (StringUtils.isBlank((String)brandName) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".getBrandByName.null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("brandName", brandName);
        param.put("tenantCode", tenantCode);
        return (RsBrandDomain)this.getForObject("rs.brand.getBrandByName", RsBrandDomain.class, param);
    }

    private PmPromotionDomain getPromotionByCode(String promotionCode, String tenantCode) {
        if (StringUtils.isBlank((String)promotionCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "pm.PmPromotion.getPromotionByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("promotionCode", promotionCode);
        paramMap.put("tenantCode", tenantCode);
        return (PmPromotionDomain)this.getForObject(apiCode, PmPromotionDomain.class, paramMap);
    }

    private void updateActiveStatus(Integer promotionId, Integer dataState, Integer oldDataState) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("promotionId", promotionId);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        this.internalInvoke("pm.channelsendBase.sendUpdatePromotionState", paramMap);
    }

    private void updateEActiveStatus(String tenantCode, String promotionEditCode, Integer dataState, Integer oldDataState) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("promotionEditCode", promotionEditCode);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        this.internalInvoke("pm.channelsendBase.sendPromotionEditStateByCode", paramMap);
    }

    private String saveCrpUrechargelist(CrpUrechargelistDomain crpUrechargelistDomain) {
        String apiCode = "crp.send.saveCrpUrechargelist";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("crpUrechargelistDomain", JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
        return this.internalInvoke(apiCode, map);
    }

    private void updateCrpUrechargeByPriKey(CrpUrechargeDomain crpUrechargeDomain) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("crpUrechargeDomain", JsonUtil.buildNormalBinder().toJson((Object)crpUrechargeDomain));
        this.internalInvoke("crp.send.updateCrpUrechargeByPriKey", paramMap);
    }

    private QueryResult<CrpUrechargeDomain> queryCrpUrechargePage(Map<String, Object> map) {
        if (map == null) {
            logger.error(this.SYS_CODE + ".getCrpAccount.null");
            logger.error(this.SYS_CODE + ".sendUpdateExUserUserinfo.saveOpenAccout.getCrpAccount\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApiException("Crp\u7f3a\u5c11\u8d26\u6237\u67e5\u8be2\u6570\u636e");
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("crp.send.queryCrpUrechargePage", paramMap, CrpUrechargeDomain.class);
    }

    private String saveUpointsList(RebUpointsListDomain rebUpointsListDomain) {
        String apiCode = "reb.upoints.saveUpointsList";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rebUpointsListDomain", JsonUtil.buildNormalBinder().toJson((Object)rebUpointsListDomain));
        return this.internalInvoke(apiCode, map);
    }

    private void updateFaccountOuter(VdFaccountOuterDomain vdFaccountOuterDomain) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("vdFaccountOuterDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterDomain));
        this.internalInvoke("vd.faccountOuter.updateFaccountOuter", paramMap);
    }

    private QueryResult<VdFaccountOuterSubset> queryFaccountOuterSubsetPage(Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("vd.faccountOuter.queryFaccountOuterSubsetPage", paramMap, VdFaccountOuterSubset.class);
    }

    private void updateFaccountOuterSubset(VdFaccountOuterSubset vdFaccountOuterSubsetDomain) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("vdFaccountOuterSubsetDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterSubsetDomain));
        this.internalInvoke("vd.faccountOuter.updateFaccountOuterSubset", paramMap);
    }

    private void saveFaccountOuterDt(VdFaccountOuterDtDomain vdFaccountOuterDtDomain) {
        if (null == vdFaccountOuterDtDomain) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("vdFaccountOuterDtDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterDtDomain));
        this.inAsyncInvoke("vd.faccountOuter.saveFaccountOuterDt", paramMap);
    }

    private QueryResult<VdFaccountOuterDomain> queryFaccountOuterPage(Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("vd.faccountOuter.queryFaccountOuterPage", paramMap, VdFaccountOuterDomain.class);
    }

    private QueryResult<RebPointsUsersDomain> queryRebPointsUsersPage(Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("reb.rebPointsUsers.queryRebPointsUsersPage", paramMap, RebPointsUsersDomain.class);
    }

    private QueryResult<RebUpointsDomain> queryUpointsPage(Map<String, Object> map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.sendReSupObject("reb.upoints.queryUpointsPage", paramMap, RebUpointsDomain.class);
    }

    private void updateUpoints(RebUpointsDomain rebUpointsDomain) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("rebUpointsDomain", JsonUtil.buildNormalBinder().toJson((Object)rebUpointsDomain));
        this.internalInvoke("reb.upoints.updateUpoints", paramMap);
    }

    private void updateUpointsState(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        String apiCode = "reb.upoints.updateUpointsState";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("upointsId", upointsId);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    private RebPointsReDomain getPointsByCode(String pointsCode, String tenantCode) {
        if (StringUtils.isBlank((String)pointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "reb.points.getPointsByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("pointsCode", pointsCode);
        paramMap.put("tenantCode", tenantCode);
        return (RebPointsReDomain)this.getForObject(apiCode, RebPointsReDomain.class, paramMap);
    }

    private void updateUpointsListState(Integer upointsListId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        String apiCode = "reb.upoints.updateUpointsListState";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("upointsListId", upointsListId);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    private void updatePointsState(Integer pointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        String apiCode = "reb.points.updatePointsState";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("pointsId", pointsId);
        paramMap.put("dataState", dataState);
        paramMap.put("oldDataState", oldDataState);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        this.internalInvoke(apiCode, paramMap);
    }

    private RebUpointsListDomain getRebUpointsList(String upointsListCode, String tenantCode) {
        if (StringUtils.isBlank((String)upointsListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String apiCode = "reb.upoints.getUpointsListByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("upointsListCode", upointsListCode);
        paramMap.put("tenantCode", tenantCode);
        return (RebUpointsListDomain)this.getForObject(apiCode, RebUpointsListDomain.class, paramMap);
    }

    public LogRouterlogDomain queryLog(String logRouterCode, String tenantCode) {
        String apiCode = "log.logRouterlog.queryRouterlogPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("routerlogMesid", logRouterCode);
        map.put("tenantCode", tenantCode);
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult qlist = this.sendReSupObject(apiCode, paramMap, LogRouterlogDomain.class);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        return (LogRouterlogDomain)qlist.getList().get(0);
    }

    @Override
    public String sendSaveExOpstoreByEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveExOpstoreByEsb.map", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        logger.error(this.SYS_CODE + ".sendSaveExOpstoreByEsb.tenantCode", (Object)tenantCode);
        if (MapUtil.isEmpty(resStream)) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        WhOpstoreDomain whOpstoreDomain = (WhOpstoreDomain)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), WhOpstoreDomain.class);
        if (null == whOpstoreDomain || StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            logger.error(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreCode())) {
            whOpstoreDomain.setOpstoreNcode(whOpstoreDomain.getOpstoreCode());
            whOpstoreDomain.setOpstoreCode(null);
        }
        whOpstoreDomain.setTenantCode(tenantCode);
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsType())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.storeGoodsType", "\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (ListUtil.isEmpty(whOpstoreDomain.getWhOpstoreSkuDomainList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain", "whOpstoreSkuDomainList\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("opstoreOcode", whOpstoreDomain.getOpstoreOcode());
        QueryResult<WhOpstoreReDomain> queryResult = this.queryOpstorePage(map);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.opstoreOcode", "\u6570\u636e\u5df2\u7ecf\u5b58\u5728");
        }
        for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreDomain.getWhOpstoreSkuDomainList()) {
            if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.whOpstoreSkuDomainList.skuNo", "skuNo\u53c2\u6570\u4e3a\u7a7a");
            }
            if (null == whOpstoreSkuDomain.getGoodsNum()) {
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOpstore.whOpstoreDomain.whOpstoreSkuDomainList.goodsNum", "goodsNum\u53c2\u6570\u4e3a\u7a7a");
            }
            whOpstoreSkuDomain.setTenantCode(tenantCode);
            whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
        }
        String code = this.sendSaveOpstoreTwo(whOpstoreDomain);
        return this.makeSuccessReturn(code);
    }

    private String makeWhOpstoreDomain(WhOpstoreDomain whOpstoreDomain) {
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList;
        if (null == whOpstoreDomain) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreDomain");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        HashMap<String, WhWarehouseReDomain> waMap = new HashMap<String, WhWarehouseReDomain>();
        HashMap<String, WhWarehouseReDomain> owaMap = new HashMap<String, WhWarehouseReDomain>();
        WhWarehouseReDomain whWarehouseReDomain = this.getWarehouse(whOpstoreDomain.getWarehouseCode(), whOpstoreDomain.getWarehouseOcode(), whOpstoreDomain.getTenantCode());
        owaMap.put(whWarehouseReDomain.getWarehouseOcode(), whWarehouseReDomain);
        waMap.put(whWarehouseReDomain.getWarehouseCode(), whWarehouseReDomain);
        whOpstoreDomain.setWarehouseCode(whWarehouseReDomain.getWarehouseCode());
        whOpstoreDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
        if (StringUtils.isBlank((String)whOpstoreDomain.getMemberCode())) {
            whOpstoreDomain.setMemberCode(whWarehouseReDomain.getMemberCode());
            whOpstoreDomain.setMemberName(whWarehouseReDomain.getMemberName());
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getMemberMcode())) {
            UmUserinfoReDomain umUserinfoReDomain = this.getUserinfoByCode(whOpstoreDomain.getMemberCode(), whOpstoreDomain.getTenantCode());
            if (null == umUserinfoReDomain) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.umUserinfoReDomain", (Object)(whOpstoreDomain.getMemberCode() + "=" + whOpstoreDomain.getTenantCode()));
                return "\u8f6c\u6362\u7528\u6237\u4e3a\u7a7a";
            }
            whOpstoreDomain.setMemberMcode(umUserinfoReDomain.getUserinfoParentCode());
            whOpstoreDomain.setMemberMname(umUserinfoReDomain.getUserinfoParentName());
        }
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList())) {
            logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreGoodsDomainList", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode()));
            return "whOpstoreGoodsDomainList\u4e3a\u7a7a! ";
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String goodsClass = "plat";
        QueryResult<RsSkuDomain> queryResutl = null;
        RsSkuDomain rsSkuDomain = null;
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            String partsnameWeightunit;
            String partsnameNumunit1;
            String partsnameNumunit;
            BigDecimal goodsWeight;
            BigDecimal goodsNum1;
            BigDecimal goodsNum;
            String warehouseCode;
            whWarehouseReDomain = StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseCode()) ? (WhWarehouseReDomain)owaMap.get(whOpstoreGoodsDomain.getWarehouseOcode()) : (WhWarehouseReDomain)waMap.get(whOpstoreGoodsDomain.getWarehouseCode());
            if (null == whWarehouseReDomain) {
                whWarehouseReDomain = this.getWarehouse(whOpstoreGoodsDomain.getWarehouseCode(), whOpstoreGoodsDomain.getWarehouseOcode(), whOpstoreDomain.getTenantCode());
                if (null == whWarehouseReDomain) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whWarehouseReDomain", (Object)(whOpstoreGoodsDomain.getWarehouseOcode() + "=" + whOpstoreGoodsDomain.getWarehouseCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u4ed3\u5e93\u4ee3\u7801\u5f02\u5e38! ";
                }
                owaMap.put(whWarehouseReDomain.getWarehouseOcode(), whWarehouseReDomain);
                waMap.put(whWarehouseReDomain.getWarehouseCode(), whWarehouseReDomain);
            }
            whOpstoreGoodsDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
            whOpstoreGoodsDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
            whOpstoreGoodsDomain.setWarehouseCode(whWarehouseReDomain.getWarehouseCode());
            whOpstoreGoodsDomain.setWarehouseName(whWarehouseReDomain.getWarehouseName());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.whOpstoreSkuDomainList", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode()));
                return "whOpstoreSkuDomainList\u4e3a\u7a7a! ";
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                paramMap.put("goodsClass", goodsClass);
                paramMap.put("skuNo", whOpstoreSkuDomain.getSkuNo());
                paramMap.put("memberCode", whOpstoreDomain.getMemberCode());
                paramMap.put("tenantCode", whOpstoreDomain.getTenantCode());
                queryResutl = this.queryRsSkuPage(paramMap);
                if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.queryResutl", (Object)(whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "sku\u4e3a\u7a7a! " + paramMap.toString();
                }
                rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                rsResourceGoodsReDomain = this.getGoodsByCode(rsSkuDomain.getGoodsCode(), whOpstoreDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.rsResourceGoodsReDomain", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "goods\u4e3a\u7a7a! " + paramMap.toString();
                }
                warehouseCode = whOpstoreSkuDomain.getWarehouseCode();
                goodsNum = whOpstoreSkuDomain.getGoodsNum();
                goodsNum1 = whOpstoreSkuDomain.getGoodsNum1();
                goodsWeight = whOpstoreSkuDomain.getGoodsWeight();
                partsnameNumunit = whOpstoreSkuDomain.getPartsnameNumunit();
                partsnameNumunit1 = whOpstoreSkuDomain.getPartsnameNumunit1();
                partsnameWeightunit = whOpstoreSkuDomain.getPartsnameWeightunit();
                try {
                    BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.copysku", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u7cfb\u7edf\u5f02\u5e38! ";
                }
                whOpstoreSkuDomain.setStoreGoodsBtype(whOpstoreDomain.getStoreGoodsBtype());
                whOpstoreSkuDomain.setStoreGoodsType(whOpstoreDomain.getStoreGoodsType());
                whOpstoreSkuDomain.setWarehouseCode(whOpstoreGoodsDomain.getWarehouseCode());
                whOpstoreSkuDomain.setWarehouseName(whOpstoreGoodsDomain.getWarehouseName());
                whOpstoreSkuDomain.setGoodsNum(goodsNum);
                whOpstoreSkuDomain.setGoodsNum1(goodsNum1);
                whOpstoreSkuDomain.setGoodsWeight(goodsWeight);
                whOpstoreSkuDomain.setPartsnameNumunit(partsnameNumunit);
                whOpstoreSkuDomain.setPartsnameNumunit1(partsnameNumunit1);
                whOpstoreSkuDomain.setPartsnameWeightunit(partsnameWeightunit);
            }
            warehouseCode = whOpstoreGoodsDomain.getWarehouseCode();
            String warehouseName = whOpstoreGoodsDomain.getWarehouseName();
            goodsNum = whOpstoreGoodsDomain.getGoodsNum();
            goodsNum1 = whOpstoreGoodsDomain.getGoodsNum1();
            goodsWeight = whOpstoreGoodsDomain.getGoodsWeight();
            partsnameNumunit = whOpstoreGoodsDomain.getPartsnameNumunit();
            partsnameNumunit1 = whOpstoreGoodsDomain.getPartsnameNumunit1();
            partsnameWeightunit = whOpstoreGoodsDomain.getPartsnameWeightunit();
            try {
                BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, rsResourceGoodsReDomain);
            }
            catch (Exception e) {
                logger.error(this.SYS_CODE + ".makeWhOpstoreDomain.copyspu", (Object)(rsSkuDomain.getGoodsCode() + "=" + whOpstoreDomain.getOpstoreOcode() + "=" + whOpstoreDomain.getTenantCode() + "=" + paramMap.toString()));
                return "\u7cfb\u7edf\u5f02\u5e38! ";
            }
            whOpstoreGoodsDomain.setWarehouseCode(warehouseCode);
            whOpstoreGoodsDomain.setWarehouseName(warehouseName);
            whOpstoreGoodsDomain.setGoodsNum(goodsNum);
            whOpstoreGoodsDomain.setGoodsNum1(goodsNum1);
            whOpstoreGoodsDomain.setGoodsWeight(goodsWeight);
            whOpstoreGoodsDomain.setPartsnameNumunit(partsnameNumunit);
            whOpstoreGoodsDomain.setPartsnameNumunit1(partsnameNumunit1);
            whOpstoreGoodsDomain.setPartsnameWeightunit(partsnameWeightunit);
        }
        return null;
    }

    private WhWarehouseReDomain getWarehouse(String warehouseCode, String warehouseOcode, String tenantCode) {
        WhWarehouseReDomain whWarehouseReDomain;
        if (StringUtils.isBlank((String)warehouseCode)) {
            Map map = this.getQueryMapParam("warehouseOcode", new Object[]{warehouseOcode, tenantCode});
            QueryResult<WhWarehouseReDomain> qwh = this.queryWarehousePage(map);
            if (null == qwh || ListUtil.isEmpty((Collection)qwh.getList())) {
                logger.error(this.SYS_CODE + ".getWarehouse.getWarehouseCode", (Object)map);
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u4e3a\u7a7a");
            }
            if (qwh.getList().size() > 1) {
                logger.error(this.SYS_CODE + ".getWarehouse.qwh", (Object)map);
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u5f02\u5e38");
            }
            whWarehouseReDomain = (WhWarehouseReDomain)qwh.getList().get(0);
        } else {
            whWarehouseReDomain = this.getWarehouseByCode(warehouseCode, tenantCode);
            if (null == whWarehouseReDomain) {
                logger.error(this.SYS_CODE + ".getWarehouse.whWarehouseReDomain", (Object)(warehouseCode + "=" + tenantCode));
                throw new ApiException("\u8f6c\u6362\u4ed3\u5e93\u4e3a\u7a7a");
            }
        }
        return whWarehouseReDomain;
    }

    private String checkOpstore(WhOpstoreDomain whOpstoreDomain) {
        QueryResult<WhOpstoreReDomain> qwh;
        if (null == whOpstoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseCode()) && StringUtils.isBlank((String)whOpstoreDomain.getWarehouseOcode())) {
            msg = msg + "warehouseCode\u548cwarehouseOcode\u90fd\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getOpstoreOcode())) {
            msg = msg + "opstoreOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getWarehouseName())) {
            msg = msg + "warehouseName\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == whOpstoreDomain.getGoodsNum()) {
            msg = msg + "goodsNum\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsBtype())) {
            msg = msg + "storeGoodsBtype\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreGoodsType())) {
            msg = msg + "storeGoodsType\u4e3a\u7a7a! ";
        } else if (!"0,1,2,3,4,5,11,12".contains(whOpstoreDomain.getStoreGoodsType())) {
            msg = msg + "storeGoodsType\u5f02\u5e38[" + whOpstoreDomain.getStoreGoodsType() + "]! ";
        }
        if (StringUtils.isBlank((String)whOpstoreDomain.getStoreType())) {
            msg = msg + "storeType\u4e3a\u7a7a! ";
        } else if (!"0,1".contains(whOpstoreDomain.getStoreType())) {
            msg = msg + "storeType\u5f02\u5e38[" + whOpstoreDomain.getStoreType() + "]! ";
        }
        if (StringUtils.isNotBlank((String)whOpstoreDomain.getOpstoreOcode()) && null != (qwh = this.queryOpstorePage(this.getQueryMapParam("opstoreOcode,tenantCode", new Object[]{whOpstoreDomain.getOpstoreOcode(), whOpstoreDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qwh.getList())) {
            msg = msg + "opstoreOcode[" + whOpstoreDomain.getOpstoreOcode() + "]\u91cd\u590d! ";
            return msg;
        }
        List<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = whOpstoreDomain.getWhOpstoreGoodsDomainList();
        if (ListUtil.isEmpty(whOpstoreGoodsDomainList)) {
            msg = msg + "whOpstoreGoodsDomainList\u4e3a\u7a7a! ";
            return msg;
        }
        int i = 0;
        int j = 0;
        for (WhOpstoreGoodsDomain whOpstoreGoodsDomain : whOpstoreGoodsDomainList) {
            ++i;
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getGoodsNo())) {
                msg = msg + "\u7b2c" + i + "\u884cgoodsNo\u4e3a\u7a7a! ";
            }
            if (null == whOpstoreGoodsDomain.getGoodsNum()) {
                msg = msg + "\u7b2c" + i + "\u884cgoodsNum\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getStoreType())) {
                msg = msg + "\u7b2c" + i + "\u884cstoreType\u4e3a\u7a7a! ";
            } else if (!"0,1".contains(whOpstoreGoodsDomain.getStoreType())) {
                msg = msg + "\u7b2c" + i + "\u884cstoreType\u5f02\u5e38[" + whOpstoreGoodsDomain.getStoreType() + "]! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getOpstoreDir())) {
                msg = msg + "\u7b2c" + i + "\u884copstoreDir\u4e3a\u7a7a! ";
            } else if (!"0,1".contains(whOpstoreGoodsDomain.getOpstoreDir())) {
                msg = msg + "\u7b2c" + i + "\u884cOpstoreDir\u5f02\u5e38[" + whOpstoreGoodsDomain.getOpstoreDir() + "]! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit())) {
                msg = msg + "\u7b2c" + i + "\u884cpartsnameNumunit\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseCode()) && StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseOcode())) {
                msg = msg + "\u7b2c" + i + "\u884cwarehouseCode\u548cwarehouseOcode\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getWarehouseName())) {
                msg = msg + "\u7b2c" + i + "\u884cwarehouseName\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)whOpstoreGoodsDomain.getPartsnameNumunit())) {
                msg = msg + "\u7b2c" + i + "\u884cpartsnameNumunit\u4e3a\u7a7a! ";
            }
            whOpstoreGoodsDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
            List<WhOpstoreSkuDomain> whOpstoreSkuDomainList = whOpstoreGoodsDomain.getWhOpstoreSkuDomainList();
            if (ListUtil.isEmpty(whOpstoreSkuDomainList)) {
                msg = msg + "\u7b2c" + i + "\u884cwhOpstoreSkuDomainList\u4e3a\u7a7a! ";
                return msg;
            }
            for (WhOpstoreSkuDomain whOpstoreSkuDomain : whOpstoreSkuDomainList) {
                ++j;
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getOpstoreDir())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884copstoreDir\u4e3a\u7a7a! ";
                } else if (!"0,1".contains(whOpstoreSkuDomain.getOpstoreDir())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cOpstoreDir\u5f02\u5e38[" + whOpstoreSkuDomain.getOpstoreDir() + "]! ";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getStoreType())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cstoreType\u4e3a\u7a7a! ";
                } else if (!"0,1".contains(whOpstoreSkuDomain.getStoreType())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cstoreType\u5f02\u5e38[" + whOpstoreSkuDomain.getStoreType() + "]! ";
                }
                whOpstoreSkuDomain.setTenantCode(whOpstoreGoodsDomain.getTenantCode());
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (null == whOpstoreSkuDomain.getGoodsNum()) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cgoodsNum\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cpartsnameNumunit\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getWarehouseCode()) && StringUtils.isBlank((String)whOpstoreSkuDomain.getWarehouseOcode())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cwarehouseCode\u548cwarehouseOcode\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)whOpstoreSkuDomain.getWarehouseName())) {
                    msg = msg + "\u7b2c" + i + "-" + j + "\u884cwarehouseName\u4e3a\u7a7a! ";
                }
                if (!StringUtils.isBlank((String)whOpstoreSkuDomain.getPartsnameNumunit())) continue;
                msg = msg + "\u7b2c" + i + "-" + j + "\u884cpartsnameNumunit\u4e3a\u7a7a! ";
            }
        }
        return msg;
    }

    private String checkWarehouse(WhWarehouseDomain whWarehouseDomain) {
        QueryResult<WhWarehouseReDomain> qlist;
        if (null == whWarehouseDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)whWarehouseDomain.getWarehouseOcode())) {
            msg = msg + "warehouseOcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whWarehouseDomain.getWarehouseName())) {
            msg = msg + "warehouseName\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)whWarehouseDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)whWarehouseDomain.getWarehouseOcode()) && null != (qlist = this.queryWarehousePage(this.getQueryMapParam("warehouseOcode,tenantCode", new Object[]{whWarehouseDomain.getWarehouseOcode(), whWarehouseDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "warehouseOcode[" + whWarehouseDomain.getWarehouseOcode() + "]\u91cd\u590d! ";
        }
        return msg;
    }
}

