/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.maihe.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.maihe.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.inv.InvUserinv;
import com.yqbsoft.laser.service.ext.maihe.domain.inv.InvUserinvDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmAddressDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmAddressReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.um.UserinfoThemeDomain;
import com.yqbsoft.laser.service.ext.maihe.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.maihe.facade.request.um.UmUserinfoRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oa.OaResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.sap.SapAdressResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.response.um.UmUserinfoResponse;
import com.yqbsoft.laser.service.ext.maihe.service.BusUserService;
import com.yqbsoft.laser.service.ext.maihe.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.ext.maihe.util.OKHttpClientUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class BusUserServiceImpl
extends UserinfoBaseService
implements BusUserService {
    private String SYS_CODE = "maihe.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusUserServiceImpl.class);
    private String ddcode = "user";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusUserinfo(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        String url = umUserinfo.getWebSiteUrl();
        if (StringUtils.isNotBlank((String)url)) {
            if (url.indexOf("http") != 0) {
                url = "http://" + url;
            }
            url = url + "/laserEr/http/post/{apiCode}/1.0/" + tenantCode + "/utf-8/shangshu";
            umUserinfo.setWebSiteUrl(url);
        }
        UmUserinfoRequest umUserinfoRequest = new UmUserinfoRequest();
        umUserinfoRequest.init(this.getDdMap(tenantCode, this.ddcode, "maihe"));
        umUserinfoRequest.setOrgTenantCode(umUserinfo.getTenantCode());
        String t = this.getTenantCodeBuUrl(umUserinfoRequest.getHost());
        if (StringUtils.isNotBlank((String)t)) {
            umUserinfo.setTenantCode(t);
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoRequest, (Object)umUserinfo);
            if (StringUtils.isBlank((String)t)) {
                umUserinfoRequest.setTenantCode(umUserinfoRequest.getToTenantCode());
            }
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.e", (Throwable)e);
            return "error";
        }
        UmUserinfoResponse umUserinfoResponse = this.restTempfacade.execute(umUserinfoRequest);
        if (null == umUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse");
            return "error";
        }
        if (!umUserinfoResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse", (Object)umUserinfoResponse.getMsg());
            return umUserinfoResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String sendUserinfoToOa(UmUserDomainBean umUserinfoDomain) {
        HashMap<String, String> oaMap = new HashMap<String, String>();
        oaMap.put("customerCode", "MH");
        oaMap.put("workCode", "customer_information");
        oaMap.put("userCode", "seeyon2");
        oaMap.put("unitCode", "MH_OA_DMS");
        Date date = new Date();
        oaMap.put("calendar", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd"));
        oaMap.put("planStart", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        oaMap.put("pk_robot", "d114a8c9dd3711ee88f80068eb57e0de");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCompname", umUserinfoDomain.getUserinfoCompname());
        map.put("sapCode", StringUtils.isEmpty((String)umUserinfoDomain.getUserinfoOcode()) ? "" : umUserinfoDomain.getUserinfoOcode());
        map.put("userinfoCon", umUserinfoDomain.getUserinfoCon());
        map.put("userinfoPhone", umUserinfoDomain.getUserinfoPhone());
        map.put("userinfoScope", umUserinfoDomain.getUserinfoScope());
        map.put("departName", umUserinfoDomain.getDepartName());
        map.put("userinfoCertUrl", umUserinfoDomain.getUserinfoCertUrl());
        map.put("mschannelName", umUserinfoDomain.getMschannelName());
        map.put("dmsCode", umUserinfoDomain.getUserinfoCode());
        InvUserinvDomain invUserinv = umUserinfoDomain.getInvUserinvDomain();
        if (invUserinv != null) {
            HashMap invUserinvMap = new HashMap();
            map.put("userinvMember", invUserinv.getUserinvMember());
            map.put("userinvPhone", invUserinv.getUserinvPhone());
            map.put("userinvNo", invUserinv.getUserinvNo());
            map.put("userinvBankname", invUserinv.getUserinvBankname());
            map.put("userinvAdd", invUserinv.getUserinvAdd());
            map.put("userinvUadd", invUserinv.getUserinvUadd());
            map.put("userinvBankno", invUserinv.getUserinvBankno());
            map.put("userinvSort", invUserinv.getUserinvSort());
            map.put("userinvImgurl", invUserinv.getUserinvImgurl());
        }
        ArrayList umAddressList = new ArrayList();
        for (UmAddressReDomain umAddressReDomain : umUserinfoDomain.getUmAddressList()) {
            HashMap<String, String> umAddressMap = new HashMap<String, String>();
            umAddressMap.put("roadCode", umAddressReDomain.getRoadCode());
            umAddressMap.put("addressMap", umAddressReDomain.getAddressMap());
            umAddressMap.put("roadName", umAddressReDomain.getRoadName());
            umAddressMap.put("provinceName", umAddressReDomain.getProvinceName());
            umAddressMap.put("addressDetail", umAddressReDomain.getAddressDetail());
            umAddressMap.put("addressMember", umAddressReDomain.getAddressMember());
            umAddressMap.put("addressPhone", umAddressReDomain.getAddressPhone());
            umAddressMap.put("cityName", umAddressReDomain.getCityName());
            umAddressMap.put("officialSealUrl", umAddressReDomain.getAddressZipcode());
            umAddressList.add(umAddressMap);
        }
        if (CollectionUtils.isNotEmpty(umAddressList)) {
            map.put("umAddressList", umAddressList);
        }
        ArrayList<UserinfoThemeDomain> userinfoThemeList = new ArrayList<UserinfoThemeDomain>();
        for (UmUserinfoQuaDomain umUserinfoQuaDomain : umUserinfoDomain.getUmUserinfoQuaDomainList()) {
            if ("registerCapital".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("registerCapital", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("followWhether".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("followWhether", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("teamNum".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("teamNum", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("salesVolume".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("salesVolume", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("networkNum".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("networkNum", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("onlineNum".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("onlineNum", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("offlineNum".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("offlineNum", umUserinfoQuaDomain.getUserinfoQuaVaule());
            }
            if (!"company".equals(umUserinfoQuaDomain.getUserinfoQuaVaule1())) continue;
            UserinfoThemeDomain userinfoThemeDomain = (UserinfoThemeDomain)JsonUtil.buildNonNullBinder().getJsonToObject(umUserinfoQuaDomain.getUserinfoQuaVaule(), UserinfoThemeDomain.class);
            userinfoThemeList.add(userinfoThemeDomain);
        }
        if (CollectionUtils.isNotEmpty(userinfoThemeList)) {
            map.put("userinfoThemeList", userinfoThemeList);
        }
        oaMap.put("workParam", JsonUtil.buildNormalBinder().toJson(map));
        String string = JsonUtil.buildNormalBinder().toJson(oaMap);
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        if (StringUtils.isEmpty((String)umUserinfoDomain.getUserinfoOcode())) {
            logRouterlogDomain.setRouterlogType("userInfoCreate");
        } else {
            logRouterlogDomain.setRouterlogType("userInfoUpdate");
        }
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        logRouterlogDomain.setRouterlogMessage(string);
        logRouterlogDomain.setTenantCode(umUserinfoDomain.getTenantCode());
        String url = this.getUrl(umUserinfoDomain.getTenantCode(), "oaUrl", "oaUrl");
        logger.info(this.SYS_CODE + ".sendUserinfoToOa.oa.req", (Object)("url=" + url + ";req" + string));
        String adressRes = OKHttpClientUtil.sendPost(url, string);
        logger.info(this.SYS_CODE + ".sendUserinfoToOa.oa.res", (Object)adressRes);
        logRouterlogDomain.setRouterlogReturn(adressRes);
        if (StringUtils.isEmpty((String)adressRes)) {
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendUserinfoToOa.\u540c\u6b65oa\u4f59\u989d\u7533\u8bf7\u8fd4\u56de\u4e3a\u7a7a");
            return "fail";
        }
        OaResponse oaResponse = (OaResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, OaResponse.class);
        logRouterlogDomain.setRouterlogReturnstate(oaResponse.getErrorCode());
        logRouterlogDomain.setRouterlogReturnstates(oaResponse.getData());
        logRouterlogDomain.setRouterlogMesid(oaResponse.getData());
        logRouterlogDomain.setRouterlogMespid(umUserinfoDomain.getUserinfoCode());
        this.sendLog(logRouterlogDomain);
        if (!"0".equals(oaResponse.getErrorCode())) {
            logger.error(this.SYS_CODE + ".sendUserinfoToOa.\u540c\u6b65a\u4f59\u989d\u7533\u8bf7\u51fa\u73b0\u5f02\u5e38", (Object)oaResponse.getErrorMessage());
            return "fail";
        }
        return "success";
    }

    @Override
    public String sendUserAdressToOa(UmAddressDomain umAddressDomain) {
        HashMap<String, String> oaMap = new HashMap<String, String>();
        oaMap.put("customerCode", "MH");
        oaMap.put("workCode", "customer_information");
        oaMap.put("userCode", "seeyon2");
        oaMap.put("unitCode", "MH_OA_DMS");
        Date date = new Date();
        oaMap.put("calendar", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd"));
        oaMap.put("planStart", DateUtils.getDateString((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        oaMap.put("pk_robot", "d114a8c9dd3711ee88f80068eb57e0de");
        UmUserinfoReDomain umUserinfoDomain = this.getUserinfoByCode(umAddressDomain.getUserCode(), umAddressDomain.getTenantCode());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCompname", umUserinfoDomain.getUserinfoCompname());
        map.put("sapCode", StringUtils.isEmpty((String)umUserinfoDomain.getUserinfoOcode()) ? "" : umUserinfoDomain.getUserinfoOcode());
        map.put("userinfoCon", umUserinfoDomain.getUserinfoCon());
        map.put("userinfoPhone", umUserinfoDomain.getUserinfoPhone());
        map.put("userinfoScope", umUserinfoDomain.getUserinfoScope());
        map.put("departName", umUserinfoDomain.getDepartName());
        map.put("userinfoCertUrl", umUserinfoDomain.getUserinfoCertUrl());
        map.put("mschannelName", umUserinfoDomain.getMschannelName());
        map.put("dmsCode", umAddressDomain.getAddressCode());
        InvUserinv invUserinv = this.queryUserinvByUserCode(umAddressDomain.getTenantCode(), umAddressDomain.getUserCode());
        if (invUserinv != null) {
            map.put("userinvMember", invUserinv.getUserinvMember());
            map.put("userinvPhone", invUserinv.getUserinvPhone());
            map.put("userinvNo", invUserinv.getUserinvNo());
            map.put("userinvBankname", invUserinv.getUserinvBankname());
            map.put("userinvAdd", invUserinv.getUserinvAdd());
            map.put("userinvUadd", invUserinv.getUserinvUadd());
            map.put("userinvBankno", invUserinv.getUserinvBankno());
            map.put("userinvSort", invUserinv.getUserinvSort());
            map.put("userinvImgurl", invUserinv.getUserinvImgurl());
        }
        HashMap<String, Object> UserinfoMap = new HashMap<String, Object>();
        UserinfoMap.put("tenantCode", umUserinfoDomain.getTenantCode());
        UserinfoMap.put("userCode", umAddressDomain.getUserCode());
        QueryResult<UmAddressReDomain> queryResult = this.queryAddressPage(UserinfoMap);
        if (queryResult != null && CollectionUtils.isNotEmpty((Collection)queryResult.getList())) {
            ArrayList umAddressList = new ArrayList();
            for (UmAddressReDomain umAddressReDomain : queryResult.getList()) {
                HashMap<String, String> umAddressMap = new HashMap<String, String>();
                umAddressMap.put("roadCode", umAddressReDomain.getRoadCode());
                umAddressMap.put("addressMap", umAddressReDomain.getAddressMap());
                umAddressMap.put("roadName", umAddressReDomain.getRoadName());
                umAddressMap.put("provinceName", umAddressReDomain.getProvinceName());
                umAddressMap.put("cityName", umAddressReDomain.getCityName());
                umAddressMap.put("addressDetail", umAddressReDomain.getAddressDetail());
                umAddressMap.put("addressMember", umAddressReDomain.getAddressMember());
                umAddressMap.put("addressPhone", umAddressReDomain.getAddressPhone());
                umAddressMap.put("officialSealUrl", umAddressReDomain.getAddressZipcode());
                umAddressList.add(umAddressMap);
            }
            map.put("umAddressList", umAddressList);
        }
        ArrayList<UserinfoThemeDomain> userinfoThemeList = new ArrayList<UserinfoThemeDomain>();
        for (UmUserinfoQuaDomain umUserinfoQuaDomain : umUserinfoDomain.getUmUserinfoQuaDomainList()) {
            if ("registerCapital".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("registerCapital", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("followWhether".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("followWhether", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("teamNum".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("teamNum", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("salesVolume".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("salesVolume", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("networkNum".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("networkNum", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("onlineNum".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("onlineNum", umUserinfoQuaDomain.getUserinfoQuaVaule());
            } else if ("offlineNum".equals(umUserinfoQuaDomain.getUserinfoQuaKey())) {
                map.put("offlineNum", umUserinfoQuaDomain.getUserinfoQuaVaule());
            }
            if (!"company".equals(umUserinfoQuaDomain.getUserinfoQuaVaule1())) continue;
            UserinfoThemeDomain userinfoThemeDomain = (UserinfoThemeDomain)JsonUtil.buildNonNullBinder().getJsonToObject(umUserinfoQuaDomain.getUserinfoQuaVaule(), UserinfoThemeDomain.class);
            userinfoThemeList.add(userinfoThemeDomain);
        }
        if (CollectionUtils.isNotEmpty(userinfoThemeList)) {
            map.put("userinfoThemeList", userinfoThemeList);
        }
        oaMap.put("workParam", JsonUtil.buildNormalBinder().toJson(map));
        String req = JsonUtil.buildNormalBinder().toJson(oaMap);
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setRouterlogType("userinfoAdress");
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        logRouterlogDomain.setRouterlogMessage(req);
        logRouterlogDomain.setTenantCode(umAddressDomain.getTenantCode());
        String url = this.getUrl(umAddressDomain.getTenantCode(), "oaUrl", "oaUrl");
        logger.info(this.SYS_CODE + ".sendUserAdressToOa.oa.req", (Object)("url=" + url + ";req" + req));
        String adressRes = OKHttpClientUtil.sendPost(url, req);
        logger.info(this.SYS_CODE + ".sendUserAdressToOa.oa.res", (Object)adressRes);
        logRouterlogDomain.setRouterlogReturn(adressRes);
        if (StringUtils.isEmpty((String)adressRes)) {
            this.sendLog(logRouterlogDomain);
            logger.error(this.SYS_CODE + ".sendUserAdressToOa.\u540c\u6b65\u5730\u5740\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a");
            return "fail";
        }
        OaResponse oaResponse = (OaResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, OaResponse.class);
        logRouterlogDomain.setRouterlogReturnstate(oaResponse.getErrorCode());
        logRouterlogDomain.setRouterlogReturnstates(oaResponse.getData());
        logRouterlogDomain.setRouterlogMesid(oaResponse.getData());
        logRouterlogDomain.setRouterlogMespid(umAddressDomain.getAddressCode());
        this.sendLog(logRouterlogDomain);
        if (!"0".equals(oaResponse.getErrorCode())) {
            logger.error(this.SYS_CODE + ".sendGrantToOa.\u540c\u6b65\u5730\u5740\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Object)oaResponse.getErrorMessage());
            return "fail";
        }
        return "success";
    }

    @Override
    public String sendUserAdressToSap(UmAddressDomain umAddressReDomain) {
        UmUserinfoReDomain umUserinfoDomain = this.getUserinfoByCode(umAddressReDomain.getUserCode(), umAddressReDomain.getTenantCode());
        HashMap<String, Object> SapMap = new HashMap<String, Object>();
        SapMap.put("method", "MAIHE.DMS.KUNSE");
        SapMap.put("app_key", "MHDMS");
        SapMap.put("version", "1.0");
        SapMap.put("timestamp", DateUtils.parseDateTime((Date)new Date()));
        ArrayList addressSapList = new ArrayList();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("KUNSE", StringUtils.isEmpty((String)umAddressReDomain.getRoadCode()) ? "" : umAddressReDomain.getRoadCode());
        map1.put("KUNNR", umUserinfoDomain.getUserinfoOcode());
        map1.put("CUSTOMER_SE", umAddressReDomain.getAddressCode());
        map1.put("NAME1_SE", umAddressReDomain.getRoadName());
        map1.put("SORTL_SE", umAddressReDomain.getAddressMap());
        map1.put("REGIO_SE", umAddressReDomain.getProvinceCode());
        map1.put("ORT01_SE", umAddressReDomain.getCityName());
        map1.put("STRAS_SE", umAddressReDomain.getAddressDetail());
        map1.put("TELF2_SE", umAddressReDomain.getAddressPhone());
        map1.put("NAME2_SE", umAddressReDomain.getAddressMember());
        map1.put("SPERR_SE", "");
        addressSapList.add(map1);
        SapMap.put("goodlist", addressSapList);
        String req = JsonUtil.buildNormalBinder().toJson(SapMap);
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setAppapiCode("/sap/zdms_query?api=dms_kunse");
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        logRouterlogDomain.setRouterlogMessage(req);
        logRouterlogDomain.setTenantCode(umUserinfoDomain.getTenantCode());
        String url = this.getUrl(umUserinfoDomain.getTenantCode(), "sapaddressUrl", "sapaddressUrl");
        logger.info(this.SYS_CODE + ".saveOrUpdateAdrees.sap.", (Object)("url=" + url + ";req" + req));
        String adressRes = OKHttpClientUtil.sendPost(url, req);
        logger.info(this.SYS_CODE + ".saveOrUpdateAdrees.sap.res", (Object)adressRes);
        logRouterlogDomain.setRouterlogReturn(adressRes);
        if (StringUtils.isEmpty((String)adressRes)) {
            this.sendLog(logRouterlogDomain);
            throw new ApiException("\u540c\u6b65SAP\u5730\u5740\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a");
        }
        SapAdressResponse sapAdressResponse = (SapAdressResponse)JsonUtil.buildNonNullBinder().getJsonToObject(adressRes, SapAdressResponse.class);
        logRouterlogDomain.setRouterlogReturnstate(sapAdressResponse.getStatus());
        logRouterlogDomain.setRouterlogReturnstates(sapAdressResponse.getMessage());
        this.sendLog(logRouterlogDomain);
        if ("E".equals(sapAdressResponse.getStatus())) {
            logger.error(this.SYS_CODE + ".saveOrUpdateAdrees.zdms_query.\u540c\u6b65sap\u5730\u5740\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38");
            throw new ApiException("\u540c\u6b65SAP\u5730\u5740\u4fe1\u606f\u5f02\u5e38" + sapAdressResponse.getMessage());
        }
        return null;
    }

    private String getUrl(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            logger.error(this.SYS_CODE + ".getUrl.param");
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        logger.info(this.SYS_CODE + ".getUrl.field", (Object)field);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public void sendLog(LogRouterlogDomain logRouterlogDomain) {
        String api_code = "log.logRouterlog.saveRouterlog";
        if (null == logRouterlogDomain) {
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("logRouterlogDomain", JsonUtil.buildNormalBinder().toJson((Object)logRouterlogDomain));
        this.inAsyncInvoke(api_code, paramMap);
    }
}

