/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.maihe.facade.http;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.maihe.common.LogRouterlogDomain;
import com.yqbsoft.laser.service.ext.maihe.common.SupperFacade;
import com.yqbsoft.laser.service.ext.maihe.common.SupperRequest;
import com.yqbsoft.laser.service.ext.maihe.common.SupperResponse;
import com.yqbsoft.laser.service.ext.maihe.facade.http.RequestUtils;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service(value="restTempfacade")
public class RestTempfacade
extends SupperFacade {
    private static String SYS_CODE = "maihe.RestTempfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(RestTempfacade.class);

    @Override
    @Retryable(value={ApiException.class}, maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5))
    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        String json;
        if (null == supperRequest) {
            return null;
        }
        logger.info(SYS_CODE + ".execute.Request", (Object)(supperRequest.getHost() + supperRequest.getOutsideApiUrl()));
        logger.info(SYS_CODE + ".execute.Request.OrderNo", (Object)(supperRequest.getInsideOrderNo() + "===" + supperRequest.getOutsideOrderNo()));
        logger.info(SYS_CODE + ".execute.Request.PARAM", supperRequest.getTextParams());
        Long s = System.currentTimeMillis();
        HashMap<String, String> apiHeader = new HashMap<String, String>();
        LogRouterlogDomain logRouterlogDomain = new LogRouterlogDomain();
        logRouterlogDomain.setAppapiCode(supperRequest.getOutsideApiUrl());
        logRouterlogDomain.setAppapiVersion("1.0");
        logRouterlogDomain.setRouteDire("51");
        logRouterlogDomain.setRouterlogName("");
        String msg = JsonUtil.buildNormalBinder().toJson(supperRequest.getTextParams());
        logRouterlogDomain.setRouterlogMessage(msg);
        logRouterlogDomain.setRouterlogMesid(supperRequest.getOutsideOrderNo());
        logRouterlogDomain.setRouterlogMespid(supperRequest.getInsideOrderNo());
        logRouterlogDomain.setTenantCode(supperRequest.getOrgTenantCode());
        try {
            String url = supperRequest.getHost();
            url = url.indexOf("laserEr") >= 0 ? url.replace("{apiCode}", supperRequest.getOutsideApiUrl()) : url + "/laserEr/http/post?method=" + supperRequest.getOutsideApiUrl() + "&version=1.0&charset=utf-8";
            logger.info(SYS_CODE + ".execute.url", (Object)url);
            json = RequestUtils.postForEntity(url, MediaType.APPLICATION_FORM_URLENCODED, supperRequest.getTextParams(), apiHeader);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".execute.post", (Throwable)e);
        }
        Long s1 = System.currentTimeMillis();
        logger.info(SYS_CODE + ".execute.\u8017\u65f6" + (s1 - s));
        logger.info(SYS_CODE + ".execute.Response", (Object)supperRequest.getOutsideApiUrl());
        logger.info(SYS_CODE + ".execute.Response.PARAM", supperRequest.getTextParams());
        logger.info(SYS_CODE + ".execute.Response.OrderNo", (Object)(supperRequest.getInsideOrderNo() + "===" + supperRequest.getOutsideOrderNo()));
        if (StringUtils.isBlank((String)json)) {
            logger.error(SYS_CODE + ".execute.null", (Object)"\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            logRouterlogDomain.setRouterlogReturnstate("json");
            logRouterlogDomain.setRouterlogReturnstates("json is null");
            logRouterlogDomain.setRouterlogType("2");
            this.sendLog(logRouterlogDomain);
            throw new ApiException(SYS_CODE + ".execute.json", "\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
        }
        logger.info(SYS_CODE + ".execute.json", (Object)json);
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException(SYS_CODE + ".execute.localResponse", (Throwable)xe);
        }
        localResponse.setMsg(json);
        localResponse.makeDomain(json);
        logRouterlogDomain.setRouterlogReturn(json);
        logRouterlogDomain.setRouterlogReturnstate(localResponse.getErrorCode());
        logRouterlogDomain.setRouterlogReturnstates(localResponse.getMsg());
        logRouterlogDomain.setRouterlogType(localResponse.getSuccess() != false ? "0" : "1");
        this.sendLog(logRouterlogDomain);
        return (T)localResponse;
    }

    @Override
    public String sign(Map<String, String> param) {
        return null;
    }

    public RestTempfacade(String host, String appkey, String secret, String signtype) {
        super(host, appkey, secret, signtype);
    }

    public RestTempfacade(String host, String accessToken) {
        super(host, accessToken);
    }

    public RestTempfacade(String host) {
        super(host);
    }

    public RestTempfacade(Map<String, Object> map) {
        super(map);
    }

    public RestTempfacade() {
    }
}

