/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.maihe.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.maihe.api.ExOrderService;
import com.yqbsoft.laser.service.ext.maihe.domain.HtmlJsonReBean;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractDataDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractGoodsDataDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractSettlDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcContractproDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcPackageDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcRefundDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.oc.OcRefundReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.rs.RsSkuDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.sg.SgSendgoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.sg.SgSendgoodsGoods;
import com.yqbsoft.laser.service.ext.maihe.domain.sg.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.sg.SgSendgoodsLogDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.sg.SgSendgoodsPackageDomain;
import com.yqbsoft.laser.service.ext.maihe.domain.sg.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.ext.maihe.facade.http.Esbfacade;
import com.yqbsoft.laser.service.ext.maihe.facade.request.oc.OcContractRequest;
import com.yqbsoft.laser.service.ext.maihe.facade.response.oc.OcContractResponse;
import com.yqbsoft.laser.service.ext.maihe.supbase.OrderBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExOrderServiceImpl
extends OrderBaseService
implements ExOrderService {
    private String SYS_CODE = "maihe.ExOrderServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(ExOrderServiceImpl.class);
    @Autowired
    Esbfacade esbfacade;

    @Override
    public SupQueryResult<OcRefundReDomain> queryExRefund(String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, String refundGoodsType, String contractBillcode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (dwStartTime != null && dwEndTime != null) {
            map.put("gmtModifiedQstart", dwStartTime);
            map.put("gmtModifiedQend", dwEndTime);
        }
        if (refundGoodsType != null) {
            map.put("refundType", refundGoodsType);
        }
        if (contractBillcode != null) {
            map.put("contractBillcode", contractBillcode);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("tenantCode", tenantCode);
        return this.queryOcRefundPage(map);
    }

    @Override
    public String updateExSendgoods(String sendgoodsCode, String expressName, String expressCode, String packageBillno, String sendgoodsGetdate) {
        SgSendgoodsGoods sg = this.getSendgoodsGoodsByCode(sendgoodsCode);
        if (null == sg) {
            return "\u53d1\u8d27\u5355\u3010" + sendgoodsCode + "\u3011\u4e0d\u5b58\u5728";
        }
        SgSendgoodsPackageDomain sgSendgoodsPackageDomain = new SgSendgoodsPackageDomain();
        sgSendgoodsPackageDomain.setTenantCode(sg.getTenantCode());
        return "success";
    }

    @Override
    public String sendSaveExSgSendgoodsPackage(SgSendgoodsPackageDomain sendgoodsPackageDomain) {
        if (null == sendgoodsPackageDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoodsPackageDomain(sendgoodsPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSgSendgoodsPackage.msg", msg);
        }
        this.sendSaveSendgoodsPackage(sendgoodsPackageDomain);
        return this.sendSendgoodsNext(sendgoodsPackageDomain.getSendgoodsCode(), sendgoodsPackageDomain.getTenantCode(), null);
    }

    private String checkSendgoodsPackageDomain(SgSendgoodsPackageDomain sendgoodsPackageDomain) {
        String msg = "";
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getSendgoodsCode())) {
            msg = msg + "\u53d1\u8d27\u5355\u53f7 sendgoodsCode \u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u53f7 tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getExpressCode())) {
            msg = msg + "\u7269\u6d41\u516c\u53f8\u4ee3\u7801 expressCode \u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getExpressName())) {
            msg = msg + "\u7269\u6d41\u516c\u53f8\u540d\u79f0 expressName \u4e3a\u7a7a\uff01";
        }
        if (StringUtils.isBlank((String)sendgoodsPackageDomain.getPackageBillno())) {
            msg = msg + "\u7269\u6d41\u5355\u53f7 packageBillno \u4e3a\u7a7a\uff01";
        }
        return msg;
    }

    @Override
    public SupQueryResult<SgSendgoodsReDomain> queryContractsChange(boolean childFlag, String brandChannelCode, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus, String contractBillcode, String tenantCode) {
        logger.info("brandChannelCode:" + brandChannelCode + "dwStartTime:" + dwStartTime + "--dwEndTime" + dwEndTime + "--orderStatus" + orderStatus);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (brandChannelCode != null) {
            map.put("memberCcode", brandChannelCode);
        }
        if (dwStartTime != null && dwEndTime != null) {
            map.put("gmtModifiedQstart", dwStartTime);
            map.put("gmtModifiedQend", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        if (contractBillcode != null) {
            map.put("contractBillcode", contractBillcode);
        }
        Integer page = pageIndex == null ? 1 : pageIndex;
        Integer rows = pageSize == null ? 10 : pageSize;
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("startRow", (page - 1) * rows);
        map.put("endRow", rows);
        map.put("goodsProFlag", true);
        map.put("goodsFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocContractReDomainSupQueryResult = this.getQueryResutl("sg.sendgoods.querySgSendgoodsPageReDomain", pMap, SgSendgoodsReDomain.class);
        if (ocContractReDomainSupQueryResult == null) {
            return new SupQueryResult();
        }
        if (ocContractReDomainSupQueryResult.getRows() == null) {
            return new SupQueryResult();
        }
        logger.info("\u8fd4\u56de\u5217\u8868\u6570\u636e:{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractReDomainSupQueryResult));
        return ocContractReDomainSupQueryResult;
    }

    @Override
    public String sendSaveExOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            msg = this.makeOcContractDomain(ocContractDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.makeOcContractDomain", (Object)msg);
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.makeOcContractDomain", msg);
            }
            String contractBillcode = this.saveOrder(ocContractDomain);
            if (StringUtils.isBlank((String)contractBillcode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.contractBillcode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(contractBillcode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendContractState(String contractNbillcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type)) {
            logger.error(this.SYS_CODE + ".sendContractState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendContractState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String contractBillcode = null;
        String msg = this.checkQueryContract(contractNbillcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        QueryResult<OcContractReDomain> qlist = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode,channelCode", new Object[]{contractNbillcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.contractBillcode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        contractBillcode = ((OcContractReDomain)qlist.getList().get(0)).getContractBillcode();
        try {
            if (type.equals("AN")) {
                this.orderNext(contractBillcode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.orderBack(contractBillcode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendRefundState(String refundNcode, String channelCode, String tenantCode, String type, Map<String, Object> map) {
        if (StringUtils.isBlank((String)type) || MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendRefundState");
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String refundCode = null;
        String msg = this.checkQueryRefund(refundNcode, channelCode, tenantCode);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendRefundState.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", msg);
        }
        QueryResult<OcRefundReDomain> qlist = this.queryRefundPage(this.getQueryMapParam("refundNcode,tenantCode,channelCode", new Object[]{refundNcode, tenantCode, channelCode}));
        if (null == qlist || !ListUtil.isNotEmpty((Collection)qlist.getList())) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendRefundState.msg", "refundNcode[" + refundNcode + "]\u4e0d\u5b58\u5728! ");
        }
        refundCode = ((OcRefundReDomain)qlist.getList().get(0)).getRefundCode();
        try {
            if (type.equals("AN")) {
                this.refundNext(refundCode, tenantCode, map);
            } else if (type.equals("AB")) {
                this.refundBack(refundCode, tenantCode, map);
            }
            return "success";
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.ocRefundDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.msg", msg);
        }
        try {
            msg = this.makeOcRefundDomain(ocRefundDomain);
            if (StringUtils.isNotBlank((String)msg)) {
                logger.error(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", (Object)msg);
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.makeOcRefundDomain", msg);
            }
            String refundCode = this.saveRefund(ocRefundDomain);
            if (StringUtils.isBlank((String)refundCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExRefund.refundCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.refundCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(refundCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExRefund.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExRefund.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        if (null == sgSendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sgSendgoodsDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.sgSendgoodsDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoods(sgSendgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.msg", (Object)msg);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.msg", msg);
        }
        String tenantCode = sgSendgoodsDomain.getTenantCode();
        sgSendgoodsDomain.setMemberCode(this.getTeananMemberCode(tenantCode));
        sgSendgoodsDomain.setMemberName("\u5e73\u53f0");
        try {
            String sendgoodsCode = this.saveSendgoods(sgSendgoodsDomain);
            if (StringUtils.isBlank((String)sendgoodsCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.sendgoodsCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(sendgoodsCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExSendgoods.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExSendgoods.e1", e.getMessage());
        }
    }

    @Override
    public String sendSaveExSendgoodsLog(SgSendgoodsLogDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.ocContractDomain", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoodsLog(sgSendgoodsLogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.msg", msg);
        }
        try {
            String sendgoodsLogCode = this.saveSendgoodsLog(sgSendgoodsLogDomain);
            if (StringUtils.isBlank((String)sendgoodsLogCode)) {
                logger.error(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode");
                return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.sendgoodsLogCode", "\u4fdd\u5b58\u5f02\u5e38");
            }
            return this.makeSuccessReturn(sendgoodsLogCode);
        }
        catch (ApiException e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e", e.getErrMsg());
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveExOrder.e1", (Throwable)e);
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.e1", e.getMessage());
        }
    }

    @Override
    public String sendQueryExOcContract(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.map");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExOcContract.map", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExOcContract.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExOcContract.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("childFlag")))) {
            map.put("childFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("sendGoodsFlag")))) {
            map.put("sendGoodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("packFlag")))) {
            map.put("packFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("settleFlag")))) {
            map.put("settleFlag", "true");
        }
        return this.makeSuccessReturn(this.queryOrderReDomainPage(map));
    }

    @Override
    public String sendQueryExRefund(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExRefund.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExRefund.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractProFlag")))) {
            map.put("ocContractProFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("ocContractGoodsFlag")))) {
            map.put("ocContractGoodsFlag", "true");
        }
        return this.makeSuccessReturn(this.queryRefundReDoaminPage(map));
    }

    @Override
    public String sendQueryExSgSendgoods(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExSgSendgoods.msg", msg);
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsFlag")))) {
            map.put("goodsFlag", "true");
        }
        if (StringUtils.isBlank((String)((String)map.get("goodsProFlag")))) {
            map.put("goodsProFlag", "true");
        }
        return this.makeSuccessReturn(this.querySgSendgoodsPage(map));
    }

    private String checkQueryMap(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExSgSendgoods.map");
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)((String)map.get("tenantCode")))) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (null == map.get("startRow")) {
            msg = msg + "startRow\u4e3a\u7a7a! ";
        }
        if (null == map.get("rows")) {
            msg = msg + "rows\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkContract(OcContractDomain ocContractDomain) {
        QueryResult<OcContractReDomain> qlist;
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getContractType())) {
            msg = msg + "contractType\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)ocContractDomain.getContractNbillcode()) && null != (qlist = this.queryOrderPage(this.getQueryMapParam("contractNbillcode,tenantCode", new Object[]{ocContractDomain.getContractNbillcode(), ocContractDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "contractNbillcode[" + ocContractDomain.getContractNbillcode() + "]\u91cd\u590d! ";
        }
        if (null == ocContractDomain.getGoodsNum() || ocContractDomain.getGoodsNum().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "goodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            msg = msg + "packageList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
                ++i;
                if (ListUtil.isEmpty(ocPackageDomain.getContractGoodsList())) {
                    msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u4e3a\u7a7a! ";
                    continue;
                }
                int j = 0;
                for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
                    ++j;
                    if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo())) {
                        msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u7b2c" + j + "\u884cskuCode\u6216skuNo\u90fd\u4e3a\u7a7a! ";
                    }
                    if (null != ocContractGoodsDomain.getGoodsNum() && ocContractGoodsDomain.getGoodsNum().compareTo(BigDecimal.ZERO) > 0) continue;
                    msg = msg + "packageList\u7b2c" + i + "\u884ccontractGoodsList\u7b2c" + j + "\u884cgoodsNum\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
                }
            }
        }
        return msg;
    }

    private String checkQueryContract(String contractNbillcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)contractNbillcode)) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkQueryRefund(String refundNcode, String channelCode, String tenantCode) {
        String msg = null;
        if (StringUtils.isBlank((String)refundNcode)) {
            msg = msg + "refundNcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)channelCode)) {
            msg = msg + "channelCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkSendgoods(SgSendgoodsDomain sgSendgoodsDomain) {
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getContractBillcode())) {
            msg = msg + "contractBillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sgSendgoodsDomain.getContractNbbillcode())) {
            msg = msg + "contractNbbillcode\u4e3a\u7a7a! ";
        }
        if (EmptyUtil.isEmpty((Object)sgSendgoodsDomain.getSendgoodsGddate())) {
            msg = msg + "sendgoodsGddate\u4e3a\u7a7a! ";
        }
        for (SgSendgoodsGoodsDomain sendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
            if (StringUtils.isBlank((String)sendgoodsGoodsDomain.getGoodsSpec4())) {
                msg = msg + "goodsSpec4\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)sendgoodsGoodsDomain.getGoodsName())) {
                msg = msg + "goodsName\u4e3a\u7a7a! ";
            }
            if (EmptyUtil.isEmpty((Object)sendgoodsGoodsDomain.getSendgoodsGoodsCamount())) {
                msg = msg + "sendgoodsGoodsCamount\u4e3a\u7a7a! ";
            }
            if (StringUtils.isBlank((String)sendgoodsGoodsDomain.getContractGoodsGtype())) {
                msg = msg + "contractGoodsGtype\u4e3a\u7a7a! ";
            }
            if (!StringUtils.isBlank((String)sendgoodsGoodsDomain.getPartsnameWeightunit())) continue;
            msg = msg + "partsnameWeightunit\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkSendgoodsLog(SgSendgoodsLogDomain sgSendgoodsLogDomain) {
        if (null == sgSendgoodsLogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)sgSendgoodsLogDomain.getContractNbillcode())) {
            msg = msg + "contractNbillcode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)sgSendgoodsLogDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        return msg;
    }

    private String checkRefund(OcRefundDomain ocRefundDomain) {
        QueryResult<OcRefundReDomain> qlist;
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode()) && StringUtils.isBlank((String)ocRefundDomain.getContractNbillcode())) {
            msg = msg + "contractBillcode\u548ccontractNbillcode\u90fd\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a! ";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            msg = msg + "refundType\u4e3a\u7a7a! ";
        }
        if (StringUtils.isNotBlank((String)ocRefundDomain.getRefundOcode()) && null != (qlist = this.queryRefundPage(this.getQueryMapParam("refundOcode,tenantCode", new Object[]{ocRefundDomain.getRefundOcode(), ocRefundDomain.getTenantCode()}))) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            msg = msg + "refundOcode[" + ocRefundDomain.getRefundOcode() + "]\u91cd\u590d! ";
        }
        if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(BigDecimal.ZERO) <= 0) {
            msg = msg + "refundMoney\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            msg = msg + "ocRefundGoodsDomainList\u4e3a\u7a7a! ";
        } else {
            int i = 0;
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                ++i;
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getSkuNo())) {
                    msg = msg + "\u7b2c" + i + "\u884cskuNo\u4e3a\u7a7a! ";
                }
                if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsGtype())) {
                    msg = msg + "\u7b2c" + i + "\u884ccontractGoodsGtype\u4e3a\u7a7a! ";
                }
                if (null != ocRefundGoodsDomain.getRefundGoodsAmt() && ocRefundGoodsDomain.getRefundGoodsAmt().compareTo(BigDecimal.ZERO) > 0) continue;
                msg = msg + "\u7b2c" + i + "\u884crefundGoodsAmt\u4e3a\u7a7a\u6216\u6570\u636e\u5f02\u5e38! ";
            }
        }
        return msg;
    }

    private String makeOcRefundDomain(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            return "\u5546\u54c1\u4e3a\u7a7a";
        }
        String msg = "";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tenantCode", ocRefundDomain.getTenantCode());
        paramMap.put("childFlag", "true");
        if (StringUtils.isNotBlank((String)ocRefundDomain.getContractBillcode())) {
            paramMap.put("contractBillcode", ocRefundDomain.getContractBillcode());
        } else {
            paramMap.put("contractNbillcode", ocRefundDomain.getContractNbillcode());
        }
        QueryResult<OcContractReDomain> qlist = this.queryOrderReDomainPage(paramMap);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.qlist", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
            return "\u8ba2\u5355\u4e3a\u7a7a! " + paramMap.toString();
        }
        BigDecimal refundMoney = ocRefundDomain.getRefundMoney();
        OcContractReDomain ocContractReDomain = (OcContractReDomain)qlist.getList().get(0);
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.copy", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()), (Throwable)e);
            return "\u5f02\u5e38! " + paramMap.toString();
        }
        List<OcContractGoodsDomain> goodsList = ocContractReDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            logger.error(this.SYS_CODE + ".makeOcRefundDomain.goodsList", (Object)(ocRefundDomain.getRefundNcode() + "=" + ocRefundDomain.getTenantCode() + "=" + paramMap.toString()));
            return "\u8ba2\u5355\u5546\u54c1\u4e3a\u7a7a! " + paramMap.toString();
        }
        HashMap<String, OcContractGoodsDomain> contractgoodsMap = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            contractgoodsMap.put(ocContractGoodsDomain.getContractGoodsGtype() + "-" + ocContractGoodsDomain.getSkuNo(), ocContractGoodsDomain);
        }
        BigDecimal reMoney = BigDecimal.ZERO;
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            OcContractGoodsDomain ocContractGoodsDomain = (OcContractGoodsDomain)contractgoodsMap.get(ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo());
            if (null == ocContractGoodsDomain) {
                logger.error(this.SYS_CODE + ".makeOcRefundDomain.ocContractGoodsDomain", (Object)(ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo()));
                return "\u8ba2\u5355\u5546\u54c1\u5f02\u5e38! " + ocRefundGoodsDomain.getContractGoodsGtype() + "-" + ocRefundGoodsDomain.getSkuNo();
            }
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reMoney = reMoney.add(ocRefundGoodsDomain.getRefundGoodsAmt());
        }
        ocRefundDomain.setRefundMoney(reMoney);
        if (null == ocRefundDomain.getRefundMoney() || ocRefundDomain.getRefundMoney().compareTo(reMoney) != 0) {
            msg = msg + "\u660e\u7ec6\u91d1\u989d\u4e0e\u6c47\u603b\u91d1\u989d";
        }
        return msg;
    }

    private String makeOcContractDomain(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (ListUtil.isEmpty(ocContractDomain.getPackageList())) {
            return "\u5305\u88f9\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
            ocContractDomain.setMemberCode(this.getTeananMemberCode(ocContractDomain.getTenantCode()));
            ocContractDomain.setMemberName("\u5e73\u53f0");
        }
        List<OcPackageDomain> packageList = ocContractDomain.getPackageList();
        String msg = "";
        String goodsClass = "plat";
        QueryResult<RsSkuDomain> queryResutl = null;
        RsSkuDomain rsSkuDomain = null;
        RsResourceGoodsReDomain rsResourceGoodsReDomain = null;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcContractGoodsDomain> contractGoodsList = ocPackageDomain.getContractGoodsList();
            if (ListUtil.isEmpty(contractGoodsList)) {
                return "\u5305\u88f9\u91cc\u7684\u5546\u54c1\u4e3a\u7a7a";
            }
            for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
                msg = this.checkOcContractGoodsDomain(ocContractGoodsDomain);
                if (StringUtils.isNotBlank((String)msg)) {
                    return msg;
                }
                if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuCode())) {
                    paramMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
                    paramMap.put("tenantCode", ocContractDomain.getTenantCode());
                    queryResutl = this.queryRsSkuPage(paramMap);
                    if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                        logger.error(this.SYS_CODE + ".makeOcContractDomain.queryResutl1", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                        return "sku\u4e3a\u7a7a! " + paramMap.toString();
                    }
                    rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                } else if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getSkuNo())) {
                    paramMap.put("goodsClass", goodsClass);
                    paramMap.put("skuNo", ocContractGoodsDomain.getSkuNo());
                    paramMap.put("memberCode", ocContractDomain.getMemberCode());
                    paramMap.put("tenantCode", ocContractDomain.getTenantCode());
                    queryResutl = this.queryRsSkuPage(paramMap);
                    if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                        logger.error(this.SYS_CODE + ".makeOcContractDomain.queryResutl2", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                        return "sku\u4e3a\u7a7a! " + paramMap.toString();
                    }
                    rsSkuDomain = (RsSkuDomain)queryResutl.getList().get(0);
                }
                rsResourceGoodsReDomain = this.getGoodsByCode(rsSkuDomain.getGoodsCode(), ocContractDomain.getTenantCode());
                if (null == rsResourceGoodsReDomain) {
                    logger.error(this.SYS_CODE + ".makeOcContractDomain.rsResourceGoodsReDomain", (Object)(ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "goods\u4e3a\u7a7a! " + paramMap.toString();
                }
                BigDecimal goodsNum = ocContractGoodsDomain.getGoodsNum();
                BigDecimal goodsWeight = ocContractGoodsDomain.getGoodsWeight();
                try {
                    BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)rsSkuDomain);
                }
                catch (Exception e) {
                    logger.error(this.SYS_CODE + ".makeOcContractDomain.copysku", (Object)(rsSkuDomain.getGoodsCode() + "=" + ocContractDomain.getContractNbillcode() + "=" + ocContractDomain.getTenantCode() + "=" + paramMap.toString()));
                    return "\u7cfb\u7edf\u5f02\u5e38! ";
                }
                ocContractGoodsDomain.setGoodsNum(goodsNum);
                ocContractGoodsDomain.setGoodsWeight(goodsWeight);
            }
        }
        return msg;
    }

    private String checkOcContractGoodsDomain(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getSkuNo()) && StringUtils.isBlank((String)ocContractGoodsDomain.getSkuCode())) {
            msg = msg + "skuNo\u548cskuCode\u90fd\u4e3a\u7a7a! ";
        }
        return msg;
    }

    @Override
    public String sendQueryExpress(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            logger.error(this.SYS_CODE + ".sendQueryExpress.map");
            return null;
        }
        String msg = this.checkQueryMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendQueryExpress.msg");
            return this.makeErrorReturn(this.SYS_CODE + ".sendQueryExpress.msg", msg);
        }
        return this.makeSuccessReturn(this.queryExpressPage(map));
    }

    @Override
    public String sendSaveBusOrderToEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        String contractBillcode = (String)resStream.get("sendgoodsCode");
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.sendgoodsCode");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.sendgoodsCode", "\u53c2\u6570\u5f02\u5e38");
        }
        OcContractReDomain orderByCode = this.getOrderByCode(contractBillcode, tenantCode, null);
        if (null == orderByCode) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.sendgoodsCode", "\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        if (2 != orderByCode.getDataState()) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.dataState", "\u8ba2\u5355\u72b6\u6001\u9519\u8bef");
        }
        String expressCode = (String)resStream.get("expressCode");
        if (StringUtils.isBlank((String)expressCode)) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.expressCode", "\u7269\u6d41\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == resStream.get("packageBillno")) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.packageBillno", "\u8fd0\u5355\u53f7\u4e3a\u7a7a");
        }
        Map<String, Object> ddMap = this.getDdMap(tenantCode, "wmsExpressCode", "wmsExpressCode");
        if (null != ddMap.get(expressCode)) {
            Map map = (Map)ddMap.get(expressCode);
            resStream.putAll(map);
        }
        String code = this.orderNext(contractBillcode, tenantCode, resStream);
        return this.makeSuccessReturn(code);
    }

    public static void main(String[] args) {
        HashMap<String, String> resStream = new HashMap<String, String>();
        resStream.put("expressCode", "12321");
        resStream.put("expressName", "12121121");
        String json = "{\"SFSY-GP\":{\"expressCode\":\"shunfeng\",\"expressName\":\"\u987a\u4e30\u5feb\u9012\"},\"GMSF\":{\"expressCode\":\"shunfeng\",\"expressName\":\"\u987a\u4e30\u5feb\u9012\"},\"3108002701_1011\":{\"expressCode\":\"zhongtongkuaiyun\",\"expressName\":\"\u4e2d\u901a\u5feb\u8fd0\"},\"ZTO\":{\"expressCode\":\"zhongtong\",\"expressName\":\"\u4e2d\u901a\u5feb\u9012\"},\"DBKD\":{\"expressCode\":\"debangkuaidi\",\"expressName\":\"\u5fb7\u90a6\u5feb\u9012\"},\"SXJD\":{\"expressCode\":\"sxjdfreight\",\"expressName\":\"\u987a\u5fc3\u5feb\u6377\"},\"YDKY\":{\"expressCode\":\"yundakuaiyun\",\"expressName\":\"\u97f5\u8fbe\u5feb\u8fd0\"},\"FENGWANG\":{\"expressCode\":\"fengwang\",\"expressName\":\"\u4e30\u7f51\u901f\u8fd0\"}}";
        String expressCode = "GMSF";
        Map jsonToMap = JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
        if (null != jsonToMap.get(expressCode)) {
            Map map = (Map)jsonToMap.get(expressCode);
            resStream.putAll(map);
        }
        System.out.println(JsonUtil.buildNormalBinder().toJson(resStream));
    }

    @Override
    public String sendRefundStateForEsb(Map<String, Object> resStream, String tenantCode) {
        logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.resStream", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
        String refundCode = (String)resStream.get("refundCode");
        String dataState = (String)resStream.get("dataState");
        if (StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            logger.error(this.SYS_CODE + ".sendSaveBusOrderToEsb.contractBillcode");
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.refundCode", "\u53c2\u6570\u5f02\u5e38");
        }
        OcRefundReDomain refundByCode = this.getRefundByCode(refundCode, tenantCode);
        if (null == refundByCode) {
            return this.makeErrorReturn(this.SYS_CODE + ".sendSaveExOrder.refundCode", "\u9000\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String code = null;
        code = "FULFILLED".equals(dataState) ? this.refundNext(refundCode, tenantCode, resStream) : this.refundBack(refundCode, tenantCode, resStream);
        return this.makeSuccessReturn(code);
    }

    @Override
    public String sendOASaveExOrder(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain || StringUtils.isBlank((String)ocContractDomain.getContractBbillcode())) {
            logger.error(this.SYS_CODE + ".sendOASaveExOrder.ocContractDomain");
            return "error";
        }
        String code = this.makeNx(ocContractDomain);
        if (StringUtils.isNotBlank((String)code)) {
            logger.error(this.SYS_CODE + ".sendOASaveExOrder.code");
            return "success";
        }
        ArrayList<OcContractDataDomain> ocContractDataDomains = new ArrayList<OcContractDataDomain>();
        String msg = this.makeOaContract(ocContractDomain, ocContractDataDomains);
        if ("error".equals(msg)) {
            logger.error(this.SYS_CODE + ".sendOASaveExOrder.ocContractDomain", (Object)msg);
            return "error";
        }
        if ("neutral".equals(msg)) {
            logger.error(this.SYS_CODE + ".sendOASaveExOrder.msg", (Object)msg);
            return "success";
        }
        return this.executeContract(ocContractDataDomains);
    }

    public String makeNx(OcContractDomain ocContractDomain) {
        String nxKey = ocContractDomain.getContractBbillcode() + "-" + ocContractDomain.getTenantCode();
        boolean flag = DisUtil.setnx((String)("dealerOrders-" + nxKey), (String)nxKey, (int)15);
        if (!flag) {
            logger.info(this.SYS_CODE + "makeNx", (Object)("contractBillcode:" + ocContractDomain.getContractBillcode() + "nxKey:" + nxKey + "\u5df2\u5b58\u5728"));
            return "error";
        }
        return "";
    }

    @Override
    public HtmlJsonReBean sendOASaveExSendgoods(String sendData) {
        logger.error(this.SYS_CODE + "sendData start", (Object)sendData);
        if (StringUtils.isBlank((String)sendData)) {
            logger.error(this.SYS_CODE + ".sendOASaveExSendgoods.sendData", (Object)"sendData is null");
            return new HtmlJsonReBean("-1", "\u53c2\u6570\u4e3a\u7a7a");
        }
        SgSendgoodsDomain sendgoodsDomain = (SgSendgoodsDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(sendData, SgSendgoodsDomain.class);
        if (null == sendgoodsDomain) {
            logger.error(this.SYS_CODE + ".sendOASaveExSendgoods.sendgoodsDomain", (Object)"sendgoodsDomain is null");
            return new HtmlJsonReBean("-1", "\u53c2\u6570\u683c\u5f0f\u6216\u6570\u636e\u4e3a\u7a7a");
        }
        String msg = this.checkSendgoods(sendgoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            logger.error(this.SYS_CODE + ".sendOASaveExSendgoods.msg", (Object)msg);
            return new HtmlJsonReBean("-1", msg);
        }
        sendgoodsDomain.setTenantCode("796758877233610836");
        OcContractReDomain ocContractReDomain = this.getOrderByCode(sendgoodsDomain.getContractBillcode(), "796758877233610836", "proFlag");
        if (null == ocContractReDomain || ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
            logger.error(this.SYS_CODE + ".sendOASaveExSendgoods.ocContractReDomain", (Object)sendgoodsDomain.getContractBillcode());
            return new HtmlJsonReBean("-1", "\u65e0\u6b64\u8ba2\u5355");
        }
        String mg = this.makeSgSendGoodsDomain(sendgoodsDomain, ocContractReDomain);
        if (StringUtils.isNotBlank((String)mg)) {
            logger.error(this.SYS_CODE + ".sendOASaveExSendgoods.mg", (Object)(sendgoodsDomain.getContractBillcode() + "contractObillcode:" + sendgoodsDomain.getContractObillcode()));
            return new HtmlJsonReBean("-1", mg);
        }
        String res = this.saveSgSendGoods(sendgoodsDomain);
        if (StringUtils.isBlank((String)res) || !"success".equals(res)) {
            logger.error(this.SYS_CODE + ".sendOASaveExSendgoods.ocContractReDomain", (Object)(sendgoodsDomain.getContractBillcode() + "contractObillcode:" + sendgoodsDomain.getContractObillcode()));
            return new HtmlJsonReBean("-1", "\u53d1\u8d27\u5355\u751f\u6210\u5931\u8d25");
        }
        return new HtmlJsonReBean();
    }

    private String makeSgSendGoodsDomain(SgSendgoodsDomain sendgoodsDomain, OcContractReDomain ocContractReDomain) {
        SgSendgoodsDomain sgSendgoodsDomain = new SgSendgoodsDomain();
        String obilCode = sendgoodsDomain.getContractObillcode();
        Map<String, Map<String, List<OcContractGoodsDomain>>> groupedByCategory = ocContractReDomain.getGoodsList().stream().collect(Collectors.groupingBy(OcContractGoodsDomain::getSkuNo, Collectors.groupingBy(OcContractGoodsDomain::getContractGoodsGtype)));
        ArrayList<SgSendgoodsGoodsDomain> sgSendgoodsGoodsDomains = new ArrayList<SgSendgoodsGoodsDomain>();
        BigDecimal sendNum = BigDecimal.ZERO;
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal goodsMoney = BigDecimal.ZERO;
        try {
            BeanUtils.copyAllPropertys((Object)sgSendgoodsDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            throw new ApiException(this.SYS_CODE + ".makeSgSendGoodsDomain.copy.e", (Throwable)e);
        }
        for (SgSendgoodsGoodsDomain sendgoodsGoodsDomain : sendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
            BigDecimal mount = sendgoodsGoodsDomain.getSendgoodsGoodsCamount();
            Map<String, List<OcContractGoodsDomain>> groupMap = groupedByCategory.get(sendgoodsGoodsDomain.getGoodsEocode());
            if (MapUtil.isEmpty(groupMap)) {
                logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain is null", (Object)(sendgoodsGoodsDomain.getContractBillcode() + "==" + sendgoodsGoodsDomain.getSkuNo()));
                return "\u5546\u54c1\u4fe1\u606f\u9519\u8bef";
            }
            List<OcContractGoodsDomain> sendgoodsGoodsDomains = groupMap.get(sendgoodsGoodsDomain.getContractGoodsGtype());
            if (ListUtil.isEmpty(sendgoodsGoodsDomains)) {
                logger.error(this.SYS_CODE + ".makeSgSendGoodsDomain is null", (Object)(sendgoodsGoodsDomain.getContractBillcode() + "==" + sendgoodsGoodsDomain.getSkuNo()));
                return "\u5546\u54c1\u4fe1\u606f\u9519\u8bef1";
            }
            OcContractGoodsDomain ocContractGoodsDomain = sendgoodsGoodsDomains.get(0);
            try {
                BeanUtils.copyAllPropertysNotNull((Object)sendgoodsGoodsDomain, (Object)ocContractGoodsDomain);
                if (EmptyUtil.isEmpty((Object)sendgoodsGoodsDomain.getPricesetNprice())) {
                    sendgoodsGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                if (EmptyUtil.isEmpty((Object)sendgoodsGoodsDomain.getContractGoodsPrice())) {
                    sendgoodsGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                sendgoodsGoodsDomain.setSendgoodsGoodsCamount(mount);
                sendgoodsGoodsDomain.setGoodsCamount(mount);
                sendgoodsGoodsDomain.setGoodsNum(mount);
                sendgoodsGoodsDomain.setContractGoodsMoney(sendgoodsGoodsDomain.getContractGoodsPrice().multiply(mount));
                sendgoodsGoodsDomain.setContractGoodsInmoney(sendgoodsGoodsDomain.getPricesetNprice().multiply(mount));
                sendNum = sendNum.add(sendgoodsGoodsDomain.getSendgoodsGoodsCamount());
                money = money.add(sendgoodsGoodsDomain.getContractGoodsInmoney());
                goodsMoney = goodsMoney.add(sendgoodsGoodsDomain.getContractGoodsMoney());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)sendgoodsDomain, (Object)ocContractReDomain);
            sendgoodsDomain.setContractObillcode(obilCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sgSendgoodsDomain.setContractSendnum(sendNum);
        sgSendgoodsDomain.setGoodsNum(sendNum);
        sgSendgoodsDomain.setGoodsMoney(goodsMoney);
        sgSendgoodsDomain.setDataBmoney(goodsMoney);
        sgSendgoodsDomain.setContractMoney(goodsMoney);
        sgSendgoodsDomain.setContractInmoney(money);
        sgSendgoodsDomain.setDataBnum(sendNum);
        sgSendgoodsDomain.setSgSendgoodsGoodsDomainList(sgSendgoodsGoodsDomains);
        return "";
    }

    private String makeOaContract(OcContractDomain ocContractDomain, List<OcContractDataDomain> ocContractDataDomains) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBbillcode", ocContractDomain.getContractBbillcode());
        map.put("tenantCode", "796758877233610836");
        map.put("childFlag", "true");
        map.put("settleFlag", "true");
        map.put("goodsProFlag", "true");
        QueryResult<OcContractReDomain> queryResult = this.queryOrderReDomainPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            logger.error(this.SYS_CODE + ".sendOASaveExOrder.map", map);
            return "error";
        }
        boolean flag = queryResult.getList().stream().anyMatch(data -> data.getDataState() == -1);
        if (flag) {
            logger.error(this.SYS_CODE + ".sendOASaveExOrder.flag", (Object)ocContractDomain.getContractBbillcode());
            return "neutral";
        }
        boolean dataFlag = false;
        int i = 0;
        do {
            queryResult = this.queryOrderReDomainPage(map);
            dataFlag = queryResult.getList().stream().anyMatch(data -> data.getDataState() != 18 && data.getDataState() != 1);
            if (i > 30) break;
            if (dataFlag && i <= 30) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            logger.info(this.SYS_CODE + "sendOASaveExOrder.wait", (Object)("contractBillcode:" + ocContractDomain.getContractBbillcode() + "\u7b2c" + i + "\u6b21\u67e5\u8be2"));
            ++i;
        } while (dataFlag);
        if (dataFlag) {
            logger.error(this.SYS_CODE + ".sendOASaveExOrder.dataFlag", (Object)("contractBillcode:" + ocContractDomain.getContractBillcode()));
            return "success";
        }
        for (OcContractReDomain ocContractReDomain : queryResult.getList()) {
            if (StringUtils.isBlank((String)ocContractReDomain.getContractType())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.contractType", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            if (StringUtils.isBlank((String)ocContractReDomain.getContractPumode())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.contractPumode", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            if (StringUtils.isBlank((String)ocContractReDomain.getGoodsReceiptArrdess())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.goodsReceiptArrdess", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            if (StringUtils.isBlank((String)ocContractReDomain.getMemberBname())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.memberBname", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            if (StringUtils.isBlank((String)ocContractReDomain.getGoodsReceiptMem())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.goodsReceiptMem", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            if (StringUtils.isBlank((String)ocContractReDomain.getGoodsReceiptPhone())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.goodsReceiptPhone", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            if (EmptyUtil.isEmpty((Object)ocContractReDomain.getDataBmoney())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.dataBmoney", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            if (EmptyUtil.isEmpty((Object)ocContractReDomain.getGoodsNum())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.goodsNum", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            if (ListUtil.isEmpty(ocContractReDomain.getGoodsList())) {
                logger.error(this.SYS_CODE + ".sendOASaveExOrder.goodsList", (Object)ocContractDomain.getContractBillcode());
                return "error";
            }
            ArrayList<OcContractGoodsDataDomain> goodsDataDomains = new ArrayList<OcContractGoodsDataDomain>();
            BigDecimal rebMoney = BigDecimal.ZERO;
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractReDomain.getGoodsList()) {
                if (StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsName())) {
                    logger.error(this.SYS_CODE + ".sendOASaveExOrder.goodsName", (Object)ocContractDomain.getContractBillcode());
                    return "error";
                }
                if (StringUtils.isBlank((String)ocContractGoodsDomain.getContractGoodsGtype())) {
                    logger.error(this.SYS_CODE + ".sendOASaveExOrder.contractGoodsGtype", (Object)ocContractDomain.getContractBillcode());
                    return "error";
                }
                if (StringUtils.isBlank((String)ocContractGoodsDomain.getContractGoodsGtype())) {
                    logger.error(this.SYS_CODE + ".sendOASaveExOrder.contractGoodsGtype", (Object)ocContractDomain.getContractBillcode());
                    return "error";
                }
                if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsPrice())) {
                    logger.error(this.SYS_CODE + ".sendOASaveExOrder.contractGoodsPrice", (Object)ocContractDomain.getContractBillcode());
                    return "error";
                }
                if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getPricesetNprice())) {
                    logger.error(this.SYS_CODE + ".sendOASaveExOrder.pricesetNprice", (Object)ocContractDomain.getContractBillcode());
                    return "error";
                }
                if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getGoodsNum())) {
                    logger.error(this.SYS_CODE + ".sendOASaveExOrder.goodsNum", (Object)ocContractDomain.getContractBillcode());
                    return "error";
                }
                if (EmptyUtil.isEmpty((Object)ocContractGoodsDomain.getContractGoodsMoney())) {
                    logger.error(this.SYS_CODE + ".sendOASaveExOrder.contractGoodsMoney", (Object)ocContractDomain.getContractBillcode());
                    return "error";
                }
                if ("00".equals(ocContractReDomain.getContractType()) && ListUtil.isEmpty(ocContractReDomain.getOcContractSettlList())) {
                    logger.error(this.SYS_CODE + ".sendOASaveExOrder.contractGoodsMoney", (Object)ocContractDomain.getContractBillcode());
                    return "error";
                }
                OcContractGoodsDataDomain ocContractGoodsDataDomain = new OcContractGoodsDataDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)ocContractGoodsDataDomain, (Object)ocContractGoodsDomain);
                    ocContractGoodsDataDomain.setGoodsEocode(ocContractGoodsDomain.getSkuNo());
                    ocContractGoodsDataDomain.setContractGoodsGtype(ocContractGoodsDataDomain.getContractGoodsGtype().equals("0") ? "\u666e\u901a\u5546\u54c1" : "\u8d60\u54c1");
                    ocContractGoodsDataDomain.setDiscountAmount(ocContractGoodsDomain.getContractGoodsInmoney().subtract(ocContractGoodsDomain.getContractGoodsMoney()).setScale(2, RoundingMode.HALF_UP));
                    ocContractGoodsDataDomain.setMemo(ocContractDomain.getContractRemark());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                goodsDataDomains.add(ocContractGoodsDataDomain);
            }
            OcContractDataDomain ocContractDataDomain = new OcContractDataDomain();
            Map<String, List<OcContractSettlDomain>> stringListMap = null;
            BigDecimal zeBig = new BigDecimal("0");
            ocContractDataDomain.setRebFlag("\u5426");
            ocContractDataDomain.setRebateAmount(zeBig);
            ocContractDataDomain.setPaymentAmount(zeBig);
            ocContractDataDomain.setRebateAmount1(zeBig);
            ocContractDataDomain.setCrpAmount(zeBig);
            if (ListUtil.isNotEmpty(ocContractReDomain.getOcContractSettlList())) {
                List<OcContractSettlDomain> vdSettlDomains;
                List<OcContractSettlDomain> crpSettlDomains;
                stringListMap = ocContractReDomain.getOcContractSettlList().stream().collect(Collectors.groupingBy(OcContractSettlDomain::getContractSettlBlance));
                List<OcContractSettlDomain> ocContractSettlDomains = stringListMap.get("REB");
                if (ListUtil.isNotEmpty(ocContractSettlDomains)) {
                    OcContractSettlDomain settlDomain = ocContractSettlDomains.get(0);
                    rebMoney = settlDomain.getContractSettlPmoney();
                    ocContractDataDomain.setUserRebFlag("\u662f");
                    ocContractDataDomain.setRebateAmount(rebMoney.setScale(2, RoundingMode.HALF_UP));
                    ocContractDataDomain.setRebateAmount1(new BigDecimal(settlDomain.getContractSettlOpno2()).setScale(2, RoundingMode.HALF_UP));
                }
                if (ListUtil.isNotEmpty(crpSettlDomains = stringListMap.get("CRP"))) {
                    OcContractSettlDomain crpSettlDomain = crpSettlDomains.get(0);
                    ocContractDataDomain.setCrpAmount(new BigDecimal(crpSettlDomain.getContractSettlOpno2()).setScale(2, RoundingMode.HALF_UP));
                }
                if (ListUtil.isNotEmpty(vdSettlDomains = stringListMap.get("VD"))) {
                    OcContractSettlDomain crpSettlDomain = vdSettlDomains.get(0);
                    ocContractDataDomain.setPaymentAmount(new BigDecimal(crpSettlDomain.getContractSettlOpno2()).setScale(2, RoundingMode.HALF_UP));
                }
            }
            try {
                BeanUtils.copyAllPropertysNotNull((Object)ocContractDataDomain, (Object)ocContractReDomain);
                if ("00".equals(ocContractDataDomain.getContractType())) {
                    ocContractDataDomain.setContractType("\u666e\u901a\u8ba2\u5355");
                }
                if ("76".equals(ocContractDataDomain.getContractType())) {
                    ocContractDataDomain.setContractType("\u514d\u8d39\u8ba2\u5355");
                }
                if ("75".equals(ocContractDataDomain.getContractType())) {
                    ocContractDataDomain.setContractType("\u6e05\u5e93\u8ba2\u5355");
                }
                ocContractDataDomain.setBrandName(ocContractReDomain.getMemberGname());
                ocContractDataDomain.setTradingEntity(ocContractReDomain.getMschannelName());
                ocContractDataDomain.setDeliveryPartyName(ocContractReDomain.getGoodsSupplierName());
                ocContractDataDomain.setDeliveryPartyCode(ocContractReDomain.getGoodsSupplierCode());
                ocContractDataDomain.setAmount(ocContractReDomain.getDataBmoney().subtract(rebMoney).setScale(2, RoundingMode.HALF_UP));
                String contractPumode = "1".equals(ocContractReDomain.getContractPumode()) ? "\u5546\u5bb6\u914d\u9001" : ("2".equals(ocContractReDomain.getContractPumode()) ? "\u8fd0\u8d39\u5230\u4ed8" : ("4".equals(ocContractReDomain.getContractPumode()) ? "\u5de5\u5382\u76f4\u53d1" : "\u81ea\u63d0"));
                ocContractDataDomain.setContractPumode(contractPumode);
                if (ListUtil.isNotEmpty(ocContractReDomain.getOcContractproDomainList())) {
                    List<OcContractproDomain> proPer1Domains;
                    List<OcContractproDomain> proPerDomains;
                    Map<String, List<OcContractproDomain>> proMapList = ocContractReDomain.getOcContractproDomainList().stream().collect(Collectors.groupingBy(OcContractproDomain::getContractproKey));
                    List<OcContractproDomain> ocContractproDomains = proMapList.get("deliveryPrice");
                    if (ListUtil.isNotEmpty(ocContractproDomains)) {
                        ocContractDataDomain.setDeliveryPrice(new BigDecimal(ocContractproDomains.get(0).getContractproValue()));
                    }
                    if (ListUtil.isNotEmpty(proPerDomains = proMapList.get("period"))) {
                        ocContractDataDomain.setPeriod(proPerDomains.get(0).getContractproValue());
                    }
                    if (ListUtil.isNotEmpty(proPer1Domains = proMapList.get("period1"))) {
                        ocContractDataDomain.setPeriod1(proPer1Domains.get(0).getContractproValue());
                    }
                }
                ocContractDataDomain.setGoodsList(goodsDataDomains);
                ocContractDataDomains.add(ocContractDataDomain);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "success";
    }

    private String executeContract(List<OcContractDataDomain> ocContractDataDomains) {
        OcContractRequest applyPriceRequest = new OcContractRequest();
        applyPriceRequest.init(this.getDdMap("796758877233610836", "applyPrice", "maihe"));
        if (ListUtil.isEmpty(ocContractDataDomains)) {
            logger.error(this.SYS_CODE + ".executeContract.map.applyPrice");
            return "error";
        }
        Map map = JsonUtil.buildNonDefaultBinder().getJsonToMap(applyPriceRequest.getDefaultParameters(), String.class, Object.class);
        if (MapUtil.isEmpty((Map)map)) {
            logger.error(this.SYS_CODE + ".executePrice.map.defaultParameters", (Object)applyPriceRequest.getDefaultParameters());
            return "error";
        }
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("data", JsonUtil.buildNonDefaultBinder().toJson(ocContractDataDomains));
        map.put("workParam", JsonUtil.buildNonDefaultBinder().toJson(objectMap));
        map.put("workCode", "dealer_orders");
        applyPriceRequest.setQueryParameter(map);
        applyPriceRequest.setOutsideApiUrl("applyPrice");
        applyPriceRequest.setOrgTenantCode("796758877233610836");
        try {
            OcContractResponse queryGoodsInfoResponse = this.esbfacade.execute(applyPriceRequest);
            if (queryGoodsInfoResponse != null && queryGoodsInfoResponse.getSuccess().booleanValue() && !EmptyUtil.isEmpty((Object)queryGoodsInfoResponse.getData())) {
                logger.info(this.SYS_CODE + ".executePrice.queryGoodsInfoResponse1", (Object)"\u6210\u529f");
                return "success";
            }
            logger.error(this.SYS_CODE + ".executePrice.queryGoodsInfoResponse2", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryGoodsInfoResponse));
            return "error";
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".executePrice.queryGoodsInfoResponse3", (Throwable)e);
            return "error";
        }
    }

    @Override
    public HtmlJsonReBean sendOAAuditExOrder(final Map<String, Object> map) {
        block5: {
            HashMap<String, Object> memoMap;
            QueryResult<OcContractReDomain> ocContractReDomainQu;
            block4: {
                logger.error(this.SYS_CODE + "sendOAAuditExOrder start", map);
                if (MapUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("contractBbillcode")) || EmptyUtil.isEmpty((Object)map.get("oaDataState"))) {
                    logger.error(this.SYS_CODE + ".sendOAAuditExOrder.sendData", map);
                    return new HtmlJsonReBean("-1", "\u53c2\u6570\u4e3a\u7a7a");
                }
                HashMap<String, Object> ocMap = new HashMap<String, Object>(){
                    {
                        this.put("contractBbillcode", map.get("contractBbillcode"));
                        this.put("tenantCode", "796758877233610836");
                    }
                };
                ocContractReDomainQu = this.queryOrderReDomainPage((Map<String, Object>)ocMap);
                if (ocContractReDomainQu == null || ListUtil.isEmpty((Collection)ocContractReDomainQu.getList())) {
                    logger.error(this.SYS_CODE + ".sendOAAuditExOrder.ocContractReDomainQu", (Object)ocMap);
                    return new HtmlJsonReBean("-1", "\u6279\u6b21\u53f7\u9519\u8bef");
                }
                memoMap = new HashMap<String, Object>();
                if (!"2".equals(map.get("oaDataState").toString())) break block4;
                memoMap.put("memo", map.get("memo"));
                memoMap.put("dataStateStr", "mh01");
                for (OcContractReDomain ocContractReDomain : ocContractReDomainQu.getList()) {
                    this.orderNext(ocContractReDomain.getContractBillcode(), ocContractReDomain.getTenantCode(), memoMap);
                }
                break block5;
            }
            if (!"1".equals(map.get("oaDataState").toString())) break block5;
            memoMap.put("dataStateStr", "mh02");
            for (OcContractReDomain ocContractReDomain : ocContractReDomainQu.getList()) {
                this.orderNext(ocContractReDomain.getContractBillcode(), ocContractReDomain.getTenantCode(), memoMap);
            }
        }
        return new HtmlJsonReBean();
    }
}

