/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.wechatapp.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.ext.channel.wechatapp.util.WeChatPayConfig;
import com.yqbsoft.laser.service.ext.channel.wechatapp.util.WeChatPayNotify;
import com.yqbsoft.laser.service.ext.channel.wechatapp.util.WeChatPaySubmit;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import com.yqbsoft.laser.service.tool.util.XmlUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";

    public void sign(ChannelRequest channelRequest) {
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.sign.null", "");
        }
        String httpUrl = WeChatPayConfig.url;
        Map exmap = JsonUtil.buildNormalBinder().getJsonToMap(channelRequest.getCmChannelClear().getExtension(), String.class, String.class);
        String verCode = "";
        if (null != exmap) {
            String spbill_create_ip = (String)exmap.get("client_ip");
            if (StringUtils.isNotBlank((String)spbill_create_ip)) {
                channelRequest.getRequestData().put("spbill_create_ip", spbill_create_ip);
            }
            verCode = (String)exmap.get("verCode");
        }
        this.makeSubmch(channelRequest.getConfigMap(), channelRequest.getRequestData());
        if (StringUtils.isNotBlank((String)verCode)) {
            httpUrl = WeChatPayConfig.activeurl;
            channelRequest.getRequestData().put("auth_code", verCode);
            channelRequest.getRequestData().remove("notify_url");
            channelRequest.getRequestData().remove("openid");
            channelRequest.getRequestData().remove("sub_openid");
            channelRequest.getRequestData().remove("trade_type");
            channelRequest.setDebitFlag(true);
        }
        String api_key = (String)channelRequest.getRequestData().get(WeChatPayConfig.pay_key);
        channelRequest.getRequestData().put("sign_type", "MD5");
        Map<String, String> params = WeChatPaySubmit.buildRequestPara(channelRequest.getRequestData());
        String resXml = "";
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42\uff1a" + params + "=api_key:" + api_key));
        try {
            String xmlStr = XmlUtil.callMapToXML(params);
            this.logger.info("ChannelSignServiceImpl.xmlStr", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8bf7\u6c42xmlStr\uff1a" + xmlStr));
            resXml = WebUtils.doPost((String)httpUrl, (String)"text/html;charset=utf-8", (byte[])xmlStr.getBytes("utf-8"), (int)5000, (int)5000);
        }
        catch (IOException e) {
            this.logger.error("ChannelSignServiceImpl.sign.e", (Throwable)e);
        }
        this.logger.info("ChannelSignServiceImpl.sign", (Object)("\u5fae\u4fe1\u652f\u4ed8\u8fd4\u56de\uff1a" + resXml));
        Map resMap = XmlUtil.getMapFromXML((String)resXml);
        HashMap<String, String> res = new HashMap<String, String>();
        if (((String)resMap.get("return_code")).equals("SUCCESS") && ((String)resMap.get("result_code")).equals("SUCCESS")) {
            if (StringUtils.isBlank((String)verCode)) {
                res.put("appid", (String)resMap.get("appid"));
                res.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
                res.put("noncestr", UUID.randomUUID().toString().replace("-", ""));
                res.put("package", "Sign=WXPay");
                res.put("prepayid", (String)resMap.get("prepay_id"));
                res.put(WeChatPayConfig.pay_key, api_key);
                res.put("partnerid", (String)channelRequest.getRequestData().get("mch_id"));
                String sign = WeChatPaySubmit.buildRequestMysign(res);
                res.put("paySign", sign);
            } else {
                channelRequest.setDebitResult("SUCCESS");
                channelRequest.setBankSeqno((String)resMap.get("transaction_id"));
                this.processDate(resMap, channelRequest);
            }
        } else if (StringUtils.isNotBlank((String)verCode)) {
            res.put("subMsg", (String)resMap.get("err_code_des"));
            res.put("subCode", (String)resMap.get("err_code"));
            channelRequest.setBankRescode((String)resMap.get("err_code"));
            channelRequest.setBankResmsg((String)resMap.get("err_code_des"));
            channelRequest.setDebitResult((String)resMap.get("err_code"));
        }
        channelRequest.setRequestData(res);
    }

    private void makeSubmch(Map<String, String> configMap, Map<String, String> requestMap) {
        if (configMap != null && configMap.containsKey("sub_appid")) {
            requestMap.put("sub_appid", configMap.get("sub_appid"));
            requestMap.put("sub_openid", requestMap.remove("openid"));
        }
        if (configMap != null && configMap.containsKey("sub_mch_id")) {
            requestMap.put("sub_mch_id", configMap.get("sub_mch_id"));
        }
    }

    private void processDate(Map<String, String> resMap, ChannelRequest channelRequest) {
        Date channelAcceptDate = null;
        String timeEnd = resMap.get("time_end");
        if (StringUtils.isNotBlank((String)timeEnd)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            try {
                channelAcceptDate = sdf.parse(timeEnd);
            }
            catch (ParseException e) {
                channelAcceptDate = new Date();
                this.logger.error("ChannelSignServiceImpl.processDate", (Object)("\u6e20\u9053\u53d7\u7406\u65f6\u95f4\u8f6c\u6362\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a" + channelRequest.getCmChannelClear().getChannelClearSeqno()));
            }
        }
        channelRequest.setChannelAcceptDate(channelAcceptDate);
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        Map res = bankRequest.getRequestData();
        if (bankRequest.isSing()) {
            res = XmlUtil.getMapFromXML((String)((String)bankRequest.getRequestData().get("resStream")));
            res.put(WeChatPayConfig.pay_key, bankRequest.getConfigMap().get(WeChatPayConfig.pay_key));
            if (!WeChatPayNotify.verify(res)) {
                throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.verify", "");
            }
        }
        if (res.containsKey("res")) {
            String resJson = (String)res.get("res");
            Map resMap = JsonUtil.buildNormalBinder().getJsonToMap(resJson, String.class, String.class);
            res.putAll(resMap);
        }
        bankRequest.setRequestData(res);
        return this.buildApiCallParam(bankRequest);
    }

    public static void main(String[] args) {
        String as = "<xml><appid><![CDATA[wx44ecf8aa3d0c1fc4]]></appid><bank_type><![CDATA[CFT]]></bank_type><cash_fee><![CDATA[1]]></cash_fee><fee_type><![CDATA[CNY]]></fee_type><is_subscribe><![CDATA[N]]></is_subscribe><mch_id><![CDATA[1489225562]]></mch_id><nonce_str><![CDATA[e7e7e9c8dddd479c9f11a6fd1fe66e46]]></nonce_str><openid><![CDATA[oXCzm0rRnStJVdWxnRCtzXC1uNuU]]></openid><out_trade_no><![CDATA[4a2790c91cab4e0d86306ee012df455e]]></out_trade_no><result_code><![CDATA[SUCCESS]]></result_code><return_code><![CDATA[SUCCESS]]></return_code><sign><![CDATA[43BD59F997CA8843BEAF4EF9689FDECC]]></sign><sub_appid><![CDATA[wxaa8f237bb41f272d]]></sub_appid><sub_is_subscribe><![CDATA[Y]]></sub_is_subscribe><sub_mch_id><![CDATA[1490664922]]></sub_mch_id><sub_openid><![CDATA[ow7ps06rtZd4iJjFfNJgrHdDLE0o]]></sub_openid><time_end><![CDATA[20171027111952]]></time_end><total_fee>1</total_fee><trade_type><![CDATA[MWEB]]></trade_type><transaction_id><![CDATA[4200000026201710270582133208]]></transaction_id></xml>";
        Map res = XmlUtil.getMapFromXML((String)as);
        res.put("pay_key", "69f049122e4d459e822a37df62669337");
        System.out.println(WeChatPayNotify.verify(res));
    }
}

