/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.xinlian.service;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.CmChannelClear;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelInBaseService;
import com.yqbsoft.laser.service.ext.channel.xinlian.XLPayPcConstants;
import com.yqbsoft.laser.service.ext.channel.xinlian.config.PayTransactionForm;
import com.yqbsoft.laser.service.ext.channel.xinlian.utils.CryptoUtils;
import com.yqbsoft.laser.service.ext.channel.xinlian.utils.PreferredSSLSocketFactory;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class ChannelInServiceImpl
extends ChannelInBaseService {
    private static final String SING_PROPERTY = "signature";
    static String PAY_CENTER_GATEWAY = "https://testrans.xlpayment.com:8443/";
    private static final String CODE = "xl.ChannelInServiceImpl";
    private String agentCode;

    public String getFchannelCode() {
        return XLPayPcConstants.CHANNEL_CODE;
    }

    protected String httpInvoke(ChannelRequest channelRequest) {
        this.logger.error("xl.ChannelInServiceImpl.httpInvoke.channelRequest.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)channelRequest));
        if (null == channelRequest || null == channelRequest.getConfigMap() || channelRequest.getConfigMap().isEmpty() || null == channelRequest.getCmChannelClear()) {
            this.logger.error("xl.ChannelInServiceImpl.channelRequest.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)channelRequest));
            throw new ApiException("xl.ChannelInServiceImpl.channelRequest.param is null");
        }
        String payData = "";
        Map configMap = channelRequest.getConfigMap();
        String sm2Pass = (String)configMap.get("sm2Pass");
        String merSm2KeyText = (String)configMap.get("merSm2KeyText");
        String merSm2PubKeyText = (String)configMap.get("merSm2KeyText");
        String merSm2DecKeyFile = (String)configMap.get("merSm2DecKeyFile");
        String merSm2DecPubKeyFile = (String)configMap.get("merSm2DecPubKeyFile");
        String payCenterPublicKey = (String)configMap.get("payCenterPublicKey");
        String gmTrustCertBase64 = (String)configMap.get("gmTrustCertBase64");
        CmChannelClear cmChannelClear = channelRequest.getCmChannelClear();
        BigDecimal orderAmount = cmChannelClear.getOrderAmount().multiply(new BigDecimal("100"));
        String amount = orderAmount.toString();
        String businessOrderno = cmChannelClear.getBusinessOrderno();
        String partnerId = (String)channelRequest.getConfigMap().get("partnerId");
        String partneropenId = (String)channelRequest.getConfigMap().get("partneropenId");
        BankRequest bankRequest = new BankRequest();
        String notifyUrl = (String)channelRequest.getConfigMap().get("notify_url");
        try {
            PayTransactionForm form = new PayTransactionForm();
            form.setRandom(UUID.fastUUID().toString(true));
            form.setTimestamp(System.currentTimeMillis());
            form.setVersionNo("1.0.0");
            form.setSignType("SM2");
            form.setPartnerId(partnerId);
            form.setBizType("UNWXSPMainScanning");
            form.setOrderId(businessOrderno);
            form.setNeedShare("00");
            form.setTrxCtgy("14");
            form.setTrxAmt(amount);
            form.setOrderDesc("\u94f6\u8054\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8");
            form.setInformUrl(notifyUrl);
            form.setTimeoutExpress("30");
            form.setDisablePayChannels(new String[]{"no_credit"});
            form.setOpenId(partneropenId);
            form.setCustomerIp("11.13.14.16");
            form.setEquipmentNo("WEB");
            form.setAreaInfo("");
            form.setUserId("");
            String requestParam = ChannelInServiceImpl.buildParamStr(JSONUtil.toJsonStr((Object)form));
            String signature = ChannelInServiceImpl.cfcaSign(requestParam, merSm2KeyText, sm2Pass);
            form.setSignature(signature);
            this.logger.info("xl.ChannelInServiceImpl.form", (Object)form);
            String encryptForm = CryptoUtils.sm2AndSm4Encrypt(payCenterPublicKey, JSONUtil.toJsonStr((Object)form));
            this.logger.info("xl.ChannelInServiceImpl\u8bf7\u6c42\u6570\u636e\u52a0\u5bc6:{}", (Object)encryptForm);
            PreferredSSLSocketFactory ssf = CryptoUtils.buildPreferredSSLSocketFactory(gmTrustCertBase64);
            String url = channelRequest.getCmFchannelApi().getFchannelApiUrl();
            HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)url).contentType(ContentType.build((ContentType)ContentType.TEXT_PLAIN, (Charset)CharsetUtil.CHARSET_UTF_8)).setSSLSocketFactory((SSLSocketFactory)ssf).charset(CharsetUtil.CHARSET_UTF_8)).body(encryptForm).execute();
            if (response == null) {
                this.logger.info("xl.ChannelInServiceImplresponse\u4e3a\u7a7a!!!");
            } else {
                this.logger.info("xl.ChannelInServiceImplresponse\u4e0d\u4e3a\u7a7a!");
            }
            String resBody = response.body();
            this.logger.info("xl.ChannelInServiceImpl\u8fd4\u56de\u6570\u636e\u539f\u6587\uff1a{}", (Object)resBody);
            resBody = CryptoUtils.sm2AndSm4Decrypt(merSm2DecKeyFile, resBody, sm2Pass);
            this.logger.info("xl.ChannelInServiceImpl\u54cd\u5e94\u6570\u636e\u89e3\u5bc6\u540e\uff1a{}", (Object)resBody);
            if (!JSONUtil.isTypeJSON((String)resBody)) {
                this.logger.info("xl.ChannelInServiceImpl\u54cd\u5e94\u6570\u636e\u89e3\u5bc6\u5931\u8d25", (Object)"");
            }
            String resObj = ChannelInServiceImpl.buildParamStr(resBody);
            JSONObject bussRespDataObj = JSONUtil.parseObj((String)resBody);
            String respSignature = bussRespDataObj.getStr((Object)SING_PROPERTY);
            this.logger.error("xl.ChannelInServiceImpl.respSignature", (Object)respSignature);
            JSONObject data = (JSONObject)bussRespDataObj.get((Object)"data");
            payData = (String)data.get((Object)"payData");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return payData;
    }

    private boolean cfcaVerify(String plainData, String signature) throws PKIException {
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize(deviceName, null);
        Session session = JCrypto.getInstance().openSession(deviceName);
        byte[] base64P7SignedData = signature.getBytes(StandardCharsets.UTF_8);
        Signature signKit = new Signature();
        boolean result = signKit.p7VerifyMessageDetach(plainData.getBytes(StandardCharsets.UTF_8), base64P7SignedData, session);
        this.logger.info("SM2 P7DetachVerify: {}", (Object)result);
        return result;
    }

    private static String cfcaSign(String plainData, String merSm2KeyText, String sm2Pass) throws PKIException {
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize(deviceName, null);
        Session session = JCrypto.getInstance().openSession(deviceName);
        X509Cert signCert = CertUtil.getCertFromSM2((byte[])merSm2KeyText.getBytes());
        SM2PrivateKey privateKey = KeyUtil.getPrivateKeyFromSM2((byte[])merSm2KeyText.getBytes(), (String)sm2Pass);
        Signature signKit = new Signature();
        byte[] sourceData = plainData.getBytes(StandardCharsets.UTF_8);
        String signAlg = "sm3WithSM2Encryption";
        byte[] signedData = signKit.p7SignMessageDetach(signAlg, sourceData, (PrivateKey)privateKey, signCert, session);
        return new String(signedData);
    }

    private static String buildParamStr(String oriRequestBody) {
        JSONObject jsonObject = JSONUtil.parseObj((String)oriRequestBody);
        ArrayList keys = new ArrayList(jsonObject.keySet());
        keys.sort(Comparator.naturalOrder());
        StringBuilder paramBuilder = new StringBuilder(oriRequestBody.length() + keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            if (SING_PROPERTY.equals(keys.get(i))) continue;
            if (i == 0) {
                paramBuilder.append((String)keys.get(i)).append("=").append(CharSequenceUtil.isEmpty((CharSequence)jsonObject.getStr(keys.get(i))) ? "" : jsonObject.getStr(keys.get(i)));
                continue;
            }
            paramBuilder.append("&").append((String)keys.get(i)).append("=").append(CharSequenceUtil.isEmpty((CharSequence)jsonObject.getStr(keys.get(i))) ? "" : jsonObject.getStr(keys.get(i)));
        }
        return paramBuilder.toString();
    }
}

