/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.xinlian.utils;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EncryptUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import com.yqbsoft.laser.service.ext.channel.xinlian.utils.TextFileHelper;
import com.yqbsoft.laser.service.ext.channel.xinlian.utils.TextHexKit;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptUtilDemo {
    public static void main(String[] args) throws Exception {
        String deviceName = "JSOFT_LIB";
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        EncryptUtilDemo demo = new EncryptUtilDemo();
        demo.demoSM4EncryptMessage(session, "\u94f6\u884c\u5361");
    }

    public void demoDES3EncryptFileTwo() throws Exception {
        String pwd = "0282010100ea6226b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a";
        String message = "CFCA-MESSAGE-TESTING";
        String sourceFilePath = "TestData/tmp-data-test.dat";
        String encryptFilePath = "TestData/tmp-data-test.enc";
        String plainTextFilePath = "TestData/tmp-data-test.dec";
        TextFileHelper.writeFile("TestData/tmp-data-test.dat", "CFCA-MESSAGE-TESTING".getBytes("UTF8"));
        EncryptUtil.encryptFileByDES3((String)"TestData/tmp-data-test.dat", (String)"TestData/tmp-data-test.enc", (String)"0282010100ea6226b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a");
        byte[] encryptData = TextFileHelper.readFile("TestData/tmp-data-test.enc");
        System.err.println("   demoDES3EncryptFileTwo: " + new String(Base64.encode((byte[])encryptData)));
        EncryptUtil.decryptFileByDES3((String)"TestData/tmp-data-test.enc", (String)"TestData/tmp-data-test.dec", (String)"0282010100ea6226b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a");
        byte[] decryptData = TextFileHelper.readFile("TestData/tmp-data-test.dec");
        System.err.println("   demoDES3EncryptFileTwo: " + "CFCA-MESSAGE-TESTING".equals(new String(decryptData, "UTF8")));
    }

    public void demoDES3EncryptMessageTwo() throws Exception {
        String pwd = "0282010100ea6226b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a";
        String message = "CFCA-MESSAGE-TESTING";
        String base64EncryptText = EncryptUtil.encryptMessageByDES3((String)"CFCA-MESSAGE-TESTING", (String)"0282010100ea6226b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a");
        System.err.println("demoDES3EncryptMessageTwo: " + base64EncryptText);
        String decryptText = EncryptUtil.decryptMessageByDES3((String)base64EncryptText, (String)"0282010100ea6226b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a");
        System.err.println("demoDES3EncryptMessageTwo: " + "CFCA-MESSAGE-TESTING".equals(decryptText));
    }

    public void demoDES3EncryptFile(Session session) throws Exception {
        String sourceFilePath = "TestData/tmp-data-test.dat";
        String encryptFilePath = "TestData/tmp-data-test.enc";
        String plainTextFilePath = "TestData/tmp-data-test.dec";
        String ivText = "0282010100ea6226";
        String kText = "b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a";
        Mechanism mechanism = new Mechanism("DESede/CBC/PKCS7Padding", (Object)new CBCParam(TextHexKit.decode("0282010100ea6226")));
        SecretKeySpec key = new SecretKeySpec(TextHexKit.decode("b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a"), "DESede");
        String message = "CFCA-MESSAGE-TESTING";
        TextFileHelper.writeFile("TestData/tmp-data-test.dat", "CFCA-MESSAGE-TESTING".getBytes("UTF8"));
        EncryptUtil.encrypt((Mechanism)mechanism, (Key)key, (String)"TestData/tmp-data-test.dat", (String)"TestData/tmp-data-test.enc", (Session)session);
        byte[] binaryBytes = TextFileHelper.readFile("TestData/tmp-data-test.enc");
        System.err.println("          demoEncryptFile: " + new String(Base64.encode((byte[])binaryBytes)));
        EncryptUtil.decrypt((Mechanism)mechanism, (Key)key, (String)"TestData/tmp-data-test.enc", (String)"TestData/tmp-data-test.dec", (Session)session);
        byte[] decryptText = TextFileHelper.readFile("TestData/tmp-data-test.dec");
        System.err.println("          demoEncryptFile: " + "CFCA-MESSAGE-TESTING".equals(new String(decryptText, "UTF8")));
    }

    public void demoDES3EncryptMessage(Session session) throws Exception {
        String ivText = "0282010100ea6226";
        String kText = "b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a";
        Mechanism mechanism = new Mechanism("DESede/CBC/PKCS7Padding", (Object)new CBCParam(TextHexKit.decode("0282010100ea6226")));
        SecretKeySpec key = new SecretKeySpec(TextHexKit.decode("b38463db95bf4f0cae06b5c8ffa73bc3bdb83c193082010a"), "DESede");
        String message = "CFCA-MESSAGE-TESTING";
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)mechanism, (Key)key, (byte[])"CFCA-MESSAGE-TESTING".getBytes("UTF8"), (Session)session);
        System.err.println("   demoDES3EncryptMessage: " + new String(base64Bytes));
        byte[] decryptText = EncryptUtil.decrypt((Mechanism)mechanism, (Key)key, (byte[])base64Bytes, (Session)session);
        System.err.println("   demoDES3EncryptMessage: " + "CFCA-MESSAGE-TESTING".equals(new String(decryptText, "UTF8")));
    }

    public void demoSM4EncryptMessageTwo() throws Exception {
        String ivText = "0282010100ea6226b38463db95bf4f0c";
        String kText = "ae06b5c8ffa73bc3bdb83c193082010a";
        byte[] iv = TextHexKit.decode("0282010100ea6226b38463db95bf4f0c");
        byte[] key = TextHexKit.decode("ae06b5c8ffa73bc3bdb83c193082010a");
        String message = "CFCA-MESSAGE-TESTING";
        byte[] base64Bytes = EncryptUtil.encryptMessageBySM4((byte[])"CFCA-MESSAGE-TESTING".getBytes("UTF8"), (byte[])iv, (byte[])key);
        System.err.println(" demoSM4EncryptMessageTwo: " + new String(base64Bytes));
        byte[] decryptText = EncryptUtil.decryptMessageBySM4((byte[])base64Bytes, (byte[])iv, (byte[])key);
        System.err.println(" demoSM4EncryptMessageTwo: " + "CFCA-MESSAGE-TESTING".equals(new String(decryptText, "UTF8")));
    }

    public void demoSM4EncryptMessageByPassword() throws Exception {
        String password = "cfca1234";
        String message = "CFCA-MESSAGE-TESTING";
        byte[] base64Bytes = EncryptUtil.encryptMessageBySM4((byte[])"CFCA-MESSAGE-TESTING".getBytes("UTF8"), (String)"cfca1234");
        System.err.println(" demoSM4EncryptMessageByPassword: " + new String(base64Bytes));
        byte[] decryptText = EncryptUtil.decryptMessageBySM4((byte[])base64Bytes, (String)"cfca1234");
        System.err.println(" demoSM4EncryptMessageByPassword: " + "CFCA-MESSAGE-TESTING".equals(new String(decryptText, "UTF8")));
    }

    public String demoSM4EncryptMessage(Session session, String message) throws Exception {
        String ivText = "0282010100ea6226b38463db95bf4f0c";
        String kText = "ae06b5c8ffa73bc3bdb83c193082010a";
        Mechanism mechanism = new Mechanism(Mechanism.SM4_CBC, (Object)new CBCParam(TextHexKit.decode("0282010100ea6226b38463db95bf4f0c")));
        SecretKeySpec key = new SecretKeySpec(TextHexKit.decode("ae06b5c8ffa73bc3bdb83c193082010a"), "SM4");
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)mechanism, (Key)key, (byte[])message.getBytes("UTF8"), (Session)session);
        System.err.println("    demoSM4EncryptMessage: " + new String(base64Bytes));
        return new String(base64Bytes);
    }

    public void demoRC4EncryptMessage(Session session) throws Exception {
        String kText = "ae06b5c8ffa73bc3bdb83c193082010a";
        Mechanism mechanism = new Mechanism("RC4");
        SecretKeySpec key = new SecretKeySpec(TextHexKit.decode("ae06b5c8ffa73bc3bdb83c193082010a"), "RC4");
        String message = "CFCA-MESSAGE-TESTING";
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)mechanism, (Key)key, (byte[])"CFCA-MESSAGE-TESTING".getBytes("UTF8"), (Session)session);
        System.err.println("    demoRC4EncryptMessage: " + new String(base64Bytes));
        byte[] decryptText = EncryptUtil.decrypt((Mechanism)mechanism, (Key)key, (byte[])base64Bytes, (Session)session);
        System.err.println("    demoRC4EncryptMessage: " + "CFCA-MESSAGE-TESTING".equals(new String(decryptText, "UTF8")));
    }

    public void demoSM2EncryptMessage(Session session) throws Exception {
        String sm2FileText = "MIICMAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDB0vnnhR0gsAqT4Uieo84OJ0EV76ea/FvatojLQKofjlQkaRn8SKWAgMLI3IOLnXsMwggHgBgoqgRzPVQYBBAIBBIIB0DCCAcwwggFxoAMCAQICBSAAAACSMAwGCCqBHM9VAYN1BQAwITELMAkGA1UEBhMCQ04xEjAQBgNVBAoMCUNGQ0EgT0NBNjAeFw0xMjExMTkwMjE5NDlaFw0xMzAyMjcwMjE5NDlaMGYxCzAJBgNVBAYTAmNuMRswGQYDVQQKDBJDRkNBIE9wZXJhdGlvbiBDQTIxEDAOBgNVBAsMB0JPQy1UUEMxFDASBgNVBAsMC0luZGl2aWR1YWwyMRIwEAYDVQQDDAlyc2FmZjAwMTEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAT7sUFLTK4wBDrSnr1q8dwMhr+ws+Lfda9VFNid0J4YYQL0pSikQRPYw+U+/ckrZTe0loRLORr9FAMD9XztA2KGo08wTTAfBgNVHSMEGDAWgBQAkArr76OKEQ0Wwlgl7Q4nkO0YJzALBgNVHQ8EBAMCBsAwHQYDVR0OBBYEFIzMC06btck4k+a3q5jmwdQiohxWMAwGCCqBHM9VAYN1BQADRwAwRAIgF9pesommXwnUg0RCBNQDE9nqdkrVqWd2bBh8wpo+E/kCID5xx7sN61oqaol2T0EvG08U/kPV6QdAws3zWFQmiTw2";
        String sm2FilePass = "1";
        Mechanism mechanism = new Mechanism("SM2");
        X509Cert cert = CertUtil.getCertFromSM2((byte[])"MIICMAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDB0vnnhR0gsAqT4Uieo84OJ0EV76ea/FvatojLQKofjlQkaRn8SKWAgMLI3IOLnXsMwggHgBgoqgRzPVQYBBAIBBIIB0DCCAcwwggFxoAMCAQICBSAAAACSMAwGCCqBHM9VAYN1BQAwITELMAkGA1UEBhMCQ04xEjAQBgNVBAoMCUNGQ0EgT0NBNjAeFw0xMjExMTkwMjE5NDlaFw0xMzAyMjcwMjE5NDlaMGYxCzAJBgNVBAYTAmNuMRswGQYDVQQKDBJDRkNBIE9wZXJhdGlvbiBDQTIxEDAOBgNVBAsMB0JPQy1UUEMxFDASBgNVBAsMC0luZGl2aWR1YWwyMRIwEAYDVQQDDAlyc2FmZjAwMTEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAT7sUFLTK4wBDrSnr1q8dwMhr+ws+Lfda9VFNid0J4YYQL0pSikQRPYw+U+/ckrZTe0loRLORr9FAMD9XztA2KGo08wTTAfBgNVHSMEGDAWgBQAkArr76OKEQ0Wwlgl7Q4nkO0YJzALBgNVHQ8EBAMCBsAwHQYDVR0OBBYEFIzMC06btck4k+a3q5jmwdQiohxWMAwGCCqBHM9VAYN1BQADRwAwRAIgF9pesommXwnUg0RCBNQDE9nqdkrVqWd2bBh8wpo+E/kCID5xx7sN61oqaol2T0EvG08U/kPV6QdAws3zWFQmiTw2".getBytes());
        SM2PrivateKey priKey = KeyUtil.getPrivateKeyFromSM2((byte[])"MIICMAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDB0vnnhR0gsAqT4Uieo84OJ0EV76ea/FvatojLQKofjlQkaRn8SKWAgMLI3IOLnXsMwggHgBgoqgRzPVQYBBAIBBIIB0DCCAcwwggFxoAMCAQICBSAAAACSMAwGCCqBHM9VAYN1BQAwITELMAkGA1UEBhMCQ04xEjAQBgNVBAoMCUNGQ0EgT0NBNjAeFw0xMjExMTkwMjE5NDlaFw0xMzAyMjcwMjE5NDlaMGYxCzAJBgNVBAYTAmNuMRswGQYDVQQKDBJDRkNBIE9wZXJhdGlvbiBDQTIxEDAOBgNVBAsMB0JPQy1UUEMxFDASBgNVBAsMC0luZGl2aWR1YWwyMRIwEAYDVQQDDAlyc2FmZjAwMTEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAT7sUFLTK4wBDrSnr1q8dwMhr+ws+Lfda9VFNid0J4YYQL0pSikQRPYw+U+/ckrZTe0loRLORr9FAMD9XztA2KGo08wTTAfBgNVHSMEGDAWgBQAkArr76OKEQ0Wwlgl7Q4nkO0YJzALBgNVHQ8EBAMCBsAwHQYDVR0OBBYEFIzMC06btck4k+a3q5jmwdQiohxWMAwGCCqBHM9VAYN1BQADRwAwRAIgF9pesommXwnUg0RCBNQDE9nqdkrVqWd2bBh8wpo+E/kCID5xx7sN61oqaol2T0EvG08U/kPV6QdAws3zWFQmiTw2".getBytes(), (String)"1");
        String message = "CFCA-MESSAGE-TESTINGweMIICMAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDB0vnnhR0gsAqT4Uieo84OJ0EV76ea/FvatojLQKofjlQkaRn8SKWAgMLI3IOLnXsMwggHgBgoqgRzPVQYBBAIBBIIB0DCCAcwwggFxoAMCAQICBSAAAACSMAwGCCqBHM9VAYN1BQAwITELMAkGA1UEBhMCQ04xEjAQBgNVBAoMCUNGQ0EgT0NBNjAeFw0xMjExMTkwMjE5NDlaFw0xMzAyMjcwMjE5NDlaMGYxCzAJBgNVBAYTAmNuMRswGQYDVQQKDBJDRkNBIE9wZXJhdGlvbiBDQTIxEDAOBgNVBAsMB0JPQy1UUEMxFDASBgNVBAsMC0luZGl2aWR1YWwyMRIwEAYDVQQDDAlyc2FmZjAwMTEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAT7sUFLTK4wBDrSnr1q8dwMhr+ws+Lfda9VFNid0J4YYQL0pSikQRPYw+U+/ckrZTe0loRLORr9FAMD9XztA2KGo08wTTAfBgNVHSMEGDAWgBQAkArr76OKEQ0Wwlgl7Q4nkO0YJzALBgNVHQ8EBAMCBsAwHQYDVR0OBBYEFIzMC06btck4k+a3q5jmwdQiohxWMAwGCCqBHM9VAYN1BQADRwAwRAIgF9pesommXwnUg0RCBNQDE9nqdkrVqWd2bBh8wpo+E/kCID5xx7sN61oqaol2T0EvG08U/kPV6QdAws3zWFQmiTw2rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr";
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)mechanism, (Key)cert.getPublicKey(), (byte[])"CFCA-MESSAGE-TESTINGweMIICMAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDB0vnnhR0gsAqT4Uieo84OJ0EV76ea/FvatojLQKofjlQkaRn8SKWAgMLI3IOLnXsMwggHgBgoqgRzPVQYBBAIBBIIB0DCCAcwwggFxoAMCAQICBSAAAACSMAwGCCqBHM9VAYN1BQAwITELMAkGA1UEBhMCQ04xEjAQBgNVBAoMCUNGQ0EgT0NBNjAeFw0xMjExMTkwMjE5NDlaFw0xMzAyMjcwMjE5NDlaMGYxCzAJBgNVBAYTAmNuMRswGQYDVQQKDBJDRkNBIE9wZXJhdGlvbiBDQTIxEDAOBgNVBAsMB0JPQy1UUEMxFDASBgNVBAsMC0luZGl2aWR1YWwyMRIwEAYDVQQDDAlyc2FmZjAwMTEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAT7sUFLTK4wBDrSnr1q8dwMhr+ws+Lfda9VFNid0J4YYQL0pSikQRPYw+U+/ckrZTe0loRLORr9FAMD9XztA2KGo08wTTAfBgNVHSMEGDAWgBQAkArr76OKEQ0Wwlgl7Q4nkO0YJzALBgNVHQ8EBAMCBsAwHQYDVR0OBBYEFIzMC06btck4k+a3q5jmwdQiohxWMAwGCCqBHM9VAYN1BQADRwAwRAIgF9pesommXwnUg0RCBNQDE9nqdkrVqWd2bBh8wpo+E/kCID5xx7sN61oqaol2T0EvG08U/kPV6QdAws3zWFQmiTw2rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr".getBytes("UTF8"), (Session)session);
        System.err.println("    demoSM2EncryptMessage: " + new String(base64Bytes));
        byte[] decryptText = EncryptUtil.decrypt((Mechanism)mechanism, (Key)priKey, (byte[])base64Bytes, (Session)session);
        System.err.println("    demoSM2EncryptMessage: " + "CFCA-MESSAGE-TESTINGweMIICMAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDB0vnnhR0gsAqT4Uieo84OJ0EV76ea/FvatojLQKofjlQkaRn8SKWAgMLI3IOLnXsMwggHgBgoqgRzPVQYBBAIBBIIB0DCCAcwwggFxoAMCAQICBSAAAACSMAwGCCqBHM9VAYN1BQAwITELMAkGA1UEBhMCQ04xEjAQBgNVBAoMCUNGQ0EgT0NBNjAeFw0xMjExMTkwMjE5NDlaFw0xMzAyMjcwMjE5NDlaMGYxCzAJBgNVBAYTAmNuMRswGQYDVQQKDBJDRkNBIE9wZXJhdGlvbiBDQTIxEDAOBgNVBAsMB0JPQy1UUEMxFDASBgNVBAsMC0luZGl2aWR1YWwyMRIwEAYDVQQDDAlyc2FmZjAwMTEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAAT7sUFLTK4wBDrSnr1q8dwMhr+ws+Lfda9VFNid0J4YYQL0pSikQRPYw+U+/ckrZTe0loRLORr9FAMD9XztA2KGo08wTTAfBgNVHSMEGDAWgBQAkArr76OKEQ0Wwlgl7Q4nkO0YJzALBgNVHQ8EBAMCBsAwHQYDVR0OBBYEFIzMC06btck4k+a3q5jmwdQiohxWMAwGCCqBHM9VAYN1BQADRwAwRAIgF9pesommXwnUg0RCBNQDE9nqdkrVqWd2bBh8wpo+E/kCID5xx7sN61oqaol2T0EvG08U/kPV6QdAws3zWFQmiTw2rrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrr".equals(new String(decryptText, "UTF8")));
    }

    public void demoRSAEncryptMessage(Session session) throws Exception {
        String p12FileText = "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";
        String p12FilePass = "123456";
        Mechanism mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
        X509Cert cert = CertUtil.getCertFromPFX((byte[])"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".getBytes(), (String)"123456");
        PrivateKey priKey = KeyUtil.getPrivateKeyFromPFX((byte[])"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".getBytes(), (String)"123456");
        String message = "CFCA-MESSAGE-TESTING";
        byte[] base64Bytes = EncryptUtil.encrypt((Mechanism)mechanism, (Key)cert.getPublicKey(), (byte[])"CFCA-MESSAGE-TESTING".getBytes("UTF8"), (Session)session);
        System.err.println("    demoRSAEncryptMessage: " + new String(base64Bytes));
        byte[] decryptText = EncryptUtil.decrypt((Mechanism)mechanism, (Key)priKey, (byte[])base64Bytes, (Session)session);
        System.err.println("    demoRSAEncryptMessage: " + "CFCA-MESSAGE-TESTING".equals(new String(decryptText, "UTF8")));
    }
}

