/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.xinlian.utils;

public final class TextHexKit {
    private static byte[] hexNumberTable;
    private static byte[] lookUpHexAlphabet;

    public static String encode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        int lengthEncode = lengthData * 2;
        byte[] encodedData = new byte[lengthEncode];
        for (int i = 0; i < lengthData; ++i) {
            encodedData[i * 2] = lookUpHexAlphabet[binaryData[i] >> 4 & 0xF];
            encodedData[i * 2 + 1] = lookUpHexAlphabet[binaryData[i] & 0xF];
        }
        return new String(encodedData);
    }

    public static byte[] decode(String hexEncoded) {
        if (hexEncoded == null) {
            return null;
        }
        byte[] binaryData = hexEncoded.getBytes();
        int lengthData = binaryData.length;
        if (lengthData % 2 != 0) {
            return null;
        }
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        int I = 0;
        for (int i = 0; i < lengthDecode; ++i) {
            I = i * 2;
            if (binaryData[I] == -1 || binaryData[I + 1] == -1) {
                return null;
            }
            decodedData[i] = (byte)(hexNumberTable[binaryData[i * 2]] << 4 | hexNumberTable[binaryData[i * 2 + 1]]);
        }
        return decodedData;
    }

    static {
        int i;
        hexNumberTable = new byte[256];
        lookUpHexAlphabet = new byte[16];
        for (i = 0; i < hexNumberTable.length; ++i) {
            TextHexKit.hexNumberTable[i] = -1;
        }
        for (i = 57; i >= 48; --i) {
            TextHexKit.hexNumberTable[i] = (byte)(i - 48);
        }
        for (i = 70; i >= 65; --i) {
            TextHexKit.hexNumberTable[i] = (byte)(i - 65 + 10);
        }
        for (i = 102; i >= 97; --i) {
            TextHexKit.hexNumberTable[i] = (byte)(i - 97 + 10);
        }
        for (i = 0; i < 10; ++i) {
            TextHexKit.lookUpHexAlphabet[i] = (byte)(48 + i);
        }
        for (i = 10; i <= 15; ++i) {
            TextHexKit.lookUpHexAlphabet[i] = (byte)(97 + i - 10);
        }
    }
}

