/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.yankon.sap.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.esb.core.router.HttpResponseBean;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.yankon.sap.common.constant.ResultCodeEnum;
import com.yqbsoft.laser.service.yankon.sap.domain.ResponseData;
import com.yqbsoft.laser.service.yankon.sap.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.yankon.sap.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.yankon.sap.service.SendgoodsService;
import com.yqbsoft.laser.service.yankon.sap.utils.ValidatorUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class SendgoodsServiceImpl
extends BaseServiceImpl
implements SendgoodsService {
    ObjectMapper mapper = new ObjectMapper();
    private String SYS_CODE = "yankonSap.SendgoodsServiceImpl";
    private final Integer MAX_SEND_COUNT = 200;

    @Override
    public String addSendgoods(List<SgSendgoodsDomain> sendgoodsList) throws IOException {
        if (CollectionUtils.isEmpty(sendgoodsList)) {
            this.logger.error(this.SYS_CODE + ".addSendgoods", (Object)"sendgoodsList is empty!");
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), ResultCodeEnum.INVALID_PARAM.getResultMsg()));
        }
        if (sendgoodsList.size() > this.MAX_SEND_COUNT) {
            this.logger.error(this.SYS_CODE + ".sendMemjobList", (Object)"memjobListCode list must <= 200!");
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), "\u540c\u6b65\u8bb0\u5f55\u8fc7\u591a\uff0c\u6bcf\u6b21\u6700\u591a\u540c\u6b65200\u6761"));
        }
        StringBuilder sb = new StringBuilder();
        String str = null;
        for (SgSendgoodsDomain sendgoods : sendgoodsList) {
            str = ValidatorUtil.validateDto(sendgoods);
            if (StringUtils.isNotBlank((String)str)) {
                sb.append(sendgoods.getSendgoodsCode() + "\u53c2\u6570\u9519\u8bef\uff1a" + str);
            }
            if (CollectionUtils.isEmpty(sendgoods.getSgSendgoodsGoodsDomainList())) {
                sb.append("\u51fa\u8d27\u5355\u5546\u54c1\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a; ");
                continue;
            }
            for (SgSendgoodsGoodsDomain sendgoodsGoods : sendgoods.getSgSendgoodsGoodsDomainList()) {
                str = ValidatorUtil.validateDto(sendgoodsGoods);
                if (!StringUtils.isNotBlank((String)str)) continue;
                sb.append(sendgoodsGoods.getSendgoodsGoodsCode() + "\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u9519\u8bef\uff1a" + str);
            }
        }
        if (sb.length() > 0) {
            this.logger.error(this.SYS_CODE + ".addSendgoods", (Object)("sendgoodsList param error!\t" + sb.toString()));
            return this.buildFailResponse(400, new ResponseData<Object>(ResultCodeEnum.INVALID_PARAM.getResultCode(), sb.toString()));
        }
        for (SgSendgoodsDomain sendgoods : sendgoodsList) {
            for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sendgoods.getSgSendgoodsGoodsDomainList()) {
            }
            HashMap<String, SgSendgoodsDomain> paramsMap = new HashMap<String, SgSendgoodsDomain>();
            paramsMap.put("sgSendgoodsDomain", sendgoods);
            this.getInternalRouter().inInvoke("sg.sendgoodsEngine.sendsaveSgSendgoods", paramsMap);
        }
        return this.buildSuccResponse(new ResponseData<Object>());
    }

    private String buildSuccResponse(ResponseData<Object> responsData) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        responseBean.setHttpBody(this.mapper.writeValueAsString(responsData));
        return this.mapper.writeValueAsString((Object)responseBean);
    }

    private String buildFailResponse(int httpStatus, ResponseData<Object> responsData) throws JsonProcessingException {
        HttpResponseBean responseBean = new HttpResponseBean();
        responseBean.setHttpStatus(httpStatus);
        responseBean.setHttpBody(this.mapper.writeValueAsString(responsData));
        return this.mapper.writeValueAsString((Object)responseBean);
    }
}

