/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.zihexin.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.ext.channel.com.domain.BankRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRequest;
import com.yqbsoft.laser.service.ext.channel.com.domain.ChannelRest;
import com.yqbsoft.laser.service.ext.channel.com.service.ChannelBaseSignService;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.AesUtil;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.Base64Util;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.RsaUtil;
import com.yqbsoft.laser.service.suppercore.SupperApiException;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.beans.factory.annotation.Autowired;

public class ChannelSignServiceImpl
extends ChannelBaseSignService {
    public static final String SYS_CODE = "cmc.ChannelSignServiceImpl";
    String api_code = "oc.contract.updateContractInmoney";
    private static final ExecutorService pool = Executors.newFixedThreadPool(50);
    @Autowired
    private InternalRouter internalRouter;

    public void sign(ChannelRequest channelRequest) {
    }

    public ChannelRest verifySign(BankRequest bankRequest) {
        this.logger.info("verifySign.param", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)bankRequest));
        if (null == bankRequest || null == bankRequest.getConfigMap() || bankRequest.getConfigMap().isEmpty()) {
            throw new ApiException("cmc.ChannelSignServiceImpl.verifySign.null", "");
        }
        Map res = bankRequest.getRequestData();
        if (StringUtils.isNotBlank((String)((String)res.get("data")))) {
            Map configMap = bankRequest.getConfigMap();
            Map<String, String> map = ChannelSignServiceImpl.unCipherPassAndDataD((String)res.get("data"), (String)res.get("keyPass"), (String)configMap.get("privateKey"));
            this.logger.info("verifySign.map", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
            this.updateContractInmoney(map, bankRequest.getTenantCode());
            bankRequest.setRequestData(map);
        }
        return this.buildApiCallParam(bankRequest);
    }

    private void updateContractInmoney(final Map<String, String> map, final String tenantCode) {
        if (pool != null) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        String amount_invoice = (String)map.get("amount_invoice");
                        String ottOrderId = (String)map.get("orderNo");
                        ChannelSignServiceImpl.this.sendLog(amount_invoice, ottOrderId, tenantCode);
                    }
                    catch (Exception e) {
                        throw new ApiException((Throwable)e);
                    }
                }
            });
        }
    }

    public void sendLog(String amount_invoice, String ottOrderId, String tenantCode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("amount_invoice", amount_invoice);
        paramMap.put("contractBbillcode", ottOrderId);
        paramMap.put("tenantCode", tenantCode);
        this.inAsyncInvoke(this.api_code, paramMap);
    }

    public void inAsyncInvoke(String apiCode, Map<String, Object> paramMap) throws SupperApiException {
        this.internalInvoke(apiCode, paramMap);
    }

    public String internalInvoke(String apiCode, Map<String, Object> paramMap) {
        Object object;
        if (null == this.internalRouter) {
            this.internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
        }
        if ((object = this.internalRouter.inInvoke(apiCode, "1.0", "0", paramMap)) == null) {
            return null;
        }
        return (String)object;
    }

    public static Map<String, String> unCipherPassAndDataD(String data, String keypass, String privateKey) {
        try {
            keypass = new String(RsaUtil.decrypt(privateKey, Base64Util.decode(keypass)));
            String param = AesUtil.decrypt(new String(Base64Util.decode(data)), keypass);
            System.out.println(param);
            return JsonUtil.buildNormalBinder().getJsonToMap(param, String.class, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

