/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.channel.zihexin.util;

import com.yqbsoft.laser.service.ext.channel.zihexin.util.Base64;
import com.yqbsoft.laser.service.ext.channel.zihexin.util.Base64Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.springframework.util.StringUtils;

public class RsaUtil {
    public static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    public static final String SIGN_256ALGORITHM = "SHA256withRSA";

    public static String sign(String content, String privateKey, String input_charset, String sType) {
        try {
            PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64Util.decode(privateKey));
            KeyFactory keyf = KeyFactory.getInstance("Rsa");
            PrivateKey priKey = keyf.generatePrivate(priPKCS8);
            if (StringUtils.isEmpty((Object)sType)) {
                sType = SIGN_ALGORITHMS;
            }
            Signature signature = Signature.getInstance(sType);
            signature.initSign(priKey);
            signature.update(content.getBytes(input_charset));
            byte[] signed = signature.sign();
            return Base64Util.encode(signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean verify(String content, String sign, String public_key, String input_charset, String sType) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("Rsa");
            byte[] encodedKey = Base64Util.decode(public_key);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            if (StringUtils.isEmpty((Object)sType)) {
                sType = SIGN_ALGORITHMS;
            }
            Signature signature = Signature.getInstance(sType);
            signature.initVerify(pubKey);
            signature.update(content.getBytes(input_charset));
            boolean bverify = signature.verify(Base64Util.decode(sign));
            return bverify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static byte[] encrypt(String publicKey, byte[] plainTextData) throws Exception {
        if (publicKey == null) {
            throw new Exception("\u52a0\u5bc6\u516c\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        RSAPublicKey rsaPublicKey = RsaUtil.loadPublicKeyByStr(publicKey);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("Rsa");
            cipher.init(1, rsaPublicKey);
            byte[] output = cipher.doFinal(plainTextData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u52a0\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u52a0\u5bc6\u516c\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u660e\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u660e\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
    }

    @Deprecated
    public static String decrypt(String content, String private_key, String input_charset) throws Exception {
        int bufl;
        PrivateKey prikey = RsaUtil.getPrivateKey(private_key);
        Cipher cipher = Cipher.getInstance("Rsa");
        cipher.init(2, prikey);
        ByteArrayInputStream ins = new ByteArrayInputStream(Base64Util.decode(content));
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        byte[] buf = new byte[128];
        while ((bufl = ins.read(buf)) != -1) {
            byte[] block = null;
            if (buf.length == bufl) {
                block = buf;
            } else {
                block = new byte[bufl];
                for (int i = 0; i < bufl; ++i) {
                    block[i] = buf[i];
                }
            }
            writer.write(cipher.doFinal(block));
        }
        return new String(writer.toByteArray(), input_charset);
    }

    public static byte[] decrypt(String privateKey, byte[] cipherData) throws Exception {
        if (privateKey == null) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u4e3a\u7a7a, \u8bf7\u8bbe\u7f6e");
        }
        PrivateKey prikey = RsaUtil.getPrivateKey(privateKey);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("Rsa");
            cipher.init(2, prikey);
            byte[] output = cipher.doFinal(cipherData);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u89e3\u5bc6\u7b97\u6cd5");
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u89e3\u5bc6\u79c1\u94a5\u975e\u6cd5,\u8bf7\u68c0\u67e5");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u5bc6\u6587\u957f\u5ea6\u975e\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u5bc6\u6587\u6570\u636e\u5df2\u635f\u574f");
        }
    }

    public static PrivateKey getPrivateKey(String key) throws Exception {
        byte[] keyBytes = Base64Util.decode(key);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("Rsa");
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        return privateKey;
    }

    public static RSAPublicKey loadPublicKeyByStr(String publicKeyStr) throws Exception {
        try {
            byte[] buffer = Base64Util.decode(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance("Rsa");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static String encrypt(String content, String publicKey) throws Exception {
        byte[] buffer = Base64.decodeBase64(publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance("Rsa");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyFactory.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance("Rsa");
        cipher.init(1, rsaPublicKey);
        byte[] output = cipher.doFinal(content.getBytes());
        return Base64.encodeBase64String(output);
    }

    public static String decrypt(String content, String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64(privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("Rsa");
        PrivateKey priKey = keyFactory.generatePrivate(keySpec);
        Cipher cipher = Cipher.getInstance("Rsa");
        cipher.init(2, priKey);
        byte[] output = cipher.doFinal(Base64.decodeBase64(content));
        return new String(output, "utf-8");
    }
}

