/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.baizhishan.common.respone;

import com.yqbsoft.laser.bus.ext.data.baizhishan.common.request.SupperRequest;
import com.yqbsoft.laser.bus.ext.data.baizhishan.common.respone.SupperFacade;
import com.yqbsoft.laser.bus.ext.data.baizhishan.common.respone.SupperResponse;
import com.yqbsoft.laser.bus.ext.data.baizhishan.utils.OKHttpClientUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service(value="facade")
public class Facade
extends SupperFacade {
    private static String SYS_CODE = "busdata.Esbfacade";
    private static final SupperLogUtil logger = new SupperLogUtil(Facade.class);

    public static String apiRequestGet(String url, Map<String, String> params, String token) {
        if (MapUtil.isEmpty(params)) {
            params = new HashMap<String, String>();
        }
        params.put("Content-Type", "application/json");
        if (StringUtils.isNotBlank((String)token)) {
            params.put("X-Access-Token", token);
        }
        params.put("X-From", "app");
        OkHttpClient client = OKHttpClientUtil.getOkHttpClirnt();
        Request.Builder requestBuilder = new Request.Builder().url(url).get();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = requestBuilder.build();
        Response response = null;
        String StringTemp = null;
        try {
            response = client.newCall(request).execute();
            StringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return StringTemp;
    }

    public static String apiRequestPost(String url, Map<String, String> params, Map<String, Object> bodyParams, String token) {
        if (MapUtil.isEmpty(params)) {
            params = new HashMap<String, String>();
        }
        params.put("Content-Type", "application/json");
        if (StringUtils.isNotBlank((String)token)) {
            params.put("X-Access-Token", token);
        }
        params.put("X-From", "app");
        OkHttpClient client = OKHttpClientUtil.getOkHttpClirnt();
        MediaType mediaType = MediaType.parse((String)"application/json;charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)JsonUtil.buildNonDefaultBinder().toJson(bodyParams));
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = requestBuilder.build();
        Response response = null;
        String StringTemp = null;
        try {
            response = client.newCall(request).execute();
            StringTemp = response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return StringTemp;
    }

    @Override
    @Retryable(value={ApiException.class}, maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5))
    public <T extends SupperResponse> T execute(SupperRequest<T> supperRequest) {
        SupperResponse localResponse;
        if (null == supperRequest) {
            return null;
        }
        String json = "";
        json = StringUtils.isNotBlank((String)supperRequest.getMethod()) && "POST".equals(supperRequest.getMethod()) ? Facade.apiRequestPost(supperRequest.getUrl(), supperRequest.getHeaderMap(), supperRequest.getTextParams(), supperRequest.getToken()) : Facade.apiRequestGet(supperRequest.getUrl(), supperRequest.getHeaderMap(), supperRequest.getToken());
        try {
            localResponse = (SupperResponse)supperRequest.getResponseClass().newInstance();
        }
        catch (Exception xe) {
            throw new ApiException(SYS_CODE + ".execute.responese", (Throwable)xe);
        }
        logger.error(SYS_CODE + ".execute.json", (Object)json);
        localResponse.makeDomain(json);
        return (T)localResponse;
    }

    @Override
    public String sign(Map<String, String> param) {
        return null;
    }

    public Facade(String url, String token) {
        super(url, token);
    }

    public Facade(Map<String, Object> map) {
        super(map);
    }

    public Facade() {
    }
}

