/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.baizhishan.service.impl;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.bus.ext.data.baizhishan.common.request.app.AppRequest;
import com.yqbsoft.laser.bus.ext.data.baizhishan.common.respone.Facade;
import com.yqbsoft.laser.bus.ext.data.baizhishan.common.respone.app.AppResponse;
import com.yqbsoft.laser.bus.ext.data.baizhishan.model.UmAddressDomain;
import com.yqbsoft.laser.bus.ext.data.baizhishan.service.BusAddressService;
import com.yqbsoft.laser.bus.ext.data.baizhishan.supbase.BusBaseService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class BusAddressServiceImpl
extends BusBaseService
implements BusAddressService {
    @Override
    public List<UmAddressDomain> queryAddressList(String token, String tenantCode) {
        ArrayList<UmAddressDomain> umAddressDomainList = null;
        Facade facade = new Facade();
        AppRequest appRequest = new AppRequest();
        appRequest.setUrl(this.getDdFlag(tenantCode, "queryAddressList", "queryAddressList"));
        appRequest.setToken(token);
        AppResponse execute = facade.execute(appRequest);
        if (200 == execute.getCode()) {
            umAddressDomainList = new ArrayList<UmAddressDomain>();
            List list = (List)JSON.parseObject((String)execute.getResult().toString(), List.class);
            for (Object address : list) {
                UmAddressDomain umAddressDomain = new UmAddressDomain();
                String toJson = JsonUtil.buildNormalBinder().toJson(address);
                Map addressMap = (Map)JSON.parseObject((String)toJson, Map.class);
                umAddressDomain.setAddressId(addressMap.get("id") != null ? addressMap.get("id").toString() : null);
                umAddressDomain.setAddressMember(addressMap.get("name") != null ? addressMap.get("name").toString() : "");
                umAddressDomain.setAddressDetail(addressMap.get("address") != null ? addressMap.get("address").toString() : "");
                umAddressDomain.setAddressPhone(addressMap.get("mobile") != null ? addressMap.get("mobile").toString() : "");
                umAddressDomain.setProvinceName(addressMap.get("province") != null ? addressMap.get("province").toString() : "");
                umAddressDomain.setProvinceCode(addressMap.get("provinceCode") != null ? addressMap.get("provinceCode").toString() : "");
                umAddressDomain.setCityName(addressMap.get("city") != null ? addressMap.get("city").toString() : "");
                umAddressDomain.setCityCode(addressMap.get("cityCode") != null ? addressMap.get("cityCode").toString() : "");
                umAddressDomain.setAddressDefault(addressMap.get("isDefault") != null ? addressMap.get("isDefault").toString() : "");
                umAddressDomain.setAreaName(addressMap.get("area") != null ? addressMap.get("area").toString() : "");
                umAddressDomain.setAreaCode(addressMap.get("areaCode") != null ? addressMap.get("areaCode").toString() : "");
                umAddressDomain.setRoadName(addressMap.get("street") != null ? addressMap.get("street").toString() : "");
                umAddressDomain.setRoadCode(addressMap.get("streetCode") != null ? addressMap.get("streetCode").toString() : "");
                umAddressDomainList.add(umAddressDomain);
            }
            return umAddressDomainList;
        }
        return null;
    }

    @Override
    public String saveAddress(UmAddressDomain umAddressDomain, String tenantCode, String token) {
        Map<String, Object> params = this.makeParams(umAddressDomain);
        try {
            Map map = this.saveAddress(tenantCode, token, JsonUtil.buildNormalBinder().toJson(params));
            if (Integer.valueOf(map.get("code").toString()) == 200) {
                return "success";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "error";
    }

    @Override
    public UmAddressDomain getByAddresId(String id, String token, String tenantCode) {
        UmAddressDomain umAddressDomain = new UmAddressDomain();
        Facade facade = new Facade();
        AppRequest appRequest = new AppRequest();
        appRequest.setUrl(this.getDdFlag(tenantCode, "getByAddresIdUrl", "getByAddresIdUrl") + id);
        appRequest.setToken(token);
        AppResponse execute = facade.execute(appRequest);
        if (200 == execute.getCode()) {
            Map userMap = (Map)JSON.parseObject((String)execute.getResult().toString(), Map.class);
            umAddressDomain.setAddressId(userMap.get("id") != null ? userMap.get("id").toString() : null);
            umAddressDomain.setAddressMember(userMap.get("name") != null ? userMap.get("name").toString() : "");
            umAddressDomain.setAddressDetail(userMap.get("address") != null ? userMap.get("address").toString() : "");
            umAddressDomain.setAddressPhone(userMap.get("mobile") != null ? userMap.get("mobile").toString() : "");
            umAddressDomain.setProvinceName(userMap.get("province") != null ? userMap.get("province").toString() : "");
            umAddressDomain.setProvinceCode(userMap.get("provinceCode") != null ? userMap.get("provinceCode").toString() : "");
            umAddressDomain.setCityName(userMap.get("city") != null ? userMap.get("city").toString() : "");
            umAddressDomain.setCityCode(userMap.get("cityCode") != null ? userMap.get("cityCode").toString() : "");
            umAddressDomain.setAddressDefault(userMap.get("isDefault") != null ? userMap.get("isDefault").toString() : "");
            umAddressDomain.setAreaName(userMap.get("area") != null ? userMap.get("area").toString() : "");
            umAddressDomain.setAreaCode(userMap.get("areaCode") != null ? userMap.get("areaCode").toString() : "");
            umAddressDomain.setRoadName(userMap.get("street") != null ? userMap.get("street").toString() : "");
            umAddressDomain.setRoadCode(userMap.get("streetCode") != null ? userMap.get("streetCode").toString() : "");
            return umAddressDomain;
        }
        return null;
    }

    @Override
    public UmAddressDomain getDefaultAddres(String token, String tenantCode) {
        UmAddressDomain umAddressDomain = new UmAddressDomain();
        Facade facade = new Facade();
        AppRequest appRequest = new AppRequest();
        appRequest.setUrl(this.getDdFlag(tenantCode, "getDefaultAddres", "getDefaultAddres"));
        appRequest.setToken(token);
        AppResponse execute = facade.execute(appRequest);
        if (200 == execute.getCode()) {
            Map userMap = (Map)JSON.parseObject((String)execute.getResult().toString(), Map.class);
            umAddressDomain.setAddressId(userMap.get("id") != null ? userMap.get("id").toString() : null);
            umAddressDomain.setAddressMember(userMap.get("name") != null ? userMap.get("name").toString() : "");
            umAddressDomain.setAddressDetail(userMap.get("address") != null ? userMap.get("address").toString() : "");
            umAddressDomain.setAddressPhone(userMap.get("mobile") != null ? userMap.get("mobile").toString() : "");
            umAddressDomain.setProvinceName(userMap.get("province") != null ? userMap.get("province").toString() : "");
            umAddressDomain.setProvinceCode(userMap.get("provinceCode") != null ? userMap.get("provinceCode").toString() : "");
            umAddressDomain.setCityName(userMap.get("city") != null ? userMap.get("city").toString() : "");
            umAddressDomain.setCityCode(userMap.get("cityCode") != null ? userMap.get("cityCode").toString() : "");
            umAddressDomain.setAddressDefault(userMap.get("isDefault") != null ? userMap.get("isDefault").toString() : "");
            umAddressDomain.setAreaName(userMap.get("area") != null ? userMap.get("area").toString() : "");
            umAddressDomain.setAreaCode(userMap.get("areaCode") != null ? userMap.get("areaCode").toString() : "");
            umAddressDomain.setRoadName(userMap.get("street") != null ? userMap.get("street").toString() : "");
            umAddressDomain.setRoadCode(userMap.get("streetCode") != null ? userMap.get("streetCode").toString() : "");
            return umAddressDomain;
        }
        return null;
    }

    @Override
    public Map getUserAddress(Map<String, Object> parMap, String tenantCode) {
        Object result = null;
        Object umAddressDomainList = null;
        Map map = null;
        try {
            map = this.makeUserAddress(JsonUtil.buildNormalBinder().toJson(parMap), tenantCode);
        }
        catch (Exception e) {
            this.logger.error("busdata.BusBaseService.getUserAddress.makeUserAddress", (Object)("\u83b7\u53d6\u7528\u6237\u5730\u5740\u5f02\u5e38:" + e.getMessage()));
            throw new ApiException((Throwable)e);
        }
        if (200 == Integer.valueOf(map.get("code").toString())) {
            return map;
        }
        return null;
    }

    private Map makeUserAddress(String toJson, String tenantCode) throws IOException {
        StringEntity entity = new StringEntity(toJson, "utf-8");
        HttpPost httpPost = new HttpPost(this.getDdFlag(tenantCode, "getUserAddress", "getUserAddress"));
        httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
        httpPost.setHeader("X-From", "app");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String msg = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        Map map = (Map)JSON.parseObject((String)msg, Map.class);
        return map;
    }

    @Override
    public void setDefaultAddress(String id, String token, String tenantCode) {
        try {
            Map map = this.setDefault(tenantCode, token, id);
            if (Integer.valueOf(map.get("code").toString()) != 200) {
                throw new ApiException("\u8bbe\u7f6e\u9ed8\u8ba4\u5730\u5740\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("busdata.BusBaseService.setDefaultAddress", (Object)JsonUtil.buildNormalBinder().toJson((Object)e.getMessage()));
            throw new ApiException("\u8bbe\u7f6e\u9ed8\u8ba4\u5730\u5740\u5931\u8d25");
        }
    }

    @Override
    public String updateAddress(UmAddressDomain umAddressDomain, String token, String tenantCode) {
        Map<String, Object> params = this.makeParams(umAddressDomain);
        params.put("id", umAddressDomain.getAddressId());
        try {
            Map map = this.updateBaizhisanAddress(tenantCode, token, JsonUtil.buildNormalBinder().toJson(params));
            if (Integer.valueOf(map.get("code").toString()) == 200) {
                return "success";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "error";
    }

    @Override
    public String deleteAddress(String id, String token, String tenantCode) {
        try {
            Map map = this.sendDeleteAddress(id, token, tenantCode);
            if (Integer.valueOf(map.get("code").toString()) == 200) {
                return "success";
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "error";
    }

    public Map saveAddress(String tenantCode, String token, String params) throws IOException {
        StringEntity entity = new StringEntity(params, "utf-8");
        HttpPost httpPost = new HttpPost(this.getDdFlag(tenantCode, "saveAddress", "saveAddress"));
        httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
        httpPost.setHeader("X-Access-Token", token);
        httpPost.setHeader("X-From", "app");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String msg = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        Map map = (Map)JSON.parseObject((String)msg, Map.class);
        return map;
    }

    public Map updateBaizhisanAddress(String tenantCode, String token, String params) throws IOException {
        StringEntity entity = new StringEntity(params, "utf-8");
        HttpPut httpPut = new HttpPut(this.getDdFlag(tenantCode, "updateAddress", "updateAddress"));
        httpPut.setHeader("Content-Type", "application/json;charset=utf-8");
        httpPut.setHeader("X-Access-Token", token);
        httpPut.setHeader("X-From", "app");
        httpPut.setEntity((HttpEntity)entity);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
        String msg = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        Map map = (Map)JSON.parseObject((String)msg, Map.class);
        return map;
    }

    public Map setDefault(String tenantCode, String token, String id) throws IOException {
        HttpPut httpPut = new HttpPut(this.getDdFlag(tenantCode, "setDefaultAddress", "setDefaultAddress") + id + "/default");
        httpPut.setHeader("Content-Type", "application/json;charset=utf-8");
        httpPut.setHeader("X-Access-Token", token);
        httpPut.setHeader("X-From", "app");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
        String msg = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        Map map = (Map)JSON.parseObject((String)msg, Map.class);
        return map;
    }

    public Map sendDeleteAddress(String id, String token, String tenantCode) throws IOException, URISyntaxException {
        URIBuilder builder = new URIBuilder(this.getDdFlag(tenantCode, "DeleteUrl", "DeleteUrl"));
        builder.addParameter("id", id);
        HttpDelete httpDelete = new HttpDelete(builder.toString());
        httpDelete.setHeader("Content-Type", "application/json;charset=utf-8");
        httpDelete.setHeader("X-Access-Token", token);
        httpDelete.setHeader("X-From", "app");
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
        String msg = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        Map map = (Map)JSON.parseObject((String)msg, Map.class);
        return map;
    }

    private Map<String, Object> makeParams(UmAddressDomain umAddressDomain) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("address", umAddressDomain.getAddressDetail());
        paramsMap.put("area", umAddressDomain.getAreaName());
        paramsMap.put("areaCode", umAddressDomain.getAreaCode());
        paramsMap.put("city", umAddressDomain.getCityName());
        paramsMap.put("cityCode", umAddressDomain.getCityCode());
        paramsMap.put("delFlag", 0);
        paramsMap.put("isDefault", umAddressDomain.getAddressDefault());
        paramsMap.put("mobile", umAddressDomain.getAddressPhone());
        paramsMap.put("name", umAddressDomain.getAddressMember());
        paramsMap.put("province", umAddressDomain.getProvinceName());
        paramsMap.put("provinceCode", umAddressDomain.getProvinceCode());
        paramsMap.put("street", umAddressDomain.getRoadName());
        paramsMap.put("streetCode", umAddressDomain.getRoadCode());
        return paramsMap;
    }

    public static void main(String[] args) {
        String token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJhY2NvdW50VHlwZSI6IjEiLCJuZXdVc2VybmFtZSI6IkJpbGwiLCJpZCI6IjE1NTI4NDQyNjE4Mjc4ODcxMDUiLCJleHAiOjE3MTAzMTEyNDUsInVzZXJuYW1lIjoiMTU1Mjg0NDI2MTgyNzg4NzEwNSJ9.gcpMtnFvhSuPUh7Lo243TMWOwmDRv88HOCgblT0SFUo";
        BusAddressServiceImpl busAddressService = new BusAddressServiceImpl();
        String tenantCode = "\"784820388580450362\"";
        int i = tenantCode.lastIndexOf("\"");
        String substring = tenantCode.substring(tenantCode.indexOf("\"") + 1, tenantCode.lastIndexOf("\""));
        System.out.println(substring);
    }
}

