/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.baizhishan.service.impl;

import com.yqbsoft.laser.bus.ext.data.baizhishan.common.respone.ReturnBean;
import com.yqbsoft.laser.bus.ext.data.baizhishan.domain.AppUser;
import com.yqbsoft.laser.bus.ext.data.baizhishan.domain.upm.AppUpoints;
import com.yqbsoft.laser.bus.ext.data.baizhishan.domain.upm.QueryUpoints;
import com.yqbsoft.laser.bus.ext.data.baizhishan.domain.upm.UpmUpoints;
import com.yqbsoft.laser.bus.ext.data.baizhishan.domain.upm.UpmUpointsClearDomain;
import com.yqbsoft.laser.bus.ext.data.baizhishan.domain.upm.UpmUpointsList;
import com.yqbsoft.laser.bus.ext.data.baizhishan.domain.user.UmUserDomainBean;
import com.yqbsoft.laser.bus.ext.data.baizhishan.domain.user.UmUserReDomain;
import com.yqbsoft.laser.bus.ext.data.baizhishan.service.BusUserService;
import com.yqbsoft.laser.bus.ext.data.baizhishan.service.ExtPointsService;
import com.yqbsoft.laser.bus.ext.data.baizhishan.supbase.BusBaseService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult2;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtPointsServiceImpl
extends BusBaseService
implements ExtPointsService {
    @Autowired
    private BusUserService busUser;

    @Override
    public ReturnBean savePoints(Map<String, Object> resStream, String tenantCode) {
        if (MapUtil.isEmpty(resStream) || StringUtil.isBlank((String)tenantCode)) {
            return new ReturnBean("-1", "\u53c2\u6570\u9519\u8bef");
        }
        AppUpoints appUpoints = (AppUpoints)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), AppUpoints.class);
        if (StringUtils.isBlank((String)appUpoints.getUserId())) {
            this.logger.error("busdata.BusBaseService.savePoints appUpoints is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            return new ReturnBean("-1", "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmUserReDomain user = this.getUserDamein(appUpoints.getUserId(), tenantCode);
        if (null == user) {
            this.logger.error("busdata.BusBaseService.savePoints user is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            return new ReturnBean("-1", "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        try {
            UpmUpointsClearDomain upointsClearDomain = new UpmUpointsClearDomain();
            upointsClearDomain.setLevelUserqua(user.getUserinfoQuality());
            upointsClearDomain.setTenantCode(tenantCode);
            upointsClearDomain.setUpointsType(appUpoints.getUpointsType());
            upointsClearDomain.setUpointsOpType(appUpoints.getUpointsOpType());
            upointsClearDomain.setUpointsClearOpmark(appUpoints.getUpointsOpmark());
            if (appUpoints.getUpointsNum().compareTo(BigDecimal.ZERO) >= 0) {
                upointsClearDomain.setUpointsClearDirection("0");
            } else {
                upointsClearDomain.setUpointsClearDirection("2");
                appUpoints.setUpointsNum(BigDecimal.ZERO.subtract(appUpoints.getUpointsNum()));
            }
            upointsClearDomain.setUpointsClearNum(appUpoints.getUpointsNum());
            upointsClearDomain.setPointsRuleApi("app");
            upointsClearDomain.setMemberCode(user.getUserPcode());
            upointsClearDomain.setMemberName(user.getUserNickname());
            upointsClearDomain.setUpointsListExcode(user.getUserOcode());
            this.sendUpointsClear(upointsClearDomain);
        }
        catch (Exception e) {
            this.logger.error("busdata.BusBaseService.queryPoints.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)e));
            return new ReturnBean("-1", "\u64cd\u4f5c\u5931\u8d25");
        }
        return new ReturnBean(null);
    }

    @Override
    public ReturnBean getPoints(Map<String, Object> resStream, String tenantCode) {
        if (MapUtil.isEmpty(resStream) || StringUtil.isBlank((String)tenantCode)) {
            return new ReturnBean("-1", "\u53c2\u6570\u9519\u8bef");
        }
        AppUpoints appUpoints = (AppUpoints)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), AppUpoints.class);
        if (StringUtils.isBlank((String)appUpoints.getUserId())) {
            return new ReturnBean("-1", "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmUserReDomain user = this.getUserDamein(appUpoints.getUserId(), tenantCode);
        if (null == user) {
            this.logger.error("busdata.BusBaseService.getPoints user is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            return new ReturnBean("-1", "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        UpmUpoints upointsByUser = this.getUpointsByUser(user.getUserPcode(), appUpoints.getUpointsType(), tenantCode);
        if (null == upointsByUser) {
            return new ReturnBean(new UpmUpoints());
        }
        return new ReturnBean(upointsByUser);
    }

    @Override
    public ReturnBean queryPoints(Map<String, Object> resStream, String tenantCode) {
        if (MapUtil.isEmpty(resStream) || StringUtil.isBlank((String)tenantCode)) {
            return new ReturnBean("-1", "\u53c2\u6570\u9519\u8bef");
        }
        QueryUpoints appUpoints = (QueryUpoints)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(resStream), QueryUpoints.class);
        if (StringUtils.isBlank((String)appUpoints.getUserId())) {
            return new ReturnBean("-1", "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        UmUserReDomain user = this.getUserDamein(appUpoints.getUserId(), tenantCode);
        if (null == user) {
            this.logger.error("busdata.BusBaseService.queryPoints user is null", (Object)JsonUtil.buildNormalBinder().toJson(resStream));
            return new ReturnBean("-1", "\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        try {
            QueryResult<UpmUpointsList> upmUpointsListQueryResult = this.queryUpointsListPage(user.getUserPcode(), appUpoints.getUpointsType(), appUpoints.getUpointsListDirection(), tenantCode, appUpoints.getRows(), appUpoints.getPage());
            SupQueryResult2 queryResult = new SupQueryResult2();
            queryResult.setPageTools(upmUpointsListQueryResult.getPageTools());
            queryResult.setRows(upmUpointsListQueryResult.getRows());
            return new ReturnBean(queryResult);
        }
        catch (Exception e) {
            this.logger.error("busdata.BusBaseService.queryPoints.e", (Object)JsonUtil.buildNormalBinder().toJson((Object)e));
            return new ReturnBean("-1", "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    private UmUserReDomain getUserDamein(String appUserId, String tenantCode) {
        UmUserReDomain user = this.getUmUser(appUserId, tenantCode);
        if (null == user) {
            AppUser userById = this.busUser.getUserById(appUserId, tenantCode);
            if (null == userById) {
                this.logger.error("busdata.BusBaseService.savePoints user is null", (Object)appUserId);
                return null;
            }
            try {
                String userinfoCode;
                UmUserDomainBean umUserDomainBean = new UmUserDomainBean();
                umUserDomainBean.setTenantCode(tenantCode);
                umUserDomainBean.setUserTel(userById.getPhone());
                umUserDomainBean.setUserNickname(userById.getNickname());
                umUserDomainBean.setUserImgurl(userById.getHeadPic());
                umUserDomainBean.setUserinfoOcode(userById.getId());
                umUserDomainBean.setUserinfoCompname(userById.getId());
                umUserDomainBean.setUserOcode(userById.getId());
                umUserDomainBean.setUserName(userById.getId());
                umUserDomainBean.setUserinfoType(1);
                umUserDomainBean.setUserinfoQuality("buy");
                if (StringUtils.isNotBlank((String)userById.getCreateTime())) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    umUserDomainBean.setGmtValid(dateFormat.parse(userById.getCreateTime()));
                }
                if (StringUtil.isBlank((String)(userinfoCode = this.sendOpenUserinfo(umUserDomainBean)))) {
                    this.logger.error("busdata.BusBaseService.savePoints user is eror", (Object)appUserId);
                    return null;
                }
                user = new UmUserReDomain();
                user.setUserPcode(userinfoCode);
                user.setUserNickname(userById.getNickname());
                user.setUserTel(userById.getPhone());
                user.setUserinfoQuality(umUserDomainBean.getUserinfoQuality());
            }
            catch (Exception e) {
                throw new ApiException("busdata.BusBaseService.execute.post", (Throwable)e);
            }
        }
        return user;
    }
}

