/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.finance.service.impl;

import com.yqbsoft.laser.service.ext.bus.finance.domain.um.UmUserReDomain;
import com.yqbsoft.laser.service.ext.bus.finance.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.finance.facade.http.RestTempfacade;
import com.yqbsoft.laser.service.ext.bus.finance.facade.request.um.UmUserRequest;
import com.yqbsoft.laser.service.ext.bus.finance.facade.request.um.UmUserinfoRequest;
import com.yqbsoft.laser.service.ext.bus.finance.facade.response.um.UmUserResponse;
import com.yqbsoft.laser.service.ext.bus.finance.facade.response.um.UmUserinfoResponse;
import com.yqbsoft.laser.service.ext.bus.finance.service.BusUserService;
import com.yqbsoft.laser.service.ext.bus.finance.supbase.UserinfoBaseService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

public class BusUserServiceImpl
extends UserinfoBaseService
implements BusUserService {
    private String SYS_CODE = "extf.BusUserServiceImpl";
    private static final SupperLogUtil logger = new SupperLogUtil(BusUserServiceImpl.class);
    private String ddcode = "user";
    @Autowired
    RestTempfacade restTempfacade;

    @Override
    public String sendSaveBusUserinfo(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        UmUserinfoRequest umUserinfoRequest = new UmUserinfoRequest();
        Map<String, Object> ddmap = this.getDdMap(tenantCode, this.ddcode, "extf");
        umUserinfoRequest.init(ddmap);
        umUserinfoRequest.setOrgTenantCode(umUserinfo.getTenantCode());
        try {
            umUserinfoRequest.setSupplierCode(umUserinfo.getUserinfoCode());
            umUserinfoRequest.setName(umUserinfo.getUserinfoCompname());
            umUserinfoRequest.setCode31(umUserinfo.getUserinfoCertNo());
            umUserinfoRequest.setType("dealer");
            umUserinfoRequest.setProjectCode((String)ddmap.get("dealer"));
            if (StringUtils.isNotBlank((String)umUserinfo.getUserinfoQuality())) {
                if (umUserinfo.getUserinfoQuality().indexOf("retailer") >= 0) {
                    umUserinfoRequest.setType("dealer");
                } else if (umUserinfo.getUserinfoQuality().indexOf("supplier") >= 0) {
                    umUserinfoRequest.setType("supplier");
                    umUserinfoRequest.setProjectCode((String)ddmap.get("supplier"));
                }
            }
            umUserinfoRequest.setCoreCode((String)ddmap.get("coreCode"));
            umUserinfoRequest.setLegalPerson(umUserinfo.getUserinfoCorp());
            umUserinfoRequest.setContactsPhone(umUserinfo.getUserinfoConPhone());
            umUserinfoRequest.setAddress(umUserinfo.getCompanyAddress());
            String apiCode = "addCustomer";
            if ("insert".equals(optype)) {
                apiCode = "addCustomer";
            } else if ("update".equals(optype)) {
                apiCode = 0 > umUserinfo.getDataState() ? "delCustomer" : "editCustomer";
            }
            umUserinfoRequest.setOutsideApiUrl(apiCode);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.e", (Throwable)e);
            return "error";
        }
        UmUserinfoResponse umUserinfoResponse = this.restTempfacade.execute(umUserinfoRequest);
        if (null == umUserinfoResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse");
            return "error";
        }
        if (!umUserinfoResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUserinfo.umUserinfoResponse", (Object)umUserinfoResponse.getMsg());
            return umUserinfoResponse.getMsg();
        }
        this.sendSaveBusUser(umUserinfo, umUser, optype);
        return "success";
    }

    @Override
    public String sendSaveBusUser(UmUserinfoReDomain umUserinfo, UmUserReDomain umUser, String optype) {
        if (null == umUserinfo || null == umUser) {
            logger.error(this.SYS_CODE + ".sendSaveBusUser.umUserinfo");
            return "error";
        }
        String tenantCode = umUserinfo.getTenantCode();
        UmUserRequest umUserRequest = new UmUserRequest();
        Map<String, Object> ddmap = this.getDdMap(tenantCode, this.ddcode, "extf");
        umUserRequest.init(ddmap);
        umUserRequest.setOrgTenantCode(umUserinfo.getTenantCode());
        try {
            umUserRequest.setSupplierCode(umUserinfo.getUserinfoCode());
            if (StringUtils.isNotBlank((String)umUserinfo.getUserinfoPhone())) {
                umUserRequest.setPhone(umUserinfo.getUserinfoPhone());
            } else {
                umUserRequest.setPhone(umUserinfo.getUserinfoConPhone());
            }
            umUserRequest.setPwd(this.getPwdDef() + "");
            String apiCode = "registerUser";
            if (optype.indexOf("insert") >= 0) {
                apiCode = "registerUser";
            } else if (optype.indexOf("update") >= 0) {
                apiCode = 0 > umUserinfo.getDataState() ? "editUserPhone" : "editUserPhone";
            }
            umUserRequest.setOutsideApiUrl(apiCode);
        }
        catch (Exception e) {
            logger.error(this.SYS_CODE + ".sendSaveBusUser.e", (Throwable)e);
            return "error";
        }
        UmUserResponse umUserResponse = this.restTempfacade.execute(umUserRequest);
        if (null == umUserResponse) {
            logger.error(this.SYS_CODE + ".sendSaveBusUser.umUserResponse");
            return "error";
        }
        if (!umUserResponse.getSuccess().booleanValue()) {
            logger.error(this.SYS_CODE + ".sendSaveBusUser.umUserResponse", (Object)umUserResponse.getMsg());
            return umUserResponse.getMsg();
        }
        return "success";
    }

    public int getPwdDef() {
        Random random = new Random();
        return random.nextInt(900000) + 100000;
    }
}

