/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cMapEnum;
import com.yqbsoft.laser.service.ims.domain.DisChannelDomain;
import com.yqbsoft.laser.service.ims.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ims.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ims.entity.ImsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.Mvgr1Entity;
import com.yqbsoft.laser.service.ims.sap.entity.SizeEntity;
import com.yqbsoft.laser.service.ims.service.DataSynchronousService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSynchronousServiceImpl
extends BaseServiceImpl
implements DataSynchronousService {
    private static final Logger log = LoggerFactory.getLogger(DataSynchronousServiceImpl.class);
    private static Map<String, String> specGroupCodeMap = new HashMap<String, String>();
    private static Map<String, String> brandCodeMap = new HashMap<String, String>();
    private static Map<String, String> pntreeNameAndCodeMap = new HashMap<String, String>();
    private static final String type = "%s\u5546\u54c1\u7c7b\u578b";

    @Override
    public Boolean goodsDataSynchronous() {
        JsonEntity jsonEntity = new JsonEntity();
        String specInfo = this.synchronousSpecInfo(jsonEntity);
        log.info("specInfo::{}", (Object)specInfo);
        ImsEntity imsEntity = new ImsEntity();
        List<ImsEntity> imsEntityInfo = imsEntity.getImsEntityInfo();
        log.info("imsEntityInfo::{}", (Object)imsEntityInfo.size());
        for (ImsEntity ims : imsEntityInfo) {
            log.info("imsEntityInfo::{}", (Object)(imsEntityInfo.size() - 1));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("memberCode", LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode());
            map.put("tenantCode", "2022012800000001");
            log.info("\u54c1\u724c\u67e5\u8be2\u4fe1\u606f::{}", map);
            SupQueryResult<RsBrandDomain> rs = this.queryBrandPage(map);
            log.info("rs::::{}", rs);
            if (rs != null) {
                log.info("ims.getSubBrand()::{}", (Object)ims.getSubBrand());
                log.info("ele.getMemo()::{}", rs);
                Optional<RsBrandDomain> rsBrandDomain = rs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getMemo().equals(ims.getSubBrand())).findFirst();
                if (!rsBrandDomain.isPresent()) {
                    Mvgr1Entity mvgr1Entity = (Mvgr1Entity)jsonEntity.getMVGR1().stream().filter(entity -> entity.getMVGR1().equals(ims.getSubBrand())).collect(Collectors.toList()).get(0);
                    String brandCode = this.saveBrand(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001", mvgr1Entity);
                    log.info("brandCode1::{}", (Object)brandCode);
                    brandCodeMap.put(mvgr1Entity.getMVGR1(), brandCode);
                } else {
                    RsBrandDomain rsBrandDomain1 = rsBrandDomain.get();
                    log.info("rsBrandDomain1::{}", (Object)rsBrandDomain1);
                    log.info("rsBrandDomain1::{}", (Object)rsBrandDomain1.getMemo());
                    log.info("rsBrandDomain1::{}", (Object)rsBrandDomain1.getBrandCode());
                    brandCodeMap.put(rsBrandDomain1.getMemo(), rsBrandDomain1.getBrandCode());
                }
            } else {
                Mvgr1Entity mvgr1Entity = (Mvgr1Entity)jsonEntity.getMVGR1().stream().filter(entity -> entity.getMVGR1().equals(ims.getSubBrand())).collect(Collectors.toList()).get(0);
                String brandCode = this.saveBrand(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001", mvgr1Entity);
                log.info("brandCode2::{}", (Object)brandCode);
                brandCodeMap.put(mvgr1Entity.getMVGR1(), brandCode);
            }
            log.info("brandCodeMap::{}", (Object)JsonUtil.buildNormalBinder().toJson(brandCodeMap));
            SupQueryResult<RsPntreeReDomain> pntreeRs = this.queryPntreePage("2022012800000001");
            log.info("pntreeRs::{}", pntreeRs);
            if (pntreeRs != null) {
                Optional<RsPntreeReDomain> rsPntreeReDomain1 = pntreeRs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getPntreeName() != null).filter(ele -> ele.getPntreeName().equals(ims.getSubBrand())).findFirst();
                if (!rsPntreeReDomain1.isPresent()) {
                    String pntreeCode = this.savePntree(ims.getSubBrand(), brandCodeMap.get(ims.getSubBrand()), specGroupCodeMap.get("specGroupCode"), "2022012800000001", LancyWithB2cMapEnum.getByValue(ims.getBrand()).getName());
                    log.info("pntreeCode1\uff1a\uff1a{}", (Object)pntreeCode);
                    pntreeNameAndCodeMap.put(ims.getSubBrand(), pntreeCode);
                } else {
                    RsPntreeReDomain rsPntreeReDomain = rsPntreeReDomain1.get();
                    log.info("rsPntreeReDomain::{}", (Object)rsPntreeReDomain);
                    pntreeNameAndCodeMap.put(rsPntreeReDomain.getPntreeName(), rsPntreeReDomain.getPntreeCode());
                }
            } else {
                String pntreeCode = this.savePntree(ims.getSubBrand(), brandCodeMap.get(ims.getSubBrand()), specGroupCodeMap.get("specGroupCode"), "2022012800000001", LancyWithB2cMapEnum.getByValue(ims.getBrand()).getName());
                log.info("pntreeCode2::{}", (Object)pntreeCode);
                pntreeNameAndCodeMap.put(ims.getSubBrand(), pntreeCode);
            }
            log.info("pntreeNameAndCodeMap::{}", (Object)JsonUtil.buildNormalBinder().toJson(pntreeNameAndCodeMap));
            List<RsClasstreeReDomain> rsClasstreeReDomains = this.queryClasstreePage("2022012800000001", LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "0", true, this.queryChannelPage(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001").getChannelCode());
            log.info("rsClasstreeReDomains::{}", rsClasstreeReDomains);
        }
        log.info("\u9000\u51fa\u5faa\u73af");
        return Boolean.TRUE;
    }

    public List<RsClasstreeReDomain> queryClasstreePage(String tenantCode, String memberCode, String classtreeType, boolean flag, String channelCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        param.put("memberCode", memberCode);
        param.put("classtreeType", classtreeType);
        param.put("channelCode", channelCode);
        ArrayList<RsClasstreeReDomain> reDomainList = new ArrayList<RsClasstreeReDomain>();
        log.info("queryClasstreePage.param::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.rsClasstree.queryClasstreePage", param, RsClasstreeReDomain.class);
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return reDomainList;
        }
        log.info("\u6240\u6709\u5206\u7c7b\uff1a\uff1a{}", (Object)reDomainSupQueryResult);
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsClasstreeReDomain> rootClass = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getClasstreeParentcode().equals("-1")) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : rootClass) {
            List<RsClasstreeReDomain> childList = this.getChild(rsClasstreeReDomain.getClasstreeCode(), all);
            if (flag) {
                rsClasstreeReDomain.setChildList(childList);
                continue;
            }
            if (ListUtil.isNotEmpty(childList)) {
                ArrayList<RsClasstreeReDomain> childList1 = new ArrayList<RsClasstreeReDomain>();
                for (RsClasstreeReDomain rsClasstreeReDomain1 : childList) {
                    if (!ListUtil.isNotEmpty(rsClasstreeReDomain1.getChildList()) && !"0".equals(rsClasstreeReDomain1.getClasstreeLast())) continue;
                    childList1.add(rsClasstreeReDomain1);
                    rsClasstreeReDomain.setChildList(childList1);
                }
            }
            if (!ListUtil.isNotEmpty(rsClasstreeReDomain.getChildList()) && !"0".equals(rsClasstreeReDomain.getClasstreeLast())) continue;
            reDomainList.add(rsClasstreeReDomain);
        }
        return reDomainList;
    }

    public List<RsClasstreeReDomain> getChild(String id, List<RsClasstreeReDomain> all) {
        ArrayList<RsClasstreeReDomain> childList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getClasstreeParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    public DisChannelDomain queryChannelPage(String memBerCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memBerCode", memBerCode);
        map.put("tenantCode", tenantCode);
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", map, DisChannelDomain.class);
        return (DisChannelDomain)rs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getChannelCode() != null && ele.getChannelName() != null).collect(Collectors.toList()).get(0);
    }

    public String saveBrand(String memberCode, String tenantCode, Mvgr1Entity mvgr1Entity) {
        RsBrandDomain brandDomain = new RsBrandDomain();
        brandDomain.setMemberCode(memberCode);
        brandDomain.setBrandName(mvgr1Entity.getBEZEI());
        brandDomain.setMemo(mvgr1Entity.getMVGR1());
        brandDomain.setTenantCode(tenantCode);
        brandDomain.setBrandLogo("\u540c\u6b65\u6570\u636e\u6682\u65e0\u54c1\u724c\u56fe\u7247");
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, tenantCode);
        brandDomain.setChannelCode(disChannelDomain.getChannelCode());
        brandDomain.setChannelName(disChannelDomain.getChannelName());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)brandDomain));
        return (String)this.getInternalRouter().inInvoke("rs.resource.sendSaveBrand", pmap);
    }

    public SupQueryResult<RsBrandDomain> queryBrandPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl("rs.brand.queryBrandPage", pmap, RsBrandDomain.class);
        return queryResutl;
    }

    public SupQueryResult<RsPntreeReDomain> queryPntreePage(String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rsPntreeReDomains = this.getQueryResutl("rs.pntree.queryPntreePage", pmap, RsPntreeReDomain.class);
        return rsPntreeReDomains;
    }

    public String savePntree(String pntreeName, String brandCode, String specGroupCode, String tenantCode, String typeCode) {
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        rsPntreeDomain.setPntreeName(pntreeName);
        rsPntreeDomain.setBrandCodeStr(String.valueOf(brandCode));
        rsPntreeDomain.setSpecGroupCodeStr(specGroupCode);
        rsPntreeDomain.setTenantCode(tenantCode);
        rsPntreeDomain.setPntreeShow(0);
        rsPntreeDomain.setAppmanageIcode(typeCode.equals(LancyWithB2cMapEnum.LANCY_CODE.getName()) ? "021" : "02101");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsPntreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsPntreeDomain));
        return this.getInternalRouter().inInvoke("rs.pntree.savePntree", pmap).toString();
    }

    public List<RsSpecGroupDomain> querySpecGroup(Map<String, Object> map) throws Exception {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecGroupPage", pmap, RsSpecGroupDomain.class);
        List<RsSpecGroupDomain> specGroup = rs.getList().stream().filter(Objects::nonNull).filter(ele -> "\u901a\u7528\u89c4\u683c\u7ec4".equals(ele.getSpecGroupName())).collect(Collectors.toList());
        if (specGroup.size() > 1) {
            throw new Exception("\u83b7\u53d6\u5230\u591a\u4e2a\u901a\u7528\u89c4\u683c\u7ec4,\u8bf7\u786e\u8ba4\u6570\u636e\u51c6\u786e\u6027");
        }
        if (specGroup.size() != 0) {
            return specGroup;
        }
        return null;
    }

    public String saveSpecGroup(String channelCode, String memBerCode, String tenantCode) {
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        rsSpecGroupDomain.setSpecGroupName("\u901a\u7528\u89c4\u683c\u7ec4");
        rsSpecGroupDomain.setChannelCode(channelCode);
        rsSpecGroupDomain.setMemberCode(memBerCode);
        rsSpecGroupDomain.setTenantCode(tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecGroupDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain));
        String specGroupCode = this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", pmap).toString();
        specGroupCodeMap.put("specGroupCode", specGroupCode);
        return specGroupCode;
    }

    public SupQueryResult<RsSpecDomain> querySpecPage(String specGroupCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecPage", pmap, RsSpecDomain.class);
        return rs;
    }

    public String saveSpec(String specGroupCode, String specName, String tenantCode) {
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        rsSpecDomain.setSpecGroupCode(specGroupCode);
        rsSpecDomain.setSpecName(specName);
        rsSpecDomain.setTenantCode(tenantCode);
        rsSpecDomain.setSpecDefault("1");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain));
        return this.getInternalRouter().inInvoke("rs.spec.saveSpec", pmap).toString();
    }

    public Boolean saveSpecOption(List<RsSpecOptionDomain> rsSpecOptionDomains) {
        for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecOptionDomains) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("rsSpecOptionDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain));
            this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", pmap);
        }
        return Boolean.TRUE;
    }

    public List<RsSpecOptionDomain> querySpecOptionPage(String specCode, String specOptionNum) {
        log.info("specCode::{}", (Object)specCode);
        log.info("specOptionNum::{}", (Object)specOptionNum);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specCode", specCode);
        map.put("specOptionNum", specOptionNum);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public String synchronousSpecInfo(JsonEntity jsonEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memBerCode", LancyWithB2cMapEnum.getByValue("D01").getCode());
        map.put("tenantCode", "2022012800000001");
        String specGroupCode = (String)this.querySpecGroup(map).stream().map(RsSpecGroupDomain::getSpecGroupCode).collect(Collectors.toList()).get(0);
        if (specGroupCode == null) {
            specGroupCode = this.saveSpecGroup(this.queryChannelPage(LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001").getChannelCode(), LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001");
        } else {
            specGroupCodeMap.put("specGroupCode", specGroupCode);
        }
        List spec = Objects.requireNonNull(this.querySpecPage(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"))).getList();
        String specCodeSize = null;
        String specCodeColor = null;
        for (RsSpecDomain rsSpecDomain : Objects.requireNonNull(spec, "spec\u4e3a\u7a7a")) {
            if ("\u5c3a\u5bf8".equals(rsSpecDomain.getSpecName())) {
                specCodeSize = rsSpecDomain.getSpecCode();
                continue;
            }
            if (!"\u989c\u8272".equals(rsSpecDomain.getSpecName())) continue;
            specCodeColor = rsSpecDomain.getSpecCode();
        }
        if (specCodeSize == null) {
            specCodeSize = this.saveSpec(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"), "\u5c3a\u5bf8", "2022012800000001");
        }
        if (specCodeColor == null) {
            specCodeColor = this.saveSpec(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"), "\u989c\u8272", "2022012800000001");
        }
        ArrayList<RsSpecOptionDomain> saveSpecOptionSize = new ArrayList<RsSpecOptionDomain>();
        ArrayList<RsSpecOptionDomain> saveSpecOptionColor = new ArrayList<RsSpecOptionDomain>();
        for (SizeEntity sizeEntity : jsonEntity.getSIZE()) {
            int size = this.querySpecOptionPage(specCodeSize, sizeEntity.getJSIZE()).size();
            log.info("size::{}", (Object)size);
            if (size != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainSize = new RsSpecOptionDomain();
            rsSpecOptionDomainSize.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainSize.setSpecCode(specCodeSize);
            rsSpecOptionDomainSize.setSpecOptionName(sizeEntity.getSIZET());
            rsSpecOptionDomainSize.setSpecOptionNum(sizeEntity.getJSIZE());
            rsSpecOptionDomainSize.setTenantCode("2022012800000001");
            rsSpecOptionDomainSize.setMemberCode(LancyWithB2cMapEnum.LANCY_CODE.getCode());
            saveSpecOptionSize.add(rsSpecOptionDomainSize);
        }
        for (ColorEntity colorEntity : jsonEntity.getCOLOR()) {
            if (this.querySpecOptionPage(specCodeColor, colorEntity.getJ_3ACOL()).size() != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainContro = new RsSpecOptionDomain();
            rsSpecOptionDomainContro.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainContro.setSpecCode(specCodeColor);
            rsSpecOptionDomainContro.setSpecOptionName(colorEntity.getTEXT());
            rsSpecOptionDomainContro.setSpecOptionNum(colorEntity.getJ_3ACOL());
            rsSpecOptionDomainContro.setTenantCode("2022012800000001");
            rsSpecOptionDomainContro.setMemberCode(LancyWithB2cMapEnum.LANCY_CODE.getCode());
            saveSpecOptionColor.add(rsSpecOptionDomainContro);
        }
        if (saveSpecOptionSize.size() != 0) {
            log.info("saveSpecOptionSize::{}", saveSpecOptionSize);
            this.saveSpecOption(saveSpecOptionSize);
        }
        if (saveSpecOptionColor.size() != 0) {
            log.info("\u4fdd\u5b58\u989c\u8272\u4e09\u7ea7", saveSpecOptionColor);
            this.saveSpecOption(saveSpecOptionColor);
        }
        return specGroupCode;
    }
}

