/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ims.common.enums.LancyWithB2cMapEnum;
import com.yqbsoft.laser.service.ims.domain.DisChannelDomain;
import com.yqbsoft.laser.service.ims.domain.RsBrandDomain;
import com.yqbsoft.laser.service.ims.domain.RsClasstreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsClasstreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeDomain;
import com.yqbsoft.laser.service.ims.domain.RsPntreeReDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecGroupDomain;
import com.yqbsoft.laser.service.ims.domain.RsSpecOptionDomain;
import com.yqbsoft.laser.service.ims.entity.ImsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.LclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.MclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.Mvgr1Entity;
import com.yqbsoft.laser.service.ims.sap.entity.SclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SizeEntity;
import com.yqbsoft.laser.service.ims.service.DataSynchronousService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSynchronousServiceImpl
extends BaseServiceImpl
implements DataSynchronousService {
    private static final Logger log = LoggerFactory.getLogger(DataSynchronousServiceImpl.class);
    private static Map<String, String> specGroupCodeMap = new Hashtable<String, String>();
    private static Map<String, String> brandCodeMap = new Hashtable<String, String>();
    private static Map<String, String> pntreeNameAndCodeMap = new Hashtable<String, String>();
    private static Map<String, String> classtreeNameAndMemoMap = new Hashtable<String, String>();

    @Override
    public Boolean goodsDataSynchronous() {
        JsonEntity jsonEntity = new JsonEntity();
        String specInfo = this.synchronousSpecInfo(jsonEntity);
        log.info("specInfo::{}", (Object)specInfo);
        ImsEntity imsEntity = new ImsEntity();
        List<ImsEntity> imsEntityInfo = imsEntity.getImsEntityInfo();
        log.info("imsEntityInfo::{}", (Object)imsEntityInfo.size());
        for (ImsEntity ims : imsEntityInfo) {
            log.info("imsEntityInfo::{}", (Object)(imsEntityInfo.size() - 1));
            this.synchronousBrand(ims, jsonEntity);
            log.info("brandCodeMap::{}", (Object)JsonUtil.buildNormalBinder().toJson(brandCodeMap));
            this.synchronousPntree(ims);
            log.info("pntreeNameAndCodeMap::{}", (Object)JsonUtil.buildNormalBinder().toJson(pntreeNameAndCodeMap));
            this.synchronousClasstree(ims, jsonEntity);
            log.info("classtreeNameAndMemoMap:::{}", (Object)JsonUtil.buildNormalBinder().toJson(classtreeNameAndMemoMap));
        }
        log.info("\u9000\u51fa\u5faa\u73af");
        return Boolean.TRUE;
    }

    public String structureClasstreeInfo(Integer source, ImsEntity ims, JsonEntity jsonEntity, String classtreeParentcode) {
        log.info("classtreeParentcode::{}", (Object)classtreeParentcode);
        String memberCode = LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode();
        RsClasstreeDomain classtreeDomain = new RsClasstreeDomain();
        classtreeDomain.setPntreeCode(pntreeNameAndCodeMap.get(ims.getSubBrand()));
        classtreeDomain.setChannelCode(this.queryChannelPage(memberCode, "2022012800000001").getChannelCode());
        classtreeDomain.setMemberCode(memberCode);
        classtreeDomain.setClasstreeLast("1");
        if (source == 1) {
            classtreeDomain.setClasstreeParentcode("-1");
            String lclsSaveCode = this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField3()));
            log.info("lclsSaveCode:{}", (Object)lclsSaveCode);
            return lclsSaveCode;
        }
        if (source == 2) {
            classtreeDomain.setClasstreeParentcode(classtreeParentcode);
            String mclsSaveCode = this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField5()));
            log.info("mclsSaveCode::{}", (Object)mclsSaveCode);
            return mclsSaveCode;
        }
        if (source == 3) {
            classtreeDomain.setClasstreeParentcode(classtreeParentcode);
            classtreeDomain.setClasstreeLast("0");
            String sclsSaveCode = this.saveClasstree(classtreeDomain, this.getClasstreeInfo(jsonEntity, source, ims.getField4()));
            log.info("sclsSaveCode::{}", (Object)sclsSaveCode);
            return sclsSaveCode;
        }
        return null;
    }

    public List<String> getClasstreeInfo(JsonEntity jsonEntity, Integer source, String code) {
        if (jsonEntity.getLCLS() != null && source == 1) {
            LclsEntity lclsEntity = jsonEntity.getLCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getLABOR() != null && ele.getLBTXT() != null).filter(ele -> ele.getLABOR().equals(code)).findFirst().get();
            return Arrays.asList(lclsEntity.getLABOR(), lclsEntity.getLBTXT());
        }
        if (jsonEntity.getMCLS() != null && source == 2) {
            MclsEntity mclsEntity = jsonEntity.getMCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getMATKL() != null && ele.getWGBEZ60() != null).filter(ele -> ele.getMATKL().equals(code)).findFirst().get();
            return Arrays.asList(mclsEntity.getMATKL(), mclsEntity.getWGBEZ60());
        }
        if (jsonEntity.getSCLS() != null && source == 3) {
            log.info("jsonEntity.getSCLS():::", jsonEntity.getSCLS());
            SclsEntity sclsEntity = jsonEntity.getSCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getEXTWG() != null && ele.getEWBEZ() != null).filter(ele -> ele.getEXTWG().equals(code)).findFirst().get();
            return Arrays.asList(sclsEntity.getEXTWG(), sclsEntity.getEWBEZ());
        }
        return null;
    }

    public List<RsClasstreeReDomain> queryClasstreePage(String tenantCode, String memberCode, String classtreeType, String channelCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", tenantCode);
        param.put("memberCode", memberCode);
        param.put("classtreeType", classtreeType);
        param.put("channelCode", channelCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        log.info("queryClasstreePage.param::{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(param));
        QueryResult reDomainSupQueryResult = this.getQueryResutl("rs.rsClasstree.queryClasstreePage", pmap, RsClasstreeReDomain.class);
        ArrayList<RsClasstreeReDomain> reDomainList = new ArrayList<RsClasstreeReDomain>();
        if (null == reDomainSupQueryResult || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            return reDomainList;
        }
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsClasstreeReDomain> rootClass = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            if (!"-1".equals(rsClasstreeReDomain.getClasstreeParentcode())) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        log.info("rootClass:::{}", (Object)JsonUtil.buildNormalBinder().toJson(rootClass));
        for (RsClasstreeReDomain rsClasstreeReDomain : rootClass) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        return rootClass;
    }

    public String saveClasstree(RsClasstreeDomain rsClasstreeDomain, List<String> list) {
        Objects.requireNonNull(list, "list\u4e3a\u83b7\u53d6\u7684\u5206\u7c7b\u7c7b\u578b");
        rsClasstreeDomain.setTenantCode("2022012800000001");
        rsClasstreeDomain.setMemo(list.get(0));
        rsClasstreeDomain.setClasstreeName(list.get(1));
        rsClasstreeDomain.setClasstreeType("0");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsClasstreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsClasstreeDomain));
        log.info("\u5206\u7c7b\u7c7b\u578b\u65b0\u6dfb\u6570\u636epmap::{}", (Object)JsonUtil.buildNormalBinder().toJson(pmap));
        String classtreeCode = this.getInternalRouter().inInvoke("rs.resource.sendSaveClasstree", pmap).toString();
        classtreeNameAndMemoMap.put(rsClasstreeDomain.getMemo(), classtreeCode);
        return classtreeCode;
    }

    public List<RsClasstreeReDomain> getChild(String id, List<RsClasstreeReDomain> all) {
        ArrayList<RsClasstreeReDomain> childList = new ArrayList<RsClasstreeReDomain>();
        for (RsClasstreeReDomain rsClasstreeReDomain : all) {
            log.info("id::{}", (Object)id);
            if (!rsClasstreeReDomain.getClasstreeParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsClasstreeReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getClasstreeCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    public DisChannelDomain queryChannelPage(String memBerCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memBerCode", memBerCode);
        map.put("tenantCode", tenantCode);
        QueryResult rs = this.getQueryResutl("dis.channel.queryChannelPage", map, DisChannelDomain.class);
        return (DisChannelDomain)rs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getChannelCode() != null && ele.getChannelName() != null).collect(Collectors.toList()).get(0);
    }

    public String saveBrand(String memberCode, String tenantCode, Mvgr1Entity mvgr1Entity) {
        RsBrandDomain brandDomain = new RsBrandDomain();
        brandDomain.setMemberCode(memberCode);
        brandDomain.setBrandName(mvgr1Entity.getBEZEI());
        brandDomain.setMemo(mvgr1Entity.getMVGR1());
        brandDomain.setTenantCode(tenantCode);
        brandDomain.setBrandLogo("\u540c\u6b65\u6570\u636e\u6682\u65e0\u54c1\u724c\u56fe\u7247");
        DisChannelDomain disChannelDomain = this.queryChannelPage(memberCode, tenantCode);
        brandDomain.setChannelCode(disChannelDomain.getChannelCode());
        brandDomain.setChannelName(disChannelDomain.getChannelName());
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsBrandDomain", JsonUtil.buildNormalBinder().toJson((Object)brandDomain));
        return (String)this.getInternalRouter().inInvoke("rs.resource.sendSaveBrand", pmap);
    }

    public SupQueryResult<RsBrandDomain> queryBrandPage(Map<String, Object> map) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult queryResutl = this.getQueryResutl("rs.brand.queryBrandPage", pmap, RsBrandDomain.class);
        return queryResutl;
    }

    public SupQueryResult<RsPntreeReDomain> queryPntreePage(String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rsPntreeReDomains = this.getQueryResutl("rs.pntree.queryPntreePage", pmap, RsPntreeReDomain.class);
        return rsPntreeReDomains;
    }

    public String savePntree(String pntreeName, String brandCode, String tenantCode, String typeCode) {
        RsPntreeDomain rsPntreeDomain = new RsPntreeDomain();
        rsPntreeDomain.setPntreeName(pntreeName);
        rsPntreeDomain.setBrandCodeStr(String.valueOf(brandCode));
        String specGroupCode = specGroupCodeMap.get("specGroupCode");
        log.info("specGroupCode::{}", (Object)specGroupCode);
        rsPntreeDomain.setSpecGroupCodeStr(specGroupCode);
        rsPntreeDomain.setTenantCode(tenantCode);
        rsPntreeDomain.setPntreeShow(0);
        rsPntreeDomain.setAppmanageIcode(typeCode.equals(LancyWithB2cMapEnum.LANCY_CODE.getName()) ? "021" : "02101");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsPntreeDomain", JsonUtil.buildNormalBinder().toJson((Object)rsPntreeDomain));
        return this.getInternalRouter().inInvoke("rs.pntree.savePntree", pmap).toString();
    }

    public RsSpecGroupDomain querySpecGroup(Map<String, Object> map) throws Exception {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecGroupPage", pmap, RsSpecGroupDomain.class);
        RsSpecGroupDomain rsSpecGroupDomain = rs.getList().stream().filter(Objects::nonNull).filter(ele -> "\u901a\u7528\u89c4\u683c\u7ec4".equals(ele.getSpecGroupName())).findFirst().get();
        if (rsSpecGroupDomain != null) {
            specGroupCodeMap.put("specGroupCode", rsSpecGroupDomain.getSpecGroupCode());
            return rsSpecGroupDomain;
        }
        return null;
    }

    public String saveSpecGroup(String channelCode, String memBerCode, String tenantCode) {
        RsSpecGroupDomain rsSpecGroupDomain = new RsSpecGroupDomain();
        rsSpecGroupDomain.setSpecGroupName("\u901a\u7528\u89c4\u683c\u7ec4");
        rsSpecGroupDomain.setChannelCode(channelCode);
        rsSpecGroupDomain.setMemberCode(memBerCode);
        rsSpecGroupDomain.setTenantCode(tenantCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecGroupDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecGroupDomain));
        String specGroupCode = this.getInternalRouter().inInvoke("rs.spec.saveSpecGroup", pmap).toString();
        specGroupCodeMap.put("specGroupCode", specGroupCode);
        return specGroupCode;
    }

    public SupQueryResult<RsSpecDomain> querySpecPage(String specGroupCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specGroupCode", specGroupCode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.spec.querySpecPage", pmap, RsSpecDomain.class);
        return rs;
    }

    public String saveSpec(String specGroupCode, String specName, String tenantCode) {
        RsSpecDomain rsSpecDomain = new RsSpecDomain();
        rsSpecDomain.setSpecGroupCode(specGroupCode);
        rsSpecDomain.setSpecName(specName);
        rsSpecDomain.setTenantCode(tenantCode);
        rsSpecDomain.setSpecDefault("1");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("rsSpecDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecDomain));
        return this.getInternalRouter().inInvoke("rs.spec.saveSpec", pmap).toString();
    }

    public Boolean saveSpecOption(List<RsSpecOptionDomain> rsSpecOptionDomains) {
        for (RsSpecOptionDomain rsSpecOptionDomain : rsSpecOptionDomains) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("rsSpecOptionDomain", JsonUtil.buildNormalBinder().toJson((Object)rsSpecOptionDomain));
            this.getInternalRouter().inInvoke("rs.spec.saveSpecOption", pmap);
        }
        return Boolean.TRUE;
    }

    public List<RsSpecOptionDomain> querySpecOptionPage(String specCode, String specOptionNum) {
        log.info("specCode::{}", (Object)specCode);
        log.info("specOptionNum::{}", (Object)specOptionNum);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("specCode", specCode);
        map.put("specOptionNum", specOptionNum);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        return this.getQueryResutl("rs.spec.querySpecOptionPage", pmap, RsSpecOptionDomain.class).getList();
    }

    public String synchronousSpecInfo(JsonEntity jsonEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memBerCode", LancyWithB2cMapEnum.getByValue("D01").getCode());
        map.put("tenantCode", "2022012800000001");
        String specGroupCode = this.querySpecGroup(map).getSpecGroupCode();
        if (specGroupCode == null) {
            specGroupCode = this.saveSpecGroup(this.queryChannelPage(LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001").getChannelCode(), LancyWithB2cMapEnum.getByValue("D01").getCode(), "2022012800000001");
        }
        List spec = Objects.requireNonNull(this.querySpecPage(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"))).getList();
        String specCodeSize = null;
        String specCodeColor = null;
        for (RsSpecDomain rsSpecDomain : Objects.requireNonNull(spec, "spec\u4e3a\u7a7a")) {
            if ("\u5c3a\u5bf8".equals(rsSpecDomain.getSpecName())) {
                specCodeSize = rsSpecDomain.getSpecCode();
                continue;
            }
            if (!"\u989c\u8272".equals(rsSpecDomain.getSpecName())) continue;
            specCodeColor = rsSpecDomain.getSpecCode();
        }
        if (specCodeSize == null) {
            specCodeSize = this.saveSpec(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"), "\u5c3a\u5bf8", "2022012800000001");
        }
        if (specCodeColor == null) {
            specCodeColor = this.saveSpec(Objects.requireNonNull(specGroupCode, "specGroupCode\u4e3a\u7a7a"), "\u989c\u8272", "2022012800000001");
        }
        ArrayList<RsSpecOptionDomain> saveSpecOptionSize = new ArrayList<RsSpecOptionDomain>();
        ArrayList<RsSpecOptionDomain> saveSpecOptionColor = new ArrayList<RsSpecOptionDomain>();
        for (SizeEntity sizeEntity : jsonEntity.getSIZE()) {
            int size = this.querySpecOptionPage(specCodeSize, sizeEntity.getJSIZE()).size();
            log.info("size::{}", (Object)size);
            if (size != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainSize = new RsSpecOptionDomain();
            rsSpecOptionDomainSize.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainSize.setSpecCode(specCodeSize);
            rsSpecOptionDomainSize.setSpecOptionName(sizeEntity.getSIZET());
            rsSpecOptionDomainSize.setSpecOptionNum(sizeEntity.getJSIZE());
            rsSpecOptionDomainSize.setTenantCode("2022012800000001");
            rsSpecOptionDomainSize.setMemberCode(LancyWithB2cMapEnum.LANCY_CODE.getCode());
            saveSpecOptionSize.add(rsSpecOptionDomainSize);
        }
        for (ColorEntity colorEntity : jsonEntity.getCOLOR()) {
            if (this.querySpecOptionPage(specCodeColor, colorEntity.getJ_3ACOL()).size() != 0) continue;
            RsSpecOptionDomain rsSpecOptionDomainContro = new RsSpecOptionDomain();
            rsSpecOptionDomainContro.setSpecGroupCode(specGroupCode);
            rsSpecOptionDomainContro.setSpecCode(specCodeColor);
            rsSpecOptionDomainContro.setSpecOptionName(colorEntity.getTEXT());
            rsSpecOptionDomainContro.setSpecOptionNum(colorEntity.getJ_3ACOL());
            rsSpecOptionDomainContro.setTenantCode("2022012800000001");
            rsSpecOptionDomainContro.setMemberCode(LancyWithB2cMapEnum.LANCY_CODE.getCode());
            saveSpecOptionColor.add(rsSpecOptionDomainContro);
        }
        if (saveSpecOptionSize.size() != 0) {
            log.info("saveSpecOptionSize::{}", saveSpecOptionSize);
            this.saveSpecOption(saveSpecOptionSize);
        }
        if (saveSpecOptionColor.size() != 0) {
            log.info("\u4fdd\u5b58\u989c\u8272\u4e09\u7ea7", saveSpecOptionColor);
            this.saveSpecOption(saveSpecOptionColor);
        }
        return specGroupCode;
    }

    public Boolean synchronousBrand(ImsEntity ims, JsonEntity jsonEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode());
        map.put("tenantCode", "2022012800000001");
        log.info("\u54c1\u724c\u67e5\u8be2\u4fe1\u606f::{}", map);
        SupQueryResult<RsBrandDomain> rs = this.queryBrandPage(map);
        log.info("rs::::{}", rs);
        if (rs != null) {
            log.info("ims.getSubBrand()::{}", (Object)ims.getSubBrand());
            log.info("ele.getMemo()::{}", rs);
            Optional<RsBrandDomain> rsBrandDomain = rs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getMemo().equals(ims.getSubBrand())).findFirst();
            if (!rsBrandDomain.isPresent()) {
                Mvgr1Entity mvgr1Entity = (Mvgr1Entity)jsonEntity.getMVGR1().stream().filter(entity -> entity.getMVGR1().equals(ims.getSubBrand())).collect(Collectors.toList()).get(0);
                String brandCode = this.saveBrand(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001", mvgr1Entity);
                log.info("brandCode1::{}", (Object)brandCode);
                brandCodeMap.put(mvgr1Entity.getMVGR1(), brandCode);
            } else {
                RsBrandDomain rsBrandDomain1 = rsBrandDomain.get();
                log.info("rsBrandDomain1::{}", (Object)rsBrandDomain1);
                log.info("rsBrandDomain1::{}", (Object)rsBrandDomain1.getMemo());
                log.info("rsBrandDomain1::{}", (Object)rsBrandDomain1.getBrandCode());
                brandCodeMap.put(rsBrandDomain1.getMemo(), rsBrandDomain1.getBrandCode());
            }
        } else {
            Mvgr1Entity mvgr1Entity = (Mvgr1Entity)jsonEntity.getMVGR1().stream().filter(entity -> entity.getMVGR1().equals(ims.getSubBrand())).collect(Collectors.toList()).get(0);
            String brandCode = this.saveBrand(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001", mvgr1Entity);
            log.info("brandCode2::{}", (Object)brandCode);
            brandCodeMap.put(mvgr1Entity.getMVGR1(), brandCode);
        }
        return Boolean.TRUE;
    }

    public Boolean synchronousPntree(ImsEntity ims) {
        SupQueryResult<RsPntreeReDomain> pntreeRs = this.queryPntreePage("2022012800000001");
        log.info("pntreeRs::{}", pntreeRs);
        if (pntreeRs != null) {
            Optional<RsPntreeReDomain> rsPntreeReDomain1 = pntreeRs.getList().stream().filter(Objects::nonNull).filter(ele -> ele.getPntreeName() != null).filter(ele -> ele.getPntreeName().equals(ims.getSubBrand())).findFirst();
            if (!rsPntreeReDomain1.isPresent()) {
                String pntreeCode = this.savePntree(ims.getSubBrand(), brandCodeMap.get(ims.getSubBrand()), "2022012800000001", LancyWithB2cMapEnum.getByValue(ims.getBrand()).getName());
                log.info("pntreeCode1\uff1a\uff1a{}", (Object)pntreeCode);
                pntreeNameAndCodeMap.put(ims.getSubBrand(), pntreeCode);
            } else {
                RsPntreeReDomain rsPntreeReDomain = rsPntreeReDomain1.get();
                log.info("rsPntreeReDomain::{}", (Object)rsPntreeReDomain);
                pntreeNameAndCodeMap.put(rsPntreeReDomain.getPntreeName(), rsPntreeReDomain.getPntreeCode());
            }
        } else {
            String pntreeCode = this.savePntree(ims.getSubBrand(), brandCodeMap.get(ims.getSubBrand()), "2022012800000001", LancyWithB2cMapEnum.getByValue(ims.getBrand()).getName());
            log.info("pntreeCode2::{}", (Object)pntreeCode);
            pntreeNameAndCodeMap.put(ims.getSubBrand(), pntreeCode);
        }
        return Boolean.TRUE;
    }

    public Boolean synchronousClasstree(ImsEntity ims, JsonEntity jsonEntity) {
        List<RsClasstreeReDomain> rsClasstreeReDomains = this.queryClasstreePage("2022012800000001", LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "0", this.queryChannelPage(LancyWithB2cMapEnum.getByValue(ims.getBrand()).getCode(), "2022012800000001").getChannelCode());
        log.info("rsClasstreeReDomains::{}", rsClasstreeReDomains);
        if (rsClasstreeReDomains != null) {
            log.info("\u5b58\u5728\u5927\u7c7b");
            log.info("ims\u5927\u7c7b::{}", (Object)ims.getField5());
            log.info("\u5927\u7c7b\u6570\u636e::{}", rsClasstreeReDomains);
            Optional<RsClasstreeReDomain> lclsIsPresent = rsClasstreeReDomains.stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getMemo() != null).filter(ele -> ele.getMemo().equals(ims.getField3())).findFirst();
            if (lclsIsPresent.isPresent()) {
                log.info("\u5b58\u5728\u76f8\u540c\u5927\u7c7b");
                if (ListUtil.isEmpty(lclsIsPresent.get().getChildList())) {
                    log.info("\u4e0d\u5b58\u5728\u4e2d\u7c7b");
                    String classtreeCode = lclsIsPresent.get().getClasstreeCode();
                    log.info("classtreeCode::\u4e8c\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                    String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, classtreeCode);
                    String string = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                } else {
                    log.info("\u5b58\u5728\u4e2d\u7c7b");
                    Optional<RsClasstreeReDomain> mclsIsPrsent = lclsIsPresent.get().getChildList().stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getMemo() != null).filter(ele -> ele.getMemo().equals(ims.getField5())).findFirst();
                    if (!mclsIsPrsent.isPresent()) {
                        log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u4e2d\u7c7b");
                        String classtreeCode = mclsIsPrsent.get().getClasstreeCode();
                        log.info("classtreeCode::\u4e8c\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                        String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, classtreeCode);
                        String string = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
                    } else {
                        log.info("\u5b58\u5728\u76f8\u540c\u4e2d\u7c7b");
                        if (ListUtil.isEmpty(mclsIsPrsent.get().getChildList())) {
                            log.info("\u4e0d\u5b58\u5728\u5c0f\u7c7b");
                            String classtreeParentcode = mclsIsPrsent.get().getClasstreeCode();
                            log.info("classtreeCode::\u4e09\u7ea7\u7ea7\u8d4b\u503c::{}", (Object)classtreeParentcode);
                            this.structureClasstreeInfo(3, ims, jsonEntity, classtreeParentcode);
                        } else {
                            log.info("\u5b58\u5728\u5c0f\u7c7b");
                            Optional<RsClasstreeReDomain> sclsIsPrsent = mclsIsPrsent.get().getChildList().stream().filter(Objects::nonNull).filter(ele -> ele.getClasstreeCode() != null && ele.getMemo() != null).filter(ele -> ele.getMemo().equals(ims.getField4())).findFirst();
                            if (!sclsIsPrsent.isPresent()) {
                                log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u5c0f\u7c7b");
                                String classtreeCode = sclsIsPrsent.get().getClasstreeCode();
                                log.info("classtreeCode::\u4e09\u7ea7\u7ea7\u8d4b\u503c::{}", (Object)classtreeCode);
                                this.structureClasstreeInfo(3, ims, jsonEntity, classtreeCode);
                            } else {
                                RsClasstreeReDomain scls = sclsIsPrsent.get();
                                classtreeNameAndMemoMap.put(scls.getMemo(), scls.getClasstreeCode());
                            }
                        }
                        RsClasstreeReDomain mcls = mclsIsPrsent.get();
                        classtreeNameAndMemoMap.put(mcls.getMemo(), mcls.getClasstreeCode());
                    }
                }
                RsClasstreeReDomain lcls = lclsIsPresent.get();
                log.info("lcls::{}", (Object)JsonUtil.buildNormalBinder().toJson((Object)lcls));
                classtreeNameAndMemoMap.put(lcls.getMemo(), lcls.getClasstreeCode());
            } else {
                log.info("\u4e0d\u5b58\u5728\u76f8\u540c\u5927\u7c7b");
                String lclsSaveCode = this.structureClasstreeInfo(1, ims, jsonEntity, null);
                String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, lclsSaveCode);
                String string = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
            }
        } else {
            log.info("\u4e0d\u5b58\u5728\u5927\u7c7b");
            String lclsSaveCode = this.structureClasstreeInfo(1, ims, jsonEntity, null);
            String mclsSaveCode = this.structureClasstreeInfo(2, ims, jsonEntity, lclsSaveCode);
            String string = this.structureClasstreeInfo(3, ims, jsonEntity, mclsSaveCode);
        }
        return Boolean.TRUE;
    }
}

