/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.utils;

import com.yqbsoft.laser.service.ims.entity.AreaDomainEntity;
import com.yqbsoft.laser.service.ims.service.RowMap;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReadUtil {
    public static <T> List<T> loadScoreInfo(String path, RowMap<T> rowMap) {
        ArrayList<T> list = new ArrayList<T>();
        InputStream resourceAsStream = ExcelReadUtil.class.getClassLoader().getResourceAsStream(path);
        XSSFWorkbook wb0 = new XSSFWorkbook(resourceAsStream);
        XSSFSheet sht0 = wb0.getSheetAt(0);
        for (Row r : sht0) {
            if (r.getRowNum() < 1) continue;
            T t = rowMap.rowMapping(r);
            list.add(t);
        }
        resourceAsStream.close();
        return list;
    }

    public static void main(String[] args) {
        List areaDomainEntities = ExcelReadUtil.loadScoreInfo("areaDomain.xlsx", new AreaDomainEntity()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        System.out.println(JsonUtil.buildNormalBinder().toJson(areaDomainEntities));
    }
}

