/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ims.dao.DisChannelMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGuideMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractMapper;
import com.yqbsoft.laser.service.ims.dao.OrgDepartMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoChannelMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoMapper;
import com.yqbsoft.laser.service.ims.model.DisChannel;
import com.yqbsoft.laser.service.ims.model.OcContract;
import com.yqbsoft.laser.service.ims.model.OrgDepart;
import com.yqbsoft.laser.service.ims.model.UmUserinfoChannel;
import com.yqbsoft.laser.service.ims.model.UmUserinfoModel;
import com.yqbsoft.laser.service.ims.model.order.PosGuide;
import com.yqbsoft.laser.service.ims.model.order.PosOrder;
import com.yqbsoft.laser.service.ims.service.PosStoreService;
import com.yqbsoft.laser.service.ims.utils.connect.PosConnetUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PosStoreServiceImpl
extends BaseServiceImpl
implements PosStoreService {
    @Autowired
    private UmUserinfoMapper umUserinfoMapper;
    @Autowired
    private OrgDepartMapper orgDepartMapper;
    @Autowired
    private DisChannelMapper disChannelMapper;
    @Autowired
    private UmUserinfoChannelMapper umUserinfoChannelMapper;
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGuideMapper ocContractGuideMapper;

    @Override
    public void synchronousOrder() {
        try {
            List<PosOrder> init = PosConnetUtils.init();
            this.logger.info("\u6253\u5370\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(init));
            for (PosOrder pos : init) {
                if (this.addOcContract(pos)) continue;
                this.addGuide(pos);
                this.addGoods(pos);
            }
        }
        catch (SQLException | ParseException throwables) {
            throwables.printStackTrace();
        }
    }

    @Override
    public void synchronousCdpImsGoods() {
    }

    private void addGoods(PosOrder pos) {
    }

    private void addGuide(PosOrder pos) throws SQLException {
        List<PosGuide> list = PosConnetUtils.initGuide(pos.getOrderId());
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<UmUserinfoChannel> arr = new ArrayList<UmUserinfoChannel>();
            for (PosGuide str : list) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("userinfoChannelVaule", str.getGuideCode());
                hashMap.put("qualityCode", "dis");
                List<UmUserinfoChannel> query = this.umUserinfoChannelMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) continue;
                UmUserinfoChannel umUserinfoChannel = query.get(0);
                umUserinfoChannel.setUserinfoChannelVaule2(str.getDiscount());
                arr.add(umUserinfoChannel);
            }
            this.logger.info("\u6dfb\u52a0\u5bfc\u8d2d");
            this.ocContractGuideMapper.insertContractGuide(arr, pos.getContractBillcode());
        }
    }

    private boolean addOcContract(PosOrder pos) throws ParseException {
        OcContract oc = new OcContract();
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(new BigDecimal(pos.getGoodsNum()));
        oc.setGoodsClass(pos.getGoodsClass());
        HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
        umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
        umInfoMap.put("userinfoQuality", "buy");
        List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("\u7528\u6237\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel umUserinfoModel = query.get(0);
        oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
        oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setMschannelCode(store.getUserinfoCode());
        oc.setMschannelName(store.getUserinfoCompname());
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType(pos.getContractType());
        oc.setContractTypepro(pos.getContractType());
        oc.setContractBlance("0");
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(new BigDecimal("0"));
        oc.setPricesetRefrice(new BigDecimal(0));
        oc.setContractPaymoney(new BigDecimal(0));
        oc.setContractInmoney(new BigDecimal(pos.getGoodsMoney()));
        oc.setContractMoney(new BigDecimal(pos.getDataBmoney()));
        oc.setGoodsMoney(new BigDecimal(pos.getDataBmoney()));
        oc.setDataBmoney(new BigDecimal(pos.getDataBmoney()));
        oc.setDataBnum(new BigDecimal(pos.getGoodsNum()));
        oc.setDataBweight(new BigDecimal(0));
        oc.setContractShow(0);
        oc.setContractEcflag(0);
        oc.setContractInvstate(0);
        oc.setGoodsLogmoney(new BigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setContractPaydate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(5);
        oc.setRefundFlag(0);
        this.logger.info("\u6253\u5370\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        this.ocContractMapper.insert(oc);
        return false;
    }
}

