/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ims.dao.CdpGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.DisChannelMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGuideMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractPayDetailMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractPayGoodsDetailMapper;
import com.yqbsoft.laser.service.ims.dao.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.OcRefundMapper;
import com.yqbsoft.laser.service.ims.dao.OrgDepartMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoChannelMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoMapper;
import com.yqbsoft.laser.service.ims.domain.OcContractGoods;
import com.yqbsoft.laser.service.ims.model.DisChannel;
import com.yqbsoft.laser.service.ims.model.GoodsCategoryVO;
import com.yqbsoft.laser.service.ims.model.OcContract;
import com.yqbsoft.laser.service.ims.model.OcContractPayDetail;
import com.yqbsoft.laser.service.ims.model.OcRefund;
import com.yqbsoft.laser.service.ims.model.OcRefundGoods;
import com.yqbsoft.laser.service.ims.model.OrgDepart;
import com.yqbsoft.laser.service.ims.model.UmUserinfoChannel;
import com.yqbsoft.laser.service.ims.model.UmUserinfoModel;
import com.yqbsoft.laser.service.ims.model.order.CdpGoods;
import com.yqbsoft.laser.service.ims.model.order.PosContractPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGoods;
import com.yqbsoft.laser.service.ims.model.order.PosGoodsPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGuide;
import com.yqbsoft.laser.service.ims.model.order.PosOrder;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.LclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.MclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SclsEntity;
import com.yqbsoft.laser.service.ims.sap.executes.CALL;
import com.yqbsoft.laser.service.ims.service.PosStoreService;
import com.yqbsoft.laser.service.ims.utils.connect.PosConnetUtils;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PosStoreServiceImpl
extends BaseServiceImpl
implements PosStoreService {
    @Autowired
    private UmUserinfoMapper umUserinfoMapper;
    @Autowired
    private OrgDepartMapper orgDepartMapper;
    @Autowired
    private DisChannelMapper disChannelMapper;
    @Autowired
    private UmUserinfoChannelMapper umUserinfoChannelMapper;
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGuideMapper ocContractGuideMapper;
    @Autowired
    private CdpGoodsMapper cdpGoodsMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;
    @Autowired
    private OcContractPayDetailMapper ocContractPayDetailMapper;
    @Autowired
    private OcContractPayGoodsDetailMapper ocContractPayGoodsDetailMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;
    @Autowired
    private OcRefundGoodsMapper ocRefundGoodsMapper;

    @Override
    public void synchronousOrder() {
        try {
            List<PosOrder> initRefund = PosConnetUtils.initRefund();
            this.logger.info("\u6253\u5370\u9000\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(initRefund));
            for (PosOrder pos : initRefund) {
                if (!this.addOcRefundContract(pos)) continue;
            }
        }
        catch (SQLException | ParseException throwables) {
            throwables.printStackTrace();
        }
    }

    private boolean addOcRefundContract(PosOrder pos) throws ParseException {
        OcRefund oc = new OcRefund();
        oc.setRefundCode(pos.getRefundCode());
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(new BigDecimal(pos.getGoodsNum()).abs());
        oc.setGoodsClass(pos.getGoodsClass());
        HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
        umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
        umInfoMap.put("userinfoQuality", "buy");
        List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("\u7528\u6237\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel umUserinfoModel = query.get(0);
        oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
        oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setDataOpnextbillstate(0);
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType(pos.getContractType());
        oc.setContractTypepro(pos.getContractType());
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(new BigDecimal("0"));
        oc.setContractPaymoney(new BigDecimal(0));
        oc.setContractMoney(new BigDecimal(pos.getDataBmoney()).abs());
        oc.setRefundMoney(new BigDecimal(pos.getDataBmoney()).abs());
        oc.setDataStatestr(pos.getDataState());
        oc.setRefundType(pos.getContractType());
        oc.setGoodsLogmoney(new BigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(8);
        this.addRefundGoods(pos, oc);
        return false;
    }

    private void addRefundGoods(PosOrder pos, OcRefund oc) {
        if (Objects.isNull(oc)) {
            return;
        }
        List<PosGoods> posGoods = null;
        try {
            posGoods = PosConnetUtils.initGoods(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        this.logger.info("\u6253\u5370goodsList\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(posGoods));
        if (!CollectionUtils.isEmpty(posGoods)) {
            int success = this.addOcRefund(oc);
            this.logger.info("\u4fdd\u5b58\u8ba2\u5355\u662f\u5426\u6210\u529f\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)success));
            if (success != 1) {
                this.logger.info("\u6dfb\u52a0\u8ba2\u5355\u51fa\u9519");
                return;
            }
            this.addOcRefundDetail(pos);
            for (PosGoods goods : posGoods) {
                String goodsSkc = goods.getGoodsSkc();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", goodsSkc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                OcRefundGoods ocContractGoods = new OcRefundGoods();
                ocContractGoods.setContractBillcode(pos.getContractBillcode());
                ocContractGoods.setSkuCode(goods.getGoodsSkc());
                ocContractGoods.setSpuCode(goods.getGoodsSku());
                ocContractGoods.setSkuName(cdpGoods.getArticleName());
                ocContractGoods.setGoodsName(cdpGoods.getArticleName());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(goods.getGoodsSkc());
                ocContractGoods.setGoodsNo(goods.getGoodsSkc());
                ocContractGoods.setSkuShowno(goods.getGoodsSku());
                ocContractGoods.setSkuNo(goods.getGoodsSku());
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setGoodsCamount(new BigDecimal(goods.getGoodsNum()));
                ocContractGoods.setGoodsClass("pos");
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getGoodType());
                ocContractGoods.setGoodsNum(new BigDecimal(goods.getGoodsNum()));
                ocContractGoods.setContractGoodsPrice(new BigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setContractGoodsMoney(new BigDecimal(cdpGoods.getListPrice()).multiply(new BigDecimal(goods.getGoodsNum())));
                ocContractGoods.setContractGoodsInmoney(new BigDecimal(goods.getContractPrice()));
                ocContractGoods.setContractGoodsPefinmoney(new BigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(new BigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(new BigDecimal("0"));
                ocContractGoods.setPricesetNprice(new BigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setPricesetMakeprice(new BigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetBaseprice(new BigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetAsprice(new BigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setRefundGoodsNum(new BigDecimal(goods.getGoodsNum()));
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setRefundGoodsCode(System.currentTimeMillis() + "");
                ocContractGoods.setRefundCode(pos.getRefundCode());
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                this.sendRefundGoods(ocContractGoods);
                this.addGoodsPayDetail(pos);
            }
        }
    }

    private int addOcRefund(OcRefund oc) {
        this.logger.info("\u6253\u5370\u9000\u5355\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        return this.ocRefundMapper.insert(oc);
    }

    private void sendRefundGoods(OcRefundGoods ocContractGoods) {
        this.ocRefundGoodsMapper.insert(ocContractGoods);
    }

    @Override
    public void synchronousCdpImsGoods() throws SQLException, ParseException {
        JsonEntity jsonEntity = null;
        this.initSap(jsonEntity);
        if (Objects.isNull(jsonEntity)) {
            this.logger.info("cdp\u540c\u6b65\u5546\u54c1\u672a\u67e5\u8be2\u5230sap");
            return;
        }
        List<CdpGoods> arr = this.getCdpGoods();
        for (CdpGoods goods : arr) {
            this.classTreeName(jsonEntity, goods);
            List colorEntitieList = jsonEntity.getCOLOR().stream().filter(u -> u.getJ_3ACOL().equals(goods.getColor())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(colorEntitieList)) continue;
            goods.setColorName(((ColorEntity)colorEntitieList.get(0)).getTEXT());
        }
    }

    private void classTreeName(JsonEntity jsonEntity, CdpGoods goods) {
        List<String> list;
        List<String> list2;
        List<String> list3;
        String field3 = goods.getField3();
        LclsEntity lclsEntity = jsonEntity.getLCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getLABOR() != null && ele.getLBTXT() != null).filter(ele -> ele.getLABOR().equals(field3)).findFirst().get();
        if (!Objects.isNull(lclsEntity) && !CollectionUtils.isEmpty(list3 = Arrays.asList(lclsEntity.getLABOR(), lclsEntity.getLBTXT()))) {
            goods.setField3Name(list3.get(0));
        }
        String field4 = goods.getField4();
        SclsEntity sclsEntity = jsonEntity.getSCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getEXTWG() != null && ele.getEWBEZ() != null).filter(ele -> ele.getEXTWG().equals(field4)).findFirst().get();
        if (!Objects.isNull(sclsEntity) && !CollectionUtils.isEmpty(list2 = Arrays.asList(sclsEntity.getEXTWG(), sclsEntity.getEWBEZ()))) {
            goods.setField4Name(list2.get(0));
        }
        String field5 = goods.getField5();
        MclsEntity mclsEntity = jsonEntity.getMCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getMATKL() != null && ele.getWGBEZ() != null).filter(ele -> ele.getMATKL().equals(field5)).findFirst().get();
        if (!Objects.isNull(mclsEntity) && !CollectionUtils.isEmpty(list = Arrays.asList(mclsEntity.getMATKL(), mclsEntity.getWGBEZ()))) {
            goods.setField5Name(list.get(0));
        }
    }

    private List<CdpGoods> getCdpGoods() {
        int rows = 2000;
        long total = 0L;
        int index = 0;
        ArrayList<CdpGoods> arr = new ArrayList<CdpGoods>();
        int page = index * rows;
        while ((long)page <= total) {
            this.logger.info("\u6253\u5370page\uff1a" + page + " total:" + total);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("page", page);
            map.put("rows", rows);
            List<CdpGoods> list = this.cdpGoodsMapper.query(map);
            if (null == list) break;
            if (page == 0) {
                total = this.cdpGoodsMapper.count(map);
            }
            page = (index + 1) * rows;
            ++index;
            arr.addAll(list);
        }
        return arr;
    }

    public void initSap(JsonEntity jsonEntity) throws SQLException, ParseException {
        jsonEntity = CALL.callRfcExample();
        this.logger.info("\u521d\u59cb\u5316\u7684\u6570\u636e\u4e3ajsonEntity \uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)jsonEntity));
    }

    private void addGoods(PosOrder pos, OcContract oc) {
        if (Objects.isNull(oc)) {
            return;
        }
        List<PosGoods> posGoods = null;
        try {
            posGoods = PosConnetUtils.initGoods(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        this.logger.info("\u6253\u5370goodsList\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(posGoods));
        BigDecimal disMoney = new BigDecimal("0");
        if (!CollectionUtils.isEmpty(posGoods)) {
            for (PosGoods goods : posGoods) {
                disMoney = disMoney.add(new BigDecimal(goods.getGoodsMakePrice()).subtract(new BigDecimal(goods.getGoodsNprice())));
            }
            int success = this.addOcContract(oc, disMoney);
            this.logger.info("\u4fdd\u5b58\u8ba2\u5355\u662f\u5426\u6210\u529f\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)success));
            if (success != 1) {
                this.logger.info("\u6dfb\u52a0\u8ba2\u5355\u51fa\u9519");
                return;
            }
            this.addOcContractDetail(pos);
            for (PosGoods goods : posGoods) {
                disMoney = disMoney.add(new BigDecimal(goods.getGoodsMakePrice()).subtract(new BigDecimal(goods.getGoodsNprice())));
                String goodsSkc = goods.getGoodsSkc();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", goodsSkc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                OcContractGoods ocContractGoods = new OcContractGoods();
                ocContractGoods.setContractBillcode(pos.getContractBillcode());
                ocContractGoods.setSkuCode(goods.getGoodsSkc());
                ocContractGoods.setSpuCode(goods.getGoodsSku());
                ocContractGoods.setSkuName(cdpGoods.getArticleName());
                ocContractGoods.setGoodsName(cdpGoods.getArticleName());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(goods.getGoodsSkc());
                ocContractGoods.setGoodsNo(goods.getGoodsSkc());
                ocContractGoods.setSkuShowno(goods.getGoodsSku());
                ocContractGoods.setSkuNo(goods.getGoodsSku());
                ocContractGoods.setContractGoodsType(0);
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setChannelCode(oc.getChannelCode());
                ocContractGoods.setChannelName(oc.getChannelName());
                ocContractGoods.setGoodsCamount(new BigDecimal(goods.getGoodsNum()));
                ocContractGoods.setGoodsClass("pos");
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getGoodType());
                ocContractGoods.setGoodsNum(new BigDecimal(goods.getGoodsNum()));
                ocContractGoods.setContractGoodsPrice(new BigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setContractGoodsMoney(new BigDecimal(cdpGoods.getListPrice()).multiply(new BigDecimal(goods.getGoodsNum())));
                ocContractGoods.setContractGoodsInmoney(new BigDecimal(goods.getContractPrice()));
                ocContractGoods.setContractGoodsPefinmoney(new BigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(new BigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(new BigDecimal("0"));
                ocContractGoods.setPricesetNprice(new BigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setPricesetMakeprice(new BigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetBaseprice(new BigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetAsprice(new BigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setContractGoodsSendnum(new BigDecimal(goods.getGoodsNum()));
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundFlag(0);
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setContractGoodsCode(System.currentTimeMillis() + "");
                ocContractGoods.setPackageCode(System.currentTimeMillis() + "");
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                this.sendSaveResourceGoods(ocContractGoods);
                this.addGoodsPayDetail(pos);
            }
        }
    }

    private void addGoodsPayDetail(PosOrder pos) {
        List<PosGoodsPayDetails> list = null;
        try {
            list = PosConnetUtils.initGoodsPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getGoodsPayDetails(list);
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayGoodsDetailMapper.insertBatch(arr);
    }

    private List<OcContractPayDetail> getGoodsPayDetails(List<PosGoodsPayDetails> list) {
        ArrayList<OcContractPayDetail> arr = new ArrayList<OcContractPayDetail>();
        for (PosGoodsPayDetails contractPayDetails : list) {
            OcContractPayDetail oc = new OcContractPayDetail();
            try {
                BeanUtils.copyAllPropertys((Object)oc, (Object)contractPayDetails);
                arr.add(oc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    private void addOcRefundDetail(PosOrder pos) {
        List<PosContractPayDetails> list = null;
        try {
            list = PosConnetUtils.initContractPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getOcContractPayDetails(list);
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u8ba2\u5355\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayDetailMapper.insertBatch(arr);
    }

    private void addOcContractDetail(PosOrder pos) {
        List<PosContractPayDetails> list = null;
        try {
            list = PosConnetUtils.initContractPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getOcContractPayDetails(list);
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u8ba2\u5355\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayDetailMapper.insertBatch(arr);
    }

    private List<OcContractPayDetail> getOcContractPayDetails(List<PosContractPayDetails> list) {
        ArrayList<OcContractPayDetail> arr = new ArrayList<OcContractPayDetail>();
        for (PosContractPayDetails contractPayDetails : list) {
            OcContractPayDetail oc = new OcContractPayDetail();
            try {
                BeanUtils.copyAllPropertys((Object)oc, (Object)contractPayDetails);
                arr.add(oc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    private int addOcContract(OcContract oc, BigDecimal disMoney) {
        oc.setGoodsPmoney(disMoney);
        this.logger.info("\u6253\u5370\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        return this.ocContractMapper.insert(oc);
    }

    public void sendSaveResourceGoods(OcContractGoods ocContractGoodsDomain) {
        this.ocContractGoodsMapper.insert(ocContractGoodsDomain);
    }

    private void addGuide(PosOrder pos) {
        List<PosGuide> list = null;
        try {
            list = PosConnetUtils.initGuide(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<UmUserinfoChannel> arr = new ArrayList<UmUserinfoChannel>();
            for (PosGuide str : list) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("userinfoChannelVaule", str.getGuideCode());
                hashMap.put("qualityCode", "dis");
                List<UmUserinfoChannel> query = this.umUserinfoChannelMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) continue;
                UmUserinfoChannel umUserinfoChannel = query.get(0);
                umUserinfoChannel.setUserinfoChannelVaule2(str.getDiscount());
                arr.add(umUserinfoChannel);
            }
            this.logger.info("\u6dfb\u52a0\u5bfc\u8d2d");
            if (!CollectionUtils.isEmpty(arr)) {
                for (UmUserinfoChannel umUserinfoChannel : arr) {
                    this.ocContractGuideMapper.insertContractGuide(umUserinfoChannel, pos.getContractBillcode());
                }
            }
        }
    }

    private boolean addOcContract(PosOrder pos) throws ParseException {
        OcContract oc = new OcContract();
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(new BigDecimal(pos.getGoodsNum()));
        oc.setGoodsClass(pos.getGoodsClass());
        HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
        umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
        umInfoMap.put("userinfoQuality", "buy");
        List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("\u7528\u6237\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel umUserinfoModel = query.get(0);
        oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
        oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setMschannelCode(store.getUserinfoCode());
        oc.setMschannelName(store.getUserinfoCompname());
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType(pos.getContractType());
        oc.setContractTypepro(pos.getContractType());
        oc.setContractBlance("0");
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(new BigDecimal("0"));
        oc.setPricesetRefrice(new BigDecimal(0));
        oc.setContractPaymoney(new BigDecimal(0));
        oc.setContractInmoney(new BigDecimal(pos.getGoodsMoney()));
        oc.setContractMoney(new BigDecimal(pos.getDataBmoney()));
        oc.setGoodsMoney(new BigDecimal(pos.getDataBmoney()));
        oc.setDataBmoney(new BigDecimal(pos.getDataBmoney()));
        oc.setDataBnum(new BigDecimal(pos.getGoodsNum()));
        oc.setDataBweight(new BigDecimal(0));
        oc.setContractShow(0);
        oc.setContractEcflag(0);
        oc.setContractInvstate(0);
        oc.setGoodsLogmoney(new BigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setContractPaydate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(5);
        oc.setRefundFlag(0);
        this.addGoods(pos, oc);
        return false;
    }

    public GoodsCategoryVO queryGoodCategory(Map map) {
        List<GoodsCategoryVO> goodsCategoryVOList = this.cdpGoodsMapper.queryGoodCategories(map);
        if (goodsCategoryVOList != null && goodsCategoryVOList.size() > 0) {
            return goodsCategoryVOList.get(0);
        }
        return null;
    }

    @Override
    public String queryImage(Map<String, Object> map) {
        String goodsImage = this.cdpGoodsMapper.queryGoodsImage();
        this.logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u6570\u636e", (Object)goodsImage);
        if (this.getCdpGoods() != null && StringUtils.isNotBlank((String)goodsImage)) {
            return goodsImage;
        }
        return "";
    }

    @Override
    public void saveImage(Map<String, Object> map) {
        this.cdpGoodsMapper.saveGoodsImage();
    }
}

