/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ims.dao.CdpGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.CdpOpenApiUrlMapper;
import com.yqbsoft.laser.service.ims.dao.DisChannelMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGuideMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractPayDetailMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractPayGoodsDetailMapper;
import com.yqbsoft.laser.service.ims.dao.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.OcRefundMapper;
import com.yqbsoft.laser.service.ims.dao.OrgDepartMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoChannelMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoMapper;
import com.yqbsoft.laser.service.ims.dao.UpmUpointsMapper;
import com.yqbsoft.laser.service.ims.domain.OcContractGoods;
import com.yqbsoft.laser.service.ims.domain.OcPackage;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousAttributeDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousEmpDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousEmpsDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousItemDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousItempayDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousOrderDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousPayitemDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousProductAliasDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousVipDomain;
import com.yqbsoft.laser.service.ims.model.DisChannel;
import com.yqbsoft.laser.service.ims.model.GoodsCategoryVO;
import com.yqbsoft.laser.service.ims.model.OcContract;
import com.yqbsoft.laser.service.ims.model.OcContractPayDetail;
import com.yqbsoft.laser.service.ims.model.OcContractPayGoodsDetail;
import com.yqbsoft.laser.service.ims.model.OcRefund;
import com.yqbsoft.laser.service.ims.model.OcRefundGoods;
import com.yqbsoft.laser.service.ims.model.OrgDepart;
import com.yqbsoft.laser.service.ims.model.UmUserinfoChannel;
import com.yqbsoft.laser.service.ims.model.UmUserinfoModel;
import com.yqbsoft.laser.service.ims.model.UpmUpointsClear;
import com.yqbsoft.laser.service.ims.model.order.CdpGoods;
import com.yqbsoft.laser.service.ims.model.order.PosContractPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGoods;
import com.yqbsoft.laser.service.ims.model.order.PosGoodsPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGuide;
import com.yqbsoft.laser.service.ims.model.order.PosOrder;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.LclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.MclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SclsEntity;
import com.yqbsoft.laser.service.ims.sap.executes.CALL;
import com.yqbsoft.laser.service.ims.service.PosStoreService;
import com.yqbsoft.laser.service.ims.utils.HttpClientUtil;
import com.yqbsoft.laser.service.ims.utils.connect.PosConnetUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PosStoreServiceImpl
extends BaseServiceImpl
implements PosStoreService {
    @Autowired
    private UpmUpointsMapper upmUpointsMapper;
    @Autowired
    private UmUserinfoMapper umUserinfoMapper;
    @Autowired
    private OrgDepartMapper orgDepartMapper;
    @Autowired
    private DisChannelMapper disChannelMapper;
    @Autowired
    private UmUserinfoChannelMapper umUserinfoChannelMapper;
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGuideMapper ocContractGuideMapper;
    @Autowired
    private CdpGoodsMapper cdpGoodsMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;
    @Autowired
    private OcContractPayDetailMapper ocContractPayDetailMapper;
    @Autowired
    private OcContractPayGoodsDetailMapper ocContractPayGoodsDetailMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;
    @Autowired
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    @Autowired
    private CdpOpenApiUrlMapper cdpOpenApiUrlMapper;
    private static final String cdp_order_code = "cdp_order";

    @Override
    public void timingPosOrder() {
        URI uri = null;
        try {
            String byCode = this.cdpOpenApiUrlMapper.getByCode(cdp_order_code);
            String str = byCode + "?dateb=2021-05-01%2000:00:01&datee=2022-08-01%2000:00:01&page=1&rows=50";
            uri = new URI(str);
            String result = HttpClientUtil.sendPostForJson(uri);
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, SupQueryResult.class);
            this.logger.info("supQueryResult\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), TimingSynchronousOrderDomain.class);
            for (TimingSynchronousOrderDomain domains : list) {
                TimingSynchronousVipDomain vip = domains.getVip();
                if (!Objects.isNull(vip)) continue;
                TimingSynchronousVipDomain timingSynchronousVipDomain = new TimingSynchronousVipDomain();
                timingSynchronousVipDomain.setCardno(80017864);
                domains.setVip(timingSynchronousVipDomain);
            }
            if (!CollectionUtils.isEmpty((Collection)list)) {
                this.timingSynchronousOrder(list);
            }
            this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)list));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void timingSynchronousOrder(List<TimingSynchronousOrderDomain> list) {
        ((Stream)list.stream().parallel()).forEach(order -> {
            String origvalue = order.getOrigvalue();
            String doctype = order.getDoctype();
            Integer cardno = order.getVip().getCardno();
            this.logger.info("cardNo:", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)cardno));
            HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
            userInfoMap.put("userinfoOcode", cardno + "");
            userInfoMap.put("userinfoQuality", "buy");
            userInfoMap.put("fuzzy", false);
            List<UmUserinfoModel> query = this.umUserinfoMapper.query(userInfoMap);
            HashMap<String, Object> orgMap = new HashMap<String, Object>();
            orgMap.put("departOcode", order.getStore().getCode());
            List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
            if (CollectionUtils.isEmpty(orgDepartList)) {
                this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(orgMap));
            } else if (CollectionUtils.isEmpty(query)) {
                this.logger.error(cardno + "\u7528\u6237\u4e0d\u5b58\u5728");
            } else if (!doctype.equals("2") && !doctype.equals("8")) {
                UmUserinfoModel umUserinfoModel = query.get(0);
                OcContract ocContract = this.saveTimingSynchronousOrder((TimingSynchronousOrderDomain)order, umUserinfoModel, orgDepartList.get(0));
                if (!Objects.isNull(ocContract)) {
                    List<TimingSynchronousItempayDomain> list;
                    List<TimingSynchronousPayitemDomain> payitem;
                    this.checkPoint(ocContract);
                    ocContract.setGoodsPbillno(origvalue);
                    this.saveTimingSynchronousGoods(ocContract, (TimingSynchronousOrderDomain)order);
                    List<TimingSynchronousEmpsDomain> emps = order.getEmps();
                    if (!CollectionUtils.isEmpty(emps)) {
                        for (TimingSynchronousEmpsDomain timingSynchronousEmpsDomain : emps) {
                            this.timingSynchronousSaveGuide(timingSynchronousEmpsDomain, ocContract.getContractBillcode());
                        }
                    }
                    if (!CollectionUtils.isEmpty(payitem = order.getPayitem())) {
                        for (TimingSynchronousPayitemDomain payDomain : payitem) {
                            this.timingSynchronousPayDetails(payDomain, order.getDocno());
                        }
                    }
                    if (!CollectionUtils.isEmpty(list = order.getItempay())) {
                        for (TimingSynchronousItempayDomain payDomain : list) {
                            this.timingSynchronousItemPayDetails(payDomain, order.getDocno());
                        }
                    }
                }
            } else {
                this.logger.info("\u6ca1\u6709\u9000\u6b3e\u5355\u53f7\uff0c\u65e0\u6cd5\u4fdd\u5b58");
            }
        });
    }

    private void checkPoint(OcContract ocContract) {
        Integer isSuccess;
        if (StringUtils.isNotBlank((String)ocContract.getMemberBcode()) && ((isSuccess = this.upmUpointsMapper.queryMemberPoints(ocContract.getMemberBcode(), "0", ocContract.getMemberCcode())) == null || isSuccess == 0)) {
            this.upmUpointsMapper.saveUpmUpoints(System.currentTimeMillis() + "", ocContract.getMemberBcode(), "0", ocContract.getMemberCcode());
        }
    }

    private BigDecimal calPoint(UmUserinfoModel umUserinfoModel, TimingSynchronousOrderDomain order) {
        return new BigDecimal(0);
    }

    public Object insertUpmUpointsClear(UpmUpointsClear clear) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)clear));
        Object departCode = this.getInternalRouter().inInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
        return departCode;
    }

    private void timingSynchronousItemPayDetails(TimingSynchronousItempayDomain payitemDomain, String docno) {
        String value2_code;
        TimingSynchronousAttributeDomain attribute;
        String no;
        OcContractPayGoodsDetail ocContractPayDetail = new OcContractPayGoodsDetail();
        ocContractPayDetail.setContractBillcode(docno);
        ocContractPayDetail.setPayMoney(new BigDecimal(StringUtils.isNotBlank((String)payitemDomain.getPayamount()) ? payitemDomain.getPayamount() : "0"));
        ocContractPayDetail.setPaywayId(payitemDomain.getC_payway_id());
        ocContractPayDetail.setGmtCreate(DateUtils.parseDate((Date)new Date()));
        ocContractPayDetail.setGmtModified(DateUtils.parseDate((Date)new Date()));
        TimingSynchronousProductAliasDomain productAlias = payitemDomain.getProductAlias();
        if (!Objects.isNull(productAlias) && StringUtils.isNotBlank((String)(no = productAlias.getNo())) && !Objects.isNull(attribute = productAlias.getAttribute()) && StringUtils.isNotBlank((String)(value2_code = attribute.getValue2_code()))) {
            String sub = no + value2_code;
            ocContractPayDetail.setGoodsSku(sub);
        }
        int insert = this.ocContractPayGoodsDetailMapper.insert(ocContractPayDetail);
        this.logger.info("\u5546\u54c1\u652f\u4ed8\u662f\u5426\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)insert));
    }

    private void timingSynchronousPayDetails(TimingSynchronousPayitemDomain payitemDomain, String no) {
        OcContractPayDetail ocContractPayDetail = new OcContractPayDetail();
        ocContractPayDetail.setContractBillcode(no);
        ocContractPayDetail.setPayMoney(new BigDecimal(StringUtils.isNotBlank((String)payitemDomain.getPayamount()) ? payitemDomain.getPayamount() : "0"));
        ocContractPayDetail.setPaywayId(payitemDomain.getC_payway_id());
        if (!Objects.isNull(payitemDomain.getCard())) {
            ocContractPayDetail.setCardId(payitemDomain.getCard().getId() + "");
            ocContractPayDetail.setDiscountRate(new BigDecimal(payitemDomain.getCard().getDiscount()));
        }
        ocContractPayDetail.setGmtCreate(DateUtils.parseDate((Date)new Date()));
        ocContractPayDetail.setGmtModified(DateUtils.parseDate((Date)new Date()));
        this.ocContractPayDetailMapper.insert(ocContractPayDetail);
    }

    private void timingSynchronousSaveGuide(TimingSynchronousEmpsDomain tse, String contractBillcode) {
        TimingSynchronousEmpDomain emp = tse.getEmp();
        if (Objects.isNull(emp)) {
            this.logger.info("\u5bfc\u8d2d\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)tse));
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("userinfoChannelVaule", emp.getNo());
        hashMap.put("qualityCode", "dis");
        List<UmUserinfoChannel> query = this.umUserinfoChannelMapper.query(hashMap);
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("\u672a\u67e5\u8be2\u5bfc\u8d2d\uff1a{}" + emp.getNo());
            return;
        }
        UmUserinfoChannel umUserinfoChannel = query.get(0);
        umUserinfoChannel.setUserinfoChannelVaule2(tse.getDiscount());
        this.ocContractGuideMapper.insertContractGuide(umUserinfoChannel, contractBillcode);
    }

    private void saveTimingSynchronousGoods(OcContract oc, TimingSynchronousOrderDomain order) {
        if (Objects.isNull(oc)) {
            return;
        }
        BigDecimal totalMoney = new BigDecimal("0");
        BigDecimal actualMoney = new BigDecimal("0");
        ArrayList<OcContractGoods> goods = new ArrayList<OcContractGoods>();
        for (TimingSynchronousItemDomain item : order.getItem()) {
            oc.setGoodsNum(oc.getGoodsNum().add(new BigDecimal(item.getQty())));
            oc.setDataBnum(oc.getGoodsNum().add(new BigDecimal(item.getQty())));
            actualMoney.add(new BigDecimal(item.getTot_amt_actual()));
            totalMoney.add(new BigDecimal(item.getTot_amt_list()));
            String spu = item.getProduct().getNo();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("spu", spu);
            hashMap.put("page", 0);
            hashMap.put("rows", 1);
            List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
            if (CollectionUtils.isEmpty(query)) {
                this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
            }
            CdpGoods cdpGoods = query.get(0);
            OcContractGoods ocContractGoods = new OcContractGoods();
            ocContractGoods.setContractBillcode(oc.getContractBillcode());
            ocContractGoods.setSkuCode(item.getProductAlias().getNo());
            ocContractGoods.setSpuCode(item.getProduct().getNo());
            ocContractGoods.setSkuName(cdpGoods.getArticleName());
            ocContractGoods.setGoodsName(cdpGoods.getArticleName());
            ocContractGoods.setMemberBcode(oc.getMemberBcode());
            ocContractGoods.setMemberBname(oc.getMemberBname());
            ocContractGoods.setMemberMcode(oc.getMemberMcode());
            ocContractGoods.setMemberMname(oc.getMemberMname());
            ocContractGoods.setMemberCode(oc.getMemberCode());
            ocContractGoods.setMemberName(oc.getMemberName());
            ocContractGoods.setMemberCcode(oc.getMemberCcode());
            ocContractGoods.setMemberCname(oc.getMemberCname());
            ocContractGoods.setGoodsShowno(item.getProduct().getNo());
            ocContractGoods.setGoodsNo(item.getProduct().getNo());
            ocContractGoods.setSkuShowno(item.getProductAlias().getNo());
            ocContractGoods.setSkuNo(item.getProductAlias().getNo());
            ocContractGoods.setContractGoodsType(0);
            ocContractGoods.setChannelCode(oc.getChannelCode());
            ocContractGoods.setChannelName(oc.getChannelName());
            ocContractGoods.setGoodsCamount(new BigDecimal(item.getQty()).abs());
            ocContractGoods.setGoodsClass("pos");
            ocContractGoods.setGoodsPro("0");
            ocContractGoods.setGoodsType(item.getType() + "");
            ocContractGoods.setGoodsNum(new BigDecimal(item.getQty()).abs());
            ocContractGoods.setContractGoodsPrice(new BigDecimal(item.getTot_amt_actual()).abs());
            ocContractGoods.setContractGoodsMoney(new BigDecimal(item.getTot_amt_actual()).abs());
            ocContractGoods.setContractGoodsInmoney(new BigDecimal(item.getTot_amt_actual()).abs());
            ocContractGoods.setContractGoodsPefinmoney(new BigDecimal("0"));
            ocContractGoods.setContractGoodsPefmoney(new BigDecimal("0"));
            ocContractGoods.setContractGoodsPefprice(new BigDecimal("0"));
            ocContractGoods.setPricesetNprice(new BigDecimal(item.getTot_amt_list()).abs());
            ocContractGoods.setPricesetMakeprice(new BigDecimal(item.getTot_amt_list()).abs());
            ocContractGoods.setPricesetBaseprice(new BigDecimal(item.getTot_amt_list()).abs());
            ocContractGoods.setContractGoodsSendnum(new BigDecimal(item.getQty()).abs());
            ocContractGoods.setDataPic(cdpGoods.getImgPath());
            ocContractGoods.setGmtCreate(new Date());
            ocContractGoods.setGmtModified(new Date());
            ocContractGoods.setDataOpbillstate(0);
            ocContractGoods.setDataState(0);
            ocContractGoods.setContractGoodsGtype("0");
            ocContractGoods.setTenantCode(oc.getTenantCode());
            ocContractGoods.setGoodsCode(item.getProductAlias().getNo());
            ocContractGoods.setGoodsClass(oc.getGoodsClass());
            ocContractGoods.setRefundFlag(0);
            if (ocContractGoods.getContractGoodsPrice().compareTo(new BigDecimal("0")) == 0) {
                ocContractGoods.setContractGoodsRefnum(new BigDecimal(item.getQty()).abs());
                ocContractGoods.setRefundFlag(1);
            }
            this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
            goods.add(ocContractGoods);
        }
        oc.setGoodsList(goods);
        oc.setContractGoodsList(goods);
        OcPackage ocPackageDomain = this.savePackage(oc);
        oc.setPackageList(Arrays.asList(ocPackageDomain));
        this.insertContract(oc);
    }

    private OcPackage savePackage(OcContract ocContract) {
        OcPackage ocPackageDomain = new OcPackage();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)ocContract);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BigDecimal goodsMoney = ocPackageDomain.getGoodsMoney();
        BigDecimal goodsPmoney = ocPackageDomain.getGoodsPmoney();
        String goodsPmbillno = ocPackageDomain.getGoodsPmbillno();
        BigDecimal goodsWeight = ocPackageDomain.getGoodsWeight();
        BigDecimal goodsNum = ocPackageDomain.getGoodsNum();
        String areaCode = ocPackageDomain.getAreaCode();
        String areaName = ocPackageDomain.getAreaName();
        String warehouseName = ocPackageDomain.getWarehouseName();
        String warehouseCode = ocPackageDomain.getWarehouseCode();
        String contractPumode = ocPackageDomain.getContractPumode();
        if (StringUtils.isNotBlank((String)contractPumode)) {
            ocPackageDomain.setContractPumode(contractPumode);
        }
        ocPackageDomain.setContractBillcode(ocContract.getContractBillcode());
        ocPackageDomain.setTenantCode(ocContract.getTenantCode());
        ocPackageDomain.setGoodsMoney(goodsMoney);
        ocPackageDomain.setGoodsInmoney(ocContract.getContractInmoney());
        ocPackageDomain.setGoodsPmoney(goodsPmoney);
        ocPackageDomain.setGoodsPmbillno(goodsPmbillno);
        ocPackageDomain.setGoodsWeight(goodsWeight);
        ocPackageDomain.setGoodsNum(goodsNum);
        ocPackageDomain.setAreaCode(areaCode);
        ocPackageDomain.setAreaName(areaName);
        ocPackageDomain.setWarehouseCode(warehouseCode);
        ocPackageDomain.setWarehouseName(warehouseName);
        ocPackageDomain.setMemberBcode(ocContract.getMemberBcode());
        ocPackageDomain.setMemberBname(ocContract.getMemberBname());
        ocPackageDomain.setMemberCode(ocContract.getMemberCode());
        ocPackageDomain.setMemberName(ocContract.getMemberName());
        return ocPackageDomain;
    }

    private void insertContract(OcContract oc) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)oc));
        this.logger.info("\u6253\u5370\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)oc));
        Object o = this.getInternalRouter().inInvoke("oc.contract.sendsaveContract", pmap);
        this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
    }

    private OcContract saveTimingSynchronousOrder(TimingSynchronousOrderDomain order, UmUserinfoModel umUserinfoModel, OrgDepart orgDepart) {
        OcContract ocContract = new OcContract();
        ocContract.setDataState(5);
        ocContract.setContractBillcode(order.getDocno());
        ocContract.setContractBbillcode(order.getDocno());
        ocContract.setMemberBcode(umUserinfoModel.getUserinfoCode());
        ocContract.setMemberBname(umUserinfoModel.getUserinfoCompname());
        ocContract.setGoodsClass("pos");
        ocContract.setGoodsNum(new BigDecimal("1"));
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(storeMap));
            return null;
        }
        UmUserinfoModel store = storeList.get(0);
        ocContract.setMemberCode(store.getUserinfoCode());
        ocContract.setMemberName(store.getUserinfoCompname());
        ocContract.setMschannelCode(store.getUserinfoCode());
        ocContract.setMschannelName(store.getUserinfoCompname());
        ocContract.setChannelCode(store.getUserinfoCode());
        ocContract.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(disMap));
            return null;
        }
        DisChannel disChannel = disChannelList.get(0);
        ocContract.setMemberCcode(disChannel.getMemberCode());
        ocContract.setMemberMcode(disChannel.getMemberCode());
        ocContract.setMemberMname(disChannel.getMemberName());
        ocContract.setMemberCname(disChannel.getMemberName());
        ocContract.setTenantCode(disChannel.getTenantCode());
        ocContract.setContractType("00");
        ocContract.setContractTypepro(order.getDoctype());
        ocContract.setContractBlance("0");
        ocContract.setContractPmode("1");
        ocContract.setContractPumode("0");
        ocContract.setContractPumode("0");
        ocContract.setGoodsWeight(new BigDecimal("0"));
        ocContract.setPricesetRefrice(new BigDecimal(0));
        ocContract.setContractPaymoney(new BigDecimal(0));
        ocContract.setContractInmoney(new BigDecimal(order.getTot_amt_actual()));
        ocContract.setContractMoney(new BigDecimal(order.getTot_amt_actual()));
        ocContract.setGoodsMoney(new BigDecimal(order.getTot_amt_actual()));
        ocContract.setDataBmoney(new BigDecimal(order.getTot_amt_actual()));
        ocContract.setDataBnum(new BigDecimal("1"));
        ocContract.setDataBweight(new BigDecimal(0));
        ocContract.setContractShow(0);
        ocContract.setContractEcflag(0);
        ocContract.setContractInvstate(0);
        ocContract.setGoodsLogmoney(new BigDecimal(0));
        ocContract.setGmtCreate(new Date());
        ocContract.setGmtModified(new Date());
        ocContract.setContractPaydate(order.getStatustime());
        ocContract.setRefundFlag(0);
        return ocContract;
    }

    @Override
    public void synchronousOrder() {
        try {
            List<PosOrder> init = PosConnetUtils.init();
            this.logger.info("\u6253\u5370\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(init));
            for (PosOrder pos : init) {
                if (this.addOcContract(pos)) continue;
                this.addGuide(pos);
            }
            List<PosOrder> initRefund = PosConnetUtils.initRefund();
            this.logger.info("\u6253\u5370\u9000\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(initRefund));
            for (PosOrder pos : initRefund) {
                if (!this.addOcRefundContract(pos)) continue;
            }
        }
        catch (SQLException | ParseException throwables) {
            throwables.printStackTrace();
        }
    }

    private boolean addOcRefundContract(PosOrder pos) throws ParseException {
        OcRefund oc = new OcRefund();
        oc.setRefundCode(pos.getRefundCode());
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(new BigDecimal(pos.getGoodsNum()).abs());
        oc.setGoodsClass(pos.getGoodsClass());
        oc.setCompanyShortname("0");
        HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
        umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
        umInfoMap.put("userinfoQuality", "buy");
        List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("\u7528\u6237\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel umUserinfoModel = query.get(0);
        oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
        oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setDataOpnextbillstate(0);
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType(pos.getContractType());
        oc.setContractTypepro(pos.getContractType());
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(new BigDecimal("0"));
        oc.setContractPaymoney(new BigDecimal(0));
        oc.setContractMoney(new BigDecimal(pos.getGoodsMoney()).abs());
        oc.setRefundMoney(new BigDecimal(pos.getDataBmoney()).abs());
        oc.setRefundPmmoney(new BigDecimal(pos.getGoodsMoney()).abs().subtract(new BigDecimal(pos.getDataBmoney()).abs()));
        oc.setDataStatestr(pos.getDataState());
        oc.setRefundType("B01");
        oc.setGoodsLogmoney(new BigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(8);
        this.addRefundGoods(pos, oc);
        return false;
    }

    private void addRefundGoods(PosOrder pos, OcRefund oc) {
        if (Objects.isNull(oc)) {
            return;
        }
        List<PosGoods> posGoods = null;
        try {
            posGoods = PosConnetUtils.initGoods(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        this.logger.info("\u6253\u5370goodsList\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(posGoods));
        if (!CollectionUtils.isEmpty(posGoods)) {
            int success = this.addOcRefund(oc);
            this.logger.info("\u4fdd\u5b58\u8ba2\u5355\u662f\u5426\u6210\u529f\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)success));
            if (success != 1) {
                this.logger.info("\u6dfb\u52a0\u8ba2\u5355\u51fa\u9519");
                return;
            }
            this.addOcRefundDetail(pos);
            for (PosGoods goods : posGoods) {
                String goodsSkc = goods.getGoodsSkc();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", goodsSkc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                OcRefundGoods ocContractGoods = new OcRefundGoods();
                ocContractGoods.setContractBillcode(pos.getContractBillcode());
                ocContractGoods.setSkuCode(goods.getGoodsSkc());
                ocContractGoods.setSpuCode(goods.getGoodsSku());
                ocContractGoods.setSkuName(cdpGoods.getArticleName());
                ocContractGoods.setGoodsName(cdpGoods.getArticleName());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(goods.getGoodsSkc());
                ocContractGoods.setGoodsNo(goods.getGoodsSkc());
                ocContractGoods.setSkuShowno(goods.getGoodsSku());
                ocContractGoods.setSkuNo(goods.getGoodsSku());
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setGoodsCamount(new BigDecimal(goods.getGoodsNum()).abs());
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getGoodType());
                ocContractGoods.setGoodsNum(new BigDecimal(goods.getGoodsNum()).abs());
                ocContractGoods.setContractGoodsPrice(new BigDecimal(goods.getGoodsNprice()).abs());
                ocContractGoods.setContractGoodsMoney(new BigDecimal(goods.getGoodsNprice()).abs());
                ocContractGoods.setContractGoodsInmoney(new BigDecimal(goods.getContractPrice()).abs());
                ocContractGoods.setContractGoodsPefinmoney(new BigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(new BigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(new BigDecimal("0"));
                ocContractGoods.setPricesetNprice(new BigDecimal(goods.getGoodsMakePrice()).abs());
                ocContractGoods.setPricesetMakeprice(new BigDecimal(cdpGoods.getListPrice()).abs());
                ocContractGoods.setPricesetBaseprice(new BigDecimal(goods.getGoodsMakePrice()).abs());
                ocContractGoods.setPricesetAsprice(new BigDecimal(goods.getGoodsNprice()).abs());
                ocContractGoods.setRefundGoodsNum(new BigDecimal(goods.getGoodsNum()).abs());
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundGoodsType(Integer.parseInt(goods.getGoodType()));
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setRefundGoodsCode(System.currentTimeMillis() + "");
                ocContractGoods.setRefundCode(pos.getRefundCode());
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                this.sendRefundGoods(ocContractGoods);
            }
            this.addRefundGoodsPayDetail(pos);
        }
    }

    private void addRefundGoodsPayDetail(PosOrder pos) {
        List<PosGoodsPayDetails> list = null;
        try {
            list = PosConnetUtils.initGoodsPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getGoodsPayDetails(list);
        for (OcContractPayDetail posGoodsPayDetails : arr) {
            posGoodsPayDetails.setRefundCode(pos.getRefundCode());
            posGoodsPayDetails.setPayMoney(posGoodsPayDetails.getPayMoney().abs());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayGoodsDetailMapper.insertBatch(arr);
    }

    private int addOcRefund(OcRefund oc) {
        this.logger.info("\u6253\u5370\u9000\u5355\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        return this.ocRefundMapper.insert(oc);
    }

    private void sendRefundGoods(OcRefundGoods ocContractGoods) {
        this.ocRefundGoodsMapper.insert(ocContractGoods);
    }

    @Override
    public void synchronousCdpImsGoods() throws SQLException, ParseException {
        JsonEntity jsonEntity = null;
        this.initSap(jsonEntity);
        if (Objects.isNull(jsonEntity)) {
            this.logger.info("cdp\u540c\u6b65\u5546\u54c1\u672a\u67e5\u8be2\u5230sap");
            return;
        }
        List<CdpGoods> arr = this.getCdpGoods();
        for (CdpGoods goods : arr) {
            this.classTreeName(jsonEntity, goods);
            List colorEntitieList = jsonEntity.getCOLOR().stream().filter(u -> u.getJ_3ACOL().equals(goods.getColor())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(colorEntitieList)) continue;
            goods.setColorName(((ColorEntity)colorEntitieList.get(0)).getTEXT());
        }
    }

    private void classTreeName(JsonEntity jsonEntity, CdpGoods goods) {
        List<String> list;
        List<String> list2;
        List<String> list3;
        String field3 = goods.getField3();
        LclsEntity lclsEntity = jsonEntity.getLCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getLABOR() != null && ele.getLBTXT() != null).filter(ele -> ele.getLABOR().equals(field3)).findFirst().get();
        if (!Objects.isNull(lclsEntity) && !CollectionUtils.isEmpty(list3 = Arrays.asList(lclsEntity.getLABOR(), lclsEntity.getLBTXT()))) {
            goods.setField3Name(list3.get(0));
        }
        String field4 = goods.getField4();
        SclsEntity sclsEntity = jsonEntity.getSCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getEXTWG() != null && ele.getEWBEZ() != null).filter(ele -> ele.getEXTWG().equals(field4)).findFirst().get();
        if (!Objects.isNull(sclsEntity) && !CollectionUtils.isEmpty(list2 = Arrays.asList(sclsEntity.getEXTWG(), sclsEntity.getEWBEZ()))) {
            goods.setField4Name(list2.get(0));
        }
        String field5 = goods.getField5();
        MclsEntity mclsEntity = jsonEntity.getMCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getMATKL() != null && ele.getWGBEZ() != null).filter(ele -> ele.getMATKL().equals(field5)).findFirst().get();
        if (!Objects.isNull(mclsEntity) && !CollectionUtils.isEmpty(list = Arrays.asList(mclsEntity.getMATKL(), mclsEntity.getWGBEZ()))) {
            goods.setField5Name(list.get(0));
        }
    }

    private List<CdpGoods> getCdpGoods() {
        int rows = 2000;
        long total = 0L;
        int index = 0;
        ArrayList<CdpGoods> arr = new ArrayList<CdpGoods>();
        int page = index * rows;
        while ((long)page <= total) {
            this.logger.info("\u6253\u5370page\uff1a" + page + " total:" + total);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("page", page);
            map.put("rows", rows);
            List<CdpGoods> list = this.cdpGoodsMapper.query(map);
            if (null == list) break;
            if (page == 0) {
                total = this.cdpGoodsMapper.count(map);
            }
            page = (index + 1) * rows;
            ++index;
            arr.addAll(list);
        }
        return arr;
    }

    public void initSap(JsonEntity jsonEntity) throws SQLException, ParseException {
        jsonEntity = CALL.callRfcExample();
        this.logger.info("\u521d\u59cb\u5316\u7684\u6570\u636e\u4e3ajsonEntity \uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)jsonEntity));
    }

    private void addGoods(PosOrder pos, OcContract oc) {
        if (Objects.isNull(oc)) {
            return;
        }
        List<PosGoods> posGoods = null;
        try {
            posGoods = PosConnetUtils.initGoods(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        this.logger.info("\u6253\u5370goodsList\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(posGoods));
        if (!CollectionUtils.isEmpty(posGoods)) {
            int success = this.saveOcContract(oc, new BigDecimal(pos.getGoodsMoney()).subtract(new BigDecimal(pos.getDataBmoney())));
            this.logger.info("\u4fdd\u5b58\u8ba2\u5355\u662f\u5426\u6210\u529f\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)success));
            if (success != 1) {
                this.logger.info("\u6dfb\u52a0\u8ba2\u5355\u51fa\u9519");
                return;
            }
            this.addOcContractDetail(pos);
            for (PosGoods goods : posGoods) {
                String goodsSkc = goods.getGoodsSkc();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", goodsSkc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                OcContractGoods ocContractGoods = new OcContractGoods();
                ocContractGoods.setContractBillcode(pos.getContractBillcode());
                ocContractGoods.setSkuCode(goods.getGoodsSkc());
                ocContractGoods.setSpuCode(goods.getGoodsSku());
                ocContractGoods.setSkuName(cdpGoods.getArticleName());
                ocContractGoods.setGoodsName(cdpGoods.getArticleName());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(goods.getGoodsSkc());
                ocContractGoods.setGoodsNo(goods.getGoodsSkc());
                ocContractGoods.setSkuShowno(goods.getGoodsSku());
                ocContractGoods.setSkuNo(goods.getGoodsSku());
                ocContractGoods.setContractGoodsType(0);
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setChannelCode(oc.getChannelCode());
                ocContractGoods.setChannelName(oc.getChannelName());
                ocContractGoods.setGoodsCamount(new BigDecimal(goods.getGoodsNum()).abs());
                ocContractGoods.setGoodsClass("pos");
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getGoodType());
                ocContractGoods.setGoodsNum(new BigDecimal(goods.getGoodsNum()).abs());
                ocContractGoods.setContractGoodsPrice(new BigDecimal(goods.getGoodsNprice()).abs());
                ocContractGoods.setContractGoodsMoney(new BigDecimal(goods.getGoodsNprice()).abs());
                ocContractGoods.setContractGoodsInmoney(new BigDecimal(goods.getGoodsMakePrice()).abs());
                ocContractGoods.setContractGoodsPefinmoney(new BigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(new BigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(new BigDecimal("0"));
                ocContractGoods.setPricesetNprice(new BigDecimal(goods.getGoodsMakePrice()).abs());
                ocContractGoods.setPricesetMakeprice(new BigDecimal(cdpGoods.getListPrice()).abs());
                ocContractGoods.setPricesetBaseprice(new BigDecimal(goods.getGoodsMakePrice()).abs());
                ocContractGoods.setPricesetAsprice(new BigDecimal(goods.getGoodsNprice()).abs());
                ocContractGoods.setContractGoodsSendnum(new BigDecimal(goods.getGoodsNum()).abs());
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundFlag(0);
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setContractGoodsCode(System.currentTimeMillis() + "");
                ocContractGoods.setPackageCode(System.currentTimeMillis() + "");
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                this.sendSaveResourceGoods(ocContractGoods);
                this.addGoodsPayDetail(pos);
            }
        }
    }

    private void addGoodsPayDetail(PosOrder pos) {
        List<PosGoodsPayDetails> list = null;
        try {
            list = PosConnetUtils.initGoodsPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getGoodsPayDetails(list);
        for (OcContractPayDetail posGoodsPayDetails : arr) {
            posGoodsPayDetails.setContractBillcode(pos.getContractBillcode());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayGoodsDetailMapper.insertBatch(arr);
    }

    private List<OcContractPayDetail> getGoodsPayDetails(List<PosGoodsPayDetails> list) {
        ArrayList<OcContractPayDetail> arr = new ArrayList<OcContractPayDetail>();
        for (PosGoodsPayDetails contractPayDetails : list) {
            OcContractPayDetail oc = new OcContractPayDetail();
            try {
                BeanUtils.copyAllPropertys((Object)oc, (Object)contractPayDetails);
                arr.add(oc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    private void addOcRefundDetail(PosOrder pos) {
        List<PosContractPayDetails> list = null;
        try {
            list = PosConnetUtils.initContractPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getOcContractPayDetails(list);
        for (OcContractPayDetail posContractPayDetails : arr) {
            posContractPayDetails.setRefundCode(pos.getRefundCode());
            posContractPayDetails.setPayMoney(posContractPayDetails.getPayMoney().abs());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u8ba2\u5355\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayDetailMapper.insertBatch(arr);
    }

    private void addOcContractDetail(PosOrder pos) {
        List<PosContractPayDetails> list = null;
        try {
            list = PosConnetUtils.initContractPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getOcContractPayDetails(list);
        for (OcContractPayDetail ocContractPayDetail : arr) {
            ocContractPayDetail.setContractBillcode(pos.getContractBillcode());
            ocContractPayDetail.setRefundCode(pos.getRefundCode());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u8ba2\u5355\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayDetailMapper.insertBatch(arr);
    }

    private List<OcContractPayDetail> getOcContractPayDetails(List<PosContractPayDetails> list) {
        ArrayList<OcContractPayDetail> arr = new ArrayList<OcContractPayDetail>();
        for (PosContractPayDetails contractPayDetails : list) {
            OcContractPayDetail oc = new OcContractPayDetail();
            try {
                BeanUtils.copyAllPropertys((Object)oc, (Object)contractPayDetails);
                arr.add(oc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    private int saveOcContract(OcContract oc, BigDecimal goodsPmoney) {
        oc.setGoodsPmoney(goodsPmoney);
        this.logger.info("\u6253\u5370\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        return this.ocContractMapper.insert(oc);
    }

    public void sendSaveResourceGoods(OcContractGoods ocContractGoodsDomain) {
        this.ocContractGoodsMapper.insert(ocContractGoodsDomain);
    }

    private void addGuide(PosOrder pos) {
        List<PosGuide> list = null;
        try {
            list = PosConnetUtils.initGuide(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<UmUserinfoChannel> arr = new ArrayList<UmUserinfoChannel>();
            for (PosGuide str : list) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("userinfoChannelVaule", str.getGuideCode());
                hashMap.put("qualityCode", "dis");
                List<UmUserinfoChannel> query = this.umUserinfoChannelMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) continue;
                UmUserinfoChannel umUserinfoChannel = query.get(0);
                umUserinfoChannel.setUserinfoChannelVaule2(str.getDiscount());
                arr.add(umUserinfoChannel);
            }
            this.logger.info("\u6dfb\u52a0\u5bfc\u8d2d");
            if (!CollectionUtils.isEmpty(arr)) {
                for (UmUserinfoChannel umUserinfoChannel : arr) {
                    this.ocContractGuideMapper.insertContractGuide(umUserinfoChannel, pos.getContractBillcode());
                }
            }
        }
    }

    private boolean addOcContract(PosOrder pos) throws ParseException {
        OcContract oc = new OcContract();
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(new BigDecimal(pos.getGoodsNum()).abs());
        oc.setGoodsClass(pos.getGoodsClass());
        oc.setGoodsPbillno("0");
        HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
        umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
        umInfoMap.put("userinfoQuality", "buy");
        List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("\u7528\u6237\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel umUserinfoModel = query.get(0);
        oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
        oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setMschannelCode(store.getUserinfoCode());
        oc.setMschannelName(store.getUserinfoCompname());
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType(pos.getContractType());
        oc.setContractTypepro(pos.getContractType());
        oc.setContractBlance("0");
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(new BigDecimal("0"));
        oc.setPricesetRefrice(new BigDecimal(0));
        oc.setContractPaymoney(new BigDecimal(0));
        oc.setContractInmoney(new BigDecimal(pos.getGoodsMoney()).abs());
        oc.setContractMoney(new BigDecimal(pos.getDataBmoney()).abs());
        oc.setGoodsMoney(new BigDecimal(pos.getDataBmoney()).abs());
        oc.setDataBmoney(new BigDecimal(pos.getDataBmoney()).abs());
        oc.setDataBnum(new BigDecimal(pos.getGoodsNum()).abs());
        oc.setDataBweight(new BigDecimal(0));
        oc.setContractShow(0);
        oc.setContractEcflag(0);
        oc.setContractInvstate(0);
        oc.setGoodsLogmoney(new BigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setContractPaydate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(5);
        oc.setRefundFlag(0);
        this.addGoods(pos, oc);
        return false;
    }

    public GoodsCategoryVO queryGoodCategory(Map map) {
        List<GoodsCategoryVO> goodsCategoryVOList = this.cdpGoodsMapper.queryGoodCategories(map);
        if (goodsCategoryVOList != null && goodsCategoryVOList.size() > 0) {
            return goodsCategoryVOList.get(0);
        }
        return null;
    }

    @Override
    public String queryImage(Map<String, Object> map) {
        String goodsImage = this.cdpGoodsMapper.queryGoodsImage(map);
        if (goodsImage != null && StringUtils.isNotBlank((String)goodsImage)) {
            return goodsImage;
        }
        return "";
    }

    @Override
    public void saveImage(Map<String, Object> map) {
        this.cdpGoodsMapper.saveGoodsImage(map);
    }
}

