/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ims.service.impl;

import com.google.common.collect.ImmutableMap;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.ims.dao.CdpGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.CdpOpenApiUrlMapper;
import com.yqbsoft.laser.service.ims.dao.DisChannelMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractGuideMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractPayDetailMapper;
import com.yqbsoft.laser.service.ims.dao.OcContractPayGoodsDetailMapper;
import com.yqbsoft.laser.service.ims.dao.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.ims.dao.OcRefundMapper;
import com.yqbsoft.laser.service.ims.dao.OrgDepartMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoChannelMapper;
import com.yqbsoft.laser.service.ims.dao.UmUserinfoMapper;
import com.yqbsoft.laser.service.ims.dao.UpmUpointsMapper;
import com.yqbsoft.laser.service.ims.domain.OcContractGoods;
import com.yqbsoft.laser.service.ims.domain.OcPackage;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousAttributeDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousCardDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousEmpDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousEmpsDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousItemDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousItempayDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousOrderDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousPayitemDomain;
import com.yqbsoft.laser.service.ims.domain.TimingSynchronousProductAliasDomain;
import com.yqbsoft.laser.service.ims.model.DisChannel;
import com.yqbsoft.laser.service.ims.model.GoodsCategoryVO;
import com.yqbsoft.laser.service.ims.model.OcContract;
import com.yqbsoft.laser.service.ims.model.OcContractPayDetail;
import com.yqbsoft.laser.service.ims.model.OcContractPayGoodsDetail;
import com.yqbsoft.laser.service.ims.model.OcRefund;
import com.yqbsoft.laser.service.ims.model.OcRefundGoods;
import com.yqbsoft.laser.service.ims.model.OrgDepart;
import com.yqbsoft.laser.service.ims.model.UlLevelUpoints;
import com.yqbsoft.laser.service.ims.model.UmUserinfoChannel;
import com.yqbsoft.laser.service.ims.model.UmUserinfoModel;
import com.yqbsoft.laser.service.ims.model.UmUserinfoQua;
import com.yqbsoft.laser.service.ims.model.UpmUpointsClear;
import com.yqbsoft.laser.service.ims.model.order.CdpGoods;
import com.yqbsoft.laser.service.ims.model.order.PosContractPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGoods;
import com.yqbsoft.laser.service.ims.model.order.PosGoodsPayDetails;
import com.yqbsoft.laser.service.ims.model.order.PosGuide;
import com.yqbsoft.laser.service.ims.model.order.PosOrder;
import com.yqbsoft.laser.service.ims.sap.entity.ColorEntity;
import com.yqbsoft.laser.service.ims.sap.entity.JsonEntity;
import com.yqbsoft.laser.service.ims.sap.entity.LclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.MclsEntity;
import com.yqbsoft.laser.service.ims.sap.entity.SclsEntity;
import com.yqbsoft.laser.service.ims.service.PosStoreService;
import com.yqbsoft.laser.service.ims.utils.HttpClientUtil;
import com.yqbsoft.laser.service.ims.utils.connect.PosConnetUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class PosStoreServiceImpl
extends BaseServiceImpl
implements PosStoreService {
    @Autowired
    private UpmUpointsMapper upmUpointsMapper;
    @Autowired
    private UmUserinfoMapper umUserinfoMapper;
    @Autowired
    private OrgDepartMapper orgDepartMapper;
    @Autowired
    private DisChannelMapper disChannelMapper;
    @Autowired
    private UmUserinfoChannelMapper umUserinfoChannelMapper;
    @Autowired
    private OcContractMapper ocContractMapper;
    @Autowired
    private OcContractGuideMapper ocContractGuideMapper;
    @Autowired
    private CdpGoodsMapper cdpGoodsMapper;
    @Autowired
    private OcContractGoodsMapper ocContractGoodsMapper;
    @Autowired
    private OcContractPayDetailMapper ocContractPayDetailMapper;
    @Autowired
    private OcContractPayGoodsDetailMapper ocContractPayGoodsDetailMapper;
    @Autowired
    private OcRefundMapper ocRefundMapper;
    @Autowired
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    @Autowired
    private CdpOpenApiUrlMapper cdpOpenApiUrlMapper;
    private static final String cdp_order_code = "cdp_order";

    @Override
    public void timingPosOrder(String satrtDadate, String endDadate) {
        URI uri = null;
        try {
            String byCode = this.cdpOpenApiUrlMapper.getByCode(cdp_order_code);
            Date date = new Date();
            Date date1 = DateUtils.addSeconds((Date)date, (int)-600);
            this.logger.info(DateUtils.parseDateToString((Date)date1, (String)"yyyy-MM-dd HH:mm:ss"));
            String endDate = DateUtils.parseDateToString((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
            String bigDate = DateUtils.parseDateToString((Date)date1, (String)"yyyy-MM-dd HH:mm:ss");
            String start = bigDate.replace(" ", "%20");
            String end = endDate.replace(" ", "%20");
            String str = null;
            str = StringUtils.isNotBlank((String)satrtDadate) && StringUtils.isNotBlank((String)endDadate) ? byCode + "?dateb=" + satrtDadate.replace(" ", "%20") + "&datee=" + endDadate.replace(" ", "%20") + "&page=1&rows=5000" : byCode + "?dateb=" + start + "&datee=" + end + "&page=1&rows=5000";
            this.logger.info("str\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)str));
            uri = new URI(str);
            String result = HttpClientUtil.sendPostForJson(uri);
            if (StringUtils.isBlank((String)result)) {
                this.logger.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)str);
                return;
            }
            SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(result, SupQueryResult.class);
            this.logger.info("supQueryResult\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)supQueryResult));
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), TimingSynchronousOrderDomain.class);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                this.timingSynchronousOrder(list);
            }
            this.logger.info("\u6253\u5370\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void timingSynchronousOrder(List<TimingSynchronousOrderDomain> list) {
        list.stream().forEach(order -> {
            String origvalue = order.getOrigvalue();
            Integer statusret = order.getStatusret();
            List<UmUserinfoModel> query = null;
            if (!Objects.isNull(order.getVip())) {
                Integer cardno = order.getVip().getCardno();
                this.logger.info("cardNo:", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)cardno));
                HashMap<String, Object> userInfoMap = new HashMap<String, Object>();
                userInfoMap.put("userinfoOcode", cardno + "");
                userInfoMap.put("userinfoQuality", "buy");
                userInfoMap.put("fuzzy", false);
                query = this.umUserinfoMapper.query(userInfoMap);
            }
            HashMap<String, Object> orgMap = new HashMap<String, Object>();
            orgMap.put("departOcode", order.getStore().getCode());
            List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
            if (CollectionUtils.isEmpty(orgDepartList)) {
                this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(orgMap));
            } else {
                OrgDepart orgDepart = orgDepartList.get(0);
                UmUserinfoModel umUserinfoModel = null;
                if (!CollectionUtils.isEmpty(query)) {
                    umUserinfoModel = (UmUserinfoModel)query.get(0);
                    HashMap<String, Object> infochannelMap = new HashMap<String, Object>();
                    infochannelMap.put("userinfoCode", umUserinfoModel.getUserinfoCode());
                    infochannelMap.put("channelCode", orgDepart.getCompanyCode());
                    List<UmUserinfoChannel> umUserinfoChannelList = this.umUserinfoChannelMapper.query(infochannelMap);
                    this.logger.info("\u662f\u5426\u6709\u8fd9\u4e2a\u6e20\u9053\u7528\u6237\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)umUserinfoChannelList.size()));
                    if (CollectionUtils.isEmpty(umUserinfoChannelList)) {
                        this.createBrandUser(umUserinfoModel, orgDepart);
                    }
                }
                if (statusret != 4) {
                    OcContract ocContract;
                    if (statusret != 2 && statusret != 8 && !Objects.isNull(ocContract = this.saveTimingSynchronousOrder((TimingSynchronousOrderDomain)order, umUserinfoModel, orgDepart))) {
                        this.checkPoint(ocContract);
                        ocContract.setGoodsPbillno(origvalue);
                        String s = this.saveTimingSynchronousGoods(ocContract, (TimingSynchronousOrderDomain)order);
                        if (!StringUtils.isBlank((String)s)) {
                            List<TimingSynchronousItempayDomain> list;
                            List<TimingSynchronousPayitemDomain> payitem;
                            List<TimingSynchronousEmpsDomain> emps = order.getEmps();
                            if (!CollectionUtils.isEmpty(emps)) {
                                for (TimingSynchronousEmpsDomain timingSynchronousEmpsDomain : emps) {
                                    this.timingSynchronousSaveGuide(timingSynchronousEmpsDomain, ocContract.getContractBillcode());
                                }
                            }
                            if (!CollectionUtils.isEmpty(payitem = order.getPayitem())) {
                                for (TimingSynchronousPayitemDomain payDomain : payitem) {
                                    this.timingSynchronousPayDetails(payDomain, order.getDocno(), null);
                                }
                            }
                            if (!CollectionUtils.isEmpty(list = order.getItempay())) {
                                for (TimingSynchronousItempayDomain payDomain : list) {
                                    this.timingSynchronousItemPayDetails(payDomain, order.getDocno(), null);
                                }
                            }
                        }
                    }
                } else {
                    this.logger.info("\u8fd9\u4e2a\u662f\u6362\u8272\u6362\u7801\u5355\u5b50");
                }
            }
        });
    }

    private void createBrandUser(UmUserinfoModel umUserinfoModel, OrgDepart orgDepart) {
        String userinfoChannelCode = this.createChannelUser(umUserinfoModel.getUserinfoCompname(), umUserinfoModel.getUserinfoCode(), orgDepart.getCompanyCode());
        if (StringUtils.isNotBlank((String)userinfoChannelCode)) {
            this.createUserLevel(umUserinfoModel.getUserinfoCode(), orgDepart.getCompanyCode());
            this.createUserQua(userinfoChannelCode, orgDepart);
        }
    }

    private void createUserQua(String userinfoChannelCode, OrgDepart orgDepart) {
        UmUserinfoQua umUserinfoQua = new UmUserinfoQua();
        umUserinfoQua.setUserinfoCode(userinfoChannelCode);
        umUserinfoQua.setTenantCode("2022012800000001");
        umUserinfoQua.setUserinfoQuaKey("store");
        List<UmUserinfoModel> query = this.umUserinfoMapper.query((Map<String, Object>)ImmutableMap.of((Object)"departCode", (Object)orgDepart.getDepartCode(), (Object)"userinfoQuality", (Object)"depart"));
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("" + userinfoChannelCode + "\u95e8\u5e97" + JsonUtil.buildNonDefaultBinder().toJson((Object)orgDepart));
            return;
        }
        UmUserinfoModel umUserinfoModel = query.get(0);
        umUserinfoQua.setUserinfoQuaVaule1(umUserinfoModel.getUserinfoCode());
        this.inserUserinfoQua(umUserinfoQua);
    }

    private void inserUserinfoQua(UmUserinfoQua umUserinfoQua) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("umUserinfoQuaDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoQua));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)umUserinfoQua));
            Object o = this.getInternalRouter().inInvoke("um.userinfoQua.saveUserinfoQua", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createUserLevel(String userinfoCode, String companyCode) {
        UlLevelUpoints ulLevelUpoints = new UlLevelUpoints();
        ulLevelUpoints.setChannelCode(companyCode);
        ulLevelUpoints.setMemberCode(userinfoCode);
        ulLevelUpoints.setLevelUserqua("buy");
        ulLevelUpoints.setLevelDatatype("levelListCode");
        ulLevelUpoints.setLevelDatavalue("0");
        ulLevelUpoints.setLevelListLevel(0);
        ulLevelUpoints.setLevelListName("\u4f1a\u5458\u5361");
        ulLevelUpoints.setLevelLnum(this.getBigDecimal(0));
        ulLevelUpoints.setLevelNum(this.getBigDecimal(0));
        ulLevelUpoints.setLevelOnum(this.getBigDecimal(0));
        ulLevelUpoints.setTenantCode("2022012800000001");
        ulLevelUpoints.setUpointsType(0);
        DisChannel byCode = this.disChannelMapper.getByCode((Map<String, Object>)ImmutableMap.of((Object)"channelCode", (Object)companyCode));
        if (byCode != null) {
            ulLevelUpoints.setMemberMcode(byCode.getMemberCode());
            this.insertUlLevelUpoints(ulLevelUpoints);
        }
    }

    private void insertUlLevelUpoints(UlLevelUpoints ulLevelUpoints) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("ulLevelUpointsDomain", JsonUtil.buildNormalBinder().toJson((Object)ulLevelUpoints));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)ulLevelUpoints));
            Object o = this.getInternalRouter().inInvoke("ul.ulLevelUllist.saveUlLevelUpoints", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String createChannelUser(String name, String userinfoCode, String companyCode) {
        UmUserinfoChannel umUserinfoChannel = new UmUserinfoChannel();
        umUserinfoChannel.setDataState(0);
        umUserinfoChannel.setUserinfoCompname(name);
        umUserinfoChannel.setChannelCode(companyCode);
        umUserinfoChannel.setUserinfoCode(userinfoCode);
        umUserinfoChannel.setGmtCreate(new Date());
        umUserinfoChannel.setGmtModified(new Date());
        umUserinfoChannel.setQualityCode("buy");
        umUserinfoChannel.setTenantCode("2022012800000001");
        return this.inserUmUserinfoChannel(umUserinfoChannel);
    }

    private String inserUmUserinfoChannel(UmUserinfoChannel umUserinfoChannel) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("umUserinfoChannelDomain", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoChannel));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)umUserinfoChannel));
            Object o = this.getInternalRouter().inInvoke("um.umUserinfoChannel.saveUserinfoChannel", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
            return (String)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String saveTimingSynchronousRefundGoods(OcRefund oc, TimingSynchronousOrderDomain order) {
        if (Objects.isNull(oc)) {
            return null;
        }
        this.logger.info("\u6253\u5370item\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(order.getItem()));
        List<TimingSynchronousItemDomain> item = order.getItem();
        ArrayList<OcRefundGoods> list = new ArrayList<OcRefundGoods>();
        if (!CollectionUtils.isEmpty(item)) {
            int i = 0;
            for (TimingSynchronousItemDomain goods : item) {
                ++i;
                if (goods.getType() != 16) {
                    oc.setGoodsNum(oc.getGoodsNum().add(this.getBigDecimal(goods.getQty())));
                } else {
                    oc.setGoodsNum(this.getBigDecimal(1));
                }
                String skc = goods.getProduct().getName();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", skc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                String spu = cdpGoods.getSpu();
                OcRefundGoods ocContractGoods = new OcRefundGoods();
                ocContractGoods.setContractBillcode(oc.getContractBillcode());
                ocContractGoods.setRefundGoodsCode(oc.getRefundCode() + "" + i);
                ocContractGoods.setSkuCode(goods.getProductAlias().getNo());
                ocContractGoods.setSpuCode(spu);
                ocContractGoods.setSkuName(goods.getProduct().getValue());
                ocContractGoods.setGoodsName(goods.getProduct().getValue());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(spu);
                ocContractGoods.setGoodsNo(spu);
                ocContractGoods.setSkuShowno(goods.getProductAlias().getNo());
                ocContractGoods.setSkuNo(goods.getProductAlias().getNo());
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setGoodsCamount(this.getBigDecimal(goods.getQty()));
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getType() + "");
                ocContractGoods.setRefundGoodsType(0);
                ocContractGoods.setGoodsNum(this.getBigDecimal(goods.getQty()));
                ocContractGoods.setContractGoodsPrice(this.getBigDecimal(goods.getTot_amt_actual()));
                ocContractGoods.setContractGoodsMoney(this.getBigDecimal(goods.getTot_amt_actual()));
                ocContractGoods.setRefundGoodsAmt(this.getBigDecimal(goods.getTot_amt_actual()));
                ocContractGoods.setRefundGoodsPrice(this.getBigDecimal(goods.getTot_amt_list()));
                ocContractGoods.setContractGoodsInmoney(this.getBigDecimal(goods.getTot_amt_list()));
                ocContractGoods.setContractGoodsPefinmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(this.getBigDecimal("0"));
                ocContractGoods.setPricesetNprice(this.getBigDecimal(goods.getTot_amt_actual()));
                ocContractGoods.setPricesetMakeprice(this.getBigDecimal(goods.getTot_amt_list()));
                ocContractGoods.setPricesetBaseprice(this.getBigDecimal(goods.getTot_amt_list()));
                ocContractGoods.setPricesetAsprice(this.getBigDecimal(goods.getTot_amt_actual()));
                ocContractGoods.setRefundGoodsNum(this.getBigDecimal(goods.getQty()));
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundGoodsType(0);
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setContractGoodsCode(goods.getProductAlias().getNo());
                ocContractGoods.setRefundCode(oc.getRefundCode());
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                if (!ocContractGoods.getGoodsType().equals("16")) {
                    ocContractGoods.setGoodsNum(this.getBigDecimal(goods.getQty()));
                } else {
                    oc.setGoodsNum(this.getBigDecimal(1));
                }
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                list.add(ocContractGoods);
            }
            oc.setOcRefundGoodsDomainList(list);
            return this.insertOcRefund(oc);
        }
        return null;
    }

    private String insertOcRefund(OcRefund oc) {
        this.logger.info("\u6dfb\u52a0\u9000\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        return this.sendSaveRefund(oc);
    }

    public String sendSaveRefund(OcRefund ocRefundDomain) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("ocRefundDomain", JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
            this.logger.info("\u6253\u5370\u8bf7\u6c42\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)ocRefundDomain));
            Object o = this.getInternalRouter().inInvoke("oc.refundEngine.sendSaveRefund", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
            return (String)o;
        }
        catch (Exception e) {
            this.logger.info("\u4fdd\u5b58\u9000\u5355\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocRefundDomain));
            e.printStackTrace();
            return null;
        }
    }

    private OcRefund saveTimingSynchronousRefundOrder(TimingSynchronousOrderDomain order, UmUserinfoModel umUserinfoModel, OrgDepart orgDepart) {
        OcRefund oc = new OcRefund();
        oc.setRefundCode(order.getDocno());
        oc.setContractBillcode(order.getOrgno());
        oc.setContractBbillcode(order.getOrgno());
        oc.setGoodsClass("pos");
        oc.setGoodsNum(this.getBigDecimal(0));
        if (!Objects.isNull(umUserinfoModel)) {
            oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
            oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
        }
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(storeMap));
            return null;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setDataOpnextbillstate(0);
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(disMap));
            return null;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType("00");
        oc.setContractTypepro(order.getStatusret() + "");
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(this.getBigDecimal("0"));
        oc.setContractPaymoney(this.getBigDecimal(0));
        oc.setContractMoney(this.getBigDecimal(order.getTot_amt_list()));
        oc.setRefundMoney(this.getBigDecimal(order.getTot_amt_actual()));
        oc.setRefundPmmoney(this.getBigDecimal(order.getTot_amt_list()).subtract(this.getBigDecimal(order.getTot_amt_actual())));
        oc.setRefundType("B01");
        oc.setGoodsLogmoney(this.getBigDecimal(0));
        Date date = this.yyyyMMddtoDate(order.getBilldate());
        if (date == null) {
            oc.setRefundDate(date);
        } else {
            oc.setRefundDate(order.getStatustime());
        }
        oc.setDataState(8);
        return oc;
    }

    private void checkPoint(OcContract ocContract) {
        Integer isSuccess;
        if (StringUtils.isNotBlank((String)ocContract.getMemberBcode()) && ((isSuccess = this.upmUpointsMapper.queryMemberPoints(ocContract.getMemberBcode(), "0", ocContract.getMemberCcode())) == null || isSuccess == 0)) {
            this.upmUpointsMapper.saveUpmUpoints(System.currentTimeMillis() + "", ocContract.getMemberBcode(), "0", ocContract.getMemberCcode());
        }
    }

    private void checkPoint(OcRefund ocContract) {
        Integer isSuccess;
        if (StringUtils.isNotBlank((String)ocContract.getMemberBcode()) && ((isSuccess = this.upmUpointsMapper.queryMemberPoints(ocContract.getMemberBcode(), "0", ocContract.getMemberCcode())) == null || isSuccess == 0)) {
            this.upmUpointsMapper.saveUpmUpoints(System.currentTimeMillis() + "", ocContract.getMemberBcode(), "0", ocContract.getMemberCcode());
        }
    }

    public Object insertUpmUpointsClear(UpmUpointsClear clear) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)clear));
        Object departCode = this.getInternalRouter().inInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
        return departCode;
    }

    private void timingSynchronousItemPayDetails(TimingSynchronousItempayDomain payitemDomain, String docno, String refundNo) {
        String value2_code;
        TimingSynchronousAttributeDomain attribute;
        String no;
        OcContractPayGoodsDetail ocContractPayDetail = new OcContractPayGoodsDetail();
        if (StringUtils.isBlank((String)refundNo)) {
            ocContractPayDetail.setContractBillcode(docno);
        } else {
            ocContractPayDetail.setRefundCode(refundNo);
        }
        ocContractPayDetail.setPayMoney(this.getBigDecimal(StringUtils.isNotBlank((String)payitemDomain.getPayamount()) ? payitemDomain.getPayamount() : "0"));
        ocContractPayDetail.setPaywayId(payitemDomain.getC_payway_id());
        ocContractPayDetail.setGmtCreate(DateUtils.parseDate((Date)new Date()));
        ocContractPayDetail.setGmtModified(DateUtils.parseDate((Date)new Date()));
        TimingSynchronousProductAliasDomain productAlias = payitemDomain.getProductAlias();
        if (!Objects.isNull(productAlias) && StringUtils.isNotBlank((String)(no = productAlias.getNo())) && !Objects.isNull(attribute = productAlias.getAttribute()) && StringUtils.isNotBlank((String)(value2_code = attribute.getValue2_code()))) {
            String sub = no + value2_code;
            ocContractPayDetail.setGoodsSku(sub);
        }
        int insert = this.ocContractPayGoodsDetailMapper.insert(ocContractPayDetail);
        this.logger.info("\u5546\u54c1\u652f\u4ed8\u662f\u5426\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)insert));
    }

    private void timingSynchronousPayDetails(TimingSynchronousPayitemDomain payitemDomain, String no, String refundNo) {
        OcContractPayDetail ocContractPayDetail = new OcContractPayDetail();
        if (StringUtils.isBlank((String)refundNo)) {
            ocContractPayDetail.setContractBillcode(no);
        } else {
            ocContractPayDetail.setRefundCode(refundNo);
        }
        ocContractPayDetail.setPayMoney(this.getBigDecimal(StringUtils.isNotBlank((String)payitemDomain.getPayamount()) ? payitemDomain.getPayamount() : "0"));
        ocContractPayDetail.setPaywayId(payitemDomain.getC_payway_id());
        if (!Objects.isNull(payitemDomain.getCard())) {
            ocContractPayDetail.setCardId(payitemDomain.getCard().getId() + "");
            ocContractPayDetail.setDiscountRate(this.getBigDecimal(payitemDomain.getCard().getDiscount()));
        }
        ocContractPayDetail.setGmtCreate(DateUtils.parseDate((Date)new Date()));
        ocContractPayDetail.setGmtModified(DateUtils.parseDate((Date)new Date()));
        this.ocContractPayDetailMapper.insert(ocContractPayDetail);
    }

    private void timingSynchronousSaveGuide(TimingSynchronousEmpsDomain tse, String contractBillcode) {
        TimingSynchronousEmpDomain emp = tse.getEmp();
        if (Objects.isNull(emp)) {
            this.logger.info("\u5bfc\u8d2d\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)tse));
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("userinfoChannelVaule", emp.getNo());
        hashMap.put("qualityCode", "dis");
        List<UmUserinfoChannel> query = this.umUserinfoChannelMapper.query(hashMap);
        if (CollectionUtils.isEmpty(query)) {
            this.logger.info("\u672a\u67e5\u8be2\u5bfc\u8d2d\uff1a{}" + emp.getNo());
            return;
        }
        UmUserinfoChannel umUserinfoChannel = query.get(0);
        umUserinfoChannel.setUserinfoChannelVaule2(tse.getDiscount());
        this.ocContractGuideMapper.insertContractGuide(umUserinfoChannel, contractBillcode);
    }

    private String saveTimingSynchronousGoods(OcContract oc, TimingSynchronousOrderDomain order) {
        if (Objects.isNull(oc)) {
            return null;
        }
        BigDecimal goodsMoney = new BigDecimal("0");
        BigDecimal goodsInMoney = new BigDecimal("0");
        ArrayList<OcContractGoods> goods = new ArrayList<OcContractGoods>();
        int i = 0;
        for (TimingSynchronousItemDomain item : order.getItem()) {
            ++i;
            item.setTot_amt_actual("0");
            List<TimingSynchronousItempayDomain> itempay = order.getItempay();
            if (!CollectionUtils.isEmpty(itempay)) {
                this.logger.info("\u6253\u5370\u65e5\u5fd7itempay\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(itempay));
                List collect = itempay.stream().filter(pay -> pay != null && pay.getM_retailitem_id().toString().equals(item.getId().toString())).collect(Collectors.toList());
                this.logger.info("\u6253\u5370\u65e5\u5fd7collect\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(collect));
                if (!CollectionUtils.isEmpty(collect)) {
                    for (TimingSynchronousItempayDomain itempayDomain : collect) {
                        Integer c_payway_id = itempayDomain.getC_payway_id();
                        if (c_payway_id == 64 || c_payway_id == 65) {
                            TimingSynchronousCardDomain cardDomain = itempayDomain.getCard();
                            if (cardDomain != null) {
                                String discount = cardDomain.getDiscount();
                                BigDecimal beginMoney = this.getBigDecimal(itempayDomain.getPayamount());
                                this.logger.info("\u6253\u5370\u91d1\u989d\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)beginMoney));
                                BigDecimal discountRatio = this.getBigDecimal(discount).divide(new BigDecimal(100)).setScale(4, 4);
                                this.logger.info("\u6253\u5370\u7a0e\u7387\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)discountRatio));
                                BigDecimal money = beginMoney.multiply(discountRatio);
                                item.setTot_amt_actual(money.add(this.getBigDecimal(item.getTot_amt_actual())).toString());
                                goodsMoney = goodsMoney.add(money);
                                itempayDomain.setPayamount(money.toString());
                                this.logger.info("\u6253\u5370\u8ba1\u7b97\u540e\u7684\u91d1\u989d22\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsMoney));
                            } else {
                                this.logger.info("\u5361\u53f7\u4e3a\u7a7a");
                            }
                        }
                        if (c_payway_id != 27) continue;
                        item.setTot_amt_actual(this.getBigDecimal(itempayDomain.getPayamount()).add(this.getBigDecimal(item.getTot_amt_actual())).toString());
                        goodsMoney = goodsMoney.add(this.getBigDecimal(itempayDomain.getPayamount()));
                        this.logger.info("\u6253\u5370\u8ba1\u7b97\u540e\u7684\u91d1\u989d\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)goodsMoney));
                    }
                }
            }
            if (item.getType() != 16) {
                oc.setGoodsNum(oc.getGoodsNum().add(this.getBigDecimal(item.getQty())));
            } else {
                oc.setGoodsNum(oc.getGoodsNum().add(this.getBigDecimal(1)));
            }
            oc.setDataBnum(oc.getGoodsNum().add(this.getBigDecimal(item.getQty())));
            String skc = item.getProduct().getName();
            String goodsName = item.getProduct().getValue();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("skc", skc);
            hashMap.put("page", 0);
            hashMap.put("rows", 1);
            List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
            if (CollectionUtils.isEmpty(query)) {
                this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                continue;
            }
            CdpGoods cdpGoods = query.get(0);
            String spu = cdpGoods.getSpu();
            goodsName = cdpGoods.getArticleName();
            OcContractGoods ocContractGoods = new OcContractGoods();
            ocContractGoods.setContractBillcode(oc.getContractBillcode());
            ocContractGoods.setContractGoodsCode(oc.getContractBillcode() + "" + i);
            ocContractGoods.setSkuCode(item.getProductAlias().getNo());
            ocContractGoods.setSpuCode(spu);
            ocContractGoods.setSkuName(goodsName);
            ocContractGoods.setGoodsName(goodsName);
            ocContractGoods.setMemberBcode(oc.getMemberBcode());
            ocContractGoods.setMemberBname(oc.getMemberBname());
            ocContractGoods.setMemberMcode(oc.getMemberMcode());
            ocContractGoods.setMemberMname(oc.getMemberMname());
            ocContractGoods.setMemberCode(oc.getMemberCode());
            ocContractGoods.setMemberName(oc.getMemberName());
            ocContractGoods.setMemberCcode(oc.getMemberCcode());
            ocContractGoods.setMemberCname(oc.getMemberCname());
            ocContractGoods.setGoodsShowno(item.getProduct().getName());
            ocContractGoods.setGoodsNo(item.getProduct().getName());
            ocContractGoods.setSkuShowno(item.getProductAlias().getNo());
            ocContractGoods.setSkuNo(item.getProductAlias().getNo());
            ocContractGoods.setContractGoodsType(0);
            ocContractGoods.setChannelCode(oc.getChannelCode());
            ocContractGoods.setChannelName(oc.getChannelName());
            ocContractGoods.setGoodsCamount(this.getBigDecimal(item.getQty()));
            ocContractGoods.setGoodsClass("pos");
            ocContractGoods.setGoodsPro("0");
            ocContractGoods.setGoodsType(item.getType() + "");
            ocContractGoods.setContractGoodsPrice(this.getBigDecimal(item.getTot_amt_actual()));
            ocContractGoods.setContractGoodsMoney(this.getBigDecimal(item.getTot_amt_actual()));
            ocContractGoods.setContractGoodsInmoney(this.getBigDecimal(item.getTot_amt_list()));
            goodsInMoney = goodsInMoney.add(this.getBigDecimal(item.getTot_amt_list()));
            ocContractGoods.setContractGoodsPefinmoney(this.getBigDecimal("0"));
            ocContractGoods.setContractGoodsPefmoney(this.getBigDecimal("0"));
            ocContractGoods.setContractGoodsPefprice(this.getBigDecimal("0"));
            ocContractGoods.setPricesetNprice(this.getBigDecimal(item.getTot_amt_list()));
            ocContractGoods.setPricesetMakeprice(this.getBigDecimal(item.getTot_amt_list()));
            ocContractGoods.setPricesetBaseprice(this.getBigDecimal(item.getTot_amt_list()));
            ocContractGoods.setContractGoodsSendnum(this.getBigDecimal(item.getQty()));
            ocContractGoods.setDataPic(cdpGoods.getImgPath());
            ocContractGoods.setGmtCreate(new Date());
            ocContractGoods.setGmtModified(new Date());
            ocContractGoods.setDataOpbillstate(0);
            ocContractGoods.setDataState(0);
            ocContractGoods.setContractGoodsGtype("0");
            ocContractGoods.setTenantCode(oc.getTenantCode());
            ocContractGoods.setGoodsCode(item.getProductAlias().getNo());
            ocContractGoods.setGoodsClass(oc.getGoodsClass());
            ocContractGoods.setRefundFlag(0);
            if (ocContractGoods.getContractGoodsPrice().compareTo(this.getBigDecimal("0")) == 0) {
                ocContractGoods.setContractGoodsRefnum(this.getBigDecimal(item.getQty()));
                ocContractGoods.setRefundFlag(1);
            }
            if (item.getType() != 16) {
                ocContractGoods.setGoodsNum(this.getBigDecimal(item.getQty()));
            } else {
                ocContractGoods.setGoodsNum(this.getBigDecimal(1));
            }
            this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
            goods.add(ocContractGoods);
        }
        this.logger.info("goodsMoney=" + goodsMoney + "  goodsInMoney=" + goodsInMoney);
        oc.setContractMoney(goodsMoney);
        oc.setGoodsMoney(goodsMoney);
        oc.setDataBmoney(goodsMoney);
        oc.setGoodsPmoney(oc.getContractInmoney().subtract(goodsMoney));
        OcPackage ocPackageDomain = this.savePackage(oc, goodsMoney, goodsInMoney);
        this.checkMoney(oc, goods, ocPackageDomain);
        ocPackageDomain.setContractGoodsList(goods);
        oc.setGoodsList(goods);
        oc.setContractGoodsList(goods);
        oc.setPackageList(Arrays.asList(ocPackageDomain));
        return this.insertContract(oc);
    }

    private void checkMoney(OcContract oc, List<OcContractGoods> goods, OcPackage ocPackageDomain) {
        if (ocPackageDomain.getGoodsMoney().compareTo(BigDecimal.ZERO) == 0 && oc.getContractInmoney().compareTo(BigDecimal.ZERO) != 0) {
            oc.setContractInmoney(BigDecimal.ZERO);
        }
    }

    private OcPackage savePackage(OcContract ocContract, BigDecimal goodsMoney, BigDecimal goodsInMoney) {
        OcPackage ocPackageDomain = new OcPackage();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)ocContract);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BigDecimal goodsPmoney = ocPackageDomain.getGoodsPmoney();
        String goodsPmbillno = ocPackageDomain.getGoodsPmbillno();
        BigDecimal goodsWeight = ocPackageDomain.getGoodsWeight();
        BigDecimal goodsNum = ocPackageDomain.getGoodsNum();
        String areaCode = ocPackageDomain.getAreaCode();
        String areaName = ocPackageDomain.getAreaName();
        String warehouseName = ocPackageDomain.getWarehouseName();
        String warehouseCode = ocPackageDomain.getWarehouseCode();
        String contractPumode = ocPackageDomain.getContractPumode();
        if (StringUtils.isNotBlank((String)contractPumode)) {
            ocPackageDomain.setContractPumode(contractPumode);
        }
        ocPackageDomain.setContractBillcode(ocContract.getContractBillcode());
        ocPackageDomain.setTenantCode(ocContract.getTenantCode());
        ocPackageDomain.setGoodsMoney(goodsInMoney);
        ocPackageDomain.setGoodsInmoney(goodsMoney);
        ocPackageDomain.setGoodsPmoney(goodsPmoney);
        ocPackageDomain.setGoodsPmbillno(goodsPmbillno);
        ocPackageDomain.setGoodsWeight(goodsWeight);
        ocPackageDomain.setGoodsNum(goodsNum);
        ocPackageDomain.setAreaCode(areaCode);
        ocPackageDomain.setAreaName(areaName);
        ocPackageDomain.setWarehouseCode(warehouseCode);
        ocPackageDomain.setWarehouseName(warehouseName);
        ocPackageDomain.setMemberBcode(ocContract.getMemberBcode());
        ocPackageDomain.setMemberBname(ocContract.getMemberBname());
        ocPackageDomain.setMemberCode(ocContract.getMemberCode());
        ocPackageDomain.setMemberName(ocContract.getMemberName());
        return ocPackageDomain;
    }

    private String insertContract(OcContract oc) {
        try {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("ocContractDomain", JsonUtil.buildNormalBinder().toJson((Object)oc));
            this.logger.info("\u6253\u5370\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)oc));
            Object o = this.getInternalRouter().inInvoke("oc.contract.sendsaveContract", pmap);
            this.logger.info("\u4fdd\u5b58\u7684\u5c5e\u6027\u8fd4\u56de\u503c\uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson(o));
            return (String)o;
        }
        catch (Exception e) {
            this.logger.info("\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
            e.printStackTrace();
            return null;
        }
    }

    private OcContract saveTimingSynchronousOrder(TimingSynchronousOrderDomain order, UmUserinfoModel umUserinfoModel, OrgDepart orgDepart) {
        OcContract ocContract = new OcContract();
        ocContract.setDataState(5);
        ocContract.setContractBillcode(order.getDocno());
        ocContract.setContractBbillcode(order.getDocno());
        if (!Objects.isNull(umUserinfoModel)) {
            ocContract.setMemberBcode(umUserinfoModel.getUserinfoCode());
            ocContract.setMemberBname(umUserinfoModel.getUserinfoCompname());
        }
        ocContract.setGoodsClass("pos");
        ocContract.setGoodsNum(this.getBigDecimal(0));
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(storeMap));
            return null;
        }
        UmUserinfoModel store = storeList.get(0);
        ocContract.setMemberCode(store.getUserinfoCode());
        ocContract.setMemberName(store.getUserinfoCompname());
        ocContract.setMschannelCode(store.getUserinfoCode());
        ocContract.setMschannelName(store.getUserinfoCompname());
        ocContract.setChannelCode(store.getUserinfoCode());
        ocContract.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(disMap));
            return null;
        }
        DisChannel disChannel = disChannelList.get(0);
        ocContract.setMemberCcode(disChannel.getMemberCode());
        ocContract.setMemberMcode(disChannel.getMemberCode());
        ocContract.setMemberMname(disChannel.getMemberName());
        ocContract.setMemberCname(disChannel.getMemberName());
        ocContract.setTenantCode(disChannel.getTenantCode());
        ocContract.setContractType("00");
        ocContract.setContractTypepro(order.getStatusret() + "");
        ocContract.setContractBlance("0");
        ocContract.setContractPmode("1");
        ocContract.setContractPumode("0");
        ocContract.setContractPumode("0");
        ocContract.setGoodsWeight(this.getBigDecimal("0"));
        ocContract.setPricesetRefrice(this.getBigDecimal(0));
        ocContract.setContractPaymoney(this.getBigDecimal(order.getTot_amt_list()));
        ocContract.setContractInmoney(this.getBigDecimal(order.getTot_amt_list()));
        ocContract.setContractMoney(this.getBigDecimal(order.getTot_amt_actual()));
        ocContract.setGoodsMoney(this.getBigDecimal(order.getTot_amt_actual()));
        ocContract.setDataBmoney(this.getBigDecimal(order.getTot_amt_actual()));
        ocContract.setDataBweight(this.getBigDecimal(0));
        ocContract.setContractShow(0);
        ocContract.setContractEcflag(0);
        ocContract.setContractInvstate(0);
        ocContract.setGoodsLogmoney(this.getBigDecimal(0));
        Date date = this.yyyyMMddtoDate(order.getBilldate());
        if (date != null) {
            ocContract.setContractPaydate(date);
        } else {
            ocContract.setContractPaydate(order.getStatustime());
        }
        ocContract.setRefundFlag(0);
        ocContract.setGoodsPmoney(ocContract.getContractInmoney().subtract(ocContract.getDataBmoney()));
        return ocContract;
    }

    public Date yyyyMMddtoDate(String args) {
        try {
            Date date = DateUtils.parseDate((String)args, (String)"yyyyMMdd");
            Date date1 = DateUtils.parseDate((String)(DateUtils.parseDate((Date)date) + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            return date1;
        }
        catch (Exception e) {
            e.fillInStackTrace();
            return null;
        }
    }

    @Override
    public void synchronousOrder() {
        try {
            List<PosOrder> init = PosConnetUtils.init();
            this.logger.info("\u6253\u5370\u6570\u636e\u6570\u91cf\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(init));
            for (PosOrder pos : init) {
                if (!this.addOcContract(pos)) continue;
                this.addGuide(pos);
                this.addOcContractDetail(pos);
                this.addGoodsPayDetail(pos);
            }
        }
        catch (SQLException | ParseException throwables) {
            throwables.printStackTrace();
        }
    }

    private boolean addOcRefundContract(PosOrder pos) throws ParseException {
        OcRefund oc = new OcRefund();
        oc.setRefundCode(pos.getRefundCode());
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(this.getBigDecimal(pos.getGoodsNum()));
        oc.setGoodsClass(pos.getGoodsClass());
        oc.setDdTypeCurrency("0");
        oc.setTenantCode("2022012800000001");
        if (StringUtils.isNotBlank((String)pos.getUserinfoOcode())) {
            HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
            umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
            umInfoMap.put("userinfoQuality", "buy");
            List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
            if (!CollectionUtils.isEmpty(query)) {
                UmUserinfoModel umUserinfoModel = query.get(0);
                oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
                oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
            }
        }
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setDataOpnextbillstate(0);
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return true;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType(pos.getContractType());
        oc.setContractTypepro(pos.getContractType());
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(this.getBigDecimal("0"));
        oc.setContractPaymoney(this.getBigDecimal(0));
        oc.setContractMoney(this.getBigDecimal(pos.getGoodsMoney()));
        oc.setRefundMoney(this.getBigDecimal(pos.getDataBmoney()));
        oc.setRefundPmmoney(this.getBigDecimal(pos.getGoodsMoney()).subtract(this.getBigDecimal(pos.getDataBmoney())));
        oc.setDataStatestr(pos.getDataState());
        oc.setRefundType("B01");
        oc.setGoodsLogmoney(this.getBigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setRefundDate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(8);
        this.addRefundGoods(pos, oc);
        return false;
    }

    private void addRefundGoods(PosOrder pos, OcRefund oc) {
        if (Objects.isNull(oc)) {
            return;
        }
        List<PosGoods> posGoods = null;
        try {
            posGoods = PosConnetUtils.initGoods(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        this.logger.info("\u6253\u5370goodsList\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(posGoods));
        ArrayList<OcRefundGoods> list = new ArrayList<OcRefundGoods>();
        if (!CollectionUtils.isEmpty(posGoods)) {
            this.addOcRefundDetail(pos);
            for (PosGoods goods : posGoods) {
                String goodsSkc = goods.getGoodsSkc();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", goodsSkc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                OcRefundGoods ocContractGoods = new OcRefundGoods();
                ocContractGoods.setContractBillcode(pos.getContractBillcode());
                ocContractGoods.setSkuCode(goods.getGoodsSkc());
                ocContractGoods.setSpuCode(goods.getGoodsSku());
                ocContractGoods.setSkuName(cdpGoods.getArticleName());
                ocContractGoods.setGoodsName(cdpGoods.getArticleName());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(goods.getGoodsSkc());
                ocContractGoods.setGoodsNo(goods.getGoodsSkc());
                ocContractGoods.setGoodsCode(goods.getGoodsSkc());
                ocContractGoods.setSkuShowno(goods.getGoodsSku());
                ocContractGoods.setSkuNo(goods.getGoodsSku());
                ocContractGoods.setTenantCode("2022012800000001");
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setGoodsCamount(this.getBigDecimal(goods.getGoodsNum()));
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getGoodType());
                ocContractGoods.setGoodsNum(this.getBigDecimal(goods.getGoodsNum()));
                ocContractGoods.setContractGoodsPrice(this.getBigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setContractGoodsMoney(this.getBigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setContractGoodsInmoney(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setContractGoodsPefinmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(this.getBigDecimal("0"));
                ocContractGoods.setPricesetNprice(this.getBigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetMakeprice(this.getBigDecimal(cdpGoods.getListPrice()));
                ocContractGoods.setPricesetBaseprice(this.getBigDecimal(goods.getGoodsMakePrice()));
                ocContractGoods.setPricesetAsprice(this.getBigDecimal(goods.getGoodsNprice()));
                ocContractGoods.setRefundGoodsNum(this.getBigDecimal(goods.getGoodsNum()));
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundGoodsType(Integer.parseInt(goods.getGoodType()));
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setRefundGoodsCode(System.currentTimeMillis() + "");
                ocContractGoods.setRefundCode(pos.getRefundCode());
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                list.add(ocContractGoods);
            }
            this.addRefundGoodsPayDetail(pos);
            oc.setOcRefundGoodsDomainList(list);
            this.insertOcRefund(oc);
        }
    }

    private void addRefundGoodsPayDetail(PosOrder pos) {
        List<PosGoodsPayDetails> list = null;
        try {
            list = PosConnetUtils.initGoodsPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getGoodsPayDetails(list);
        for (OcContractPayDetail posGoodsPayDetails : arr) {
            posGoodsPayDetails.setRefundCode(pos.getRefundCode());
            posGoodsPayDetails.setPayMoney(posGoodsPayDetails.getPayMoney());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayGoodsDetailMapper.insertBatch(arr);
    }

    private int addOcRefund(OcRefund oc) {
        this.logger.info("\u6253\u5370\u9000\u5355\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)oc));
        return this.ocRefundMapper.insert(oc);
    }

    private void sendRefundGoods(OcRefundGoods ocContractGoods) {
        this.ocRefundGoodsMapper.insert(ocContractGoods);
    }

    @Override
    public void synchronousCdpImsGoods() throws SQLException, ParseException {
        JsonEntity jsonEntity = null;
        this.initSap(jsonEntity);
        if (Objects.isNull(jsonEntity)) {
            this.logger.info("cdp\u540c\u6b65\u5546\u54c1\u672a\u67e5\u8be2\u5230sap");
            return;
        }
        List<CdpGoods> arr = this.getCdpGoods();
        for (CdpGoods goods : arr) {
            this.classTreeName(jsonEntity, goods);
            List colorEntitieList = jsonEntity.getCOLOR().stream().filter(u -> u.getJ_3ACOL().equals(goods.getColor())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(colorEntitieList)) continue;
            goods.setColorName(((ColorEntity)colorEntitieList.get(0)).getTEXT());
        }
    }

    private void classTreeName(JsonEntity jsonEntity, CdpGoods goods) {
        List<String> list;
        List<String> list2;
        List<String> list3;
        String field3 = goods.getField3();
        LclsEntity lclsEntity = jsonEntity.getLCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getLABOR() != null && ele.getLBTXT() != null).filter(ele -> ele.getLABOR().equals(field3)).findFirst().get();
        if (!Objects.isNull(lclsEntity) && !CollectionUtils.isEmpty(list3 = Arrays.asList(lclsEntity.getLABOR(), lclsEntity.getLBTXT()))) {
            goods.setField3Name(list3.get(0));
        }
        String field4 = goods.getField4();
        SclsEntity sclsEntity = jsonEntity.getSCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getEXTWG() != null && ele.getEWBEZ() != null).filter(ele -> ele.getEXTWG().equals(field4)).findFirst().get();
        if (!Objects.isNull(sclsEntity) && !CollectionUtils.isEmpty(list2 = Arrays.asList(sclsEntity.getEXTWG(), sclsEntity.getEWBEZ()))) {
            goods.setField4Name(list2.get(0));
        }
        String field5 = goods.getField5();
        MclsEntity mclsEntity = jsonEntity.getMCLS().stream().filter(Objects::nonNull).filter(ele -> ele.getMATKL() != null && ele.getWGBEZ() != null).filter(ele -> ele.getMATKL().equals(field5)).findFirst().get();
        if (!Objects.isNull(mclsEntity) && !CollectionUtils.isEmpty(list = Arrays.asList(mclsEntity.getMATKL(), mclsEntity.getWGBEZ()))) {
            goods.setField5Name(list.get(0));
        }
    }

    private List<CdpGoods> getCdpGoods() {
        int rows = 2000;
        long total = 0L;
        int index = 0;
        ArrayList<CdpGoods> arr = new ArrayList<CdpGoods>();
        int page = index * rows;
        while ((long)page <= total) {
            this.logger.info("\u6253\u5370page\uff1a" + page + " total:" + total);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("page", page);
            map.put("rows", rows);
            List<CdpGoods> list = this.cdpGoodsMapper.query(map);
            if (null == list) break;
            if (page == 0) {
                total = this.cdpGoodsMapper.count(map);
            }
            page = (index + 1) * rows;
            ++index;
            arr.addAll(list);
        }
        return arr;
    }

    public void initSap(JsonEntity jsonEntity) throws SQLException, ParseException {
        this.logger.info("\u521d\u59cb\u5316\u7684\u6570\u636e\u4e3ajsonEntity \uff1a{}", (Object)JsonUtil.buildNonEmptyBinder().toJson((Object)jsonEntity));
    }

    private boolean addGoods(PosOrder pos, OcContract oc) {
        if (Objects.isNull(oc)) {
            return false;
        }
        List<PosGoods> posGoods = null;
        try {
            posGoods = PosConnetUtils.initGoods(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        BigDecimal goodsMoney = new BigDecimal("0");
        BigDecimal goodsInMoney = new BigDecimal("0");
        if (!CollectionUtils.isEmpty(posGoods)) {
            ArrayList<OcContractGoods> list = new ArrayList<OcContractGoods>();
            for (PosGoods goods : posGoods) {
                String goodsSkc = goods.getGoodsSkc();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("skc", goodsSkc);
                hashMap.put("page", 0);
                hashMap.put("rows", 1);
                List<CdpGoods> query = this.cdpGoodsMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) {
                    this.logger.info("\u5546\u54c1\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNonDefaultBinder().toJson(query));
                }
                CdpGoods cdpGoods = query.get(0);
                OcContractGoods ocContractGoods = new OcContractGoods();
                ocContractGoods.setContractBillcode(pos.getContractBillcode());
                ocContractGoods.setSkuCode(goods.getGoodsSkc());
                ocContractGoods.setSpuCode(goods.getGoodsSku());
                ocContractGoods.setSkuName(cdpGoods.getArticleName());
                ocContractGoods.setGoodsName(cdpGoods.getArticleName());
                ocContractGoods.setMemberBcode(oc.getMemberBcode());
                ocContractGoods.setMemberBname(oc.getMemberBname());
                ocContractGoods.setMemberMcode(oc.getMemberMcode());
                ocContractGoods.setMemberMname(oc.getMemberMname());
                ocContractGoods.setMemberCode(oc.getMemberCode());
                ocContractGoods.setMemberName(oc.getMemberName());
                ocContractGoods.setMemberCcode(oc.getMemberCcode());
                ocContractGoods.setMemberCname(oc.getMemberCname());
                ocContractGoods.setGoodsShowno(goods.getGoodsSkc());
                ocContractGoods.setGoodsNo(cdpGoods.getSpu());
                ocContractGoods.setSkuNo(cdpGoods.getSkc());
                ocContractGoods.setGoodsCode(cdpGoods.getSpu());
                ocContractGoods.setSkuShowno(cdpGoods.getSkc());
                ocContractGoods.setSkuNo(cdpGoods.getSkc());
                ocContractGoods.setTenantCode("2022012800000001");
                ocContractGoods.setContractGoodsType(0);
                ocContractGoods.setContractGoodsGtype("0");
                ocContractGoods.setChannelCode(oc.getChannelCode());
                ocContractGoods.setChannelName(oc.getChannelName());
                ocContractGoods.setGoodsCamount(this.getBigDecimal(goods.getGoodsNum()));
                ocContractGoods.setGoodsClass("pos");
                ocContractGoods.setGoodsPro("0");
                ocContractGoods.setGoodsType(goods.getGoodType());
                ocContractGoods.setContractGoodsPrice(this.getBigDecimal(goods.getContractNPrice()));
                goodsMoney = goodsMoney.add(this.getBigDecimal(goods.getContractNPrice()));
                goodsInMoney = goodsInMoney.add(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setContractGoodsPrice(this.getBigDecimal(goods.getContractNPrice()));
                ocContractGoods.setContractGoodsMoney(this.getBigDecimal(goods.getContractNPrice()));
                ocContractGoods.setContractGoodsInmoney(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setContractGoodsPefinmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefmoney(this.getBigDecimal("0"));
                ocContractGoods.setContractGoodsPefprice(this.getBigDecimal("0"));
                ocContractGoods.setPricesetNprice(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setPricesetMakeprice(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setPricesetBaseprice(this.getBigDecimal(goods.getContractPrice()));
                ocContractGoods.setPricesetAsprice(this.getBigDecimal(goods.getContractNPrice()));
                ocContractGoods.setContractGoodsSendnum(this.getBigDecimal(goods.getGoodsNum()));
                ocContractGoods.setDataPic(cdpGoods.getImgPath());
                ocContractGoods.setGmtCreate(oc.getGmtCreate());
                ocContractGoods.setGmtModified(oc.getGmtModified());
                ocContractGoods.setDataOpbillstate(0);
                ocContractGoods.setDataState(0);
                ocContractGoods.setRefundFlag(0);
                ocContractGoods.setTenantCode(oc.getTenantCode());
                ocContractGoods.setContractGoodsCode(System.currentTimeMillis() + "");
                ocContractGoods.setPackageCode(System.currentTimeMillis() + "");
                ocContractGoods.setGoodsClass(oc.getGoodsClass());
                if (!ocContractGoods.getGoodsType().equals("16")) {
                    ocContractGoods.setGoodsNum(this.getBigDecimal(goods.getGoodsNum()));
                    oc.setGoodsNum(oc.getGoodsNum().add(this.getBigDecimal(goods.getGoodsNum())));
                } else {
                    oc.setGoodsNum(oc.getGoodsNum().add(this.getBigDecimal(1)));
                    ocContractGoods.setGoodsNum(this.getBigDecimal(1));
                }
                if (ocContractGoods.getContractGoodsPrice().compareTo(this.getBigDecimal("0")) == 0) {
                    ocContractGoods.setContractGoodsRefnum(this.getBigDecimal(goods.getGoodsNum()));
                    ocContractGoods.setRefundFlag(1);
                }
                this.logger.info("\u4fdd\u5b58\u5546\u54c1\u6570\u636e\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
                list.add(ocContractGoods);
            }
            oc.setGoodsList(list);
            oc.setContractGoodsList(list);
            oc.setContractMoney(goodsMoney);
            oc.setGoodsMoney(goodsMoney);
            oc.setDataBmoney(goodsMoney);
            oc.setPackageList(Arrays.asList(this.savePackage(oc, goodsMoney, goodsInMoney)));
            return this.saveOcContract(oc);
        }
        return false;
    }

    private void addGoodsPayDetail(PosOrder pos) {
        List<PosGoodsPayDetails> list = null;
        try {
            list = PosConnetUtils.initGoodsPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getGoodsPayDetails(list);
        for (OcContractPayDetail posGoodsPayDetails : arr) {
            posGoodsPayDetails.setContractBillcode(pos.getContractBillcode());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u5546\u54c1\u652f\u4ed8\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayGoodsDetailMapper.insertBatch(arr);
    }

    private List<OcContractPayDetail> getGoodsPayDetails(List<PosGoodsPayDetails> list) {
        ArrayList<OcContractPayDetail> arr = new ArrayList<OcContractPayDetail>();
        for (PosGoodsPayDetails contractPayDetails : list) {
            OcContractPayDetail oc = new OcContractPayDetail();
            try {
                BeanUtils.copyAllPropertys((Object)oc, (Object)contractPayDetails);
                arr.add(oc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    private void addOcRefundDetail(PosOrder pos) {
        List<PosContractPayDetails> list = null;
        try {
            list = PosConnetUtils.initContractPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getOcContractPayDetails(list);
        for (OcContractPayDetail posContractPayDetails : arr) {
            posContractPayDetails.setRefundCode(pos.getRefundCode());
            posContractPayDetails.setPayMoney(posContractPayDetails.getPayMoney());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u8ba2\u5355\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayDetailMapper.insertBatch(arr);
    }

    private void addOcContractDetail(PosOrder pos) {
        List<PosContractPayDetails> list = null;
        try {
            list = PosConnetUtils.initContractPayDetail(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (CollectionUtils.isEmpty(list)) {
            this.logger.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return;
        }
        List<OcContractPayDetail> arr = this.getOcContractPayDetails(list);
        for (OcContractPayDetail ocContractPayDetail : arr) {
            ocContractPayDetail.setContractBillcode(pos.getContractBillcode());
            ocContractPayDetail.setRefundCode(pos.getRefundCode());
        }
        if (CollectionUtils.isEmpty(arr)) {
            this.logger.info("\u8ba2\u5355\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson(arr));
            return;
        }
        this.ocContractPayDetailMapper.insertBatch(arr);
    }

    private List<OcContractPayDetail> getOcContractPayDetails(List<PosContractPayDetails> list) {
        ArrayList<OcContractPayDetail> arr = new ArrayList<OcContractPayDetail>();
        for (PosContractPayDetails contractPayDetails : list) {
            OcContractPayDetail oc = new OcContractPayDetail();
            try {
                BeanUtils.copyAllPropertys((Object)oc, (Object)contractPayDetails);
                arr.add(oc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return arr;
    }

    private boolean saveOcContract(OcContract oc) {
        oc.setGoodsPmoney(oc.getContractInmoney().subtract(oc.getDataBmoney()));
        String s = this.insertContract(oc);
        return !StringUtils.isBlank((String)s);
    }

    public void sendSaveResourceGoods(OcContractGoods ocContractGoodsDomain) {
        this.ocContractGoodsMapper.insert(ocContractGoodsDomain);
    }

    private void addGuide(PosOrder pos) {
        List<PosGuide> list = null;
        try {
            list = PosConnetUtils.initGuide(pos.getOrderId());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        if (!CollectionUtils.isEmpty(list)) {
            ArrayList<UmUserinfoChannel> arr = new ArrayList<UmUserinfoChannel>();
            for (PosGuide str : list) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("userinfoChannelVaule", str.getGuideCode());
                hashMap.put("qualityCode", "dis");
                List<UmUserinfoChannel> query = this.umUserinfoChannelMapper.query(hashMap);
                if (CollectionUtils.isEmpty(query)) continue;
                UmUserinfoChannel umUserinfoChannel = query.get(0);
                umUserinfoChannel.setUserinfoChannelVaule2(str.getDiscount());
                arr.add(umUserinfoChannel);
            }
            this.logger.info("\u6dfb\u52a0\u5bfc\u8d2d");
            if (!CollectionUtils.isEmpty(arr)) {
                for (UmUserinfoChannel umUserinfoChannel : arr) {
                    this.ocContractGuideMapper.insertContractGuide(umUserinfoChannel, pos.getContractBillcode());
                }
            }
        }
    }

    private boolean addOcContract(PosOrder pos) throws ParseException {
        OcContract oc = new OcContract();
        oc.setContractBillcode(pos.getContractBillcode());
        oc.setContractBbillcode(pos.getContractBillcode());
        oc.setGoodsNum(this.getBigDecimal(pos.getGoodsNum()));
        oc.setGoodsClass(pos.getGoodsClass());
        oc.setTenantCode("2022012800000001");
        oc.setGoodsPbillno("0");
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        orgMap.put("departOcode", pos.getStoreCode());
        List<OrgDepart> orgDepartList = this.orgDepartMapper.query(orgMap);
        if (CollectionUtils.isEmpty(orgDepartList)) {
            this.logger.info("\u95e8\u5e97\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return false;
        }
        OrgDepart orgDepart = orgDepartList.get(0);
        if (StringUtils.isNotBlank((String)pos.getUserinfoOcode())) {
            HashMap<String, Object> umInfoMap = new HashMap<String, Object>();
            umInfoMap.put("userinfoOcode", pos.getUserinfoOcode());
            umInfoMap.put("userinfoQuality", "buy");
            List<UmUserinfoModel> query = this.umUserinfoMapper.query(umInfoMap);
            if (!CollectionUtils.isEmpty(query)) {
                UmUserinfoModel umUserinfoModel = query.get(0);
                oc.setMemberBcode(umUserinfoModel.getUserinfoCode());
                oc.setMemberBname(umUserinfoModel.getUserinfoCompname());
                HashMap<String, Object> infochannelMap = new HashMap<String, Object>();
                infochannelMap.put("userinfoCode", umUserinfoModel.getUserinfoCode());
                infochannelMap.put("channelCode", orgDepart.getCompanyCode());
                List<UmUserinfoChannel> umUserinfoChannelList = this.umUserinfoChannelMapper.query(infochannelMap);
                if (CollectionUtils.isEmpty(umUserinfoChannelList)) {
                    this.createBrandUser(umUserinfoModel, orgDepart);
                }
            }
        }
        HashMap<String, Object> storeMap = new HashMap<String, Object>();
        storeMap.put("departCode", orgDepart.getDepartCode());
        storeMap.put("userinfoQuality", "depart");
        List<UmUserinfoModel> storeList = this.umUserinfoMapper.query(storeMap);
        if (CollectionUtils.isEmpty(storeList)) {
            this.logger.info("\u95e8\u5e97\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return false;
        }
        UmUserinfoModel store = storeList.get(0);
        oc.setMemberCode(store.getUserinfoCode());
        oc.setMemberName(store.getUserinfoCompname());
        oc.setMschannelCode(store.getUserinfoCode());
        oc.setMschannelName(store.getUserinfoCompname());
        oc.setChannelCode(store.getUserinfoCode());
        oc.setChannelName(store.getUserinfoCompname());
        String companyCode = orgDepart.getCompanyCode();
        HashMap<String, Object> disMap = new HashMap<String, Object>();
        disMap.put("channelCode", companyCode);
        disMap.put("channelPcode", "-1");
        List<DisChannel> disChannelList = this.disChannelMapper.query(disMap);
        if (CollectionUtils.isEmpty(disChannelList)) {
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a{}", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)pos));
            return false;
        }
        DisChannel disChannel = disChannelList.get(0);
        oc.setMemberCcode(disChannel.getMemberCode());
        oc.setMemberMcode(disChannel.getMemberCode());
        oc.setMemberMname(disChannel.getMemberName());
        oc.setMemberCname(disChannel.getMemberName());
        oc.setTenantCode(disChannel.getTenantCode());
        oc.setContractType("00");
        oc.setContractTypepro(pos.getContractType());
        oc.setContractBlance("0");
        oc.setContractPmode("1");
        oc.setContractPumode("0");
        oc.setContractPumode("0");
        oc.setGoodsWeight(this.getBigDecimal("0"));
        oc.setPricesetRefrice(this.getBigDecimal(0));
        oc.setDataBnum(this.getBigDecimal(pos.getGoodsNum()));
        oc.setGoodsNum(this.getBigDecimal(pos.getGoodsNum()));
        oc.setDataBweight(this.getBigDecimal(0));
        oc.setContractPaymoney(this.getBigDecimal(pos.getGoodsMoney()));
        oc.setContractInmoney(this.getBigDecimal(pos.getGoodsMoney()));
        oc.setContractMoney(this.getBigDecimal(pos.getDataBmoney()));
        oc.setGoodsMoney(this.getBigDecimal(pos.getDataBmoney()));
        oc.setDataBmoney(this.getBigDecimal(pos.getDataBmoney()));
        oc.setContractShow(0);
        oc.setContractEcflag(0);
        oc.setContractInvstate(0);
        oc.setGoodsLogmoney(this.getBigDecimal(0));
        oc.setGmtCreate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setGmtModified(DateUtils.parseDate((String)pos.getGmtModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setContractPaydate(DateUtils.parseDate((String)pos.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
        oc.setDataState(5);
        oc.setRefundFlag(0);
        return this.addGoods(pos, oc);
    }

    public GoodsCategoryVO queryGoodCategory(Map map) {
        List<GoodsCategoryVO> goodsCategoryVOList = this.cdpGoodsMapper.queryGoodCategories(map);
        if (goodsCategoryVOList != null && goodsCategoryVOList.size() > 0) {
            return goodsCategoryVOList.get(0);
        }
        return null;
    }

    @Override
    public String queryImage(Map<String, Object> map) {
        String goodsImage = this.cdpGoodsMapper.queryGoodsImage(map);
        if (goodsImage != null && StringUtils.isNotBlank((String)goodsImage)) {
            return goodsImage;
        }
        return "";
    }

    @Override
    public void saveImage(Map<String, Object> map) {
        this.cdpGoodsMapper.saveGoodsImage(map);
    }

    private BigDecimal getBigDecimal(String money) {
        if (StringUtils.isNotBlank((String)money)) {
            return new BigDecimal(money).abs();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getBigDecimal(Integer money) {
        if (money != null) {
            return new BigDecimal(money).abs();
        }
        return BigDecimal.ZERO;
    }
}

