/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oms.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.oms.domain.EditSkuDomain;
import com.yqbsoft.laser.service.oms.domain.OcContractReDomain;
import com.yqbsoft.laser.service.oms.domain.OcRefundDomain;
import com.yqbsoft.laser.service.oms.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.oms.domain.RsResourceGoodsReDomain;
import com.yqbsoft.laser.service.oms.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.oms.service.OrderService;
import com.yqbsoft.laser.service.oms.utils.JbsUtils;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private static final String tenantCode = "2022012800000001";

    @Override
    public SupQueryResult<RsResourceGoodsReDomain> downloadMarketableGoods(String shopCode, String spuCode, String dwStartDate, String dwEndDate, Integer pageIndex, Integer pageSize) {
        this.logger.info("shopCode:" + shopCode + "spuCode:" + spuCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (shopCode == null && spuCode == null) {
            throw new ApiException("\u5e97\u94fa\u7f16\u7801\u548c\u5546\u54c1\u6b3e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (shopCode != null) {
            map.put("memberCode", shopCode);
        }
        if (shopCode == null && spuCode != null) {
            map.put("goodsNo", spuCode);
        }
        if (dwStartDate != null && dwEndDate != null) {
            map.put("startDate", dwStartDate);
            map.put("endDate", dwEndDate);
        }
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        HashMap<String, String> pMap = new HashMap<String, String>();
        map.put("tenantCode", tenantCode);
        map.put("dataOpbillstate", "1");
        map.put("fuzzy", true);
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult rs = this.getQueryResutl("rs.resourceGoods.queryResourceGoodsPage", pMap, RsResourceGoodsReDomain.class);
        if (rs == null) {
            throw new ApiException("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        rs.getList().forEach(rsResourceGoodsReDomain -> {
            HashMap<String, String> sMap = new HashMap<String, String>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
            hashMap.put("goodsShowno", rsResourceGoodsReDomain.getGoodsNo());
            hashMap.put("tenantCode", tenantCode);
            hashMap.put("fuzzy", true);
            sMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(hashMap));
            QueryResult sku = this.getQueryResutl("rs.sku.querySkuPage", sMap, RsSkuReDomain.class);
            List list = sku.getList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                rsResourceGoodsReDomain.setRsSkuReDomain(list);
            }
        });
        return rs;
    }

    @Override
    public String sendSgSendgoods(String skuCode, Integer goodsNum) {
        if (skuCode == null || goodsNum == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "skuCode:" + skuCode + "goodsNum" + goodsNum);
        }
        HashMap<String, String> skMap = new HashMap<String, String>();
        skMap.put("skuCode", skuCode);
        HashMap<String, String> sMap = new HashMap<String, String>();
        sMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(skMap));
        sMap.put("tenantCode", tenantCode);
        QueryResult sku = this.getQueryResutl("rs.sku.querySkuOnePage", sMap, RsSkuReDomain.class);
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        if (sku != null) {
            try {
                BeanUtils.copyAllPropertys((Object)editSkuDomain, sku.getList().get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.info("-------------------------------editSkuDomain:" + editSkuDomain.getGoodsNum());
        editSkuDomain.setGoodsNum(BigDecimal.valueOf(goodsNum.intValue()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson((Object)editSkuDomain));
        map.put("tenantCode", tenantCode);
        this.logger.info("-------------------------------editSkuDomain:" + editSkuDomain.getGoodsNum());
        this.getInternalRouter().inInvoke("rs.resource.sendUpdateSkuEdit", map);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public SupQueryResult<OcContractReDomain> downloadContracts(boolean childFlag, String brandChannelCode, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus) {
        this.logger.info("brandChannelCode:" + brandChannelCode + "dwStartTime:" + dwStartTime);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (brandChannelCode == null) {
            throw new ApiException("\u54c1\u724c\u6e20\u9053\u4e3a\u7a7a");
        }
        map.put("memberName", brandChannelCode);
        if (dwStartTime != null && dwEndTime != null) {
            map.put("dwStartTime", dwStartTime);
            map.put("dwEndTime", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        map.put("page", pageIndex);
        map.put("rows", pageSize);
        map.put("childFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        return this.getQueryResutl("oc.contract.queryContractPageReDomain", pMap, OcContractReDomain.class);
    }

    @Override
    public SupQueryResult<OcRefundReDomain> downloadRefundContracts(String refundType, String dwStartTime, String dwEndTime, Integer pageIndex, Integer pageSize, Integer orderStatus, boolean childFlag) {
        this.logger.info("refundType:" + refundType + "dwStartTime:" + dwStartTime);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (refundType == null) {
            throw new ApiException("\u552e\u540e\u7533\u8bf7\u7c7b\u578b\u4e3a\u7a7a");
        }
        map.put("refundType", refundType);
        if (dwStartTime != null && dwEndTime != null) {
            map.put("startDate", dwStartTime);
            map.put("endDate", dwEndTime);
        }
        if (orderStatus != null) {
            map.put("dataState", orderStatus);
        }
        map.put("page", pageIndex == null ? 1 : pageIndex);
        map.put("rows", pageSize == null ? 10 : pageSize);
        map.put("childFlag", childFlag);
        map.put("tenantCode", tenantCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        return this.getQueryResutl("oc.refund.queryRefundReDomainPage", pMap, OcRefundReDomain.class);
    }

    @Override
    public String syncRefundContractsStatus(String refundCode, String contractBillcode) {
        this.logger.info("refundCode:" + refundCode + "contractBillcode:" + contractBillcode);
        HashMap<String, String> map = new HashMap<String, String>();
        if (refundCode == null || contractBillcode == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "refundCode:" + refundCode + "-contractBillcode:" + contractBillcode);
        }
        map.put("refundCode", refundCode);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        QueryResult ocRefundReDomain = this.getQueryResutl("oc.refund.queryRefundPage", pMap, OcRefundDomain.class);
        if (ocRefundReDomain == null) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (ocRefundReDomain.getList().size() < 0) {
            throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        OcRefundDomain refundReDomain = (OcRefundDomain)ocRefundReDomain.getList().get(0);
        refundReDomain.setContractBbillcode(contractBillcode);
        HashMap<String, String> oMap = new HashMap<String, String>();
        oMap.put("ocRefundDomain", JsonUtil.buildNonEmptyBinder().toJson((Object)refundReDomain));
        this.getInternalRouter().inInvoke("oc.refund.updateRefund", oMap);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String syncShippedPackageExpressInfo(String contractBillcode, String packageBillno, String expressCode, String expressName) {
        this.logger.info("contractBillcode:" + contractBillcode);
        HashMap<String, String> map = new HashMap<String, String>();
        if (contractBillcode == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "-contractBillcode:" + contractBillcode);
        }
        map.put("expressCode", expressCode);
        map.put("expressName", expressName);
        map.put("packageBillno", packageBillno);
        HashMap<String, String> pMap = new HashMap<String, String>();
        pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
        pMap.put("contractBillcode", contractBillcode);
        pMap.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("oc.contractEngine.sendContractNext", pMap);
        return JbsUtils.getSuccessMap("");
    }

    @Override
    public String backRefundContractsStatus(String contractBillcode, String refundCode, boolean status) {
        this.logger.info("refundCode:" + refundCode + "contractBillcode:" + contractBillcode);
        if (refundCode == null || contractBillcode == null) {
            return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "refundCode:" + refundCode + "-contractBillcode:" + contractBillcode);
        }
        if (status) {
            OcRefundDomain ocRefundDomain = new OcRefundDomain();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("contractBillcode", contractBillcode);
            HashMap<String, String> pMap = new HashMap<String, String>();
            pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
            QueryResult ocContractReDomain = this.getQueryResutl("oc.contract.getContractByCode", pMap, OcContractReDomain.class);
            if (ocContractReDomain == null) {
                throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (ocContractReDomain.getList().size() < 0) {
                throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundDomain, ocContractReDomain.getList().get(0));
                ocRefundDomain.setRefundUsertype("0");
                ocRefundDomain.setRefundCode(refundCode);
                ocRefundDomain.setGoodsReceiptMem("");
                ocRefundDomain.setGoodsReceiptPhone("");
                ocRefundDomain.setGoodsReceiptArrdess("");
                ocRefundDomain.setDataStatestr("61");
                ocRefundDomain.setRefundType("B01");
                if (ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
                    ocRefundDomain.setMemberCcode(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCcode());
                    ocRefundDomain.setMemberCname(ocRefundDomain.getOcRefundGoodsDomainList().get(0).getMemberCname());
                }
                HashMap<String, String> ocMap = new HashMap<String, String>();
                ocMap.put("ocRefundDomain", JsonUtil.buildNonEmptyBinder().toJson((Object)ocRefundDomain));
                this.getInternalRouter().inInvoke("oc.refundEngine.sendSaveRefund", ocMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.logger.info("refundCode:" + refundCode + "contractBillcode:" + contractBillcode);
            HashMap<String, String> map = new HashMap<String, String>();
            if (refundCode == null || contractBillcode == null) {
                return JbsUtils.getErrorMap("\u53c2\u6570\u4f20\u8f93\u4e3a\u7a7a", "refundCode:" + refundCode + "-contractBillcode:" + contractBillcode);
            }
            map.put("refundCode", refundCode);
            HashMap<String, String> pMap = new HashMap<String, String>();
            pMap.put("map", JsonUtil.buildNonEmptyBinder().toJson(map));
            QueryResult ocRefundReDomain = this.getQueryResutl("oc.refund.queryRefundPage", pMap, OcRefundReDomain.class);
            if (ocRefundReDomain == null) {
                throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (ocRefundReDomain.getList().size() < 0) {
                throw new ApiException("\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            OcRefundReDomain refundReDomain = (OcRefundReDomain)ocRefundReDomain.getList().get(0);
            refundReDomain.setDataState(6);
            HashMap<String, String> oMap = new HashMap<String, String>();
            oMap.put("ocRefundDomain", JsonUtil.buildNonEmptyBinder().toJson((Object)refundReDomain));
            this.getInternalRouter().inInvoke("oc.refund.updateRefund", oMap);
        }
        return JbsUtils.getSuccessMap("");
    }
}

