/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.at.queue;

import com.yqbsoft.laser.service.at.domain.AtAuctionWinDomain;
import com.yqbsoft.laser.service.at.service.AtAuctionWinService;
import com.yqbsoft.laser.service.at.thread.ThreadFactoryImpl;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class WinCleaningQueue
implements Runnable {
    private final AtAuctionWinService atAuctionWinService;
    private final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private final BlockingQueue<AtAuctionWinDomain> cleaningQueue;
    private final ExecutorService exService;

    public WinCleaningQueue(AtAuctionWinService atAuctionWinService) {
        int poolSize = 1;
        this.atAuctionWinService = atAuctionWinService;
        this.cleaningQueue = new LinkedBlockingDeque<AtAuctionWinDomain>();
        this.exService = Executors.newFixedThreadPool(poolSize, new ThreadFactoryImpl("AUCTION_CLEANING_WORKER_", true));
    }

    public void start() throws Exception {
        new Thread(this).start();
    }

    public void addAuction(AtAuctionWinDomain atAuctionWin) {
        this.cleaningQueue.add(atAuctionWin);
    }

    public void removeAuction(AtAuctionWinDomain atAuctionWin) {
        this.cleaningQueue.remove(atAuctionWin);
    }

    public int getQueueSize() {
        return this.cleaningQueue.size();
    }

    @Override
    public void run() {
        this.exService.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            WinCleaningQueue.this.logger.error("===========\u4fdd\u5b58\u8bb0\u5f55\u961f\u5217\uff1a ===================\u53d6\u51fa\u524d===============", (Object)("\u961f\u5217\u957f\u5ea6\u3010" + WinCleaningQueue.this.cleaningQueue.size() + "\u3011"));
                            AtAuctionWinDomain atAuctionWin = (AtAuctionWinDomain)WinCleaningQueue.this.cleaningQueue.take();
                            if (null == atAuctionWin) {
                                Thread.sleep(100L);
                                continue;
                            }
                            WinCleaningQueue.this.atAuctionWinService.saveatAuctionWin(atAuctionWin);
                            WinCleaningQueue.this.logger.error("===========\u4fdd\u5b58\u8bb0\u5f55\u961f\u5217\uff1a ===================\u53d6\u51fa\u540e===============", (Object)("\u961f\u5217\u957f\u5ea6\u3010" + WinCleaningQueue.this.cleaningQueue.size() + "\u3011"));
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

