/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.at.service.impl;

import com.yqbsoft.laser.service.at.dao.AtAuctionEnrollMapper;
import com.yqbsoft.laser.service.at.dao.AtAuctionMapper;
import com.yqbsoft.laser.service.at.domain.AtAuctionDomain;
import com.yqbsoft.laser.service.at.domain.AtAuctionGinfoDomain;
import com.yqbsoft.laser.service.at.domain.AtAuctionPriceDomain;
import com.yqbsoft.laser.service.at.domain.AtChannelsendDomain;
import com.yqbsoft.laser.service.at.domain.AtChannelsendlistDomain;
import com.yqbsoft.laser.service.at.es.EsSendEnginePutThread;
import com.yqbsoft.laser.service.at.es.SendPutThread;
import com.yqbsoft.laser.service.at.model.AtAuction;
import com.yqbsoft.laser.service.at.model.AtAuctionGinfo;
import com.yqbsoft.laser.service.at.model.AtAuctionGoods;
import com.yqbsoft.laser.service.at.model.AtChannelsend;
import com.yqbsoft.laser.service.at.model.AtChannelsendlist;
import com.yqbsoft.laser.service.at.model.TmProappEnv;
import com.yqbsoft.laser.service.at.service.AtAuctionBaseService;
import com.yqbsoft.laser.service.at.service.AtAuctionPriceService;
import com.yqbsoft.laser.service.at.service.AtAuctionService;
import com.yqbsoft.laser.service.at.service.AtChannelsendService;
import com.yqbsoft.laser.service.at.service.AtChannelsendlistService;
import com.yqbsoft.laser.service.at.service.impl.AtChannelsendServiceImpl;
import com.yqbsoft.laser.service.at.service.impl.AtChannelsendlistServiceImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.BigDecmalUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class AtAuctionBaseServiceImpl
extends BaseServiceImpl
implements AtAuctionBaseService {
    private static final String SYS_CODE = SYS_CODE + ".AtAuctionBaseServiceImpl";
    @Autowired
    private AtAuctionService atAuctionService;
    private AtChannelsendService atChannelsendService;
    private AtChannelsendlistService atChannelsendlistService;
    private AtAuctionPriceService atAuctionPriceService;
    private AtAuctionMapper atAuctionMapper;
    private AtAuctionEnrollMapper atAuctionEnrollMapper;

    public void setAtAuctionPriceService(AtAuctionPriceService atAuctionPriceService) {
        this.atAuctionPriceService = atAuctionPriceService;
    }

    public void setAtAuctionService(AtAuctionService atAuctionService) {
        this.atAuctionService = atAuctionService;
    }

    public void setAtChannelsendService(AtChannelsendService atChannelsendService) {
        this.atChannelsendService = atChannelsendService;
    }

    public void setAtChannelsendlistService(AtChannelsendlistService atChannelsendlistService) {
        this.atChannelsendlistService = atChannelsendlistService;
    }

    public void setAtAuctionMapper(AtAuctionMapper atAuctionMapper) {
        this.atAuctionMapper = atAuctionMapper;
    }

    public void setAtAuctionEnrollMapper(AtAuctionEnrollMapper atAuctionEnrollMapper) {
        this.atAuctionEnrollMapper = atAuctionEnrollMapper;
    }

    @Override
    public String sendSaveatAuction(AtAuctionDomain atAuctionDomain) throws ApiException {
        List<AtChannelsend> atChannelsendList = this.atAuctionService.saveatAuction(atAuctionDomain);
        if (ListUtil.isNotEmpty(atChannelsendList)) {
            AtChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(AtChannelsendServiceImpl.getSendService(), atChannelsendList));
            return atChannelsendList.get(0).getChannelsendOpcode();
        }
        return null;
    }

    @Override
    public void sendSavechannelsendBatch(List<AtChannelsendDomain> atChannelsendDomainList) throws ApiException {
        List<AtChannelsend> atChannelsendList = this.atChannelsendService.saveChannelsendBatch(atChannelsendDomainList);
        if (ListUtil.isNotEmpty(atChannelsendList)) {
            AtChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(AtChannelsendServiceImpl.getSendService(), atChannelsendList));
        }
    }

    @Override
    public void sendSavechannelsendlistBatch(List<AtChannelsendlistDomain> atChannelsendlistDomainList) throws ApiException {
        this.atChannelsendlistService.saveChannelsendlistBatch(atChannelsendlistDomainList);
    }

    @Override
    public void sendSaveChannelsend(AtChannelsend atChannelsend) {
        List<AtChannelsendlist> atChannelsendlistList = this.atChannelsendService.saveSendChannelsend(atChannelsend);
        if (ListUtil.isNotEmpty(atChannelsendlistList)) {
            AtChannelsendlistServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(AtChannelsendlistServiceImpl.getEsSendEngineService(), atChannelsendlistList));
        }
    }

    @Override
    public void sendUpdateatAuction(AtAuctionDomain atAuctionDomain) throws ApiException {
        List<AtChannelsend> atChannelsendList = this.atAuctionService.updateatAuction(atAuctionDomain);
        if (ListUtil.isNotEmpty(atChannelsendList)) {
            AtChannelsendServiceImpl.getSendService().addPutPool(new SendPutThread(AtChannelsendServiceImpl.getSendService(), atChannelsendList));
        }
    }

    @Override
    public String saveatAuctionPrice(AtAuctionPriceDomain atAuctionPriceDomain) throws ApiException {
        BigDecimal bigDecimal;
        String atauctionGinfoCode;
        if (null == atAuctionPriceDomain) {
            this.logger.error("saveAuctionPrice.json:00");
            return "\u51fa\u4ef7\u4fe1\u606f\u4e3a\u7a7a";
        }
        String tenantCode = atAuctionPriceDomain.getTenantCode();
        AtAuctionGinfo atAuctionGinfo = this.atAuctionService.getatAuctionGinfoByCode(tenantCode, atauctionGinfoCode = atAuctionPriceDomain.getAuctionGinfoCode());
        if (atAuctionGinfo == null) {
            this.logger.error("saveAuctionPrice.json:01", (Object)(atAuctionPriceDomain.getTenantCode() + "=====" + atAuctionPriceDomain.getAuctionGinfoCode()));
            return "\u6b64\u5305\u88f9\u4e0d\u5b58\u5728";
        }
        Date date = this.atAuctionService.getSysDate();
        if (date.compareTo(atAuctionGinfo.getAuctionEdate()) != -1) {
            this.logger.error("saveAuctionPrice.json:02", (Object)("Now=" + date + ",Old=" + atAuctionGinfo.getAuctionEdate()));
            return "\u8be5\u5305\u88f9\u5df2\u7ed3\u675f\u7ade\u4ef7";
        }
        atAuctionPriceDomain.setAuctionPriceAmount(atAuctionPriceDomain.getAuctionPriceNow());
        this.atAuctionService.updateatAuctionGinglock(atAuctionGinfo.getAuctionGinfoId());
        AtAuctionGinfo atAuctionGinfoNew = this.atAuctionService.getatAuctionGinfoByCode(tenantCode, atauctionGinfoCode);
        AtAuction atAuction = this.atAuctionService.getatAuctionMoByCode(atAuctionGinfoNew.getTenantCode(), atAuctionGinfoNew.getAuctionCode());
        if (atAuction.getDataState() == 2) {
            this.logger.error("saveAuctionPrice.json:02", (Object)("\u573a\u6b21\u53f7\u4e3a" + atAuction.getAuctionId() + "\u7684\u573a\u6b21\u4ee5\u5f3a\u884c\u7ed3\u675f"));
            return "\u8be5\u573a\u6b21\u56e0\u67d0\u4e9b\u7279\u6b8a\u539f\u56e0\u5f3a\u5236\u7ed3\u675f\uff01\u8be6\u60c5\u8bf7\u54a8\u8be2\u5ba2\u670d\uff01";
        }
        Integer auctionruleDelayflag = atAuctionGinfoNew.getAuctionruleDelayflag();
        Boolean flag = false;
        if ("1".equals(atAuctionGinfoNew.getAuctionruleType())) {
            if (atAuctionGinfoNew.getAuctionGinfoPrice() != null && atAuctionGinfoNew.getAuctionGinfoPrice() != new BigDecimal(0)) {
                bigDecimal = atAuctionGinfoNew.getAuctionGinfoPrice().subtract(atAuctionGinfoNew.getPricesetNprice());
                if (atAuctionPriceDomain.getMemberBcode().equals(atAuctionGinfoNew.getAuctionGinfoMem())) {
                    // empty if block
                }
                if (atAuctionPriceDomain.getAuctionPriceNow().compareTo(bigDecimal) == 0) {
                    return "\u4e0d\u80fd\u4e0e\u6700\u9ad8\u4ef7\u51fa\u4ef7\u4e00\u6837";
                }
                if (atAuctionPriceDomain.getAuctionPriceNow().compareTo(bigDecimal) == -1) {
                    return "\u51fa\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u6700\u9ad8\u4ef7";
                }
            }
            flag = true;
        }
        if ("0".equals(atAuctionGinfoNew.getAuctionruleType())) {
            if (atAuctionGinfoNew.getAuctionGinfoPrice() != null && atAuctionGinfoNew.getAuctionGinfoPrice() != new BigDecimal(0)) {
                bigDecimal = atAuctionGinfoNew.getAuctionGinfoPrice().subtract(atAuctionGinfoNew.getPricesetNprice());
                if (atAuctionPriceDomain.getMemberBcode().equals(atAuctionGinfoNew.getAuctionGinfoMem())) {
                    // empty if block
                }
                if (atAuctionPriceDomain.getAuctionPriceNow().compareTo(bigDecimal) == 1) {
                    flag = true;
                }
            } else {
                flag = true;
            }
        }
        if ("3".equals(atAuctionGinfoNew.getAuctionruleType())) {
            if (atAuctionGinfoNew.getAuctionGinfoPrice() != null && atAuctionGinfoNew.getAuctionGinfoPrice() != new BigDecimal(0)) {
                bigDecimal = atAuctionGinfoNew.getPricesetNprice().add(atAuctionPriceDomain.getAuctionPriceAmount());
                if (new BigDecimal(0).compareTo(bigDecimal) == 0 || new BigDecimal(0).compareTo(bigDecimal) == 1) {
                    return "\u4f60\u8981\u5012\u8d34\u94b1\u4e86\uff01";
                }
                if (atAuctionPriceDomain.getMemberBcode().equals(atAuctionGinfoNew.getAuctionGinfoMem())) {
                    // empty if block
                }
                BigDecimal subtract = atAuctionGinfoNew.getPricesetNprice().subtract(atAuctionGinfoNew.getAuctionGinfoPrice());
                if (atAuctionPriceDomain.getAuctionPriceNow().compareTo(subtract) == 0) {
                    return "\u4e0d\u80fd\u4e0e\u6700\u9ad8\u4ef7\u51fa\u4ef7\u4e00\u6837";
                }
                BigDecimal auctionginfoPrice = atAuctionGinfoNew.getAuctionGinfoPrice();
                if (bigDecimal.compareTo(auctionginfoPrice) == -1) {
                    flag = true;
                }
            } else {
                flag = true;
            }
        }
        if (auctionruleDelayflag == 1) {
            int auctionruleDelay = atAuctionGinfoNew.getAuctionruleDelay();
            int auctionruleDelaysum = atAuctionGinfoNew.getAuctionruleDelaysum();
            Date auctionEdate = atAuction.getAuctionEdate();
            Date auctionDelayedDate = new Date(auctionEdate.getTime() - (long)(auctionruleDelay * 60 * 1000));
            Date auctionDelayEndDate = new Date(auctionEdate.getTime() + (long)((auctionruleDelaysum - auctionruleDelay) * 60 * 1000));
            Date auctionEndDate = new Date(auctionEdate.getTime() + (long)(auctionruleDelaysum * 60 * 1000));
            if (date.compareTo(auctionDelayedDate) == 1) {
                atAuctionGinfoNew.setAuctionEdate(new Date(date.getTime() + (long)(auctionruleDelay * 60 * 1000)));
            }
            if (date.compareTo(auctionDelayEndDate) == 1) {
                atAuctionGinfoNew.setAuctionEdate(auctionEndDate);
            }
        }
        if (flag.booleanValue()) {
            BigDecimal maxSum = atAuctionPriceDomain.getAuctionPriceNow().add(atAuctionGinfoNew.getPricesetNprice());
            this.recalculation(atAuctionGinfoNew, atAuctionPriceDomain.getAuctionPriceNow());
            HashMap<String, Object> maps = new HashMap<String, Object>();
            maps.put("auctionGinfoMem", atAuctionPriceDomain.getMemberBcode());
            maps.put("auctionGinfoMemname", atAuctionPriceDomain.getMemberBname());
            maps.put("auctionGinfoPrice", maxSum);
            maps.put("auctionEdate", atAuctionGinfoNew.getAuctionEdate());
            maps.put("auctionGinfoMoney", atAuctionGinfoNew.getAuctionGinfoMoney());
            maps.put("auctionGinfoId", atAuctionGinfoNew.getAuctionGinfoId());
            this.logger.error(".saveatAuctionPrice:03", (Object)JsonUtil.buildNormalBinder().toJson((Object)atAuctionGinfoNew));
            this.logger.error(".saveatAuctionPrice:04", (Object)JsonUtil.buildNormalBinder().toJson(maps));
            this.atAuctionService.updateatAuctionBean(maps);
            HashMap<String, Object> parMap = new HashMap<String, Object>();
            parMap.put("auctionCode", atAuctionPriceDomain.getAuctionCode());
            parMap.put("tenantCode", tenantCode);
            parMap.put("auctionEdate", atAuctionGinfoNew.getAuctionEdate());
            this.logger.error(SYS_CODE + ".saveatAuctionPrice-\u66f4\u65b0\u573a\u6b21\u3001\u62a5\u540d\u7ade\u4ef7\u65f6\u95f4", parMap);
            this.atAuctionEnrollMapper.updateAuctionEnrollDate(parMap);
            this.atAuctionMapper.updateAuctionDate(parMap);
        }
        atAuctionPriceDomain.setAuctionPriceOld(atAuctionPriceDomain.getAuctionPriceNow().add(atAuctionGinfoNew.getPricesetNprice()));
        this.atAuctionPriceService.saveatAuctionPrice(atAuctionPriceDomain);
        return "success";
    }

    private String getEnv(String tenantCode, String proappCode) {
        String cacheKey = "TmProappEnv-tenant-ProappCode";
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)cacheKey, (String)(tenantCode + "-" + proappCode), TmProappEnv.class);
        if (null == tmProappEnv) {
            return null;
        }
        return tmProappEnv.getProappEnvOpenconf();
    }

    public void recalculation(AtAuctionGinfo atAuctionGinfo, BigDecimal money) {
        if (null == atAuctionGinfo || money == null || money.compareTo(new BigDecimal(0)) == -1) {
            this.logger.error(".recalculation:00", (Object)"\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        String auctionGinfoCode = atAuctionGinfo.getAuctionGinfoCode();
        String tenantCode = atAuctionGinfo.getTenantCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionGinfoCode", auctionGinfoCode);
        map.put("tenantCode", tenantCode);
        List atAuctionGoodsList = this.atAuctionService.queryatAuctionGoodsPage(map).getList();
        if (ListUtil.isEmpty((Collection)atAuctionGoodsList)) {
            this.logger.error(".recalculation:01", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728=" + map));
            return;
        }
        BigDecimal goodsprice = BigDecimal.ZERO;
        BigDecimal format = BigDecimal.ZERO;
        for (AtAuctionGoods atAuctionGoods : atAuctionGoodsList) {
            if (null == atAuctionGoods.getGoodsSupplyweight()) {
                atAuctionGoods.setGoodsSupplyweight(BigDecimal.ZERO);
            }
            goodsprice = atAuctionGoods.getGoodsSupplyweight().multiply(money.add(atAuctionGoods.getPricesetNprice()));
            this.logger.error("======1=======", (Object)(goodsprice + "=" + atAuctionGoods.getGoodsSupplyweight() + "*" + money));
            format = format.add(BigDecmalUtil.format((BigDecimal)goodsprice, (String)this.getEnv(tenantCode, atAuctionGinfo.getAppmanageIcode())));
        }
        atAuctionGinfo.setAuctionGinfoMoney(format);
        atAuctionGinfo.setPricesetPrefprice(format);
    }

    public static void main(String[] args) {
        BigDecimal a = new BigDecimal(3500);
        BigDecimal b = new BigDecimal(4000);
        System.out.println(a.compareTo(b));
    }

    private void updateAtAuctionGinfoModel(AtAuctionGinfo atAuctionGinfo) {
        this.atAuctionService.updateatAuctionGinfo(this.makeAtAuctionGinfoDomain(atAuctionGinfo));
    }

    private AtAuctionGinfoDomain makeAtAuctionGinfoDomain(AtAuctionGinfo atAuctionGinfo) {
        if (null == atAuctionGinfo) {
            return null;
        }
        AtAuctionGinfoDomain atAuctionGinfoDomain = new AtAuctionGinfoDomain();
        try {
            BeanUtils.copyAllPropertys((Object)atAuctionGinfoDomain, (Object)atAuctionGinfo);
            return atAuctionGinfoDomain;
        }
        catch (Exception e) {
            this.logger.error(".makeAtAuctionGinfoReDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public void sendMake(AtAuction atAuction) {
        if (null == atAuction) {
            return;
        }
        this.atAuctionService.saveStartOrEnd(atAuction);
    }

    @Override
    public void sendSignMake(AtAuction atAuction) {
        if (null == atAuction) {
            return;
        }
        this.atAuctionService.saveSignStartOrEnd(atAuction);
    }
}

