/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.at.service.impl;

import com.yqbsoft.laser.service.at.dao.AtAuctionPriceMapper;
import com.yqbsoft.laser.service.at.domain.AtAuctionPriceDomain;
import com.yqbsoft.laser.service.at.domain.AtAuctionPriceReDomain;
import com.yqbsoft.laser.service.at.model.AtAuctionPrice;
import com.yqbsoft.laser.service.at.model.PriceBigData;
import com.yqbsoft.laser.service.at.service.AtAuctionPriceService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AtAuctionPriceServiceImpl
extends BaseServiceImpl
implements AtAuctionPriceService {
    private static final String SYS_CODE = SYS_CODE + ".AtAuctionPriceServiceImpl";
    private AtAuctionPriceMapper atAuctionPriceMapper;

    public void setAtAuctionPriceMapper(AtAuctionPriceMapper atAuctionPriceMapper) {
        this.atAuctionPriceMapper = atAuctionPriceMapper;
    }

    private Date getSysDate() {
        try {
            return this.atAuctionPriceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkatAuctionPrice(AtAuctionPriceDomain atAuctionPriceDomain) {
        if (null == atAuctionPriceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)atAuctionPriceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setatAuctionPriceDefault(AtAuctionPrice atAuctionPrice) {
        if (null == atAuctionPrice) {
            return;
        }
        if (null == atAuctionPrice.getDataState()) {
            atAuctionPrice.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == atAuctionPrice.getGmtCreate()) {
            atAuctionPrice.setGmtCreate(date);
        }
        atAuctionPrice.setGmtModified(date);
        if (StringUtils.isBlank((String)atAuctionPrice.getAuctionPriceCode())) {
            atAuctionPrice.setAuctionPriceCode(this.getNo(null, "AtAuctionPrice", "atAuctionPrice", atAuctionPrice.getTenantCode()));
        }
    }

    private int getatAuctionPriceMaxCode() {
        int code = 0;
        try {
            return this.atAuctionPriceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getatAuctionPriceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setatAuctionPriceUpdataDefault(AtAuctionPrice atAuctionPrice) {
        if (null == atAuctionPrice) {
            return;
        }
        atAuctionPrice.setGmtModified(this.getSysDate());
    }

    private void saveatAuctionPriceModel(AtAuctionPrice atAuctionPrice) throws ApiException {
        if (null == atAuctionPrice) {
            return;
        }
        try {
            this.atAuctionPriceMapper.insert(atAuctionPrice);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveatAuctionPriceModel.ex", (Throwable)e);
        }
    }

    private void saveatAuctionPriceBatchModel(List<AtAuctionPrice> atAuctionPriceList) throws ApiException {
        if (null == atAuctionPriceList || atAuctionPriceList.isEmpty()) {
            return;
        }
        try {
            this.atAuctionPriceMapper.insertBatch(atAuctionPriceList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveatAuctionPriceBatchModel.ex", (Throwable)e);
        }
    }

    private AtAuctionPrice getatAuctionPriceModelById(Integer auctionPriceId) {
        if (null == auctionPriceId) {
            return null;
        }
        try {
            return this.atAuctionPriceMapper.selectByPrimaryKey(auctionPriceId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getatAuctionPriceModelById", (Throwable)e);
            return null;
        }
    }

    private AtAuctionPrice getatAuctionPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.atAuctionPriceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getatAuctionPriceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delatAuctionPriceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.atAuctionPriceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delatAuctionPriceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delatAuctionPriceModelByCode.num");
        }
    }

    private void deleteatAuctionPriceModel(Integer auctionPriceId) throws ApiException {
        if (null == auctionPriceId) {
            return;
        }
        int i = 0;
        try {
            i = this.atAuctionPriceMapper.deleteByPrimaryKey(auctionPriceId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteatAuctionPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteatAuctionPriceModel.num");
        }
    }

    private void updateatAuctionPriceModel(AtAuctionPrice atAuctionPrice) throws ApiException {
        if (null == atAuctionPrice) {
            return;
        }
        int i = 0;
        try {
            i = this.atAuctionPriceMapper.updateByPrimaryKey(atAuctionPrice);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateatAuctionPriceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateatAuctionPriceModel.num");
        }
    }

    private void updateStateatAuctionPriceModel(Integer auctionPriceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionPriceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionPriceId", auctionPriceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctionPriceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionPriceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionPriceModel.null");
        }
    }

    private void updateStateatAuctionPriceModelByCode(String tenantCode, String auctionPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionPriceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionPriceCode", auctionPriceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctionPriceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionPriceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionPriceModelByCode.null");
        }
    }

    private AtAuctionPrice makeatAuctionPrice(AtAuctionPriceDomain atAuctionPriceDomain, AtAuctionPrice atAuctionPrice) {
        if (null == atAuctionPriceDomain) {
            return null;
        }
        if (null == atAuctionPrice) {
            atAuctionPrice = new AtAuctionPrice();
        }
        try {
            BeanUtils.copyAllPropertys((Object)atAuctionPrice, (Object)atAuctionPriceDomain);
            return atAuctionPrice;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeatAuctionPrice", (Throwable)e);
            return null;
        }
    }

    private AtAuctionPriceReDomain makeAtAuctionPriceReDomain(AtAuctionPrice atAuctionPrice) {
        if (null == atAuctionPrice) {
            return null;
        }
        AtAuctionPriceReDomain atAuctionPriceReDomain = new AtAuctionPriceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)atAuctionPriceReDomain, (Object)atAuctionPrice);
            return atAuctionPriceReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeAtAuctionPriceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AtAuctionPrice> queryatAuctionPriceModelPage(Map<String, Object> parammap) {
        try {
            return this.atAuctionPriceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryatAuctionPriceModel", (Throwable)e);
            return null;
        }
    }

    private int countatAuctionPrice(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.atAuctionPriceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countatAuctionPrice", (Throwable)e);
        }
        return i;
    }

    private AtAuctionPrice createAtAuctionPrice(AtAuctionPriceDomain atAuctionPriceDomain) {
        String msg = this.checkatAuctionPrice(atAuctionPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveatAuctionPrice.checkatAuctionPrice", msg);
        }
        AtAuctionPrice atAuctionPrice = this.makeatAuctionPrice(atAuctionPriceDomain, null);
        this.setatAuctionPriceDefault(atAuctionPrice);
        return atAuctionPrice;
    }

    @Override
    public String saveatAuctionPrice(AtAuctionPriceDomain atAuctionPriceDomain) throws ApiException {
        AtAuctionPrice atAuctionPrice = this.createAtAuctionPrice(atAuctionPriceDomain);
        this.saveatAuctionPriceModel(atAuctionPrice);
        return atAuctionPrice.getAuctionPriceCode();
    }

    @Override
    public String saveatAuctionPriceBatch(List<AtAuctionPriceDomain> atAuctionPriceDomainList) throws ApiException {
        if (null == atAuctionPriceDomainList || atAuctionPriceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AtAuctionPrice> atAuctionPriceList = new ArrayList<AtAuctionPrice>();
        String code = "";
        for (AtAuctionPriceDomain atAuctionPriceDomain : atAuctionPriceDomainList) {
            AtAuctionPrice atAuctionPrice = this.createAtAuctionPrice(atAuctionPriceDomain);
            code = atAuctionPrice.getAuctionPriceCode();
            atAuctionPriceList.add(atAuctionPrice);
        }
        this.saveatAuctionPriceBatchModel(atAuctionPriceList);
        return code;
    }

    @Override
    public void updateatAuctionPriceState(Integer auctionPriceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateatAuctionPriceModel(auctionPriceId, dataState, oldDataState, map);
    }

    @Override
    public void updateatAuctionPriceStateByCode(String tenantCode, String auctionPriceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateatAuctionPriceModelByCode(tenantCode, auctionPriceCode, dataState, oldDataState, map);
    }

    @Override
    public void updateatAuctionPrice(AtAuctionPriceDomain atAuctionPriceDomain) throws ApiException {
        String msg = this.checkatAuctionPrice(atAuctionPriceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateatAuctionPrice.checkatAuctionPrice", msg);
        }
        AtAuctionPrice oldAtAuctionPrice = this.getatAuctionPriceModelById(atAuctionPriceDomain.getAuctionPriceId());
        if (null == oldAtAuctionPrice) {
            throw new ApiException(SYS_CODE + ".updateatAuctionPrice.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AtAuctionPrice atAuctionPrice = this.makeatAuctionPrice(atAuctionPriceDomain, oldAtAuctionPrice);
        this.setatAuctionPriceUpdataDefault(atAuctionPrice);
        this.updateatAuctionPriceModel(atAuctionPrice);
    }

    @Override
    public AtAuctionPrice getatAuctionPrice(Integer auctionPriceId) {
        return this.getatAuctionPriceModelById(auctionPriceId);
    }

    @Override
    public void deleteatAuctionPrice(Integer auctionPriceId) throws ApiException {
        this.deleteatAuctionPriceModel(auctionPriceId);
    }

    @Override
    public QueryResult<AtAuctionPrice> queryatAuctionPricePage(Map<String, Object> map) {
        List<AtAuctionPrice> atAuctionPriceList = this.queryatAuctionPriceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countatAuctionPrice(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(atAuctionPriceList);
        return queryResult;
    }

    @Override
    public AtAuctionPrice getatAuctionPriceByCode(String tenantCode, String auctionPriceCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionPriceCode", auctionPriceCode);
        return this.getatAuctionPriceModelByCode(map);
    }

    @Override
    public void deleteatAuctionPriceByCode(String tenantCode, String auctionPriceCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionPriceCode", auctionPriceCode);
        this.delatAuctionPriceModelByCode(map);
    }

    private List<PriceBigData> queryJJPriceDayDataModel(Map<String, Object> map) {
        try {
            return this.atAuctionPriceMapper.queryJJPriceDayData(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryJJPriceDayDataModel", (Throwable)e);
            return null;
        }
    }

    private List<PriceBigData> queryGinfoCodeDataModel(Map<String, Object> map) {
        try {
            return this.atAuctionPriceMapper.queryGinfoCodeData(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryGinfoCodeDataModel", (Throwable)e);
            return null;
        }
    }

    private BigDecimal selectGinfoLastPriceDataModel(String auctionGinfoCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionGinfoCode", auctionGinfoCode);
        map.put("tenantCode", tenantCode);
        try {
            return this.atAuctionPriceMapper.selectGinfoLastPriceData(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".selectGinfoLastPriceDataModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PriceBigData> queryJJPriceBigData(Map<String, Object> map) throws ApiException {
        List<PriceBigData> queryJJPriceDayList = this.queryJJPriceDayDataModel(map);
        if (ListUtil.isEmpty(queryJJPriceDayList)) {
            return null;
        }
        if (null == map.get("tenantCode")) {
            return null;
        }
        if (null == map.get("auctionPriceType")) {
            return null;
        }
        String tenantCode = map.get("tenantCode").toString();
        String auctionPriceType = map.get("auctionPriceType").toString();
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        BigDecimal finalprice = new BigDecimal(0);
        map2.put("tenantCode", tenantCode);
        map2.put("auctionPriceType", auctionPriceType);
        for (PriceBigData priceBigData : queryJJPriceDayList) {
            map2.put("gmtCreat", priceBigData.getDateValue());
            List<PriceBigData> ginfoDataList = this.queryGinfoCodeDataModel(map2);
            if (ListUtil.isEmpty(ginfoDataList)) {
                priceBigData.setCountValue(new BigDecimal(0));
                continue;
            }
            for (PriceBigData priceBigData1 : ginfoDataList) {
                BigDecimal childprice = this.selectGinfoLastPriceDataModel(priceBigData1.getDateValue(), tenantCode);
                finalprice = finalprice.add(childprice);
            }
            priceBigData.setCountValue(finalprice);
        }
        return queryJJPriceDayList;
    }

    @Override
    public BigDecimal getMinPriceNow(String tenantCode, String auctionCode, String auctionGinfoCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("auctionGinfoCode", auctionGinfoCode);
        try {
            return this.atAuctionPriceMapper.getMinPriceNow(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getMinPriceNow", (Throwable)e);
            return null;
        }
    }

    @Override
    public BigDecimal getMaxPriceNow(String tenantCode, String auctionCode, String auctionGinfoCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("auctionGinfoCode", auctionGinfoCode);
        try {
            return this.atAuctionPriceMapper.getMaxPriceNow(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getMaxPriceNow", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<AtAuctionPrice> queryAtAuctionPricePageFromFreeAuction(Map<String, Object> map) {
        try {
            List<AtAuctionPrice> list = this.atAuctionPriceMapper.queryAtAuctionPricePageFromFreeAuction(map);
            return list;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryAtAuctionPricePageFromFreeAuction", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<AtAuctionPrice> queryAtAuctionPricePageLastFromFreeAuction(Map<String, Object> map) {
        try {
            List<AtAuctionPrice> list = this.atAuctionPriceMapper.queryAtAuctionPricePageLastFromFreeAuction(map);
            return list;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryAtAuctionPricePageFromFreeAuction", (Throwable)e);
            return null;
        }
    }
}

