/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd.service.impl;

import com.yqbsoft.laser.service.cd.dao.CdCardpChangeMapper;
import com.yqbsoft.laser.service.cd.domain.CdCardpChangeDomain;
import com.yqbsoft.laser.service.cd.domain.CdCardpChangeReDomain;
import com.yqbsoft.laser.service.cd.model.CdCardpChange;
import com.yqbsoft.laser.service.cd.service.CdCardpChangeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CdCardpChangeImpl
extends BaseServiceImpl
implements CdCardpChangeService {
    private static final String SYS_CODE = "cd.CARDP.CdCardpChangeImpl";
    private CdCardpChangeMapper cdCardpChangeMapper;

    public void setCdCardpChangeMapper(CdCardpChangeMapper cdCardpChangeMapper) {
        this.cdCardpChangeMapper = cdCardpChangeMapper;
    }

    private Date getSysDate() {
        try {
            return this.cdCardpChangeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpChangeImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCardpChange(CdCardpChangeDomain cdCardpChangeDomain) {
        if (null == cdCardpChangeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cdCardpChangeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCardpChangeDefault(CdCardpChange cdCardpChange) {
        if (null == cdCardpChange) {
            return;
        }
        if (null == cdCardpChange.getDataState()) {
            cdCardpChange.setDataState(0);
        }
        if (null == cdCardpChange.getGmtCreate()) {
            cdCardpChange.setGmtCreate(this.getSysDate());
        }
        cdCardpChange.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cdCardpChange.getCardpChangeCode())) {
            cdCardpChange.setCardpChangeCode(this.createUUIDString());
        }
    }

    private int getCardpChangeMaxCode() {
        int code = 0;
        try {
            return this.cdCardpChangeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpChangeImpl.getCardpChangeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCardpChangeUpdataDefault(CdCardpChange cdCardpChange) {
        if (null == cdCardpChange) {
            return;
        }
        cdCardpChange.setGmtModified(this.getSysDate());
    }

    private void saveCardpChangeModel(CdCardpChange cdCardpChange) throws ApiException {
        if (null == cdCardpChange) {
            return;
        }
        try {
            this.cdCardpChangeMapper.insert(cdCardpChange);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.saveCardpChangeModel.ex", (Throwable)e);
        }
    }

    private void saveCardpChangeBatchModel(List<CdCardpChange> cdCardpChangeList) throws ApiException {
        if (null == cdCardpChangeList || cdCardpChangeList.isEmpty()) {
            return;
        }
        try {
            this.cdCardpChangeMapper.insertBatch(cdCardpChangeList);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.saveCardpChangeBatchModel.ex", (Throwable)e);
        }
    }

    private CdCardpChange getCardpChangeModelById(Integer cardpChangeId) {
        if (null == cardpChangeId) {
            return null;
        }
        try {
            return this.cdCardpChangeMapper.selectByPrimaryKey(cardpChangeId);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpChangeImpl.getCardpChangeModelById", (Throwable)e);
            return null;
        }
    }

    private CdCardpChange getCardpChangeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cdCardpChangeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpChangeImpl.getCardpChangeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCardpChangeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpChangeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.delCardpChangeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.delCardpChangeModelByCode.num");
        }
    }

    private void deleteCardpChangeModel(Integer cardpChangeId) throws ApiException {
        if (null == cardpChangeId) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpChangeMapper.deleteByPrimaryKey(cardpChangeId);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.deleteCardpChangeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.deleteCardpChangeModel.num");
        }
    }

    private void updateCardpChangeModel(CdCardpChange cdCardpChange) throws ApiException {
        if (null == cdCardpChange) {
            return;
        }
        int i = 0;
        try {
            i = this.cdCardpChangeMapper.updateByPrimaryKeySelective(cdCardpChange);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.updateCardpChangeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.updateCardpChangeModel.num");
        }
    }

    private void updateStateCardpChangeModel(Integer cardpChangeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cardpChangeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardpChangeId", cardpChangeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cdCardpChangeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.updateStateCardpChangeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.updateStateCardpChangeModel.null");
        }
    }

    private void updateStateCardpChangeModelByCode(String tenantCode, String cardpChangeCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)cardpChangeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpChangeCode", cardpChangeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cdCardpChangeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.updateStateCardpChangeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.updateStateCardpChangeModelByCode.null");
        }
    }

    private CdCardpChange makeCardpChange(CdCardpChangeDomain cdCardpChangeDomain, CdCardpChange cdCardpChange) {
        if (null == cdCardpChangeDomain) {
            return null;
        }
        if (null == cdCardpChange) {
            cdCardpChange = new CdCardpChange();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpChange, (Object)cdCardpChangeDomain);
            return cdCardpChange;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpChangeImpl.makeCardpChange", (Throwable)e);
            return null;
        }
    }

    private CdCardpChangeReDomain makeCdCardpChangeReDomain(CdCardpChange cdCardpChange) {
        if (null == cdCardpChange) {
            return null;
        }
        CdCardpChangeReDomain cdCardpChangeReDomain = new CdCardpChangeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cdCardpChangeReDomain, (Object)cdCardpChange);
            return cdCardpChangeReDomain;
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpChangeImpl.makeCdCardpChangeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CdCardpChange> queryCardpChangeModelPage(Map<String, Object> parammap) {
        try {
            return this.cdCardpChangeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpChangeImpl.queryCardpChangeModel", (Throwable)e);
            return null;
        }
    }

    private int countCardpChange(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cdCardpChangeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cd.CARDP.CdCardpChangeImpl.countCardpChange", (Throwable)e);
        }
        return i;
    }

    private CdCardpChange createCdCardpChange(CdCardpChangeDomain cdCardpChangeDomain) {
        String msg = this.checkCardpChange(cdCardpChangeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.saveCardpChange.checkCardpChange", msg);
        }
        CdCardpChange cdCardpChange = this.makeCardpChange(cdCardpChangeDomain, null);
        this.setCardpChangeDefault(cdCardpChange);
        return cdCardpChange;
    }

    @Override
    public String saveCardpChange(CdCardpChangeDomain cdCardpChangeDomain) throws ApiException {
        CdCardpChange cdCardpChange = this.createCdCardpChange(cdCardpChangeDomain);
        this.saveCardpChangeModel(cdCardpChange);
        return cdCardpChange.getCardpChangeCode();
    }

    @Override
    public String saveCardpChangeBatch(List<CdCardpChangeDomain> cdCardpChangeDomainList) throws ApiException {
        if (null == cdCardpChangeDomainList || cdCardpChangeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CdCardpChange> cdCardpChangeList = new ArrayList<CdCardpChange>();
        String code = "";
        for (CdCardpChangeDomain cdCardpChangeDomain : cdCardpChangeDomainList) {
            CdCardpChange cdCardpChange = this.createCdCardpChange(cdCardpChangeDomain);
            code = cdCardpChange.getCardpChangeCode();
            cdCardpChangeList.add(cdCardpChange);
        }
        this.saveCardpChangeBatchModel(cdCardpChangeList);
        return code;
    }

    @Override
    public void updateCardpChangeState(Integer cardpChangeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCardpChangeModel(cardpChangeId, dataState, oldDataState);
    }

    @Override
    public void updateCardpChangeStateByCode(String tenantCode, String cardpChangeCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCardpChangeModelByCode(tenantCode, cardpChangeCode, dataState, oldDataState);
    }

    @Override
    public void updateCardpChange(CdCardpChangeDomain cdCardpChangeDomain) throws ApiException {
        String msg = this.checkCardpChange(cdCardpChangeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.updateCardpChange.checkCardpChange", msg);
        }
        CdCardpChange oldCdCardpChange = this.getCardpChangeModelById(cdCardpChangeDomain.getCardpChangeId());
        if (null == oldCdCardpChange) {
            throw new ApiException("cd.CARDP.CdCardpChangeImpl.updateCardpChange.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CdCardpChange cdCardpChange = this.makeCardpChange(cdCardpChangeDomain, oldCdCardpChange);
        this.setCardpChangeUpdataDefault(cdCardpChange);
        this.updateCardpChangeModel(cdCardpChange);
    }

    @Override
    public CdCardpChange getCardpChange(Integer cardpChangeId) {
        return this.getCardpChangeModelById(cardpChangeId);
    }

    @Override
    public void deleteCardpChange(Integer cardpChangeId) throws ApiException {
        this.deleteCardpChangeModel(cardpChangeId);
    }

    @Override
    public QueryResult<CdCardpChange> queryCardpChangePage(Map<String, Object> map) {
        List<CdCardpChange> cdCardpChangeList = this.queryCardpChangeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCardpChange(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cdCardpChangeList);
        return queryResult;
    }

    @Override
    public CdCardpChange getCardpChangeByCode(String tenantCode, String cardpChangeCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpChangeCode", cardpChangeCode);
        return this.getCardpChangeModelByCode(map);
    }

    @Override
    public void deleteCardpChangeByCode(String tenantCode, String cardpChangeCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cardpChangeCode", cardpChangeCode);
        this.delCardpChangeModelByCode(map);
    }
}

