/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.channelmanage.service.impl;

import com.yqbsoft.laser.service.channelmanage.dao.CmChannelPayMapper;
import com.yqbsoft.laser.service.channelmanage.domain.CmChannelPayDomain;
import com.yqbsoft.laser.service.channelmanage.model.CmChannelPay;
import com.yqbsoft.laser.service.channelmanage.service.CmChannelPayService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmChannelPayServiceImpl
extends BaseServiceImpl
implements CmChannelPayService {
    public static final String SYS_CODE = "cm.CmChannelPayServiceImpl";
    private CmChannelPayMapper cmChannelPayMapper;

    public void setCmChannelPayMapper(CmChannelPayMapper cmChannelPayMapper) {
        this.cmChannelPayMapper = cmChannelPayMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmChannelPayMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelPayServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelPay(CmChannelPayDomain cmChannelPayDomain) {
        if (null == cmChannelPayDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setChannelPayDefault(CmChannelPay cmChannelPay) {
        if (null == cmChannelPay) {
            return;
        }
        if (null == cmChannelPay.getDataState()) {
            cmChannelPay.setDataState(0);
        }
        if (null == cmChannelPay.getGmtCreate()) {
            cmChannelPay.setGmtCreate(this.getSysDate());
        }
        cmChannelPay.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmChannelPay.getChannelPaySeqno())) {
            cmChannelPay.setChannelPaySeqno(this.createUUIDString());
        }
    }

    private int getChannelPayMaxCode() {
        int code = 0;
        try {
            return this.cmChannelPayMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelPayServiceImpl.getChannelPayMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelPayUpdataDefault(CmChannelPay cmChannelPay) {
        if (null == cmChannelPay) {
            return;
        }
        cmChannelPay.setGmtModified(this.getSysDate());
    }

    private void saveChannelPayModel(CmChannelPay cmChannelPay) throws ApiException {
        if (null == cmChannelPay) {
            return;
        }
        try {
            this.cmChannelPayMapper.insert(cmChannelPay);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelPayServiceImpl.saveChannelPayModel.ex", (Throwable)e);
        }
    }

    private CmChannelPay getChannelPayModelById(Integer channelPayId) {
        if (null == channelPayId) {
            return null;
        }
        try {
            return this.cmChannelPayMapper.selectByPrimaryKey(channelPayId);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelPayServiceImpl.getChannelPayModelById", (Throwable)e);
            return null;
        }
    }

    public CmChannelPay getChannelPayModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmChannelPayMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelPayServiceImpl.getChannelPayModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delChannelPayModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmChannelPayMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelPayServiceImpl.delChannelPayModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmChannelPayServiceImpl.delChannelPayModelByCode.num");
        }
    }

    private void deleteChannelPayModel(Integer channelPayId) throws ApiException {
        if (null == channelPayId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmChannelPayMapper.deleteByPrimaryKey(channelPayId);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelPayServiceImpl.deleteChannelPayModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmChannelPayServiceImpl.deleteChannelPayModel.num");
        }
    }

    private void updateChannelPayModel(CmChannelPay cmChannelPay) throws ApiException {
        if (null == cmChannelPay) {
            return;
        }
        try {
            this.cmChannelPayMapper.updateByPrimaryKeySelective(cmChannelPay);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelPayServiceImpl.updateChannelPayModel.ex", (Throwable)e);
        }
    }

    private void updateStateChannelPayModel(Integer channelPayId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelPayId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelPayId", channelPayId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmChannelPayMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelPayServiceImpl.updateStateChannelPayModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cm.CmChannelPayServiceImpl.updateStateChannelPayModel.null");
        }
    }

    private CmChannelPay makeChannelPay(CmChannelPayDomain cmChannelPayDomain, CmChannelPay cmChannelPay) {
        if (null == cmChannelPayDomain) {
            return null;
        }
        if (null == cmChannelPay) {
            cmChannelPay = new CmChannelPay();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmChannelPay, (Object)cmChannelPayDomain);
            return cmChannelPay;
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelPayServiceImpl.makeChannelPay", (Throwable)e);
            return null;
        }
    }

    private List<CmChannelPay> queryChannelPayModelPage(Map<String, Object> parammap) {
        try {
            return this.cmChannelPayMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelPayServiceImpl.queryChannelPayModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelPay(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmChannelPayMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelPayServiceImpl.countChannelPay", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveChannelPay(CmChannelPayDomain cmChannelPayDomain) throws ApiException {
        String msg = this.checkChannelPay(cmChannelPayDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmChannelPayServiceImpl.saveChannelPay.checkChannelPay", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelClearSeqno", cmChannelPayDomain.getChannelClearSeqno());
        map.put("tenantCode", cmChannelPayDomain.getTenantCode());
        List<CmChannelPay> list = this.queryChannelPayModelPage(map);
        if (null != list && !list.isEmpty()) {
            this.logger.error("cm.CmChannelPayServiceImpl.saveChannelPay.list", (Object)((Object)map).toString());
            return;
        }
        CmChannelPay cmChannelPay = this.makeChannelPay(cmChannelPayDomain, null);
        this.setChannelPayDefault(cmChannelPay);
        this.saveChannelPayModel(cmChannelPay);
    }

    @Override
    public void updateChannelPayState(Integer channelPayId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelPayModel(channelPayId, dataState, oldDataState);
    }

    @Override
    public void updateChannelPay(CmChannelPayDomain cmChannelPayDomain) throws ApiException {
        String msg = this.checkChannelPay(cmChannelPayDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmChannelPayServiceImpl.updateChannelPay.checkChannelPay", msg);
        }
        CmChannelPay oldCmChannelPay = this.getChannelPayModelById(cmChannelPayDomain.getChannelPayId());
        if (null == oldCmChannelPay) {
            throw new ApiException("cm.CmChannelPayServiceImpl.updateChannelPay.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmChannelPay cmChannelPay = this.makeChannelPay(cmChannelPayDomain, oldCmChannelPay);
        this.setChannelPayUpdataDefault(cmChannelPay);
        this.updateChannelPayModel(cmChannelPay);
    }

    @Override
    public CmChannelPay getChannelPay(Integer channelPayId) {
        return this.getChannelPayModelById(channelPayId);
    }

    @Override
    public void deleteChannelPay(Integer channelPayId) throws ApiException {
        this.deleteChannelPayModel(channelPayId);
    }

    @Override
    public QueryResult<CmChannelPay> queryChannelPayPage(Map<String, Object> map) {
        List<CmChannelPay> cmChannelPayList = this.queryChannelPayModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelPay(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmChannelPayList);
        return queryResult;
    }

    @Override
    public CmChannelPay getChannelPayByCode(Map<String, Object> map) {
        return this.getChannelPayModelByCode(map);
    }

    @Override
    public void delChannelPayByCode(Map<String, Object> map) throws ApiException {
        this.delChannelPayModelByCode(map);
    }
}

