/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.chargeProvided.recharge.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.chargeProvided.recharge.dao.CpRechargeMapper;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.CpRechargeDomain;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.CpRechargeSendDomain;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.CrpUrecharge;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.CrpUrechargeDomain;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.PtePtradpde;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.VdFaccountOuterDtDomain;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.VdFaccountOuterSubset;
import com.yqbsoft.laser.service.chargeProvided.recharge.engine.SendPollThread;
import com.yqbsoft.laser.service.chargeProvided.recharge.engine.SendPutThread;
import com.yqbsoft.laser.service.chargeProvided.recharge.engine.SendService;
import com.yqbsoft.laser.service.chargeProvided.recharge.model.CpRecharge;
import com.yqbsoft.laser.service.chargeProvided.recharge.model.CpRechargeSend;
import com.yqbsoft.laser.service.chargeProvided.recharge.service.CpRechargeSendService;
import com.yqbsoft.laser.service.chargeProvided.recharge.service.CpRechargeService;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtradeBean;
import com.yqbsoft.laser.service.chargeProvided.trade.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CpRechargeServiceImpl
extends BaseServiceImpl
implements CpRechargeService {
    public static final String SYS_CODE = "cp.CpRechargeServiceImpl";
    private CpRechargeMapper cpRechargeMapper;
    private CpRechargeSendService cpRechargeSendService;
    private static Object lock = new Object();
    private static SendService sendService;

    public void setCpRechargeMapper(CpRechargeMapper cpRechargeMapper) {
        this.cpRechargeMapper = cpRechargeMapper;
    }

    public CpRechargeSendService getCpRechargeSendService() {
        return this.cpRechargeSendService;
    }

    public void setCpRechargeSendService(CpRechargeSendService cpRechargeSendService) {
        this.cpRechargeSendService = cpRechargeSendService;
    }

    private Date getSysDate() {
        try {
            return this.cpRechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecharge(CpRechargeDomain cpRechargeDomain) {
        if (null == cpRechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (null == cpRechargeDomain.getRechargeMoney()) {
            msg = msg + "RechargeMoney\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getFchannelCode())) {
            msg = msg + "FchannelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getFaccountId())) {
            msg = msg + "FaccountId\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRechargeDefault(CpRecharge cpRecharge) {
        if (null == cpRecharge) {
            return;
        }
        if (null == cpRecharge.getDataState()) {
            cpRecharge.setDataState(0);
        }
        if (null == cpRecharge.getGmtCreate()) {
            cpRecharge.setGmtCreate(this.getSysDate());
        }
        cpRecharge.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cpRecharge.getRechargeCode())) {
            cpRecharge.setRechargeCode(this.getNo(null, CpRecharge.class.getSimpleName(), "rechargeCode", cpRecharge.getTenantCode()));
        }
    }

    private void setRechargeUpdataDefault(CpRecharge cpRecharge) {
        if (null == cpRecharge) {
            return;
        }
        cpRecharge.setGmtModified(this.getSysDate());
    }

    private void saveRechargeModel(CpRecharge cpRecharge) throws ApiException {
        if (null == cpRecharge) {
            return;
        }
        try {
            this.cpRechargeMapper.insert(cpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRechargeModel.ex", (Throwable)e);
        }
    }

    private CpRecharge getRechargeModelById(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        try {
            return this.cpRechargeMapper.selectByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.getRechargeModelById", (Throwable)e);
            return null;
        }
    }

    public CpRecharge getRechargeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cpRechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.getRechargeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRechargeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cpRechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.delRechargeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpRechargeServiceImpl.delRechargeModelByCode.num");
        }
    }

    private void deleteRechargeModel(Integer rechargeId) throws ApiException {
        if (null == rechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.cpRechargeMapper.deleteByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.deleteRechargeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpRechargeServiceImpl.deleteRechargeModel.num");
        }
    }

    private void updateRechargeModel(CpRecharge cpRecharge) throws ApiException {
        if (null == cpRecharge) {
            return;
        }
        try {
            this.cpRechargeMapper.updateByPrimaryKeySelective(cpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRechargeModel.ex", (Throwable)e);
        }
    }

    private void updateStateRechargeModel(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeId", rechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cpRechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateStateRechargeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateStateRechargeModel.null");
        }
    }

    private void updateStateRechargeModelByCode(String rechargeCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)rechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeCode", rechargeCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cpRechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateStateRechargeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateStateRechargeModelByCode.null");
        }
    }

    private CpRecharge makeRecharge(CpRechargeDomain cpRechargeDomain, CpRecharge cpRecharge) {
        if (null == cpRechargeDomain) {
            return null;
        }
        if (null == cpRecharge) {
            cpRecharge = new CpRecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cpRecharge, (Object)cpRechargeDomain);
            return cpRecharge;
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.makeRecharge", (Throwable)e);
            return null;
        }
    }

    private List<CpRecharge> queryRechargeModelPage(Map<String, Object> parammap) {
        try {
            return this.cpRechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.queryRechargeModel", (Throwable)e);
            return null;
        }
    }

    private int countRecharge(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cpRechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.countRecharge", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSendTrade(CpRechargeDomain cpRechargeDomain) {
        Map<String, String> envmap = new HashMap();
        if (null != cpRechargeDomain && StringUtils.isNotBlank((String)cpRechargeDomain.getRechargeRemark())) {
            envmap = JsonUtil.buildNormalBinder().getJsonToMap(cpRechargeDomain.getRechargeRemark(), String.class, Object.class);
            cpRechargeDomain.setRechargeRemark((String)envmap.get("remark"));
        }
        String rechargeCode = this.saveRecharge(cpRechargeDomain);
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setTenantCode(cpRechargeDomain.getTenantCode());
        ptePtradeDomain.setPartnerCode(cpRechargeDomain.getPartnerCode());
        ptePtradeDomain.setMerchantCode(cpRechargeDomain.getUserinfoCode());
        ptePtradeDomain.setFchannelPmodeCode(cpRechargeDomain.getFchannelPmodeCode());
        ptePtradeDomain.setOrderAmount(cpRechargeDomain.getRechargeMoney());
        ptePtradeDomain.setOpuserCode(cpRechargeDomain.getUserinfoCode());
        ptePtradeDomain.setOpuserName(cpRechargeDomain.getUserinfoName());
        ptePtradeDomain.setBusinessOrderno(rechargeCode);
        ptePtradeDomain.setAcquireSeqno(rechargeCode);
        if (StringUtils.isBlank((String)cpRechargeDomain.getFundType())) {
            ptePtradeDomain.setPtradeType("01");
        } else {
            ptePtradeDomain.setPtradeType(cpRechargeDomain.getFundType());
        }
        ptePtradeDomain.setBusinessOrder(rechargeCode);
        ptePtradeDomain.setPaymentMemo("\u7ebf\u4e0a\u5145\u503c");
        envmap.put("userPcode", cpRechargeDomain.getUserinfoCode());
        ptePtradeDomain.setExtension(JsonUtil.buildNonDefaultBinder().toJson(envmap));
        ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.RECHARGE.getCode());
        ptePtradeDomain.settPaymentInfoOperator(cpRechargeDomain.getUserName());
        ptePtradeDomain.setPaymentTecode("");
        ptePtradeDomain.setPaymentReturnurl("cp.recharge.updateRechargeStatubyTrade");
        ptePtradeDomain.setPaymentNotifyurl("cp.recharge.updateRechargeStatubyTrade");
        ConcurrentHashMap<String, String> queryMap = new ConcurrentHashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        this.logger.info("cp.CpRechargeServiceImpl.saveRecharge.pte.ptrade.savePtrade.\u53c2\u6570", (Object)JSONObject.toJSONString(queryMap));
        String result = this.internalInvoke("pte.ptrade.sendSavePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRecharge.checkRecharge", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
        HashMap<String, Object> mapStr = new HashMap<String, Object>();
        mapStr.put("rechargeCode", rechargeCode);
        mapStr.put("tenantCode", cpRechargeDomain.getTenantCode());
        CpRecharge rechargeByCode = this.getRechargeByCode(mapStr);
        CpRechargeDomain cpRechargeDomain1 = new CpRechargeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)cpRechargeDomain1, (Object)rechargeByCode);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.makeRecharge", (Throwable)e);
        }
        cpRechargeDomain1.setRechargeUrl(result);
        cpRechargeDomain1.setRechargeId(rechargeByCode.getRechargeId());
        this.updateRecharge(cpRechargeDomain1);
        return result;
    }

    @Override
    public String saveRecharge(CpRechargeDomain cpRechargeDomain) throws ApiException {
        String msg = this.checkRecharge(cpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRecharge.checkRecharge", msg);
        }
        CpRecharge cpRecharge = this.makeRecharge(cpRechargeDomain, null);
        this.setRechargeDefault(cpRecharge);
        this.saveRechargeModel(cpRecharge);
        ArrayList<CpRecharge> list = new ArrayList<CpRecharge>();
        list.add(cpRecharge);
        List<CpRechargeSend> cpRechargeSendList = this.buidPmChannelsend(list, "insert");
        if (ListUtil.isNotEmpty(cpRechargeSendList)) {
            CpRechargeServiceImpl.getSendService().addPutPool(new SendPutThread(CpRechargeServiceImpl.getSendService(), cpRechargeSendList));
        }
        return cpRecharge.getRechargeCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 50; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    private List<CpRechargeSend> buidPmChannelsend(List<CpRecharge> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CpRechargeSend> pmChannelsendList = new ArrayList();
        ArrayList<CpRechargeSendDomain> disChannelsendDomainList = new ArrayList<CpRechargeSendDomain>();
        for (CpRecharge promotion : pmPromotionList) {
            CpRechargeSendDomain pmChannelsendDomain = new CpRechargeSendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getRechargeCode());
            pmChannelsendDomain.setChannelsendType("cpRecharge");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.cpRechargeSendService.saveCrpChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public void updateRechargeState(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<CpRechargeSend> cpRechargeSendList;
        ArrayList<CpRecharge> list;
        this.updateStateRechargeModel(rechargeId, dataState, oldDataState, map);
        CpRecharge cpRecharge = this.getRecharge(rechargeId);
        if (null == cpRecharge) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRechargeState.null");
        }
        if (2 == dataState && cpRecharge.getRechargeMode().equals("1")) {
            this.sendPay(cpRecharge, map);
            list = new ArrayList<CpRecharge>();
            list.add(cpRecharge);
            cpRechargeSendList = this.buidPmChannelsendStr(list, "update");
            if (ListUtil.isNotEmpty(cpRechargeSendList)) {
                CpRechargeServiceImpl.getSendService().addPutPool(new SendPutThread(CpRechargeServiceImpl.getSendService(), cpRechargeSendList));
            }
        }
        if (5 == dataState && cpRecharge.getRechargeMode().equals("0")) {
            this.sendPay(cpRecharge, map);
            list = new ArrayList();
            list.add(cpRecharge);
            cpRechargeSendList = this.buidPmChannelsendStr(list, "update");
            if (ListUtil.isNotEmpty(cpRechargeSendList)) {
                CpRechargeServiceImpl.getSendService().addPutPool(new SendPutThread(CpRechargeServiceImpl.getSendService(), cpRechargeSendList));
            }
        }
    }

    public String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode, String appmanageIcode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType + appmanageIcode).concat("-").concat(flagSettingCode + appmanageIcode);
        String value = this.getRedisValue(field);
        return value;
    }

    public String getRedisValue(String key) {
        String redisValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)key);
        return redisValue;
    }

    private List<CpRechargeSend> buidPmChannelsendStr(List<CpRecharge> crpRechargeList, String dri) {
        if (ListUtil.isEmpty(crpRechargeList)) {
            return null;
        }
        ArrayList<CpRechargeSendDomain> disChannelsendDomainList = new ArrayList<CpRechargeSendDomain>();
        for (CpRecharge recharge : crpRechargeList) {
            CpRechargeSendDomain crpChannelsendDomain = new CpRechargeSendDomain();
            crpChannelsendDomain.setChannelsendOpcode(recharge.getRechargeCode());
            crpChannelsendDomain.setChannelsendType("cpRecharge");
            crpChannelsendDomain.setChannelsendDir(dri);
            crpChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)recharge));
            crpChannelsendDomain.setTenantCode(recharge.getTenantCode());
            disChannelsendDomainList.add(crpChannelsendDomain);
        }
        List<CpRechargeSend> pmChannelsendList = this.cpRechargeSendService.saveCrpChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    public void updateRechargeStateByCode(String rechargeCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateRechargeModelByCode(rechargeCode, tenantCode, dataState, oldDataState, map);
        if (2 == dataState) {
            CpRecharge cpRecharge = this.getRechargeByCode(this.getQueryParamMap("rechargeCode,tenantCode", new Object[]{rechargeCode, tenantCode}));
            if (null == cpRecharge) {
                throw new ApiException("cp.CpRechargeServiceImpl.updateRechargeStateByCode.null");
            }
            this.sendPay(cpRecharge, map);
        }
    }

    private PtradeBean makeParticipant(CpRecharge cpRecharge) {
        if (null == cpRecharge) {
            return null;
        }
        PtradeBean pb = new PtradeBean();
        String fundType = cpRecharge.getFundType();
        if (StringUtils.isBlank((String)fundType)) {
            fundType = "01";
        }
        pb.setTenantCode(cpRecharge.getTenantCode());
        pb.setFchannelPmodeCode(cpRecharge.getFchannelPmodeCode());
        pb.setFchannelMode("0");
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        String code = cpRecharge.getUserinfoCode().substring(0, 1);
        PtePtradeParticipantDomain pd1 = new PtePtradeParticipantDomain();
        pd1.setDicActorCode("BUY_B");
        pd1.setFaccountId(cpRecharge.getFaccountId());
        pd1.setFchannelCode("0" + code);
        pd1.setFchannelClassifyCode(code + fundType);
        pd1.setOrderAmount(cpRecharge.getRechargeMoney());
        pd1.setFundType(fundType);
        partList.add(pd1);
        pb.setPartList(partList);
        if (StringUtils.isNotBlank((String)cpRecharge.getFchannelCode())) {
            PtePtradeParticipantDomain pd2 = new PtePtradeParticipantDomain();
            pd2.setDicActorCode("BANK");
            pd2.setFundType(fundType);
            pd2.setFchannelCode(cpRecharge.getFchannelCode());
            pd2.setFchannelClassifyCode(cpRecharge.getFchannelClassifyCode());
            pd2.setOrderAmount(cpRecharge.getRechargeMoney());
            partList.add(pd2);
        }
        return pb;
    }

    private void sendPay(CpRecharge cpRecharge, Map<String, Object> map) {
        if (null == cpRecharge) {
            return;
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setOrderOamount(cpRecharge.getRechargeMoney());
        ptePtradeDomain.setOrderAmount(cpRecharge.getRechargeMoney());
        ptePtradeDomain.setPtradeType(cpRecharge.getRechargeType());
        ptePtradeDomain.setAcquireSeqno(cpRecharge.getRechargeCode());
        ptePtradeDomain.setPartnerCode(cpRecharge.getUserinfoCode());
        if (StringUtils.isNotBlank((String)cpRecharge.getRechargeOpcode())) {
            ptePtradeDomain.setBusinessOrderno(cpRecharge.getRechargeOpcode());
        } else {
            ptePtradeDomain.setBusinessOrderno(cpRecharge.getRechargeCode());
        }
        if (StringUtils.isNotBlank((String)cpRecharge.getRechargeOpcode1())) {
            ptePtradeDomain.setBusinessOrder(cpRecharge.getRechargeOpcode1());
        } else {
            ptePtradeDomain.setBusinessOrder(cpRecharge.getRechargeCode());
        }
        if (StringUtils.isNotBlank((String)cpRecharge.getBankcodeName())) {
            ptePtradeDomain.setPaymentMemo(cpRecharge.getBankcodeName());
        } else {
            ptePtradeDomain.setPaymentMemo((StringUtils.isBlank((String)cpRecharge.getRechargeOpcode()) ? "" : cpRecharge.getRechargeOpcode()) + (StringUtils.isBlank((String)cpRecharge.getRechargeName()) ? "\u5145\u503c" : cpRecharge.getRechargeName()));
        }
        ptePtradeDomain.setOpuserCode(cpRecharge.getUserinfoCode());
        ptePtradeDomain.setOpuserName(cpRecharge.getUserinfoName());
        ptePtradeDomain.setBusinessType(StringUtils.isBlank((String)cpRecharge.getRechargeType()) ? "C01" : cpRecharge.getRechargeType());
        List ptePtradeList = new ArrayList();
        if (StringUtils.isNotBlank((String)cpRecharge.getBankcardCode())) {
            HashMap<String, String> objectMap = new HashMap<String, String>();
            objectMap.put("ptradpdeCode", cpRecharge.getBankcardCode());
            objectMap.put("tenantCode", "00000000");
            HashMap<String, String> inner = new HashMap<String, String>();
            inner.put("map", JsonUtil.buildNonDefaultBinder().toJson(objectMap));
            String PtradpdePage = this.internalInvoke("pte.ptradpde.queryPtradpdePage", inner);
            QueryResult ptePtradpdeQueryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(PtradpdePage, QueryResult.class);
            ptePtradeList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)ptePtradpdeQueryResult.getList()), PtePtradpde.class);
        }
        if (ListUtil.isNotEmpty(ptePtradeList)) {
            ptePtradeDomain.setPtradpdeCode(((PtePtradpde)ptePtradeList.get(0)).getPtradpdeCode());
        } else if ("0".equals(cpRecharge.getRechargeMode())) {
            ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.RECHARGE.getCode());
        } else {
            ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.RECHARGEULINE.getCode());
        }
        ptePtradeDomain.setTenantCode(cpRecharge.getTenantCode());
        ptePtradeDomain.setChannelCode(cpRecharge.getChannelCode());
        ptePtradeDomain.setChannelName(cpRecharge.getChannelName());
        ptePtradeDomain.setMerchantCode(cpRecharge.getUserinfoCode());
        ptePtradeDomain.setFchannelPmodeCode(cpRecharge.getFchannelPmodeCode());
        if (null != map && !map.isEmpty()) {
            ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(map));
        }
        ptePtradeDomain.setPaymentNotifyurl("cp.recharge.updateRechargeStatubyTrade");
        PtradeBean ptradeBean = this.makeParticipant(cpRecharge);
        ptePtradeDomain.setPtradeBean(ptradeBean);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        String result = this.internalInvoke("pte.ptrade.sendSavePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("cp.CpRechargeServiceImpl.sendPay.send", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
    }

    @Override
    public void updateRecharge(CpRechargeDomain cpRechargeDomain) throws ApiException {
        String msg = this.checkRecharge(cpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRecharge.checkRecharge", msg);
        }
        CpRecharge oldCpRecharge = this.getRechargeModelById(cpRechargeDomain.getRechargeId());
        if (null == oldCpRecharge) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRecharge.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CpRecharge cpRecharge = this.makeRecharge(cpRechargeDomain, oldCpRecharge);
        this.setRechargeUpdataDefault(cpRecharge);
        this.updateRechargeModel(cpRecharge);
    }

    @Override
    public CpRecharge getRecharge(Integer rechargeId) {
        return this.getRechargeModelById(rechargeId);
    }

    @Override
    public void deleteRecharge(Integer rechargeId) throws ApiException {
        CpRecharge cpRecharge = this.getRechargeModelById(rechargeId);
        if (null == cpRecharge) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRecharge.null", "\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        if (cpRecharge.getRechargeMode().equals("0") || cpRecharge.getDataState() == 2) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRecharge.null", "\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.deleteRechargeModel(rechargeId);
    }

    @Override
    public QueryResult<CpRecharge> queryRechargePage(Map<String, Object> map) {
        List<CpRecharge> cpRechargeList = this.queryRechargeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecharge(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cpRechargeList);
        return queryResult;
    }

    @Override
    public CpRecharge getRechargeByCode(Map<String, Object> map) {
        return this.getRechargeModelByCode(map);
    }

    @Override
    public void delRechargeByCode(Map<String, Object> map) throws ApiException {
        this.delRechargeModelByCode(map);
    }

    @Override
    public boolean updateRechargeStatubyTrade(Map<String, Object> map) {
        Integer dataState;
        if (map == null) {
            this.logger.error("cp.CpRechargeServiceImpl.updateRechargeStatubyTrade.null", (Object)"\u53c2\u6570\u4e3a\u7a7a\uff01");
            return false;
        }
        this.logger.info("cp.CpRechargeServiceImpl.updateRechargeStatubyTrade.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        String rechargeCode = map.get("businessOrderno") != null ? (String)map.get("businessOrderno") : null;
        String tenantCode = map.get("tenantCode") != null ? (String)map.get("tenantCode") : null;
        Integer n = dataState = map.get("dataState") != null ? (Integer)map.get("dataState") : null;
        if (StringUtils.isBlank((String)rechargeCode) || dataState == null) {
            this.logger.error("cp.CpRechargeServiceImpl.updateRechargeStatubyTrade.null", (Object)"rechargeCode or dataState is null\uff01");
            return false;
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("rechargeCode", rechargeCode);
        pmap.put("tenantCode", tenantCode);
        CpRecharge cpRecharge = this.getRechargeByCode(pmap);
        if (cpRecharge == null) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRechargeStatubyTrade.null", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (dataState == cpRecharge.getDataState()) {
            return true;
        }
        this.updateRechargeState(cpRecharge.getRechargeId(), dataState, cpRecharge.getDataState(), null);
        return true;
    }

    @Override
    public void saveRechargeTradeBack(String rechargeCode, String tenantCode) {
        if (StringUtils.isBlank((String)rechargeCode)) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRechargeTradeBack.null", "\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeCode", rechargeCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        CpRecharge recharge = this.getRechargeByCode(map);
        if (recharge == null) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRechargeTradeBack.null", "\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
        }
        ConcurrentHashMap<String, String> queryMap = new ConcurrentHashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("acquireSeqno", rechargeCode);
        queryMap.put("ptradpdeCode", "CHARGEBACK");
        this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", queryMap);
        recharge.setDataState(3);
        this.updateRechargeModel(recharge);
    }

    @Override
    public String saveRechargeOne(CpRechargeDomain cpRechargeDomain) throws ApiException {
        this.logger.error("cp.CpRechargeServiceImpl.saveRechargeOne", (Object)"\u8fdb\u5165\u4e86saveRechargeOne\u65b9\u6cd5");
        if (null == cpRechargeDomain) {
            return null;
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getUserinfoCode())) {
            return "\u7528\u6237\u4ee3\u7801\u4e3a\u7a7a";
        }
        UmUserinfoDomainBean umUserinfoDomainBean = this.getUmUserinfoDomainBean(cpRechargeDomain.getUserinfoCode(), cpRechargeDomain.getTenantCode());
        if (null == umUserinfoDomainBean) {
            return "\u7528\u6237\u4e0d\u5b58\u5728";
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getRechargeOpcode()) && StringUtils.isNotBlank((String)cpRechargeDomain.getRechargeCode())) {
            cpRechargeDomain.setRechargeOpcode(cpRechargeDomain.getRechargeCode());
        }
        cpRechargeDomain.setRechargeMode("1");
        cpRechargeDomain.setUserinfoName(umUserinfoDomainBean.getUserinfoCompname());
        if (StringUtils.isBlank((String)cpRechargeDomain.getRechargeType())) {
            cpRechargeDomain.setRechargeType("Z1");
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getFundType())) {
            cpRechargeDomain.setFundType("01");
        }
        String type = cpRechargeDomain.getUserinfoCode().substring(0, 1);
        cpRechargeDomain.setRechargeCategory(type);
        String fundType = cpRechargeDomain.getFundType();
        if (StringUtils.isBlank((String)fundType)) {
            fundType = "01";
        }
        String faccountType = "1" + fundType;
        if ("2".equals(type)) {
            faccountType = "2" + fundType;
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getFaccountId()) && StringUtils.isNotBlank((String)cpRechargeDomain.getUserinfoCode())) {
            VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(cpRechargeDomain.getUserinfoCode(), faccountType, cpRechargeDomain.getTenantCode());
            if (null == vdFaccountInfo) {
                return "\u7528\u6237\u8d26\u6237\u4e3a\u7a7a";
            }
            cpRechargeDomain.setFchannelClassifyCode(faccountType);
            cpRechargeDomain.setFchannelCode("0" + type);
            cpRechargeDomain.setFchannelPmodeCode("web");
            cpRechargeDomain.setFaccountId(vdFaccountInfo.getFaccountOuterNo());
            cpRechargeDomain.setRechargeName(vdFaccountInfo.getFaccountOuterName());
        }
        String code = this.saveRecharge(cpRechargeDomain);
        this.logger.error("cp.CpRechargeServiceImpl.saveRechargeOne", (Object)"saveRecharge\u65b9\u6cd5\u6267\u884c\u5b8c\u6bd5");
        this.updateRechargeStateByCode(code, cpRechargeDomain.getTenantCode(), 2, null, null);
        return "success";
    }

    private UmUserinfoDomainBean getUmUserinfoDomainBean(String userinfoCode, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("userinfoCode", userinfoCode);
        pmap.put("tenantCode", tenantCode);
        UmUserinfoDomainBean umUserinfoDomainBean = (UmUserinfoDomainBean)this.getForObject("um.user.getUserinfoByCode", UmUserinfoDomainBean.class, pmap);
        return umUserinfoDomainBean;
    }

    private VdFaccountInfo getOuterFaccount(String merchantCode, String faccountType, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", tenantCode);
        List list = (List)this.readObj("vd.faccount.queryOuterFaccount", pmap, "list", new Object[]{VdFaccountInfo.class});
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (VdFaccountInfo)list.get(0);
    }

    private VdFaccountInfo savecrpRe(String merchantCode, String faccountType, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", tenantCode);
        List list = (List)this.readObj("vd.faccount.queryOuterFaccount", pmap, "list", new Object[]{VdFaccountInfo.class});
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (VdFaccountInfo)list.get(0);
    }

    @Override
    public String saveRechargeOneForString(String cpRechargeDomainStr) throws ApiException {
        CpRechargeDomain rechargeDomain = (CpRechargeDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(cpRechargeDomainStr, CpRechargeDomain.class);
        return this.saveRechargeOne(rechargeDomain);
    }

    @Override
    public Map<String, Object> queryRechargeSum(Map<String, Object> map) {
        try {
            return this.cpRechargeMapper.queryRechargeSum(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.queryContractModelSumModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public void updateRechargeStatebalance(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        BigDecimal balance = BigDecimal.ZERO;
        this.updateStateRechargeModel(rechargeId, dataState, oldDataState, map);
        if (2 == dataState) {
            CpRecharge cpRecharge = this.getRecharge(rechargeId);
            if (null == cpRecharge) {
                throw new ApiException("cp.CpRechargeServiceImpl.updateRechargeState.null");
            }
            String type = cpRecharge.getUserinfoCode().substring(0, 1);
            String fundType = cpRecharge.getFundType();
            if (StringUtils.isBlank((String)fundType)) {
                fundType = "01";
            }
            String faccountType = "1" + fundType;
            if ("2".equals(type)) {
                faccountType = "2" + fundType;
            }
            HashMap<String, String> smap = new HashMap<String, String>();
            HashMap<String, String> crpmap = new HashMap<String, String>();
            crpmap.put("fundType", "02");
            crpmap.put("userinfoCode", cpRecharge.getUserinfoCode());
            crpmap.put("tenantCod e", cpRecharge.getTenantCode());
            smap.put("map", JsonUtil.buildNonDefaultBinder().toJson(crpmap));
            String jsons = this.internalInvoke("crp.send.queryCrpUrechargePage", smap);
            QueryResult crpUrecharge = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(jsons, QueryResult.class);
            List crpUrechargeList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)crpUrecharge.getList()), CrpUrecharge.class);
            this.logger.error("crpUrechargeList++" + JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargeList));
            VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(cpRecharge.getUserinfoCode(), faccountType, cpRecharge.getTenantCode());
            this.logger.error("vdFaccountInfo+++" + JsonUtil.buildNonDefaultBinder().toJson((Object)vdFaccountInfo));
            if (null == vdFaccountInfo) {
                throw new ApiException("cp.CpRechargeServiceImpl.vdFaccountInfo.null");
            }
            smap.clear();
            crpmap.clear();
            crpmap.put("faccountOuterNo", vdFaccountInfo.getFaccountOuterNo());
            crpmap.put("fundType", "02");
            crpmap.put("tenantCode", vdFaccountInfo.getTenantCode());
            smap.put("map", JsonUtil.buildNonDefaultBinder().toJson(crpmap));
            String vdjson = this.internalInvoke("vd.faccountOuter.queryFaccountOuterSubsetPage", smap);
            if (StringUtils.isBlank((String)vdjson)) {
                this.logger.error("cp.CpRechargeServiceImpl.queryFaccountOuterSubsetPage.", (Object)("-" + JsonUtil.buildNormalBinder().toJson((Object)vdFaccountInfo)));
            }
            QueryResult VdFaccountOuterSubset2 = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(vdjson, QueryResult.class);
            List vdFaccountOuterSubsets = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)VdFaccountOuterSubset2.getList()), VdFaccountOuterSubset.class);
            this.logger.error("vdFaccountOuterSubsets+++" + JsonUtil.buildNonDefaultBinder().toJson((Object)vdFaccountOuterSubsets));
            VdFaccountOuterDtDomain vdFaccountOuterDtDomain = new VdFaccountOuterDtDomain();
            VdFaccountOuterSubset vdFaccountOuterSubset = (VdFaccountOuterSubset)vdFaccountOuterSubsets.get(0);
            vdFaccountOuterDtDomain.setOrderAmount(cpRecharge.getRechargeMoney());
            vdFaccountOuterDtDomain.setFundType("02");
            vdFaccountOuterDtDomain.setTenantCode(vdFaccountInfo.getTenantCode());
            vdFaccountOuterDtDomain.setFaccountOuterNo(vdFaccountInfo.getFaccountOuterNo());
            smap.clear();
            smap.put("vdFaccountOuterDtDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)vdFaccountOuterDtDomain));
            this.internalInvoke("vd.faccountOuter.saveFaccountOuterDt", smap);
            if (cpRecharge.getFundType().equals("02") && cpRecharge.getRechargeMoney().compareTo(BigDecimal.ZERO) == -1) {
                vdFaccountOuterSubset.setFaccountAmount(BigDecimal.ZERO);
                this.internalInvoke("vd.faccountOuter.updateFaccountOuterSubset", this.getQueryParamMap("vdFaccountOuterSubsetDomain", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterSubset)}));
                if (StringUtils.isNotBlank((String)cpRecharge.getUserinfoCode())) {
                    balance = cpRecharge.getRechargeMoney().add(vdFaccountInfo.getFaccountAmount());
                    if (balance.compareTo(BigDecimal.ZERO) == -1) {
                        if (crpUrechargeList.isEmpty()) {
                            this.logger.error("\u6dfb\u52a0\u4fe1\u4fdd");
                            CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
                            crpUrechargeDomain.setRechargeSmoney(balance);
                            crpUrechargeDomain.setFundType("02");
                            crpUrechargeDomain.setUserinfoCode(cpRecharge.getUserinfoCode());
                            crpUrechargeDomain.setTenantCode(cpRecharge.getTenantCode());
                            smap.clear();
                            smap.put("crpUrechargeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargeDomain));
                            String json = this.internalInvoke("crp.send.saveCrpUrecharge", smap);
                            if (StringUtils.isBlank((String)json)) {
                                throw new ApiException("cp.CpRechargeServiceImpl.saveCrpUrecharge.", "-" + JsonUtil.buildNormalBinder().toJson(smap));
                            }
                        } else {
                            smap.clear();
                            CrpUrecharge urecharge = (CrpUrecharge)crpUrechargeList.get(0);
                            urecharge.setRechargeSmoney(balance.add(urecharge.getRechargeSmoney()));
                            smap.put("crpUrechargeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)urecharge));
                            String json = this.internalInvoke("crp.send.updateCrpUrecharge", smap);
                            if (StringUtils.isBlank((String)json)) {
                                this.logger.error("cp.CpRechargeServiceImpl.json", (Object)"updateCrpUrecharge");
                            }
                        }
                    } else {
                        vdFaccountOuterSubset.setFaccountAmount(vdFaccountInfo.getFaccountAmount().add(cpRecharge.getRechargeMoney()));
                        this.internalInvoke("vd.faccountOuter.updateFaccountOuterSubset", this.getQueryParamMap("vdFaccountOuterSubsetDomain", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterSubset)}));
                    }
                }
            } else if (cpRecharge.getFundType().equals("02") && cpRecharge.getRechargeMoney().compareTo(BigDecimal.ZERO) == 1) {
                if (StringUtils.isNotBlank((String)cpRecharge.getUserinfoCode())) {
                    if (ListUtil.isNotEmpty((Collection)crpUrechargeList)) {
                        smap.clear();
                        CrpUrecharge userCharge = (CrpUrecharge)crpUrechargeList.get(0);
                        BigDecimal smoney = userCharge.getRechargeSmoney().add(cpRecharge.getRechargeMoney());
                        if (smoney.compareTo(BigDecimal.ZERO) >= 0) {
                            userCharge.setRechargeSmoney(BigDecimal.ZERO);
                            smap.put("crpUrechargeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)userCharge));
                            String json = this.internalInvoke("crp.send.updateCrpUrecharge", smap);
                            if (StringUtils.isBlank((String)json)) {
                                this.logger.error("cp.CpRechargeServiceImpl.json", (Object)"updateCrpUrecharge");
                            }
                            if (smoney.compareTo(BigDecimal.ZERO) != 0) {
                                vdFaccountOuterSubset.setFaccountAmount(vdFaccountInfo.getFaccountAmount().add(smoney));
                                this.internalInvoke("vd.faccountOuter.updateFaccountOuterSubset", this.getQueryParamMap("vdFaccountOuterSubsetDomain", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterSubset)}));
                            }
                        } else {
                            smap.clear();
                            smap.put("crpUrechargeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)userCharge));
                            userCharge.setRechargeSmoney(userCharge.getRechargeSmoney().subtract(smoney));
                            String json = this.internalInvoke("crp.send.updateCrpUrecharge", smap);
                            if (StringUtils.isBlank((String)json)) {
                                this.logger.error("cp.CpRechargeServiceImpl.json", (Object)"updateCrpUrecharge");
                            }
                        }
                    } else {
                        vdFaccountOuterSubset.setFaccountAmount(vdFaccountInfo.getFaccountAmount().add(cpRecharge.getRechargeMoney()));
                        this.internalInvoke("vd.faccountOuter.updateFaccountOuterSubset", this.getQueryParamMap("vdFaccountOuterSubsetDomain", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterSubset)}));
                    }
                }
            } else {
                this.sendPay(cpRecharge, map);
            }
        }
    }

    public static void main(String[] args) {
        BigDecimal a = BigDecimal.ZERO;
        BigDecimal b = BigDecimal.ZERO;
        if (a.compareTo(b) == 1) {
            System.out.println(111);
        }
    }

    @Override
    public void updateRechargeByvd() throws ApiException {
        HashMap<String, String> crpmap = new HashMap<String, String>();
        HashMap<String, String> smap = new HashMap<String, String>();
        BigDecimal balance = BigDecimal.ZERO;
        crpmap.put("tenantCode", "2019103100000001");
        crpmap.put("userinfoCode", "20000210311924");
        smap.put("map", JsonUtil.buildNonDefaultBinder().toJson(crpmap));
        String userjsons = this.internalInvoke("um.user.queryUserinfoPage", smap);
        if (null == userjsons) {
            this.logger.error("\u7528\u6237\u4e0d\u5b58\u5728" + JsonUtil.buildNonDefaultBinder().toJson(crpmap));
        }
        SupQueryResult userlist = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(userjsons, SupQueryResult.class);
        this.logger.error("userlist++" + JsonUtil.buildNonDefaultBinder().toJson((Object)userlist));
        List umUserinfoReDomainBeanList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userlist.getList()), UmUserinfoDomainBean.class);
        if (ListUtil.isNotEmpty((Collection)umUserinfoReDomainBeanList)) {
            for (UmUserinfoDomainBean umUserinfoDomainBean : umUserinfoReDomainBeanList) {
                VdFaccountOuterSubset vdFaccountOuterSubset;
                String type = umUserinfoDomainBean.getUserinfoCode().substring(0, 1);
                String fundType = "01";
                if (StringUtils.isBlank((String)fundType)) {
                    fundType = "01";
                }
                String faccountType = "1" + fundType;
                if ("2".equals(type)) {
                    faccountType = "2" + fundType;
                }
                VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(umUserinfoDomainBean.getUserinfoCode(), faccountType, umUserinfoDomainBean.getTenantCode());
                this.logger.error("cp.CpRechargeServiceImpl.vdFaccountInfo.null");
                if (null == vdFaccountInfo) {
                    this.logger.error("cp.CpRechargeServiceImpl.vdFaccountInfo.null");
                }
                this.logger.error("cp.CpRechargeServiceImpl.vdFaccountInfo+++" + JsonUtil.buildNonDefaultBinder().toJson((Object)vdFaccountInfo));
                smap.clear();
                crpmap.clear();
                crpmap.put("fundType", "01");
                crpmap.put("userinfoCode", umUserinfoDomainBean.getUserinfoCode());
                crpmap.put("tenantCode", umUserinfoDomainBean.getTenantCode());
                smap.put("map", JsonUtil.buildNonDefaultBinder().toJson(crpmap));
                String jsons = this.internalInvoke("crp.send.queryCrpUrechargePage", smap);
                if (null == userjsons) {
                    this.logger.error("\u7528\u6237\u4e0d\u5b58\u5728" + JsonUtil.buildNonDefaultBinder().toJson(crpmap));
                }
                balance = vdFaccountInfo.getFaccountAmount().add(new BigDecimal(-3));
                QueryResult crpUrecharge = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(jsons, QueryResult.class);
                List crpUrechargeList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)crpUrecharge.getList()), CrpUrecharge.class);
                smap.clear();
                crpmap.clear();
                crpmap.put("faccountOuterNo", vdFaccountInfo.getFaccountOuterNo());
                crpmap.put("fundType", "01");
                crpmap.put("tenantCode", vdFaccountInfo.getTenantCode());
                smap.put("map", JsonUtil.buildNonDefaultBinder().toJson(crpmap));
                String vdjson = this.internalInvoke("vd.faccountOuter.queryFaccountOuterSubsetPage", smap);
                if (StringUtils.isBlank((String)vdjson)) {
                    this.logger.error("cp.CpRechargeServiceImpl.queryFaccountOuterSubsetPage.", (Object)("-" + JsonUtil.buildNormalBinder().toJson((Object)vdFaccountInfo)));
                }
                QueryResult VdFaccountOuterSubset2 = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(vdjson, QueryResult.class);
                List vdFaccountOuterSubsets = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)VdFaccountOuterSubset2.getList()), VdFaccountOuterSubset.class);
                this.logger.error("vdFaccountOuterSubsets++" + JsonUtil.buildNonDefaultBinder().toJson((Object)vdFaccountOuterSubsets));
                VdFaccountOuterDtDomain vdFaccountOuterDtDomain = new VdFaccountOuterDtDomain();
                vdFaccountOuterDtDomain.setOrderAmount(new BigDecimal(3));
                vdFaccountOuterDtDomain.setFundType("01");
                vdFaccountOuterDtDomain.setTenantCode(umUserinfoDomainBean.getTenantCode());
                vdFaccountOuterDtDomain.setFaccountOuterNo(vdFaccountInfo.getFaccountOuterNo());
                smap.put("vdFaccountOuterDtDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)vdFaccountOuterDtDomain));
                this.internalInvoke("vd.faccountOuter.saveFaccountOuterDt", smap);
                if (balance.compareTo(BigDecimal.ZERO) == -1) {
                    String json;
                    if (ListUtil.isNotEmpty((Collection)vdFaccountOuterSubsets)) {
                        vdFaccountOuterSubset = (VdFaccountOuterSubset)vdFaccountOuterSubsets.get(0);
                        vdFaccountOuterSubset.setFaccountAmount(BigDecimal.ZERO);
                        this.internalInvoke("vd.faccountOuter.updateFaccountOuterSubset", this.getQueryParamMap("vdFaccountOuterSubsetDomain", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterSubset)}));
                    }
                    if (ListUtil.isEmpty((Collection)crpUrechargeList)) {
                        smap.clear();
                        CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
                        crpUrechargeDomain.setRechargeSmoney(balance);
                        crpUrechargeDomain.setFundType("01");
                        crpUrechargeDomain.setUserinfoCode(umUserinfoDomainBean.getUserinfoCode());
                        crpUrechargeDomain.setTenantCode(umUserinfoDomainBean.getTenantCode());
                        smap.put("crpUrechargeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargeDomain));
                        json = this.internalInvoke("crp.send.saveCrpUrecharge", smap);
                        if (!StringUtils.isBlank((String)json)) continue;
                        this.logger.error("cp.CpRechargeServiceImpl.saveCrpUrecharge.", (Object)("-" + JsonUtil.buildNormalBinder().toJson(smap)));
                        continue;
                    }
                    smap.clear();
                    CrpUrecharge urecharge = (CrpUrecharge)crpUrechargeList.get(0);
                    urecharge.setRechargeSmoney(balance.add(urecharge.getRechargeSmoney()));
                    smap.put("crpUrechargeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)urecharge));
                    json = this.internalInvoke("crp.send.updateCrpUrecharge", smap);
                    if (!StringUtils.isBlank((String)json)) continue;
                    this.logger.error("cp.CpRechargeServiceImpl.json", (Object)"updateCrpUrecharge");
                    continue;
                }
                if (!ListUtil.isNotEmpty((Collection)vdFaccountOuterSubsets)) continue;
                vdFaccountOuterSubset = (VdFaccountOuterSubset)vdFaccountOuterSubsets.get(0);
                vdFaccountOuterSubset.setFaccountAmount(balance);
                this.internalInvoke("vd.faccountOuter.updateFaccountOuterSubset", this.getQueryParamMap("vdFaccountOuterSubsetDomain", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterSubset)}));
            }
        }
    }

    @Override
    public String sendRechargeCrp(CpRechargeDomain cpRechargeDomain) throws ApiException {
        this.logger.error("cp.CpRechargeServiceImpl.sendRechargeCrp" + JsonUtil.buildNonDefaultBinder().toJson((Object)cpRechargeDomain));
        CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargeDomain, (Object)cpRechargeDomain);
            crpUrechargeDomain.setRechargeAllmoney(cpRechargeDomain.getRechargeMoney());
            crpUrechargeDomain.setRechargeSmoney(cpRechargeDomain.getRechargeMoney());
            crpUrechargeDomain.setUserinfoCode(cpRechargeDomain.getUserinfoCode());
            crpUrechargeDomain.setUserinfoName(cpRechargeDomain.getUserName());
            crpUrechargeDomain.setRechargeName2(cpRechargeDomain.getUserinfoName());
            crpUrechargeDomain.setRechargeUrl4(cpRechargeDomain.getRechargeUname());
            crpUrechargeDomain.setRechargeOpcode(cpRechargeDomain.getRechargeUname());
            crpUrechargeDomain.setRechargeName10("\u6388\u4fe1\u8fd4\u8fd8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("crpUrechargeDomain", JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargeDomain));
            String saveCrpUrecharge = this.internalInvoke("crp.send.sendsaveCrpUrecharge", map);
            if (StringUtils.isNotBlank((String)saveCrpUrecharge)) {
                return "success";
            }
            return "error";
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
            return "error";
        }
    }

    @Override
    public String saveRechargeOneNew(CpRechargeDomain cpRechargeDomain) throws ApiException {
        this.logger.error("cp.CpRechargeServiceImpl.saveRechargeOneNew", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpRechargeDomain));
        if (null == cpRechargeDomain) {
            return null;
        }
        String code = this.saveRecharge(cpRechargeDomain);
        this.logger.error("cp.CpRechargeServiceImpl.saveRechargeOneNew", (Object)"saveRecharge\u65b9\u6cd5\u6267\u884c\u5b8c\u6bd5");
        this.updateRechargeStateByCode(code, cpRechargeDomain.getTenantCode(), 2, null, null);
        return "success";
    }
}

