/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcCflowMapper;
import com.yqbsoft.laser.service.contract.dao.OcCflowNodeMapper;
import com.yqbsoft.laser.service.contract.domain.OcCflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowNodeDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowNodeReDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowReDomain;
import com.yqbsoft.laser.service.contract.es.ContractQueryCall;
import com.yqbsoft.laser.service.contract.model.OcCflow;
import com.yqbsoft.laser.service.contract.model.OcCflowNode;
import com.yqbsoft.laser.service.contract.service.OcCflowService;
import com.yqbsoft.laser.service.contract.service.impl.CflowPollThread;
import com.yqbsoft.laser.service.contract.service.impl.CflowService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class OcCflowServiceImpl
extends BaseServiceImpl
implements OcCflowService {
    public static final String SYS_CODE = "oc.CONTRACT.OcCflowServiceImpl";
    public static final String CACHE_KEY_CFLOW = "ocProtCflow";
    public static final String CACHE_KEY_CFLOWNODE = "ocProtCflowNode";
    public static final String CACHE_KEY_PARENTCFLOWNODE = "ocProtCflowNodeByParent";
    private static CflowService cflowService;
    private static Object lock;
    private OcCflowMapper ocCflowMapper;
    private OcCflowNodeMapper ocCflowNodeMapper;

    public void setOcCflowMapper(OcCflowMapper ocCflowMapper) {
        this.ocCflowMapper = ocCflowMapper;
    }

    public void setOcCflowNodeMapper(OcCflowNodeMapper ocCflowNodeMapper) {
        this.ocCflowNodeMapper = ocCflowNodeMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocCflowMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCflow(OcCflowDomain ocCflowDomain) {
        if (null == ocCflowDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocCflowDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCflowDefault(OcCflow ocCflow) {
        if (null == ocCflow) {
            return;
        }
        if (null == ocCflow.getDataState()) {
            ocCflow.setDataState(0);
        }
        if (null == ocCflow.getGmtCreate()) {
            ocCflow.setGmtCreate(this.getSysDate());
        }
        ocCflow.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ocCflowMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCflowUpdataDefault(OcCflow ocCflow) {
        if (null == ocCflow) {
            return;
        }
        ocCflow.setGmtModified(this.getSysDate());
    }

    private void saveCflowModel(OcCflow ocCflow) throws ApiException {
        if (null == ocCflow) {
            return;
        }
        try {
            this.ocCflowMapper.insert(ocCflow);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.saveCflowModel.ex", (Throwable)e);
        }
    }

    private OcCflow getCflowModelById(Integer cflowId) {
        if (null == cflowId) {
            return null;
        }
        try {
            return this.ocCflowMapper.selectByPrimaryKey(cflowId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.getCflowModelById", (Throwable)e);
            return null;
        }
    }

    public OcCflow getCflowModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocCflowMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.getCflowModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCflowModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocCflowMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.delCflowModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.delCflowModelByCode.num");
        }
    }

    private void deleteCflowModel(Integer cflowId) throws ApiException {
        if (null == cflowId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocCflowMapper.deleteByPrimaryKey(cflowId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.deleteCflowModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.deleteCflowModel.num");
        }
    }

    private void updateCflowModel(OcCflow ocCflow) throws ApiException {
        if (null == ocCflow) {
            return;
        }
        try {
            this.ocCflowMapper.updateByPrimaryKeySelective(ocCflow);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateCflowModel.ex", (Throwable)e);
        }
    }

    private void updateStateCflowModel(Integer cflowId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cflowId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowId", cflowId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocCflowMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateStateCflowModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateStateCflowModel.null");
        }
    }

    private OcCflow makeCflow(OcCflowDomain ocCflowDomain, OcCflow ocCflow) {
        if (null == ocCflowDomain) {
            return null;
        }
        if (null == ocCflow) {
            ocCflow = new OcCflow();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocCflow, (Object)ocCflowDomain);
            return ocCflow;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.makeCflow", (Throwable)e);
            return null;
        }
    }

    private OcCflowReDomain makeReCflow(OcCflow ocCflow) {
        if (null == ocCflow) {
            return null;
        }
        OcCflowReDomain ocCflowReDomain = new OcCflowReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocCflowReDomain, (Object)ocCflow);
            return ocCflowReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.makeReCflow", (Throwable)e);
            return null;
        }
    }

    private List<OcCflow> queryCflowModelPage(Map<String, Object> parammap) {
        try {
            return this.ocCflowMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.queryCflowModel", (Throwable)e);
            return null;
        }
    }

    private int countCflow(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocCflowMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.countCflow", (Throwable)e);
        }
        return i;
    }

    private String checkCflowNode(OcCflowNodeDomain ocCflowNodeDomain) {
        if (null == ocCflowNodeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocCflowNodeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCflowNodeDefault(OcCflowNode ocCflowNode) {
        if (null == ocCflowNode) {
            return;
        }
        if (null == ocCflowNode.getDataState()) {
            ocCflowNode.setDataState(0);
        }
        if (null == ocCflowNode.getGmtCreate()) {
            ocCflowNode.setGmtCreate(this.getSysDate());
        }
        ocCflowNode.setGmtModified(this.getSysDate());
    }

    private int getCflowNodeMaxCode() {
        int code = 0;
        try {
            return this.ocCflowNodeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.getCflowNodeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCflowNodeUpdataDefault(OcCflowNode ocCflowNode) {
        if (null == ocCflowNode) {
            return;
        }
        ocCflowNode.setGmtModified(this.getSysDate());
    }

    private void saveCflowNodeModel(OcCflowNode ocCflowNode) throws ApiException {
        if (null == ocCflowNode) {
            return;
        }
        try {
            this.ocCflowNodeMapper.insert(ocCflowNode);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.saveCflowNodeModel.ex", (Throwable)e);
        }
    }

    private OcCflowNode getCflowNodeModelById(Integer cflowNodeId) {
        if (null == cflowNodeId) {
            return null;
        }
        try {
            return this.ocCflowNodeMapper.selectByPrimaryKey(cflowNodeId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.getCflowNodeModelById", (Throwable)e);
            return null;
        }
    }

    public OcCflowNode getCflowNodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocCflowNodeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.getCflowNodeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCflowNodeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocCflowNodeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.delCflowNodeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.delCflowNodeModelByCode.num");
        }
    }

    private void deleteCflowNodeModel(Integer cflowNodeId) throws ApiException {
        if (null == cflowNodeId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocCflowNodeMapper.deleteByPrimaryKey(cflowNodeId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.deleteCflowNodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.deleteCflowNodeModel.num");
        }
    }

    private void updateCflowNodeModel(OcCflowNode ocCflowNode) throws ApiException {
        if (null == ocCflowNode) {
            return;
        }
        try {
            this.ocCflowNodeMapper.updateByPrimaryKeySelective(ocCflowNode);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateCflowNodeModel.ex", (Throwable)e);
        }
    }

    private void updateStateCflowNodeModel(Integer cflowNodeId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == cflowNodeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowNodeId", cflowNodeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocCflowNodeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateStateCflowNodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateStateCflowNodeModel.null");
        }
    }

    private OcCflowNode makeCflowNode(OcCflowNodeDomain ocCflowNodeDomain, OcCflowNode ocCflowNode) {
        if (null == ocCflowNodeDomain) {
            return null;
        }
        if (null == ocCflowNode) {
            ocCflowNode = new OcCflowNode();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocCflowNode, (Object)ocCflowNodeDomain);
            return ocCflowNode;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.makeCflowNode", (Throwable)e);
            return null;
        }
    }

    private OcCflowNodeReDomain makeReCflowNode(OcCflowNode ocCflowNode) {
        if (null == ocCflowNode) {
            return null;
        }
        OcCflowNodeReDomain ocCflowNodeReDomain = new OcCflowNodeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocCflowNodeReDomain, (Object)ocCflowNode);
            ocCflowNodeReDomain.setMap(ContractQueryCall.makeMnNode(ocCflowNodeReDomain));
            return ocCflowNodeReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.makeReCflowNode", (Throwable)e);
            return null;
        }
    }

    private List<OcCflowNodeReDomain> makeReCflowNodeList(List<OcCflowNode> ocCflowNodeList) {
        if (null == ocCflowNodeList || ocCflowNodeList.isEmpty()) {
            return null;
        }
        ArrayList<OcCflowNodeReDomain> nodeReList = new ArrayList<OcCflowNodeReDomain>();
        for (OcCflowNode ocCflowNode : ocCflowNodeList) {
            nodeReList.add(this.makeReCflowNode(ocCflowNode));
        }
        return nodeReList;
    }

    private List<OcCflowNode> queryCflowNodeModelPage(Map<String, Object> parammap) {
        try {
            return this.ocCflowNodeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.queryCflowNodeModel", (Throwable)e);
            return null;
        }
    }

    private int countCflowNode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocCflowNodeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcCflowServiceImpl.countCflowNode", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveCflow(OcCflowDomain ocCflowDomain) throws ApiException {
        String msg = this.checkCflow(ocCflowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.saveCflow.checkCflow", msg);
        }
        OcCflow ocCflow = this.makeCflow(ocCflowDomain, null);
        this.setCflowDefault(ocCflow);
        this.saveCflowModel(ocCflow);
    }

    @Override
    public void updateCflowState(Integer cflowId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCflowModel(cflowId, dataState, oldDataState);
    }

    @Override
    public void updateCflow(OcCflowDomain ocCflowDomain) throws ApiException {
        String msg = this.checkCflow(ocCflowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateCflow.checkCflow", msg);
        }
        OcCflow oldOcCflow = this.getCflowModelById(ocCflowDomain.getCflowId());
        if (null == oldOcCflow) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateCflow.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcCflow ocCflow = this.makeCflow(ocCflowDomain, oldOcCflow);
        this.setCflowUpdataDefault(ocCflow);
        this.updateCflowModel(ocCflow);
    }

    @Override
    public OcCflow getCflow(Integer cflowId) {
        return this.getCflowModelById(cflowId);
    }

    @Override
    public OcCflowReDomain getCflowByPaypdCode(String dicPaypdCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dicPaypdCode", dicPaypdCode);
        map.put("tenantCode", tenantCode);
        List<OcCflow> ocCflowList = this.queryCflowModelPage(map);
        if (null == ocCflowList || ocCflowList.isEmpty()) {
            return null;
        }
        OcCflow ocCflow = ocCflowList.get(0);
        OcCflowReDomain ocCflowReDomain = this.makeReCflow(ocCflow);
        if (null == ocCflowReDomain) {
            return null;
        }
        List<OcCflowNodeReDomain> nodeReList = this.queryNodeNext(tenantCode, ocCflowReDomain.getCflowCode(), ocCflowReDomain.getCflowCode());
        ocCflowReDomain.setNodeReList(nodeReList);
        return ocCflowReDomain;
    }

    @Override
    public List<OcCflowNodeReDomain> queryCflowNodeNext(String cflowCode, String cflowNodeParentcode, String tenantCode) {
        return this.queryNodeNext(tenantCode, cflowNodeParentcode, cflowCode);
    }

    private List<OcCflowNodeReDomain> queryNodeNext(String tenantCode, String cflowNodeParentcode, String cflowCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cflowCode", cflowCode);
        map.put("cflowNodeParentcode", cflowNodeParentcode);
        map.put("orderStr", "CFLOW_NODE_INDEX");
        map.put("order", true);
        List<OcCflowNodeReDomain> nodeReList = this.makeReCflowNodeList(this.queryCflowNodeModelPage(map));
        if (null == nodeReList || nodeReList.isEmpty()) {
            return null;
        }
        return nodeReList;
    }

    public void createNodeChildren(String tenantCode, List<OcCflowNodeReDomain> nodeReList) {
        if (null == nodeReList || nodeReList.isEmpty()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        for (OcCflowNodeReDomain ocCflowNodeReDomain : nodeReList) {
            map.put("cflowCode", ocCflowNodeReDomain.getCflowCode());
            map.put("cflowNodeParentcode", ocCflowNodeReDomain.getCflowNodeCode());
            List<OcCflowNodeReDomain> nodeReChildrenList = this.makeReCflowNodeList(this.queryCflowNodeModelPage(map));
            if (null == nodeReChildrenList || nodeReChildrenList.isEmpty()) continue;
            ocCflowNodeReDomain.setChildren(nodeReChildrenList);
            this.createNodeChildren(tenantCode, nodeReChildrenList);
        }
    }

    @Override
    public void deleteCflow(Integer cflowId) throws ApiException {
        this.deleteCflowModel(cflowId);
    }

    @Override
    public QueryResult<OcCflow> queryCflowPage(Map<String, Object> map) {
        List<OcCflow> ocCflowList = this.queryCflowModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCflow(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocCflowList);
        return queryResult;
    }

    @Override
    public void saveCflowNode(OcCflowNodeDomain ocCflowNodeDomain) throws ApiException {
        String msg = this.checkCflowNode(ocCflowNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.saveCflowNode.checkCflowNode", msg);
        }
        OcCflowNode ocCflowNode = this.makeCflowNode(ocCflowNodeDomain, null);
        this.setCflowNodeDefault(ocCflowNode);
        this.saveCflowNodeModel(ocCflowNode);
    }

    @Override
    public void updateCflowNodeState(Integer cflowNodeId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCflowNodeModel(cflowNodeId, dataState, oldDataState);
    }

    @Override
    public void updateCflowNode(OcCflowNodeDomain ocCflowNodeDomain) throws ApiException {
        String msg = this.checkCflowNode(ocCflowNodeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateCflowNode.checkCflowNode", msg);
        }
        OcCflowNode oldOcCflowNode = this.getCflowNodeModelById(ocCflowNodeDomain.getCflowNodeId());
        if (null == oldOcCflowNode) {
            throw new ApiException("oc.CONTRACT.OcCflowServiceImpl.updateCflowNode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcCflowNode ocCflowNode = this.makeCflowNode(ocCflowNodeDomain, oldOcCflowNode);
        this.setCflowNodeUpdataDefault(ocCflowNode);
        this.updateCflowNodeModel(ocCflowNode);
    }

    @Override
    public OcCflowNode getCflowNode(Integer cflowNodeId) {
        return this.getCflowNodeModelById(cflowNodeId);
    }

    @Override
    public OcCflowNode getCflowNodeByCode(String cflowNodeCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cflowNodeCode", cflowNodeCode);
        map.put("tenantCode", tenantCode);
        return this.getCflowNodeModelByCode(map);
    }

    @Override
    public void deleteCflowNode(Integer cflowNodeId) throws ApiException {
        this.deleteCflowNodeModel(cflowNodeId);
    }

    @Override
    public QueryResult<OcCflowNode> queryCflowNodePage(Map<String, Object> map) {
        List<OcCflowNode> ocCflowNodeList = this.queryCflowNodeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCflowNode(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocCflowNodeList);
        return queryResult;
    }

    @Override
    public void queryCflowCache() {
        this.info("oc.CONTRACT.OcCflowServiceImpl.queryCflowCache.start", "=======\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataState", 1L);
        List<OcCflow> cflowList = this.queryCflowModelPage(params);
        if (CollectionUtils.isEmpty(cflowList)) {
            DisUtil.delVer((String)CACHE_KEY_CFLOW);
            DisUtil.delVer((String)CACHE_KEY_CFLOWNODE);
            DisUtil.delVer((String)CACHE_KEY_PARENTCFLOWNODE);
            this.info("oc.CONTRACT.OcCflowServiceImpl.queryCflowCache.null", "=======\u8c03\u5ea6end=======");
            return;
        }
        HashMap<String, String> mmap = new HashMap<String, String>();
        HashMap<String, String> nodemap = new HashMap<String, String>();
        HashMap<String, String> nodeparentmap = new HashMap<String, String>();
        String key = "";
        for (OcCflow ocCflow : cflowList) {
            OcCflowReDomain ocCflowReDomain = this.makeCache(ocCflow);
            key = ocCflowReDomain.getDicPaypdCode();
            if (StringUtils.isNotBlank((String)ocCflowReDomain.getProappCode())) {
                key = key + "-" + ocCflowReDomain.getProappCode();
            }
            if (StringUtils.isNotBlank((String)ocCflowReDomain.getChannelCode())) {
                key = key + "-" + ocCflowReDomain.getChannelCode();
            }
            if (StringUtils.isNotBlank((String)ocCflowReDomain.getGoodsClass())) {
                key = key + "-" + ocCflowReDomain.getGoodsClass();
            }
            key = key + "-" + ocCflowReDomain.getTenantCode();
            mmap.put(key, JsonUtil.buildNormalBinder().toJson((Object)ocCflowReDomain));
        }
        params.put("orderStr", "CFLOW_NODE_INDEX");
        params.put("order", true);
        List<OcCflowNode> nodeList = this.queryCflowNodeModelPage(params);
        if (null == nodeList || nodeList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY_CFLOWNODE);
            DisUtil.delVer((String)CACHE_KEY_PARENTCFLOWNODE);
            return;
        }
        String nodekey = "";
        String parkey = "";
        String str = "";
        List nodeParentList = null;
        for (OcCflowNode ocCflowNode : nodeList) {
            nodekey = ocCflowNode.getCflowCode() + "-" + ocCflowNode.getCflowNodeCode() + "-" + ocCflowNode.getTenantCode();
            nodemap.put(nodekey, JsonUtil.buildNormalBinder().toJson((Object)ocCflowNode));
            parkey = ocCflowNode.getCflowCode() + "-" + ocCflowNode.getCflowNodeParentcode() + "-" + ocCflowNode.getTenantCode();
            str = (String)nodeparentmap.get(parkey);
            nodeParentList = StringUtils.isNotBlank((String)str) ? JsonUtil.buildNormalBinder().getJsonToList(str, OcCflowNodeReDomain.class) : new ArrayList();
            nodeParentList.add(this.makeReCflowNode(ocCflowNode));
            nodeparentmap.put(parkey, JsonUtil.buildNormalBinder().toJson(nodeParentList));
        }
        for (Map.Entry entry : mmap.entrySet()) {
            DisUtil.setMap((String)CACHE_KEY_CFLOW, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        for (Map.Entry entry : nodemap.entrySet()) {
            DisUtil.setMap((String)CACHE_KEY_CFLOWNODE, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        for (Map.Entry entry : nodeparentmap.entrySet()) {
            DisUtil.setMap((String)CACHE_KEY_PARENTCFLOWNODE, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        this.info("oc.CONTRACT.OcCflowServiceImpl.queryCflowCache.end", "=======\u8c03\u5ea6end=======");
    }

    private OcCflowReDomain makeCache(OcCflow ocCflow) {
        if (null == ocCflow) {
            return null;
        }
        OcCflowReDomain ocCflowReDomain = this.makeReCflow(ocCflow);
        if (null == ocCflowReDomain) {
            return null;
        }
        List<OcCflowNodeReDomain> nodeReList = this.queryNodeNext(ocCflow.getTenantCode(), ocCflowReDomain.getCflowCode(), ocCflowReDomain.getCflowCode());
        if (ListUtil.isEmpty(nodeReList) && !"00000000".equals(ocCflow.getTenantCode())) {
            nodeReList = this.queryNodeNext("00000000", ocCflowReDomain.getCflowCode(), ocCflowReDomain.getCflowCode());
        }
        this.makeReDomain(nodeReList);
        ocCflowReDomain.setNodeReList(nodeReList);
        return ocCflowReDomain;
    }

    private void makeReDomain(List<OcCflowNodeReDomain> nodeReList) {
        if (ListUtil.isEmpty(nodeReList)) {
            return;
        }
        String main = "";
        String node = "";
        for (OcCflowNodeReDomain ocCflowNodeReDomain : nodeReList) {
            ocCflowNodeReDomain.setMap(ContractQueryCall.makeMnNode(ocCflowNodeReDomain));
            main = ContractQueryCall.getMnNodeMnMain(ocCflowNodeReDomain);
            if (StringUtils.isNotBlank((String)main)) {
                node = ContractQueryCall.getMnNodeMnNode(ocCflowNodeReDomain);
                DisUtil.setMap((String)("OC_FLOW_NODEMN-main-" + main), (String)node, (String)node);
                DisUtil.set((String)("OC_FLOW_NODEMN-node-" + node), (String)main);
            }
            if (!StringUtils.isNotBlank((String)(main = ContractQueryCall.getMbNodeMnMain(ocCflowNodeReDomain)))) continue;
            node = ContractQueryCall.getMbNodeMnNode(ocCflowNodeReDomain);
            DisUtil.setMap((String)("OC_FLOW_NODEMB-main-" + main), (String)node, (String)node);
            DisUtil.set((String)("OC_FLOW_NODEMN-node-" + node), (String)main);
        }
    }

    @Override
    public void saveCflowInit(String tenantCode) {
        List<OcCflow> cflowList = this.queryCflowModelPage(this.getQueryParamMap("tenantCode,dataState", new Object[]{"00000000", 1L}));
        List<OcCflowNode> list = this.queryCflowNodeModelPage(this.getQueryParamMap("tenantCode,dataState", new Object[]{"00000000", 1L}));
        HashMap map = new HashMap();
        for (OcCflowNode node : list) {
            ArrayList<OcCflowNode> nodelist = (ArrayList<OcCflowNode>)map.get(node.getCflowCode());
            if (null == nodelist) {
                nodelist = new ArrayList<OcCflowNode>();
            }
            node.setTenantCode(tenantCode);
            node.setCflowNodeId(null);
            nodelist.add(node);
            map.put(node.getCflowCode(), nodelist);
        }
        for (OcCflow cflow : cflowList) {
            cflow.setTenantCode(tenantCode);
            cflow.setCflowId(null);
            cflow.setOcCflowNodeList((List)map.get(cflow.getCflowCode()));
        }
        this.getCflowService().putQueue(cflowList);
    }

    @Override
    public void saveCflowByList(List<OcCflow> list) {
        if (null == list || list.size() == 0) {
            return;
        }
        for (OcCflow cflow : list) {
            this.saveCflowModel(cflow);
            for (OcCflowNode node : cflow.getOcCflowNodeList()) {
                this.saveCflowNodeModel(node);
            }
        }
        this.queryCflowCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CflowService getCflowService() {
        Object object = lock;
        synchronized (object) {
            if (null == cflowService) {
                cflowService = new CflowService((OcCflowService)SpringApplicationContextUtil.getBean((String)"ocCflowService"));
                cflowService.addPollPool(new CflowPollThread(cflowService));
            }
            return cflowService;
        }
    }

    static {
        lock = new Object();
    }
}

