/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRemainContractMapper;
import com.yqbsoft.laser.service.contract.domain.OcRemainContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcRemainContractReDomain;
import com.yqbsoft.laser.service.contract.model.OcRemainContract;
import com.yqbsoft.laser.service.contract.service.OcRemainContractService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRemainContractServiceImpl
extends BaseServiceImpl
implements OcRemainContractService {
    private static final String SYS_CODE = "oc.CONTRACT.OcRemainContractServiceImpl";
    private OcRemainContractMapper ocRemainContractMapper;

    public void setOcRemainContractMapper(OcRemainContractMapper ocRemainContractMapper) {
        this.ocRemainContractMapper = ocRemainContractMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRemainContractMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRemainContractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOcRemainContract(OcRemainContractDomain ocRemainContractDomain) {
        if (null == ocRemainContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRemainContractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOcRemainContractDefault(OcRemainContract ocRemainContract) {
        if (null == ocRemainContract) {
            return;
        }
        if (null == ocRemainContract.getDataState()) {
            ocRemainContract.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocRemainContract.getGmtCreate()) {
            ocRemainContract.setGmtCreate(date);
        }
        ocRemainContract.setGmtModified(date);
        if (StringUtils.isBlank((String)ocRemainContract.getRemainContractCode())) {
            ocRemainContract.setRemainContractCode(this.getNo(null, "OcRemainContract", "ocRemainContract", ocRemainContract.getTenantCode()));
        }
    }

    private int getOcRemainContractMaxCode() {
        int code = 0;
        try {
            return this.ocRemainContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRemainContractServiceImpl.getOcRemainContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOcRemainContractUpdataDefault(OcRemainContract ocRemainContract) {
        if (null == ocRemainContract) {
            return;
        }
        ocRemainContract.setGmtModified(this.getSysDate());
    }

    private void saveOcRemainContractModel(OcRemainContract ocRemainContract) throws ApiException {
        if (null == ocRemainContract) {
            return;
        }
        try {
            this.ocRemainContractMapper.insert(ocRemainContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.saveOcRemainContractModel.ex", (Throwable)e);
        }
    }

    private void saveOcRemainContractBatchModel(List<OcRemainContract> ocRemainContractList) throws ApiException {
        if (null == ocRemainContractList || ocRemainContractList.isEmpty()) {
            return;
        }
        try {
            this.ocRemainContractMapper.insertBatch(ocRemainContractList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.saveOcRemainContractBatchModel.ex", (Throwable)e);
        }
    }

    private OcRemainContract getOcRemainContractModelById(Integer remainContractId) {
        if (null == remainContractId) {
            return null;
        }
        try {
            return this.ocRemainContractMapper.selectByPrimaryKey(remainContractId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRemainContractServiceImpl.getOcRemainContractModelById", (Throwable)e);
            return null;
        }
    }

    private OcRemainContract getOcRemainContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRemainContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRemainContractServiceImpl.getOcRemainContractModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOcRemainContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRemainContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.delOcRemainContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.delOcRemainContractModelByCode.num");
        }
    }

    private void deleteOcRemainContractModel(Integer remainContractId) throws ApiException {
        if (null == remainContractId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRemainContractMapper.deleteByPrimaryKey(remainContractId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.deleteOcRemainContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.deleteOcRemainContractModel.num");
        }
    }

    private void updateOcRemainContractModel(OcRemainContract ocRemainContract) throws ApiException {
        if (null == ocRemainContract) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRemainContractMapper.updateByPrimaryKey(ocRemainContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.updateOcRemainContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.updateOcRemainContractModel.num");
        }
    }

    private void updateStateOcRemainContractModel(Integer remainContractId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == remainContractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("remainContractId", remainContractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRemainContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.updateStateOcRemainContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.updateStateOcRemainContractModel.null");
        }
    }

    private void updateStateOcRemainContractModelByCode(String tenantCode, String remainContractCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)remainContractCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("remainContractCode", remainContractCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRemainContractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.updateStateOcRemainContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.updateStateOcRemainContractModelByCode.null");
        }
    }

    private OcRemainContract makeOcRemainContract(OcRemainContractDomain ocRemainContractDomain, OcRemainContract ocRemainContract) {
        if (null == ocRemainContractDomain) {
            return null;
        }
        if (null == ocRemainContract) {
            ocRemainContract = new OcRemainContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRemainContract, (Object)ocRemainContractDomain);
            return ocRemainContract;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRemainContractServiceImpl.makeOcRemainContract", (Throwable)e);
            return null;
        }
    }

    private OcRemainContractReDomain makeOcRemainContractReDomain(OcRemainContract ocRemainContract) {
        if (null == ocRemainContract) {
            return null;
        }
        OcRemainContractReDomain ocRemainContractReDomain = new OcRemainContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRemainContractReDomain, (Object)ocRemainContract);
            return ocRemainContractReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRemainContractServiceImpl.makeOcRemainContractReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcRemainContract> queryOcRemainContractModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRemainContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRemainContractServiceImpl.queryOcRemainContractModel", (Throwable)e);
            return null;
        }
    }

    private int countOcRemainContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRemainContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRemainContractServiceImpl.countOcRemainContract", (Throwable)e);
        }
        return i;
    }

    private OcRemainContract createOcRemainContract(OcRemainContractDomain ocRemainContractDomain) {
        String msg = this.checkOcRemainContract(ocRemainContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.saveOcRemainContract.checkOcRemainContract", msg);
        }
        OcRemainContract ocRemainContract = this.makeOcRemainContract(ocRemainContractDomain, null);
        this.setOcRemainContractDefault(ocRemainContract);
        return ocRemainContract;
    }

    @Override
    public String saveOcRemainContract(OcRemainContractDomain ocRemainContractDomain) throws ApiException {
        OcRemainContract ocRemainContract = this.createOcRemainContract(ocRemainContractDomain);
        this.saveOcRemainContractModel(ocRemainContract);
        return ocRemainContract.getRemainContractCode();
    }

    @Override
    public String saveOcRemainContractBatch(List<OcRemainContractDomain> ocRemainContractDomainList) throws ApiException {
        if (null == ocRemainContractDomainList || ocRemainContractDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcRemainContract> ocRemainContractList = new ArrayList<OcRemainContract>();
        String code = "";
        for (OcRemainContractDomain ocRemainContractDomain : ocRemainContractDomainList) {
            OcRemainContract ocRemainContract = this.createOcRemainContract(ocRemainContractDomain);
            code = ocRemainContract.getRemainContractCode();
            ocRemainContractList.add(ocRemainContract);
        }
        this.saveOcRemainContractBatchModel(ocRemainContractList);
        return code;
    }

    @Override
    public void updateOcRemainContractState(Integer remainContractId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == remainContractId) {
            return;
        }
        this.updateStateOcRemainContractModel(remainContractId, dataState, oldDataState, map);
    }

    @Override
    public void updateOcRemainContractStateByCode(String tenantCode, String remainContractCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)remainContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOcRemainContractModelByCode(tenantCode, remainContractCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOcRemainContract(OcRemainContractDomain ocRemainContractDomain) throws ApiException {
        String msg = this.checkOcRemainContract(ocRemainContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.updateOcRemainContract.checkOcRemainContract", msg);
        }
        OcRemainContract oldOcRemainContract = this.getOcRemainContractModelById(ocRemainContractDomain.getRemainContractId());
        if (null == oldOcRemainContract) {
            throw new ApiException("oc.CONTRACT.OcRemainContractServiceImpl.updateOcRemainContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRemainContract ocRemainContract = this.makeOcRemainContract(ocRemainContractDomain, oldOcRemainContract);
        this.setOcRemainContractUpdataDefault(ocRemainContract);
        this.updateOcRemainContractModel(ocRemainContract);
    }

    @Override
    public OcRemainContract getOcRemainContract(Integer remainContractId) {
        if (null == remainContractId) {
            return null;
        }
        return this.getOcRemainContractModelById(remainContractId);
    }

    @Override
    public void deleteOcRemainContract(Integer remainContractId) throws ApiException {
        if (null == remainContractId) {
            return;
        }
        this.deleteOcRemainContractModel(remainContractId);
    }

    @Override
    public QueryResult<OcRemainContract> queryOcRemainContractPage(Map<String, Object> map) {
        List<OcRemainContract> ocRemainContractList = this.queryOcRemainContractModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOcRemainContract(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRemainContractList);
        return queryResult;
    }

    @Override
    public OcRemainContract getOcRemainContractByCode(String tenantCode, String remainContractCode) throws ApiException {
        if (StringUtils.isBlank((String)remainContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("remainContractCode", remainContractCode);
        return this.getOcRemainContractModelByCode(map);
    }

    @Override
    public void deleteOcRemainContractByCode(String tenantCode, String remainContractCode) throws ApiException {
        if (StringUtils.isBlank((String)remainContractCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("remainContractCode", remainContractCode);
        this.delOcRemainContractModelByCode(map);
    }
}

