/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcProductPickMapper;
import com.yqbsoft.laser.service.contract.domain.OcProductPickDomain;
import com.yqbsoft.laser.service.contract.domain.OcProductPickReDomain;
import com.yqbsoft.laser.service.contract.model.OcProductPick;
import com.yqbsoft.laser.service.contract.service.OcProductPickService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcProductPickServiceImpl
extends BaseServiceImpl
implements OcProductPickService {
    private static final String SYS_CODE = "oc.CONTRACT.OcProductPickServiceImpl";
    private OcProductPickMapper ocProductPickMapper;

    public void setOcProductPickMapper(OcProductPickMapper ocProductPickMapper) {
        this.ocProductPickMapper = ocProductPickMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocProductPickMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOcProductPick(OcProductPickDomain ocProductPickDomain) {
        if (null == ocProductPickDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocProductPickDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOcProductPickDefault(OcProductPick ocProductPick) {
        if (null == ocProductPick) {
            return;
        }
        if (null == ocProductPick.getDataState()) {
            ocProductPick.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocProductPick.getGmtCreate()) {
            ocProductPick.setGmtCreate(date);
        }
        ocProductPick.setGmtModified(date);
        if (StringUtils.isBlank((String)ocProductPick.getProductPickCode())) {
            ocProductPick.setProductPickCode(this.getNo(null, "OcProductPick", "ocProductPick", ocProductPick.getTenantCode()));
        }
    }

    private int getOcProductPickMaxCode() {
        int code = 0;
        try {
            return this.ocProductPickMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.getOcProductPickMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOcProductPickUpdataDefault(OcProductPick ocProductPick) {
        if (null == ocProductPick) {
            return;
        }
        ocProductPick.setGmtModified(this.getSysDate());
    }

    private void saveOcProductPickModel(OcProductPick ocProductPick) throws ApiException {
        if (null == ocProductPick) {
            return;
        }
        try {
            this.ocProductPickMapper.insert(ocProductPick);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.saveOcProductPickModel.ex", (Throwable)e);
        }
    }

    private void saveOcProductPickBatchModel(List<OcProductPick> ocProductPickList) throws ApiException {
        if (null == ocProductPickList || ocProductPickList.isEmpty()) {
            return;
        }
        try {
            this.ocProductPickMapper.insertBatch(ocProductPickList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.saveOcProductPickBatchModel.ex", (Throwable)e);
        }
    }

    private OcProductPick getOcProductPickModelById(Integer productPickId) {
        if (null == productPickId) {
            return null;
        }
        try {
            return this.ocProductPickMapper.selectByPrimaryKey(productPickId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.getOcProductPickModelById", (Throwable)e);
            return null;
        }
    }

    private OcProductPick getOcProductPickModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocProductPickMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.getOcProductPickModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOcProductPickModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.delOcProductPickModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.delOcProductPickModelByCode.num");
        }
    }

    private void deleteOcProductPickModel(Integer productPickId) throws ApiException {
        if (null == productPickId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.deleteByPrimaryKey(productPickId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.deleteOcProductPickModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.deleteOcProductPickModel.num");
        }
    }

    private void updateOcProductPickModel(OcProductPick ocProductPick) throws ApiException {
        if (null == ocProductPick) {
            return;
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.updateByPrimaryKey(ocProductPick);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPickModel.num");
        }
    }

    private void updateStateOcProductPickModel(Integer productPickId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == productPickId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("productPickId", productPickId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateStateOcProductPickModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateStateOcProductPickModel.null");
        }
    }

    private void updateStateOcProductPickModelByCode(String tenantCode, String productPickCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)productPickCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("productPickCode", productPickCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocProductPickMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateStateOcProductPickModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateStateOcProductPickModelByCode.null");
        }
    }

    private OcProductPick makeOcProductPick(OcProductPickDomain ocProductPickDomain, OcProductPick ocProductPick) {
        if (null == ocProductPickDomain) {
            return null;
        }
        if (null == ocProductPick) {
            ocProductPick = new OcProductPick();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocProductPick, (Object)ocProductPickDomain);
            return ocProductPick;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.makeOcProductPick", (Throwable)e);
            return null;
        }
    }

    private OcProductPickReDomain makeOcProductPickReDomain(OcProductPick ocProductPick) {
        if (null == ocProductPick) {
            return null;
        }
        OcProductPickReDomain ocProductPickReDomain = new OcProductPickReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocProductPickReDomain, (Object)ocProductPick);
            return ocProductPickReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.makeOcProductPickReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcProductPick> queryOcProductPickModelPage(Map<String, Object> parammap) {
        try {
            return this.ocProductPickMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.queryOcProductPickModel", (Throwable)e);
            return null;
        }
    }

    private int countOcProductPick(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocProductPickMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcProductPickServiceImpl.countOcProductPick", (Throwable)e);
        }
        return i;
    }

    private OcProductPick createOcProductPick(OcProductPickDomain ocProductPickDomain) {
        String msg = this.checkOcProductPick(ocProductPickDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.saveOcProductPick.checkOcProductPick", msg);
        }
        OcProductPick ocProductPick = this.makeOcProductPick(ocProductPickDomain, null);
        this.setOcProductPickDefault(ocProductPick);
        return ocProductPick;
    }

    @Override
    public String saveOcProductPick(OcProductPickDomain ocProductPickDomain) throws ApiException {
        OcProductPick ocProductPick = this.createOcProductPick(ocProductPickDomain);
        this.saveOcProductPickModel(ocProductPick);
        return ocProductPick.getProductPickCode();
    }

    @Override
    public String saveOcProductPickBatch(List<OcProductPickDomain> ocProductPickDomainList) throws ApiException {
        if (null == ocProductPickDomainList || ocProductPickDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcProductPick> ocProductPickList = new ArrayList<OcProductPick>();
        String code = "";
        for (OcProductPickDomain ocProductPickDomain : ocProductPickDomainList) {
            OcProductPick ocProductPick = this.createOcProductPick(ocProductPickDomain);
            code = ocProductPick.getProductPickCode();
            ocProductPickList.add(ocProductPick);
        }
        this.saveOcProductPickBatchModel(ocProductPickList);
        return code;
    }

    @Override
    public void updateOcProductPickState(Integer productPickId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == productPickId) {
            return;
        }
        this.updateStateOcProductPickModel(productPickId, dataState, oldDataState, map);
    }

    @Override
    public void updateOcProductPickStateByCode(String tenantCode, String productPickCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)productPickCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOcProductPickModelByCode(tenantCode, productPickCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOcProductPick(OcProductPickDomain ocProductPickDomain) throws ApiException {
        String msg = this.checkOcProductPick(ocProductPickDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPick.checkOcProductPick", msg);
        }
        OcProductPick oldOcProductPick = this.getOcProductPickModelById(ocProductPickDomain.getProductPickId());
        if (null == oldOcProductPick) {
            throw new ApiException("oc.CONTRACT.OcProductPickServiceImpl.updateOcProductPick.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcProductPick ocProductPick = this.makeOcProductPick(ocProductPickDomain, oldOcProductPick);
        this.setOcProductPickUpdataDefault(ocProductPick);
        this.updateOcProductPickModel(ocProductPick);
    }

    @Override
    public OcProductPick getOcProductPick(Integer productPickId) {
        if (null == productPickId) {
            return null;
        }
        return this.getOcProductPickModelById(productPickId);
    }

    @Override
    public void deleteOcProductPick(Integer productPickId) throws ApiException {
        if (null == productPickId) {
            return;
        }
        this.deleteOcProductPickModel(productPickId);
    }

    @Override
    public QueryResult<OcProductPick> queryOcProductPickPage(Map<String, Object> map) {
        List<OcProductPick> ocProductPickList = this.queryOcProductPickModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOcProductPick(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocProductPickList);
        return queryResult;
    }

    @Override
    public OcProductPick getOcProductPickByCode(String tenantCode, String productPickCode) throws ApiException {
        if (StringUtils.isBlank((String)productPickCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("productPickCode", productPickCode);
        return this.getOcProductPickModelByCode(map);
    }

    @Override
    public void deleteOcProductPickByCode(String tenantCode, String productPickCode) throws ApiException {
        if (StringUtils.isBlank((String)productPickCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("productPickCode", productPickCode);
        this.delOcProductPickModelByCode(map);
    }
}

