/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRegularGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcRegularMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.domain.OcPackageDomain;
import com.yqbsoft.laser.service.contract.domain.OcRegularDomain;
import com.yqbsoft.laser.service.contract.domain.OcRegularGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRegularGoodsReDomain;
import com.yqbsoft.laser.service.contract.domain.OcRegularReDomain;
import com.yqbsoft.laser.service.contract.domain.UmUser;
import com.yqbsoft.laser.service.contract.domain.UmUserinfo;
import com.yqbsoft.laser.service.contract.model.OcContract;
import com.yqbsoft.laser.service.contract.model.OcRegular;
import com.yqbsoft.laser.service.contract.model.OcRegularGoods;
import com.yqbsoft.laser.service.contract.service.OcRegularService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRegularServiceImpl
extends BaseServiceImpl
implements OcRegularService {
    private static final String SYS_CODE = "oc.CONTRACT.OcRegularServiceImpl";
    private OcRegularMapper ocRegularMapper;
    private OcRegularGoodsMapper ocRegularGoodsMapper;

    public void setOcRegularMapper(OcRegularMapper ocRegularMapper) {
        this.ocRegularMapper = ocRegularMapper;
    }

    public void setOcRegularGoodsMapper(OcRegularGoodsMapper ocRegularGoodsMapper) {
        this.ocRegularGoodsMapper = ocRegularGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRegularMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRegular(OcRegularDomain ocRegularDomain) {
        if (null == ocRegularDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRegularDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRegularDefault(OcRegular ocRegular) {
        if (null == ocRegular) {
            return;
        }
        if (null == ocRegular.getDataState()) {
            ocRegular.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocRegular.getGmtCreate()) {
            ocRegular.setGmtCreate(date);
        }
        ocRegular.setGmtModified(date);
        if (0 == ocRegular.getRegularNum()) {
            ocRegular.setRegularNum(10);
        }
        if (null == ocRegular.getRegularRule()) {
            ocRegular.setRegularRule("0");
        }
        if (StringUtils.isBlank((String)ocRegular.getRegularCode())) {
            ocRegular.setRegularCode(this.createUUIDString());
        }
    }

    private int getRegularMaxCode() {
        int code = 0;
        try {
            return this.ocRegularMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getRegularMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRegularUpdataDefault(OcRegular ocRegular) {
        if (null == ocRegular) {
            return;
        }
        ocRegular.setGmtModified(this.getSysDate());
    }

    private void saveRegularModel(OcRegular ocRegular) throws ApiException {
        if (null == ocRegular) {
            return;
        }
        try {
            this.ocRegularMapper.insert(ocRegular);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveRegularModel.ex", (Throwable)e);
        }
    }

    private void saveRegularBatchModel(List<OcRegular> ocRegularList) throws ApiException {
        if (null == ocRegularList || ocRegularList.isEmpty()) {
            return;
        }
        try {
            this.ocRegularMapper.insertBatch(ocRegularList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveRegularBatchModel.ex", (Throwable)e);
        }
    }

    private OcRegular getRegularModelById(Integer regularId) {
        if (null == regularId) {
            return null;
        }
        try {
            return this.ocRegularMapper.selectByPrimaryKey(regularId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getRegularModelById", (Throwable)e);
            return null;
        }
    }

    private OcRegular getRegularModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRegularMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getRegularModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRegularModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.delRegularModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.delRegularModelByCode.num");
        }
    }

    private void deleteRegularModel(Integer regularId) throws ApiException {
        if (null == regularId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.deleteByPrimaryKey(regularId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.deleteRegularModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.deleteRegularModel.num");
        }
    }

    private void updateRegularModel(OcRegular ocRegular) throws ApiException {
        if (null == ocRegular) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.updateByPrimaryKey(ocRegular);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegularModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegularModel.num");
        }
    }

    private void updateStateRegularModel(Integer regularId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == regularId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regularId", regularId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateRegularModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateRegularModel.null");
        }
    }

    private void updateStateRegularModelByCode(String tenantCode, String regularCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)regularCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularCode", regularCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateRegularModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateRegularModelByCode.null");
        }
    }

    private OcRegular makeRegular(OcRegularDomain ocRegularDomain, OcRegular ocRegular) {
        if (null == ocRegularDomain) {
            return null;
        }
        if (null == ocRegular) {
            ocRegular = new OcRegular();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRegular, (Object)ocRegularDomain);
            return ocRegular;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.makeRegular", (Throwable)e);
            return null;
        }
    }

    private OcRegularReDomain makeOcRegularReDomain(OcRegular ocRegular) {
        if (null == ocRegular) {
            return null;
        }
        OcRegularReDomain ocRegularReDomain = new OcRegularReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRegularReDomain, (Object)ocRegular);
            return ocRegularReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.makeOcRegularReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcRegular> queryRegularModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRegularMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.queryRegularModel", (Throwable)e);
            return null;
        }
    }

    private int countRegular(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRegularMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.countRegular", (Throwable)e);
        }
        return i;
    }

    private OcRegular createOcRegular(OcRegularDomain ocRegularDomain) {
        String msg = this.checkRegular(ocRegularDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveRegular.checkRegular", msg);
        }
        OcRegular ocRegular = this.makeRegular(ocRegularDomain, null);
        this.setRegularDefault(ocRegular);
        return ocRegular;
    }

    private String checkRegularGoods(OcRegularGoodsDomain ocRegularGoodsDomain) {
        if (null == ocRegularGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRegularGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRegularGoodsDefault(OcRegularGoods ocRegularGoods) {
        if (null == ocRegularGoods) {
            return;
        }
        if (null == ocRegularGoods.getDataState()) {
            ocRegularGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocRegularGoods.getGmtCreate()) {
            ocRegularGoods.setGmtCreate(date);
        }
        if (null == ocRegularGoods.getGmtModified()) {
            ocRegularGoods.setGmtModified(date);
        }
        if (StringUtils.isBlank((String)ocRegularGoods.getRegularGoodsCode())) {
            ocRegularGoods.setRegularGoodsCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)ocRegularGoods.getRegularCode())) {
            ocRegularGoods.setRegularCode(this.createUUIDString());
        }
        if (0 == ocRegularGoods.getRegularGoodsNum()) {
            ocRegularGoods.setRegularGoodsNum(1);
        }
    }

    private int getRegularGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocRegularGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getRegularGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRegularGoodsUpdataDefault(OcRegularGoods ocRegularGoods) {
        if (null == ocRegularGoods) {
            return;
        }
        ocRegularGoods.setGmtModified(this.getSysDate());
    }

    private void saveRegularGoodsModel(OcRegularGoods ocRegularGoods) throws ApiException {
        if (null == ocRegularGoods) {
            return;
        }
        try {
            this.ocRegularGoodsMapper.insert(ocRegularGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveRegularGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveRegularGoodsBatchModel(List<OcRegularGoods> ocRegularGoodsList) throws ApiException {
        if (null == ocRegularGoodsList || ocRegularGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocRegularGoodsMapper.insertBatch(ocRegularGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveRegularGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private OcRegularGoods getRegularGoodsModelById(Integer regularGoodsId) {
        if (null == regularGoodsId) {
            return null;
        }
        try {
            return this.ocRegularGoodsMapper.selectByPrimaryKey(regularGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getRegularGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private OcRegularGoods getRegularGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRegularGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getRegularGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRegularGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.delRegularGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.delRegularGoodsModelByCode.num");
        }
    }

    private void deleteRegularGoodsModel(Integer regularGoodsId) throws ApiException {
        if (null == regularGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularGoodsMapper.deleteByPrimaryKey(regularGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.deleteRegularGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.deleteRegularGoodsModel.num");
        }
    }

    private void updateRegularGoodsModel(OcRegularGoods ocRegularGoods) throws ApiException {
        if (null == ocRegularGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularGoodsMapper.updateByPrimaryKey(ocRegularGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegularGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegularGoodsModel.num");
        }
    }

    private void updateStateRegularGoodsModel(Integer regularGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == regularGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regularGoodsId", regularGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRegularGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateRegularGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateRegularGoodsModel.null");
        }
    }

    private void updateStateRegularGoodsModelByCode(String tenantCode, String regularGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)regularGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularGoodsCode", regularGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRegularGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateRegularGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateRegularGoodsModelByCode.null");
        }
    }

    private OcRegularGoods makeRegularGoods(OcRegularGoodsDomain ocRegularGoodsDomain, OcRegularGoods ocRegularGoods) {
        if (null == ocRegularGoodsDomain) {
            return null;
        }
        if (null == ocRegularGoods) {
            ocRegularGoods = new OcRegularGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRegularGoods, (Object)ocRegularGoodsDomain);
            return ocRegularGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.makeRegularGoods", (Throwable)e);
            return null;
        }
    }

    private OcRegularGoodsReDomain makeOcRegularGoodsReDomain(OcRegularGoods ocRegularGoods) {
        if (null == ocRegularGoods) {
            return null;
        }
        OcRegularGoodsReDomain ocRegularGoodsReDomain = new OcRegularGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRegularGoodsReDomain, (Object)ocRegularGoods);
            return ocRegularGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.makeOcRegularGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcRegularGoods> queryRegularGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRegularGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.queryRegularGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countRegularGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRegularGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.countRegularGoods", (Throwable)e);
        }
        return i;
    }

    private OcRegularGoods createOcRegularGoods(OcRegularGoodsDomain ocRegularGoodsDomain) {
        String msg;
        OcRegularGoods goods = this.getRegularGoodsModelByMemberCodeAndSkuCode(ocRegularGoodsDomain.getMemberCode(), ocRegularGoodsDomain.getSkuCode());
        if (null != goods) {
            ocRegularGoodsDomain.setRegularGoodsId(goods.getRegularGoodsId());
            this.updateRegularGoods(ocRegularGoodsDomain);
        }
        if (StringUtils.isNotBlank((String)(msg = this.checkRegularGoods(ocRegularGoodsDomain)))) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveRegularGoods.checkRegularGoods", msg);
        }
        OcRegularGoods ocRegularGoods = this.makeRegularGoods(ocRegularGoodsDomain, null);
        this.setRegularGoodsDefault(ocRegularGoods);
        return ocRegularGoods;
    }

    @Override
    public String saveRegularBatch(List<OcRegularDomain> ocRegularDomainList) throws ApiException {
        if (null == ocRegularDomainList || ocRegularDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcRegular> ocRegularList = new ArrayList<OcRegular>();
        String code = "";
        for (OcRegularDomain ocRegularDomain : ocRegularDomainList) {
            OcRegular ocRegular = this.createOcRegular(ocRegularDomain);
            code = ocRegular.getRegularCode();
            ocRegularList.add(ocRegular);
        }
        this.saveRegularBatchModel(ocRegularList);
        return code;
    }

    @Override
    public void updateRegularState(Integer regularId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == regularId) {
            return;
        }
        this.updateStateRegularModel(regularId, dataState, oldDataState, map);
    }

    @Override
    public void updateRegularStateByCode(String tenantCode, String regularCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)regularCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRegularModelByCode(tenantCode, regularCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRegular(OcRegularDomain ocRegularDomain) throws ApiException {
        String msg = this.checkRegular(ocRegularDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegular.checkRegular", msg);
        }
        OcRegular oldOcRegular = this.getRegularModelById(ocRegularDomain.getRegularId());
        if (null == oldOcRegular) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegular.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRegular ocRegular = this.makeRegular(ocRegularDomain, oldOcRegular);
        this.setRegularUpdataDefault(ocRegular);
        this.updateRegularModel(ocRegular);
    }

    @Override
    public OcRegular getRegular(Integer regularId) {
        if (null == regularId) {
            return null;
        }
        return this.getRegularModelById(regularId);
    }

    @Override
    public void deleteRegular(Integer regularId) throws ApiException {
        if (null == regularId) {
            return;
        }
        this.deleteRegularModel(regularId);
    }

    @Override
    public QueryResult<OcRegular> queryRegularPage(Map<String, Object> map) {
        List<OcRegular> ocRegularList = this.queryRegularModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRegular(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRegularList);
        return queryResult;
    }

    @Override
    public OcRegular getRegularByCode(String tenantCode, String regularCode) throws ApiException {
        if (StringUtils.isBlank((String)regularCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularCode", regularCode);
        return this.getRegularModelByCode(map);
    }

    @Override
    public void deleteRegularByCode(String tenantCode, String regularCode) throws ApiException {
        if (StringUtils.isBlank((String)regularCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularCode", regularCode);
        this.delRegularModelByCode(map);
    }

    @Override
    public String saveRegularGoods(OcRegularGoodsDomain ocRegularGoodsDomain) throws ApiException {
        OcRegularGoods ocRegularGoods = this.createOcRegularGoods(ocRegularGoodsDomain);
        this.saveRegularGoodsModel(ocRegularGoods);
        return ocRegularGoods.getRegularGoodsCode();
    }

    @Override
    public String saveRegularGoodsBatch(List<OcRegularGoodsReDomain> ocRegularGoodsDomainList) throws ApiException {
        if (null == ocRegularGoodsDomainList || ocRegularGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcRegularGoods> ocRegularGoodsList = new ArrayList<OcRegularGoods>();
        String code = "";
        for (OcRegularGoodsDomain ocRegularGoodsDomain : ocRegularGoodsDomainList) {
            OcRegularGoods ocRegularGoods = this.createOcRegularGoods(ocRegularGoodsDomain);
            code = ocRegularGoods.getRegularGoodsCode();
            ocRegularGoodsList.add(ocRegularGoods);
        }
        this.saveRegularGoodsBatchModel(ocRegularGoodsList);
        return code;
    }

    @Override
    public void updateRegularGoodsState(Integer regularGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == regularGoodsId) {
            return;
        }
        this.updateStateRegularGoodsModel(regularGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateRegularGoodsStateByCode(String tenantCode, String regularGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)regularGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRegularGoodsModelByCode(tenantCode, regularGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRegularGoods(OcRegularGoodsDomain ocRegularGoodsDomain) throws ApiException {
        String msg = this.checkRegularGoods(ocRegularGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegularGoods.checkRegularGoods", msg);
        }
        OcRegularGoods oldOcRegularGoods = this.getRegularGoodsModelById(ocRegularGoodsDomain.getRegularGoodsId());
        if (null == oldOcRegularGoods) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegularGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRegularGoods ocRegularGoods = this.makeRegularGoods(ocRegularGoodsDomain, oldOcRegularGoods);
        this.setRegularGoodsUpdataDefault(ocRegularGoods);
        this.updateRegularGoodsModel(ocRegularGoods);
    }

    @Override
    public OcRegularGoods getRegularGoods(Integer regularGoodsId) {
        if (null == regularGoodsId) {
            return null;
        }
        return this.getRegularGoodsModelById(regularGoodsId);
    }

    @Override
    public void deleteRegularGoods(Integer regularGoodsId) throws ApiException {
        if (null == regularGoodsId) {
            return;
        }
        this.deleteRegularGoodsModel(regularGoodsId);
    }

    @Override
    public OcRegularGoods getRegularGoodsByCode(String tenantCode, String regularGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)regularGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularGoodsCode", regularGoodsCode);
        return this.getRegularGoodsModelByCode(map);
    }

    @Override
    public void deleteRegularGoodsByCode(String tenantCode, String regularGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)regularGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularGoodsCode", regularGoodsCode);
        this.delRegularGoodsModelByCode(map);
    }

    private OcRegular getRegularModelByMemberCode(String memberCode) {
        if (null == memberCode) {
            return null;
        }
        try {
            return this.ocRegularMapper.selectOneByMemberCode(memberCode);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getRegularModelByMemberCode", (Throwable)e);
            return null;
        }
    }

    private OcRegularGoods getRegularGoodsModelByMemberCodeAndSkuCode(String memberCode, String skuCode) {
        if (null == memberCode || null == skuCode) {
            return null;
        }
        try {
            return this.ocRegularGoodsMapper.selectOneByMemberCodeAndSkuCode(memberCode, skuCode);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getRegularGoodsModelByMemberCodeAndSkuCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<OcRegularGoods> queryRegularGoodsPage(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String memberCode = (String)map.get("memberCode");
        if (null == memberCode) {
            return null;
        }
        OcRegular regular = this.getRegularModelByMemberCode(memberCode);
        if (null == regular) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.queryRegularGoodsPage", "\u7528\u6237\u672a\u8bbe\u7f6e\u89c4\u5219");
        }
        map.put("startRow", 0);
        map.put("rows", regular.getRegularNum());
        String rule = regular.getRegularRule();
        if ("0".equals(rule)) {
            map.put("orderStr", "GMT_MODIFIED");
        }
        if ("1".equals(rule)) {
            map.put("orderStr", "REGULAR_GOODS_NUM");
        }
        if ("2".equals(rule)) {
            map.put("orderStr", "REGULAR_GOODS_AMT");
        }
        if ("3".equals(rule)) {
            map.put("orderStr", "REGULAR_GOODS_SNUNM");
        }
        List<OcRegularGoods> ocRegularGoodsList = this.queryRegularGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRegularGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRegularGoodsList);
        return queryResult;
    }

    @Override
    public String saveCountNum(OcContractReDomain ocContract) throws ApiException {
        OcRegular ocRegular = this.getRegularModelByMemberCode(ocContract.getMemberBcode());
        if (null == ocRegular) {
            OcRegularDomain ocRegularDomain = new OcRegularDomain();
            ocRegularDomain.setMemberCode(ocContract.getMemberBcode());
            ocRegularDomain.setTenantCode(ocContract.getTenantCode());
            ocRegularDomain.setRegularRule("0");
            ocRegularDomain.setRegularNum(10);
            ocRegularDomain.setMemberName(ocContract.getMemberBname());
            this.saveRegular(ocRegularDomain);
            ocRegular = this.getRegularModelByMemberCode(ocContract.getMemberBcode());
        }
        List<OcRegularGoodsReDomain> oldGoodsDomain = this.getOcRegularGoodsDomains(ocContract);
        List<OcRegularGoodsReDomain> ocRegularGoodsDomains = this.createOcRegularGoodsDomains(ocRegular, ocContract, oldGoodsDomain);
        this.deleteRegularGoodsByMemberCode(ocContract.getMemberBcode(), ocContract.getTenantCode());
        this.saveRegularGoodsBatch(ocRegularGoodsDomains);
        return "success";
    }

    private void removeEq(List<OcRegularGoodsReDomain> ocRegularGoodsDomains) {
        Collections.sort(ocRegularGoodsDomains, new Comparator<OcRegularGoodsReDomain>(){

            @Override
            public int compare(OcRegularGoodsReDomain o1, OcRegularGoodsReDomain o2) {
                return o1.getSkuCode().compareTo(o2.getSkuCode());
            }
        });
        for (int ia = 0; ia < ocRegularGoodsDomains.size(); ++ia) {
            int count = 0;
            for (int j = ia + 1; j < ocRegularGoodsDomains.size() && ocRegularGoodsDomains.get(ia).getSkuCode().equals(ocRegularGoodsDomains.get(j).getSkuCode()); ++j) {
                ++count;
            }
            Integer num = ocRegularGoodsDomains.get(ia).getRegularGoodsNum();
            BigDecimal snunm = ocRegularGoodsDomains.get(ia).getRegularGoodsSnunm();
            BigDecimal amt = ocRegularGoodsDomains.get(ia).getRegularGoodsAmt();
            for (int j = 0; j < count; ++j) {
                num = num + ocRegularGoodsDomains.get(ia + 1).getRegularGoodsNum();
                snunm = ocRegularGoodsDomains.get(ia + 1).getRegularGoodsSnunm().add(snunm);
                amt = ocRegularGoodsDomains.get(ia + 1).getRegularGoodsAmt().add(amt);
                ocRegularGoodsDomains.remove(ia + 1);
            }
            ocRegularGoodsDomains.get(ia).setRegularGoodsNum(num);
            ocRegularGoodsDomains.get(ia).setRegularGoodsSnunm(snunm);
            ocRegularGoodsDomains.get(ia).setRegularGoodsAmt(amt);
        }
    }

    private List<OcRegularGoodsReDomain> getOcRegularGoodsDomains(OcContractReDomain ocContract) {
        List oldGoods;
        ArrayList<OcRegularGoodsReDomain> oldGoodsDomain = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", ocContract.getMemberBcode());
        QueryResult<OcRegularGoods> ocRegularGoodsQueryResult = this.queryRegularGoodsPage(map);
        if (null != ocRegularGoodsQueryResult && null != (oldGoods = ocRegularGoodsQueryResult.getList())) {
            oldGoodsDomain = new ArrayList<OcRegularGoodsReDomain>();
            for (OcRegularGoods ocRegularGoods : oldGoods) {
                OcRegularGoodsReDomain regularGoodsDomain = this.makeRegularGoodsDomain(null, ocRegularGoods);
                oldGoodsDomain.add(regularGoodsDomain);
            }
        }
        return oldGoodsDomain;
    }

    private List<OcRegularGoodsReDomain> createOcRegularGoodsDomains(OcRegular ocRegular, OcContractReDomain ocContract, List<OcRegularGoodsReDomain> oldGoods) {
        Integer num;
        ArrayList<OcRegularGoodsReDomain> ocRegularGoodsDomains = new ArrayList<OcRegularGoodsReDomain>();
        String rule = ocRegular.getRegularRule();
        if (null == rule) {
            rule = "0";
        }
        if (0 == (num = ocRegular.getRegularNum())) {
            num = 10;
        }
        List<OcPackageDomain> packageList = ocContract.getPackageList();
        for (OcPackageDomain ocPackage : packageList) {
            List<OcContractGoodsDomain> goodsList = ocPackage.getContractGoodsList();
            for (OcContractGoodsDomain ocContractGoods : goodsList) {
                OcRegularGoodsReDomain regularGoodsDomain = new OcRegularGoodsReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)regularGoodsDomain, (Object)ocContractGoods);
                }
                catch (Exception e) {
                    this.logger.error("oc.CONTRACT.OcRegularServiceImpl.saveCountNumCopy", (Throwable)e);
                }
                regularGoodsDomain.setMemberCode(ocContract.getMemberBcode());
                regularGoodsDomain.setMemberName(ocContract.getMemberBname());
                regularGoodsDomain.setTenantCode(ocContract.getTenantCode());
                regularGoodsDomain.setGmtCreate(ocContract.getGmtCreate());
                regularGoodsDomain.setGmtModified(ocContract.getGmtModified());
                regularGoodsDomain.setDataState(ocContract.getDataState());
                regularGoodsDomain.setRegularGoodsNum(1);
                regularGoodsDomain.setRegularGoodsSnunm(ocContractGoods.getGoodsNum());
                regularGoodsDomain.setRegularGoodsAmt(ocContractGoods.getContractGoodsMoney());
                regularGoodsDomain.setPricesetNprice(ocContractGoods.getPricesetNprice());
                ocRegularGoodsDomains.add(regularGoodsDomain);
            }
        }
        if (0 < oldGoods.size()) {
            ocRegularGoodsDomains.addAll(oldGoods);
        }
        this.removeEq(ocRegularGoodsDomains);
        if ("0".equals(rule)) {
            Collections.sort(ocRegularGoodsDomains, new Comparator<OcRegularGoodsReDomain>(){

                @Override
                public int compare(OcRegularGoodsReDomain o1, OcRegularGoodsReDomain o2) {
                    Date dt1 = o1.getGmtModified();
                    Date dt2 = o2.getGmtModified();
                    if (dt1.getTime() > dt2.getTime()) {
                        return -1;
                    }
                    if (dt1.getTime() < dt2.getTime()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        if ("1".equals(rule)) {
            Collections.sort(ocRegularGoodsDomains, new Comparator<OcRegularGoodsReDomain>(){

                @Override
                public int compare(OcRegularGoodsReDomain o1, OcRegularGoodsReDomain o2) {
                    if (o1.getRegularGoodsNum() > o2.getRegularGoodsNum()) {
                        return -1;
                    }
                    if (o1.getRegularGoodsNum().equals(o2.getRegularGoodsNum())) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        if ("2".equals(rule)) {
            Collections.sort(ocRegularGoodsDomains, new Comparator<OcRegularGoodsReDomain>(){

                @Override
                public int compare(OcRegularGoodsReDomain o1, OcRegularGoodsReDomain o2) {
                    if (o1.getRegularGoodsAmt().compareTo(o2.getRegularGoodsAmt()) == 1) {
                        return -1;
                    }
                    if (o1.getRegularGoodsAmt().compareTo(o2.getRegularGoodsAmt()) == 0) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        if ("3".equals(rule)) {
            Collections.sort(ocRegularGoodsDomains, new Comparator<OcRegularGoodsReDomain>(){

                @Override
                public int compare(OcRegularGoodsReDomain o1, OcRegularGoodsReDomain o2) {
                    if (o1.getRegularGoodsSnunm().compareTo(o2.getRegularGoodsSnunm()) == 1) {
                        return -1;
                    }
                    if (o1.getRegularGoodsSnunm().compareTo(o2.getRegularGoodsSnunm()) == 0) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        if (ocRegularGoodsDomains.size() > num) {
            List<OcRegularGoodsReDomain> newList = ocRegularGoodsDomains.subList(0, num);
            return newList;
        }
        return ocRegularGoodsDomains;
    }

    private OcRegularGoodsReDomain makeRegularGoodsDomain(OcRegularGoodsReDomain ocRegularGoodsDomain, OcRegularGoods ocRegularGoods) {
        if (null == ocRegularGoods) {
            return null;
        }
        if (null == ocRegularGoodsDomain) {
            ocRegularGoodsDomain = new OcRegularGoodsReDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRegularGoodsDomain, (Object)ocRegularGoods);
            return ocRegularGoodsDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.makeRegularGoods", (Throwable)e);
            return null;
        }
    }

    private OcContract createOcContract(OcContractReDomain ocContractDomain) {
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveCountNum.checkContract", msg);
        }
        OcContract OcContract2 = this.makeContract(ocContractDomain, null);
        return OcContract2;
    }

    private OcContract makeContract(OcContractReDomain ocContractDomain, OcContract ocContract) {
        if (null == ocContractDomain) {
            return null;
        }
        if (null == ocContract) {
            ocContract = new OcContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContract, (Object)ocContractDomain);
            return ocContract;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.makeContract", (Throwable)e);
            return null;
        }
    }

    private String checkContract(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getMemberBcode())) {
            msg = msg + "MemberBcode\u4e3a\u7a7a;";
        }
        return msg;
    }

    @Override
    public String saveRegular(OcRegularDomain ocRegularDomain) throws ApiException {
        OcRegular regular = this.getRegularModelByMemberCode(ocRegularDomain.getMemberCode());
        if (null != regular) {
            ocRegularDomain.setRegularId(regular.getRegularId());
            ocRegularDomain.setRegularCode(regular.getRegularCode());
            ocRegularDomain.setMemberName(regular.getMemberName());
            this.updateRegular(ocRegularDomain);
            return "success";
        }
        OcRegular ocRegular = this.createOcRegular(ocRegularDomain);
        this.saveRegularModel(ocRegular);
        return ocRegular.getRegularCode();
    }

    @Override
    public String updateGoodsBySkuCode(Map<String, Object> map) throws ApiException {
        String msg = this.checkRegularGoodsByMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateGoodsBySkuCode.checkRegularGoodsByMap", msg);
        }
        this.updateRegularGoodsBySkuCodeModel(map);
        return "success";
    }

    private void updateRegularGoodsBySkuCodeModel(Map<String, Object> map) {
        if (null == map) {
            return;
        }
        try {
            this.ocRegularGoodsMapper.updateBySkuCodeAndMemberCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateRegularGoodsBySkuCodeModel.ex", (Throwable)e);
        }
    }

    private String checkRegularGoodsByMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)String.valueOf(map.get("skuCode")))) {
            msg = msg + "skuCode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("pricesetNprice")))) {
            msg = msg + "pricesetNprice is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("dataState")))) {
            msg = msg + "dataState is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("goodsNum")))) {
            msg = msg + "goodsNum is null";
        }
        return msg;
    }

    @Override
    public void deleteRegularGoodsByMemberCodeAndSkuCode(String memberCode, String skuCode) throws ApiException {
        if (null == memberCode || null == skuCode) {
            return;
        }
        this.deleteRegularGoodsByMemberCodeAndSkuCodeModel(memberCode, skuCode);
    }

    @Override
    public String saveRegularByuser(UmUserinfo umUserinfo, UmUser umUser, String optype) throws ApiException {
        if (null == umUserinfo || null == umUser) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImplsaveRegularByuser", (Object)"is null");
            return "error";
        }
        OcRegularDomain ocRegularDomain = new OcRegularDomain();
        ocRegularDomain.setMemberCode(umUserinfo.getUserinfoCode());
        ocRegularDomain.setMemberName(umUserinfo.getUserinfoParentName());
        ocRegularDomain.setRegularRule("0");
        ocRegularDomain.setRegularNum(10);
        ocRegularDomain.setTenantCode(umUserinfo.getTenantCode());
        OcRegular ocRegular = this.createOcRegular(ocRegularDomain);
        this.saveRegularModel(ocRegular);
        return "success";
    }

    private void deleteRegularGoodsByMemberCodeAndSkuCodeModel(String memberCode, String skuCode) throws ApiException {
        if (null == memberCode || null == skuCode) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularGoodsMapper.deleteByMemberCodeAndSkuCode(memberCode, skuCode);
            this.logger.error("oc.CONTRACT.OcRegularServiceImpldeleteRegularGoodsByMemberCodeAndSkuCodeModel\u5220\u9664\u884c\u6570=" + i);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.deleteRegularGoodsByMemberCodeAndSkuCodeModel.ex", (Throwable)e);
        }
    }

    public void deleteRegularGoodsByMemberCode(String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)memberCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.deleteRegularGoodsByMemberCodeModel(this.getQueryMapParam("memberCode,tenantCode", new Object[]{memberCode, tenantCode}));
    }

    private void deleteRegularGoodsByMemberCodeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        try {
            this.ocRegularGoodsMapper.deleteByMemberCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.deleteRegularGoodsByMemberCodeModel.ex", (Throwable)e);
        }
    }
}

