/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.es;

import com.yqbsoft.laser.service.contract.domain.MnNode;
import com.yqbsoft.laser.service.contract.domain.OcCflowNodeReDomain;
import com.yqbsoft.laser.service.contract.enumc.FlowStartCon;
import com.yqbsoft.laser.service.contract.es.SyncTradeFuture;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.suppercore.cache.repository.BeanRepository;
import com.yqbsoft.laser.service.suppercore.cache.repository.CacheBean;
import com.yqbsoft.laser.service.suppercore.cache.repository.InvokeFuture;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;

public class ContractQueryCall {
    private static final String sys_code = "oc.CONTRACT.call";
    protected static final OpenLogUtil logger = new OpenLogUtil(ContractQueryCall.class);
    public static final String OC_FLOW_NODEMN = "OC_FLOW_NODEMN";
    public static final String OC_FLOW_NODEMB = "OC_FLOW_NODEMB";
    public static final String PTEQUERY_CALL = "ocContract-state";
    public static final long DEFAULT_TIME = 5000L;
    public static final String OC_BBILLCODESTR = "OC_BBILLCODESTR";
    public static final int OC_BBILLCODESTR_TIME = 3600000;
    private boolean synFlag = false;
    private String correlationId;
    public static final String OC_MNNODEMN = "MN";
    public static final String OC_MNNODEMB = "MB";
    static Object obj = new Object();
    private long timeout = 0L;

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public static Map<String, MnNode> makeMnNode(OcCflowNodeReDomain ocCflowNodeReDomain) {
        if (null == ocCflowNodeReDomain || StringUtils.isBlank((String)ocCflowNodeReDomain.getCflowNodeAsyn())) {
            return null;
        }
        if (null != ocCflowNodeReDomain.getMap()) {
            return ocCflowNodeReDomain.getMap();
        }
        String js = ocCflowNodeReDomain.getCflowNodeAsyn().trim();
        if (js.indexOf("{") != 0) {
            return null;
        }
        Map map = JsonUtil.buildNormalBinder().getJsonToMap(js, String.class, MnNode.class);
        MnNode mnNode = (MnNode)map.get(OC_MNNODEMN);
        if (null != mnNode && StringUtils.isBlank((String)mnNode.getNode())) {
            mnNode.setNode(ocCflowNodeReDomain.getCflowCode());
        }
        if (null != (mnNode = (MnNode)map.get(OC_MNNODEMB)) && StringUtils.isBlank((String)mnNode.getNode())) {
            mnNode.setNode(ocCflowNodeReDomain.getCflowCode());
        }
        return map;
    }

    public static String getMnNodeMnNode(OcCflowNodeReDomain ocCflowNodeDomain) {
        Map<String, MnNode> map = ContractQueryCall.makeMnNode(ocCflowNodeDomain);
        if (MapUtil.isEmpty(map) || null == map.get(OC_MNNODEMN)) {
            return null;
        }
        return map.get(OC_MNNODEMN).getNode();
    }

    public static String getMnNodeMnMain(OcCflowNodeReDomain ocCflowNodeDomain) {
        Map<String, MnNode> map = ContractQueryCall.makeMnNode(ocCflowNodeDomain);
        if (MapUtil.isEmpty(map) || null == map.get(OC_MNNODEMN)) {
            return null;
        }
        return map.get(OC_MNNODEMN).getMain();
    }

    public static String getMbNodeMnNode(OcCflowNodeReDomain ocCflowNodeReDomain) {
        Map<String, MnNode> map = ContractQueryCall.makeMnNode(ocCflowNodeReDomain);
        if (MapUtil.isEmpty(map) || null == map.get(OC_MNNODEMB)) {
            return null;
        }
        return map.get(OC_MNNODEMB).getNode();
    }

    public static String getMbNodeMnMain(OcCflowNodeReDomain ocCflowNodeReDomain) {
        Map<String, MnNode> map = ContractQueryCall.makeMnNode(ocCflowNodeReDomain);
        if (MapUtil.isEmpty(map) || null == map.get(OC_MNNODEMB)) {
            return null;
        }
        return map.get(OC_MNNODEMB).getMain();
    }

    public static boolean checkMNode(String cflowCode) {
        if (StringUtils.isBlank((String)cflowCode)) {
            return false;
        }
        Map map = DisUtil.getMapAll((String)("OC_FLOW_NODEMN-main-" + cflowCode));
        return !MapUtil.isEmpty((Map)map);
    }

    public static boolean checkNowNodeEx(String contractBillcode, String tenantCode, String cflowCode) {
        if (StringUtils.isBlank((String)cflowCode)) {
            return false;
        }
        String main = DisUtil.get((String)("OC_FLOW_NODEMN-node-" + cflowCode));
        if (StringUtils.isBlank((String)main)) {
            return false;
        }
        Map mnmap = DisUtil.getMapAll((String)("OC_FLOW_NODEMN-" + contractBillcode + "-" + tenantCode));
        Map mbmap = DisUtil.getMapAll((String)("OC_FLOW_NODEMB-" + contractBillcode + "-" + tenantCode));
        if (MapUtil.isEmpty((Map)mnmap) && MapUtil.isEmpty((Map)mbmap)) {
            return false;
        }
        if (MapUtil.isNotEmpty((Map)mnmap) && mnmap.containsKey(cflowCode)) {
            return true;
        }
        return MapUtil.isNotEmpty((Map)mbmap) && mbmap.containsKey(cflowCode);
    }

    public static int checkMNodeEx(String contractBillcode, String tenantCode, String main) {
        if (StringUtils.isBlank((String)main)) {
            return 0;
        }
        Map map = DisUtil.getMapAll((String)("OC_FLOW_NODEMN-main-" + main));
        if (MapUtil.isEmpty((Map)map)) {
            return 0;
        }
        Map mnmap = DisUtil.getMapAll((String)("OC_FLOW_NODEMN-" + contractBillcode + "-" + tenantCode));
        Map mbmap = DisUtil.getMapAll((String)("OC_FLOW_NODEMB-" + contractBillcode + "-" + tenantCode));
        if (MapUtil.isEmpty((Map)mnmap) && MapUtil.isEmpty((Map)mbmap)) {
            return 0;
        }
        String exState = "";
        for (String key : map.keySet()) {
            if (MapUtil.isNotEmpty((Map)mnmap)) {
                exState = (String)mnmap.get(key);
                if (StringUtils.isNotBlank((String)exState)) {
                    if (FlowStartCon.CE.getCode().equals(exState)) {
                        return 1;
                    }
                    if (FlowStartCon.EE.getCode().equals(exState)) {
                        return 3;
                    }
                } else {
                    return 3;
                }
            }
            if (!MapUtil.isNotEmpty((Map)mbmap)) continue;
            exState = (String)mbmap.get(key);
            if (StringUtils.isNotBlank((String)exState)) {
                if (FlowStartCon.CE.getCode().equals(exState)) {
                    return 1;
                }
                if (!FlowStartCon.EE.getCode().equals(exState)) continue;
                return 3;
            }
            return 3;
        }
        return 2;
    }

    public static int checkMex(String contractBillcode, String tenantCode, String cflowCode) {
        if (StringUtils.isBlank((String)cflowCode)) {
            return 0;
        }
        String main = DisUtil.get((String)("OC_FLOW_NODEMN-node-" + cflowCode));
        if (StringUtils.isBlank((String)main)) {
            return 0;
        }
        return ContractQueryCall.checkMNodeEx(contractBillcode, tenantCode, main);
    }

    public static void putSync(String type, String correlationId, SyncTradeFuture syncInvokeFuture, String con, long timeout) {
        if (StringUtils.isBlank((String)correlationId) || null == syncInvokeFuture) {
            return;
        }
        CacheBean bean = new CacheBean();
        bean.setValue((Object)correlationId);
        if (timeout == -1L) {
            bean.setExpire(-1L);
        } else {
            bean.setExpire(timeout + 5000L);
        }
        bean.setCon(con);
        bean.setFuture((InvokeFuture)syncInvokeFuture);
        bean.setCacheKey(type);
        BeanRepository.newInstance((String)(type + "rep"), (String)"MEM", (Object)1).put(correlationId, (Object)bean);
    }

    public static InvokeFuture getSync(String type, String correlationId) {
        if (StringUtils.isBlank((String)correlationId)) {
            return null;
        }
        CacheBean bean = (CacheBean)BeanRepository.newInstance((String)(type + "rep"), (String)"MEM", (Object)1).remove(correlationId);
        return bean != null ? bean.getFuture() : null;
    }

    public static CacheBean getCacheBean(String type, String correlationId) {
        if (StringUtils.isBlank((String)correlationId)) {
            return null;
        }
        CacheBean bean = (CacheBean)BeanRepository.newInstance((String)(type + "rep"), (String)"MEM", (Object)1).get(correlationId);
        return bean;
    }

    public static void delSync(String type, String correlationId) {
        if (StringUtils.isBlank((String)correlationId)) {
            return;
        }
        BeanRepository.newInstance((String)(type + "rep"), (String)"MEM", (Object)1).remove(correlationId);
    }

    public boolean isSynFlag() {
        return this.synFlag;
    }

    public void setSynFlag(boolean synFlag) {
        this.synFlag = synFlag;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public static void call(String type, String correlationId, String obj) {
        if (StringUtils.isBlank((String)correlationId)) {
            logger.error("oc.CONTRACT.call.call", (Object)"correlationId is null");
            return;
        }
        try {
            logger.error("oc.CONTRACT.call.call.set", (Object)("key" + type + "-" + correlationId + "obj" + obj));
            DisUtil.set((String)(type + "-" + correlationId), (String)obj, (int)6000);
            DisUtil.set((String)(type + "-" + correlationId + "-" + obj), (String)obj, (int)6000);
            logger.error("oc.CONTRACT.call.call.get", (Object)("key" + type + "-" + correlationId + "-" + obj + "obj" + DisUtil.getRemot((String)(type + "-" + correlationId)) + "===" + DisUtil.getRemot((String)(type + "-" + correlationId + "-" + obj))));
            CacheBean bean = ContractQueryCall.getCacheBean(type, correlationId);
            if (null == bean || null == bean.getFuture()) {
                return;
            }
            if (StringUtils.isNotBlank((String)bean.getCon())) {
                String[] d;
                for (String string : d = bean.getCon().split(",")) {
                    if (!obj.equals(string)) continue;
                    bean.getFuture().setDone((Object)obj);
                    ContractQueryCall.delSync(type, correlationId);
                    return;
                }
            } else {
                bean.getFuture().setDone((Object)obj);
                ContractQueryCall.delSync(type, correlationId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

