/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.enums;

public enum PbCodeEnum {
    _0001("0001", "\u6ee1\u8d60", "", "PTE"),
    _0002("0002", "\u6ee1\u51cf", "3", "PM"),
    _0003("0003", "\u4ee3\u91d1\u5238", "3", "COP"),
    _0006("0006", "\u6ee1\u6298", "3", "PM"),
    _0007("0007", "\u79d2\u6740", "", "PMS"),
    _0030("0030", "\u5185\u8d2d", "", "PMS"),
    B002("B002", "\u8de8\u5e97\u6ee1\u51cf", "8", "BPM"),
    B006("B006", "\u8de8\u5e97\u6ee1\u6298", "8", "BPM"),
    B0003("B0003", "\u8de8\u5e97\u4f18\u60e0\u5238", "9", "BCOP");

    private final String code;
    private final String desc;
    private final String type;
    private final String settlCode;

    private PbCodeEnum(String code, String desc, String type, String settlCode) {
        this.code = code;
        this.desc = desc;
        this.type = type;
        this.settlCode = settlCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getType() {
        return this.type;
    }

    public String getSettlCode() {
        return this.settlCode;
    }

    public static PbCodeEnum getByCode(String code) {
        for (PbCodeEnum pbCodeEnum : PbCodeEnum.values()) {
            if (!pbCodeEnum.getCode().equals(code)) continue;
            return pbCodeEnum;
        }
        return null;
    }

    public static boolean checkNoCopOrFlashSale(String code) {
        return B0003.getCode().equals(code) || _0007.getCode().equals(code) || _0003.getCode().equals(code) || _0030.getCode().equals(code);
    }

    public static boolean checkCopOrBCop(String code) {
        return B0003.getCode().equals(code) || _0003.getCode().equals(code);
    }

    public static boolean checkPmsGoods(String code) {
        return _0030.getCode().equals(code) || _0007.getCode().equals(code);
    }
}

