/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;

public class JsonParser {
    private static volatile ObjectMapper objectMapper = null;

    public static String toJson(Object object) {
        try {
            return JsonParser.objectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String toJson(InputStream inputStream) {
        try {
            return JsonParser.objectMapper().writeValueAsString((Object)inputStream);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static <T> T toObject(InputStream inputStream, Class<T> cls) {
        try {
            return (T)JsonParser.objectMapper().readValue(inputStream, cls);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(String json, Class<T> cls) {
        try {
            return (T)JsonParser.objectMapper().readValue(json, cls);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T toObject(byte[] json, Class<T> cls) {
        try {
            return (T)JsonParser.objectMapper().readValue(json, cls);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObjectMapper objectMapper() {
        if (null == objectMapper) {
            objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
        return objectMapper;
    }
}

