/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.ProjectReportMapper;
import com.yqbsoft.laser.service.contract.domain.ProjectReportDomain;
import com.yqbsoft.laser.service.contract.model.DuplicateCheckResult;
import com.yqbsoft.laser.service.contract.model.ProjectReport;
import com.yqbsoft.laser.service.contract.model.SimilarReport;
import com.yqbsoft.laser.service.contract.service.ProjectReportService;
import com.yqbsoft.laser.service.contract.utils.TextSimilarityUtils;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public class ProjectReportServiceImpl
extends BaseServiceImpl
implements ProjectReportService {
    private ProjectReportMapper projectReportMapper;

    @Override
    @Transactional
    public ProjectReport save(ProjectReportDomain projectReportDomain) throws Exception {
        projectReportDomain.validateOnCreate();
        ProjectReport pr = new ProjectReport();
        BeanUtils.copyAllPropertys((Object)pr, (Object)projectReportDomain);
        this.projectReportMapper.insert(pr);
        return pr;
    }

    @Override
    public SupQueryResult<ProjectReport> listByType(Map<String, Object> param) throws Exception {
        List<ProjectReport> projectReports = this.projectReportMapper.query(param);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.projectReportMapper.count(param));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(projectReports);
        return queryResult;
    }

    @Override
    public ProjectReport getById(Long id) throws Exception {
        return this.projectReportMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional
    public ProjectReport submit(ProjectReportDomain projectReportDomain) throws Exception {
        projectReportDomain.submitNext();
        ProjectReport pr = new ProjectReport();
        BeanUtils.copyAllPropertys((Object)pr, (Object)projectReportDomain);
        this.projectReportMapper.updateByPrimaryKey(pr);
        return pr;
    }

    @Override
    public ProjectReport reject(Long id, String reason) throws Exception {
        ProjectReport pr = this.getById(id);
        ProjectReportDomain projectReportDomain = new ProjectReportDomain();
        BeanUtils.copyAllPropertys((Object)projectReportDomain, (Object)pr);
        projectReportDomain.reject(reason);
        BeanUtils.copyAllPropertys((Object)pr, (Object)projectReportDomain);
        this.projectReportMapper.updateByPrimaryKey(pr);
        return pr;
    }

    @Override
    public ProjectReport approve(Long id) throws Exception {
        ProjectReport pr = this.getById(id);
        ProjectReportDomain projectReportDomain = new ProjectReportDomain();
        BeanUtils.copyAllPropertys((Object)projectReportDomain, (Object)pr);
        projectReportDomain.rollbackPrev();
        BeanUtils.copyAllPropertys((Object)pr, (Object)projectReportDomain);
        this.projectReportMapper.updateByPrimaryKey(pr);
        return pr;
    }

    @Override
    public DuplicateCheckResult duplicateCheck(Long id) throws Exception {
        ProjectReport base = this.projectReportMapper.selectByPrimaryKey(id);
        if (base == null) {
            throw new IllegalArgumentException("\u62a5\u5907\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("province", base.getProvince());
        map.put("city", base.getCity());
        map.put("district", base.getDistrict());
        map.put("address", base.getAddressDetail());
        List<ProjectReport> candidates = this.projectReportMapper.query(map);
        ArrayList<SimilarReport> similarReports = new ArrayList<SimilarReport>();
        for (ProjectReport other : candidates) {
            double sim = TextSimilarityUtils.calcSimilarity(base, other);
            SimilarReport sr = new SimilarReport();
            sr.setReport(other);
            sr.setSimilarity(sim);
            similarReports.add(sr);
        }
        similarReports.sort((a, b) -> Double.compare(b.getSimilarity(), a.getSimilarity()));
        DuplicateCheckResult result = new DuplicateCheckResult();
        result.setBaseReport(base);
        result.setSimilarReports(similarReports);
        return result;
    }

    public void setProjectReportMapper(ProjectReportMapper projectReportMapper) {
        this.projectReportMapper = projectReportMapper;
    }
}

