/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.ProjectReportItemMapper;
import com.yqbsoft.laser.service.contract.dao.ProjectReportItemOrderMapper;
import com.yqbsoft.laser.service.contract.dao.ProjectReportMapper;
import com.yqbsoft.laser.service.contract.domain.ProjectReportDomain;
import com.yqbsoft.laser.service.contract.domain.ProjectReportItemDomain;
import com.yqbsoft.laser.service.contract.enums.ProjectReportStatus;
import com.yqbsoft.laser.service.contract.model.DuplicateCheckResult;
import com.yqbsoft.laser.service.contract.model.ProjectReport;
import com.yqbsoft.laser.service.contract.model.ProjectReportItem;
import com.yqbsoft.laser.service.contract.model.ProjectReportItemOrder;
import com.yqbsoft.laser.service.contract.model.SimilarReport;
import com.yqbsoft.laser.service.contract.service.ProjectReportService;
import com.yqbsoft.laser.service.contract.utils.ProjectReportAssembler;
import com.yqbsoft.laser.service.contract.utils.ProjectReportItemAssembler;
import com.yqbsoft.laser.service.contract.utils.ProjectReportItemOrderAssembler;
import com.yqbsoft.laser.service.contract.utils.TextSimilarityUtils;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public class ProjectReportServiceImpl
extends BaseServiceImpl
implements ProjectReportService {
    private ProjectReportMapper projectReportMapper;
    private ProjectReportItemMapper projectReportItemMapper;
    private ProjectReportItemOrderMapper projectReportItemOrderMapper;

    @Override
    @Transactional
    public ProjectReport save(ProjectReportDomain projectReportDomain) throws Exception {
        projectReportDomain.validateOnCreate();
        projectReportDomain.setStatus(ProjectReportStatus.DRAFT.getCode());
        ProjectReport pr = ProjectReportAssembler.toEntity(projectReportDomain);
        this.projectReportMapper.insert(pr);
        this.replaceItems(pr.getId(), projectReportDomain.getItems());
        return this.projectReportMapper.selectByPrimaryKey(pr.getId());
    }

    @Override
    public SupQueryResult<ProjectReport> listByType(Map<String, Object> param) throws Exception {
        List<ProjectReport> projectReports = this.projectReportMapper.query(param);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.projectReportMapper.count(param));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(projectReports);
        return queryResult;
    }

    @Override
    public ProjectReport getById(Long id) throws Exception {
        ProjectReport pr = this.projectReportMapper.selectByPrimaryKey(id);
        if (pr == null) {
            return null;
        }
        List<ProjectReportItem> items = this.projectReportItemMapper.selectByReportId(id);
        if (items != null && !items.isEmpty()) {
            for (ProjectReportItem it : items) {
                List<ProjectReportItemOrder> orders = this.projectReportItemOrderMapper.selectByItemId(it.getId());
                it.setOrders(orders);
            }
        }
        pr.setItems(items);
        return pr;
    }

    @Override
    @Transactional
    public ProjectReport submit(ProjectReportDomain projectReportDomain) throws Exception {
        projectReportDomain.submitNext();
        ProjectReport pr = ProjectReportAssembler.toEntity(projectReportDomain);
        this.projectReportMapper.updateByPrimaryKey(pr);
        if (projectReportDomain.getItems() != null) {
            this.replaceItems(pr.getId(), projectReportDomain.getItems());
        }
        return this.projectReportMapper.selectByPrimaryKey(pr.getId());
    }

    @Override
    @Transactional
    public ProjectReport reject(Long id, String reason) throws Exception {
        ProjectReport pr = this.projectReportMapper.selectByPrimaryKey(id);
        if (pr == null) {
            throw new IllegalArgumentException("\u62a5\u5907\u4e0d\u5b58\u5728");
        }
        ProjectReportDomain domain = ProjectReportAssembler.toDomain(pr);
        domain.reject(reason);
        ProjectReport updated = ProjectReportAssembler.toEntity(domain);
        this.projectReportMapper.updateByPrimaryKey(updated);
        if (domain.getItems() != null) {
            this.replaceItems(updated.getId(), domain.getItems());
        }
        return this.projectReportMapper.selectByPrimaryKey(updated.getId());
    }

    @Override
    @Transactional
    public ProjectReport approve(Long id) throws Exception {
        ProjectReport pr = this.projectReportMapper.selectByPrimaryKey(id);
        if (pr == null) {
            throw new IllegalArgumentException("\u62a5\u5907\u4e0d\u5b58\u5728");
        }
        ProjectReportDomain domain = ProjectReportAssembler.toDomain(pr);
        domain.rollbackPrev();
        ProjectReport updated = ProjectReportAssembler.toEntity(domain);
        this.projectReportMapper.updateByPrimaryKey(updated);
        if (domain.getItems() != null) {
            this.replaceItems(updated.getId(), domain.getItems());
        }
        return this.projectReportMapper.selectByPrimaryKey(updated.getId());
    }

    @Override
    public DuplicateCheckResult duplicateCheck(Long id) throws Exception {
        ProjectReport base = this.projectReportMapper.selectByPrimaryKey(id);
        if (base == null) {
            throw new IllegalArgumentException("\u62a5\u5907\u4e0d\u5b58\u5728");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("province", base.getProvince());
        map.put("city", base.getCity());
        map.put("district", base.getDistrict());
        map.put("address", base.getAddressDetail());
        List<ProjectReport> candidates = this.projectReportMapper.query(map);
        ArrayList<SimilarReport> similarReports = new ArrayList<SimilarReport>();
        for (ProjectReport other : candidates) {
            double sim = TextSimilarityUtils.calcSimilarity(base, other);
            SimilarReport sr = new SimilarReport();
            sr.setReport(other);
            sr.setSimilarity(sim);
            similarReports.add(sr);
        }
        similarReports.sort((a, b) -> Double.compare(b.getSimilarity(), a.getSimilarity()));
        DuplicateCheckResult result = new DuplicateCheckResult();
        result.setBaseReport(base);
        result.setSimilarReports(similarReports);
        return result;
    }

    private void replaceItems(Long reportId, List<ProjectReportItemDomain> itemDomains) {
        this.projectReportItemOrderMapper.deleteByReportId(reportId);
        this.projectReportItemMapper.deleteByReportId(reportId);
        if (itemDomains == null || itemDomains.isEmpty()) {
            return;
        }
        for (ProjectReportItemDomain itemDomain : itemDomains) {
            ProjectReportItem itemEntity = ProjectReportItemAssembler.toEntity(itemDomain);
            itemEntity.setReportId(reportId);
            this.projectReportItemMapper.insert(itemEntity);
            if (itemDomain.getOrders() == null || itemDomain.getOrders().isEmpty()) continue;
            List<ProjectReportItemOrder> orders = itemDomain.getOrders().stream().map(ProjectReportItemOrderAssembler::toEntity).collect(Collectors.toList());
            for (ProjectReportItemOrder o : orders) {
                o.setReportItemId(itemEntity.getId());
            }
            this.projectReportItemOrderMapper.insertBatch(orders);
        }
    }

    public void setProjectReportMapper(ProjectReportMapper projectReportMapper) {
        this.projectReportMapper = projectReportMapper;
    }

    public void setProjectReportItemMapper(ProjectReportItemMapper projectReportItemMapper) {
        this.projectReportItemMapper = projectReportItemMapper;
    }

    public void setProjectReportItemOrderMapper(ProjectReportItemOrderMapper projectReportItemOrderMapper) {
        this.projectReportItemOrderMapper = projectReportItemOrderMapper;
    }
}

