/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.groovy;

import com.yqbsoft.laser.service.esb.annotation.DateTimeFormat;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.router.InternalRouterImpl;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseService;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.SupperApiException;
import com.yqbsoft.laser.service.suppercore.supper.SupBaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GroovyBaseServiceImpl
extends SupBaseServiceImpl
implements BaseService {
    private static final ExecutorService pool = Executors.newFixedThreadPool(5);
    private static final String SUB_MAP_SEPARATOR = ":";
    private InternalRouter internalRouter;
    private Object UUIDLock = new Object();

    public void setInternalRouter(InternalRouter internalRouter) {
        this.internalRouter = internalRouter;
    }

    public InternalRouter getInternalRouter() {
        if (null == this.internalRouter) {
            this.setInternalRouter((InternalRouter)((InternalRouterImpl)SpringApplicationContextUtil.getBean((String)"internalRouter", InternalRouterImpl.class)));
        }
        return this.internalRouter;
    }

    public Map<String, Object> getQueryParamMap(String key, Object ... values) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String[] keys = key.split(",");
            if (keys.length > 0) {
                for (int i = 0; i < keys.length; ++i) {
                    map.put(keys[i], values[i]);
                }
            }
        }
        catch (Exception e) {
            map = null;
        }
        return map;
    }

    public Map<String, Object> getQueryMapParam(String keyStr, Object ... values) {
        if (StringUtils.isBlank((String)keyStr)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String[] keys = keyStr.split(",");
        boolean isSubMap = false;
        for (int i = 0; i < keys.length; ++i) {
            String k = keys[i];
            if (k.contains(SUB_MAP_SEPARATOR)) {
                isSubMap = true;
                result.put(k.split(SUB_MAP_SEPARATOR)[0], JsonUtil.buildNormalBinder().toJson(this.getSubMap(keys, values, i)));
                continue;
            }
            if (isSubMap || values[i] == null) continue;
            if (this.isBaseType(values[i])) {
                result.put(k, values[i]);
                continue;
            }
            result.put(k, JsonUtil.buildNormalBinder().toJson(values[i]));
        }
        return result;
    }

    private boolean isBaseType(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Character;
    }

    private Map<String, Object> getSubMap(String[] keys, Object[] values, Integer start) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(keys[start].split(SUB_MAP_SEPARATOR)[1], values[start]);
        for (int i = start + 1; i < keys.length; ++i) {
            String key = keys[i];
            if (key.contains(SUB_MAP_SEPARATOR)) {
                return result;
            }
            result.put(key, values[i]);
        }
        return result;
    }

    public String makeMaxCode(int code, int len) {
        StringBuffer codeStr = new StringBuffer(code + "");
        if (codeStr.length() >= len) {
            return codeStr.toString();
        }
        int forlen = len - codeStr.length();
        for (int i = 0; i < forlen; ++i) {
            codeStr.insert(0, "0");
        }
        return codeStr.toString();
    }

    public String makeMaxCode8(int code) {
        return this.makeMaxCode(code, 8);
    }

    public static void main(String[] args) {
        GroovyBaseServiceImpl baseService = new GroovyBaseServiceImpl();
        System.out.println(baseService.makeMaxCode8(2010191101));
    }

    public String makeMaxCode6(int code) {
        return this.makeMaxCode(code, 6);
    }

    public String getBatchNo(String notype, String tableName, String columnName, int num, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", notype);
        map.put("tableName", tableName);
        map.put("columnName", columnName);
        map.put("num", num);
        map.put("tenantCode", tenantCode);
        Object object = this.internalRouter.inInvoke("nm.no.createBatchMaxBillNumber", "1.0", "0", map);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public String getNo(String notype, String tableName, String columnName, String tenantCode) {
        String key;
        String no;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", notype);
        map.put("tableName", tableName);
        map.put("columnName", columnName);
        map.put("tenantCode", tenantCode);
        if (StringUtils.isBlank((String)notype)) {
            notype = "0";
        }
        if (StringUtils.isNotBlank((String)(no = DisUtil.spop((String)(key = tenantCode + notype + tableName + columnName))))) {
            return no;
        }
        Object object = this.internalRouter.inInvoke("nm.no.createMaxBillNumber", "1.0", "0", map);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public String getSysParam(String flagSettingCode, String tenantCode, String typeKey) {
        Map remap;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flagSettingCode", flagSettingCode);
        map.put("tenantCode", tenantCode);
        Object object = this.internalRouter.inInvoke("dd.falgSetting.getFalgSettingByCode", "1.0", "0", map);
        if (object != null && (remap = JsonUtil.buildNormalBinder().getJsonToMap(object.toString(), String.class, Object.class)) != null) {
            return (String)remap.get("flagSettingInfo");
        }
        return null;
    }

    public String internalInvoke(String apiCode, Map<String, Object> paramMap) {
        Object object = this.getInternalRouter().inInvoke(apiCode, "1.0", "0", paramMap);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public String internalInvokeCallBack(String apiCode, Map<String, Object> paramMap, String routerdire) {
        Object object = this.getInternalRouter().inInvoke(apiCode, "1.0", routerdire, paramMap);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    public void inAsyncInvoke(final String apiCode, final Map<String, Object> paramMap) throws SupperApiException {
        if (pool != null) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    GroovyBaseServiceImpl.this.internalInvoke(apiCode, paramMap);
                }
            });
        }
    }

    public Object readObj(String apiCode, Map<String, Object> paramMap, String type, Object ... resultMap) {
        String object = this.internalInvoke(apiCode, paramMap);
        Object obj = null;
        if (type.equals("")) {
            return "";
        }
        if (object == null) {
            return null;
        }
        if (type.equals("object")) {
            obj = JsonUtil.buildNormalBinder().getJsonToObject(object, (Class)resultMap[0]);
        } else if (type.equals("map")) {
            obj = JsonUtil.buildNormalBinder().getJsonToMap(object, (Class)resultMap[0], (Class)resultMap[1]);
        } else if (type.equals("list")) {
            obj = JsonUtil.buildNormalBinder().getJsonToList(object, (Class)resultMap[0]);
        }
        return obj;
    }

    public QueryResult sendReSupObject(String apiCode, Map<String, Object> paramMap, Class cls) {
        String json = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isNotBlank((String)json)) {
            QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
            List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), cls);
            queryResult.setList(list);
            return queryResult;
        }
        return null;
    }

    public <T> T getForObject(String apiCode, Class<T> responseType, Map<String, Object> params) {
        String json = this.internalInvoke(apiCode, params);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        return (T)JsonUtil.buildNormalBinder().getJsonToObject(json, responseType);
    }

    public <T> QueryResult<T> getQueryResutl(String apiCode, Map<String, Object> paramMap, Class<T> cls) {
        String json = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isNotBlank((String)json)) {
            QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
            List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), cls);
            queryResult.setList(list);
            return queryResult;
        }
        return null;
    }

    protected void convertTimeInModel(Object model) {
        Field[] fields;
        for (Field field : fields = BeanUtils.getObjAllOpProperty((Object)model)) {
            String valStr;
            DateTimeFormat annotation = field.getAnnotation(DateTimeFormat.class);
            if (annotation == null) continue;
            String dateTimeFormat = annotation.pattern();
            Object value = BeanUtils.getObjValue((Object)model, (String)field.getName(), null);
            if (null == value || StringUtils.isEmpty((String)(valStr = String.valueOf(value)))) continue;
            value = DateUtil.getDateString((Date)DateUtil.getDateToString((String)valStr, (String)"yyyy-MM-dd HH:mm:ss"), (String)dateTimeFormat);
            BeanUtils.setObjValue((Object)model, (String)field.getName(), (Object)value);
        }
    }

    public PageTools getPage(Map<String, Object> map) {
        Integer pageSize;
        if (null == map || map.isEmpty()) {
            return new PageTools();
        }
        PageTools pageTools = new PageTools();
        Integer pageNo = (Integer)map.get("page");
        if (null != pageNo) {
            pageTools.setPageNo(pageNo.intValue());
        }
        if (null == (pageSize = (Integer)map.get("rows")) || "0".equals(pageSize)) {
            pageSize = 10;
        }
        pageTools.setPageSize(pageSize.intValue());
        Integer startRow = (Integer)map.get("startRow");
        if (null != startRow) {
            pageTools.setStartRow(startRow.intValue());
        }
        return pageTools;
    }

    public <T> QueryResult<T> getPageInfo(List<T> list, Map<String, Object> map, int recordCount) {
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = this.getPage(map);
        pageTools.setRecordCount(recordCount);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUUIDString() {
        Object object = this.UUIDLock;
        synchronized (object) {
            return UUID.randomUUID().toString().replace("-", "");
        }
    }
}

