/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.utils;

import com.yqbsoft.laser.service.contract.domain.ProjectReportItemDomain;
import com.yqbsoft.laser.service.contract.domain.ReplenishmentItemDomain;
import com.yqbsoft.laser.service.contract.service.ProjectReportService;
import com.yqbsoft.laser.service.contract.utils.ReplenishmentApprovedEvent;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class ReplenishmentApprovedEventHandler {
    private final ProjectReportService projectReportService;

    @EventListener
    public void handReplenishmentApproved(ReplenishmentApprovedEvent event) throws Exception {
        Long reportId = event.getReportId();
        List<ReplenishmentItemDomain> items = event.getItems();
        ArrayList<ProjectReportItemDomain> reportItems = new ArrayList<ProjectReportItemDomain>();
        for (ReplenishmentItemDomain item : items) {
            ProjectReportItemDomain reportItem = new ProjectReportItemDomain();
            reportItem.setReportId(reportId);
            reportItem.setSpuCode(item.getSpuCode());
            reportItem.setSkuCode(item.getSkuCode());
            reportItem.setSalesCode(item.getSalesCode());
            reportItem.setProductName(item.getProductName());
            reportItem.setSpec(item.getSpec());
            reportItem.setSeries(item.getSeries());
            reportItem.setCategoryName(item.getCategoryName());
            reportItem.setColor(item.getColor());
            reportItem.setSupportChannel(item.getSupportChannel());
            reportItem.setExFactoryPrice(item.getExFactoryPrice());
            reportItem.setContractPrice(item.getContractPrice());
            reportItem.setQty(item.getQty());
            reportItem.setOrderedQty(0);
            reportItem.setVersion(0);
            reportItem.setIsQuoted(1);
            reportItem.setDiscountedPrice(item.getContractPrice());
            reportItems.add(reportItem);
        }
        this.projectReportService.addGoodsToReportOrder(reportId, reportItems);
    }

    public ReplenishmentApprovedEventHandler(ProjectReportService projectReportService) {
        this.projectReportService = projectReportService;
    }
}

