/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractSubMapper;
import com.yqbsoft.laser.service.contract.dao.OcContractSublistMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractSubDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractSubReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractSublistDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractSublistReDomain;
import com.yqbsoft.laser.service.contract.model.OcContractSub;
import com.yqbsoft.laser.service.contract.model.OcContractSublist;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcContractSubService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractSubServiceImpl
extends BaseServiceImpl
implements OcContractSubService {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractSubServiceImpl";
    private OcContractSubMapper ocContractSubMapper;
    private OcContractSublistMapper ocContractSublistMapper;
    private OcContractService ocContractService;

    public void setOcContractSubMapper(OcContractSubMapper ocContractSubMapper) {
        this.ocContractSubMapper = ocContractSubMapper;
    }

    public void setOcContractSublistMapper(OcContractSublistMapper ocContractSublistMapper) {
        this.ocContractSublistMapper = ocContractSublistMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocContractSubMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractSub(OcContractSubDomain ocContractSubDomain) {
        if (null == ocContractSubDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractSubDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractSubDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractSubDefault(OcContractSub ocContractSub) {
        if (null == ocContractSub) {
            return;
        }
        if (null == ocContractSub.getDataState()) {
            ocContractSub.setDataState(0);
        }
        if (null == ocContractSub.getGmtCreate()) {
            ocContractSub.setGmtCreate(this.getSysDate());
        }
        ocContractSub.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContractSub.getContractSubCode())) {
            ocContractSub.setContractSubCode(this.createUUIDString());
        }
    }

    private int getContractSubMaxCode() {
        int code = 0;
        try {
            return this.ocContractSubMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.getContractSubMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractSubUpdataDefault(OcContractSub ocContractSub) {
        if (null == ocContractSub) {
            return;
        }
        ocContractSub.setGmtModified(this.getSysDate());
    }

    private void saveContractSubModel(OcContractSub ocContractSub) throws ApiException {
        if (null == ocContractSub) {
            return;
        }
        try {
            this.ocContractSubMapper.insert(ocContractSub);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.saveContractSubModel.ex", (Throwable)e);
        }
    }

    private void saveContractSubBatchModel(List<OcContractSub> ocContractSubList) throws ApiException {
        if (null == ocContractSubList || ocContractSubList.isEmpty()) {
            return;
        }
        try {
            this.ocContractSubMapper.insertBatch(ocContractSubList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.saveContractSubBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractSub getContractSubModelById(Integer contractSubId) {
        if (null == contractSubId) {
            return null;
        }
        try {
            return this.ocContractSubMapper.selectByPrimaryKey(contractSubId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.getContractSubModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractSub getContractSubModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractSubMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.getContractSubModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractSubModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSubMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.delContractSubModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.delContractSubModelByCode.num");
        }
    }

    private void deleteContractSubModel(Integer contractSubId) throws ApiException {
        if (null == contractSubId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSubMapper.deleteByPrimaryKey(contractSubId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.deleteContractSubModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.deleteContractSubModel.num");
        }
    }

    private void updateContractSubModel(OcContractSub ocContractSub) throws ApiException {
        if (null == ocContractSub) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSubMapper.updateByPrimaryKey(ocContractSub);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSubModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSubModel.num");
        }
    }

    private void updateStateContractSubModel(Integer contractSubId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractSubId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSubId", contractSubId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractSubMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSubModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSubModel.null");
        }
    }

    private void updateStateContractSubModelByCode(String tenantCode, String contractSubCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractSubCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSubCode", contractSubCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractSubMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSubModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSubModelByCode.null");
        }
    }

    private void updateStateContractSubPayModelByCode(String tenantCode, String contractSubCode, Integer dataState, Integer oldDataState, BigDecimal contractSubPmoney) throws ApiException {
        if (StringUtils.isBlank((String)contractSubCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSubCode", contractSubCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("contractSubPmoney", contractSubPmoney);
        int i = 0;
        try {
            i = this.ocContractSubMapper.updatePay(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSubPayModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSubPayModelByCode.null");
        }
    }

    private void updateContractSubPateModelByCode(String tenantCode, String contractSubCode, String ptradeSeqno) throws ApiException {
        if (StringUtils.isBlank((String)contractSubCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)ptradeSeqno)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSubCode", contractSubCode);
        map.put("ptradeSeqno", ptradeSeqno);
        int i = 0;
        try {
            i = this.ocContractSubMapper.updatePate(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSubPateModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSubPateModelByCode.null");
        }
    }

    private OcContractSub makeContractSub(OcContractSubDomain ocContractSubDomain, OcContractSub ocContractSub) {
        if (null == ocContractSubDomain) {
            return null;
        }
        if (null == ocContractSub) {
            ocContractSub = new OcContractSub();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSub, (Object)ocContractSubDomain);
            return ocContractSub;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.makeContractSub", (Throwable)e);
            return null;
        }
    }

    private OcContractSubReDomain makeOcContractSubReDomain(OcContractSub ocContractSub) {
        if (null == ocContractSub) {
            return null;
        }
        OcContractSubReDomain ocContractSubReDomain = new OcContractSubReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSubReDomain, (Object)ocContractSub);
            return ocContractSubReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.makeOcContractSubReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractSub> queryContractSubModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractSubMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.queryContractSubModel", (Throwable)e);
            return null;
        }
    }

    private int countContractSub(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractSubMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.countContractSub", (Throwable)e);
        }
        return i;
    }

    private OcContractSub createOcContractSub(OcContractSubDomain ocContractSubDomain) {
        String msg = this.checkContractSub(ocContractSubDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.saveContractSub.checkContractSub", msg);
        }
        OcContractSub ocContractSub = this.makeContractSub(ocContractSubDomain, null);
        this.setContractSubDefault(ocContractSub);
        return ocContractSub;
    }

    private String checkContractSublist(OcContractSublistDomain ocContractSublistDomain) {
        if (null == ocContractSublistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractSublistDomain.getContractSubCode())) {
            msg = msg + "ContractSubCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractSublistDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractSublistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractSublistDefault(OcContractSublist ocContractSublist) {
        if (null == ocContractSublist) {
            return;
        }
        if (null == ocContractSublist.getDataState()) {
            ocContractSublist.setDataState(0);
        }
        if (null == ocContractSublist.getGmtCreate()) {
            ocContractSublist.setGmtCreate(this.getSysDate());
        }
        ocContractSublist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContractSublist.getContractSublistCode())) {
            ocContractSublist.setContractSublistCode(this.createUUIDString());
        }
    }

    private int getContractSublistMaxCode() {
        int code = 0;
        try {
            return this.ocContractSublistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.getContractSublistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractSublistUpdataDefault(OcContractSublist ocContractSublist) {
        if (null == ocContractSublist) {
            return;
        }
        ocContractSublist.setGmtModified(this.getSysDate());
    }

    private void saveContractSublistModel(OcContractSublist ocContractSublist) throws ApiException {
        if (null == ocContractSublist) {
            return;
        }
        try {
            this.ocContractSublistMapper.insert(ocContractSublist);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.saveContractSublistModel.ex", (Throwable)e);
        }
    }

    private void saveContractSublistBatchModel(List<OcContractSublist> ocContractSublistList) throws ApiException {
        if (null == ocContractSublistList || ocContractSublistList.isEmpty()) {
            return;
        }
        try {
            this.ocContractSublistMapper.insertBatch(ocContractSublistList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.saveContractSublistBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractSublist getContractSublistModelById(Integer contractSublistId) {
        if (null == contractSublistId) {
            return null;
        }
        try {
            return this.ocContractSublistMapper.selectByPrimaryKey(contractSublistId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.getContractSublistModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractSublist getContractSublistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractSublistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.getContractSublistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractSublistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSublistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.delContractSublistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.delContractSublistModelByCode.num");
        }
    }

    private void deleteContractSublistModel(Integer contractSublistId) throws ApiException {
        if (null == contractSublistId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSublistMapper.deleteByPrimaryKey(contractSublistId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.deleteContractSublistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.deleteContractSublistModel.num");
        }
    }

    private void updateContractSublistModel(OcContractSublist ocContractSublist) throws ApiException {
        if (null == ocContractSublist) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSublistMapper.updateByPrimaryKey(ocContractSublist);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSublistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSublistModel.num");
        }
    }

    private void updateStateContractSublistModel(Integer contractSublistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractSublistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSublistId", contractSublistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractSublistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSublistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSublistModel.null");
        }
    }

    private void updateStateContractSublistModelByCode(String tenantCode, String contractSublistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractSublistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSublistCode", contractSublistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractSublistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSublistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateStateContractSublistModelByCode.null");
        }
    }

    private OcContractSublist makeContractSublist(OcContractSublistDomain ocContractSublistDomain, OcContractSublist ocContractSublist) {
        if (null == ocContractSublistDomain) {
            return null;
        }
        if (null == ocContractSublist) {
            ocContractSublist = new OcContractSublist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSublist, (Object)ocContractSublistDomain);
            return ocContractSublist;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.makeContractSublist", (Throwable)e);
            return null;
        }
    }

    private OcContractSublistReDomain makeOcContractSublistReDomain(OcContractSublist ocContractSublist) {
        if (null == ocContractSublist) {
            return null;
        }
        OcContractSublistReDomain ocContractSublistReDomain = new OcContractSublistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSublistReDomain, (Object)ocContractSublist);
            return ocContractSublistReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.makeOcContractSublistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractSublist> queryContractSublistModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractSublistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.queryContractSublistModel", (Throwable)e);
            return null;
        }
    }

    private int countContractSublist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractSublistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSubServiceImpl.countContractSublist", (Throwable)e);
        }
        return i;
    }

    private OcContractSublist createOcContractSublist(OcContractSublistDomain ocContractSublistDomain) {
        String msg = this.checkContractSublist(ocContractSublistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.saveContractSublist.checkContractSublist", msg);
        }
        OcContractSublist ocContractSublist = this.makeContractSublist(ocContractSublistDomain, null);
        this.setContractSublistDefault(ocContractSublist);
        return ocContractSublist;
    }

    @Override
    public String saveContractSub(OcContractSubDomain ocContractSubDomain) throws ApiException {
        OcContractSub ocContractSub = this.createOcContractSub(ocContractSubDomain);
        this.saveContractSubModel(ocContractSub);
        return ocContractSub.getContractSubCode();
    }

    @Override
    public String saveContractSubBatch(List<OcContractSubDomain> ocContractSubDomainList) throws ApiException {
        if (null == ocContractSubDomainList || ocContractSubDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractSub> ocContractSubList = new ArrayList<OcContractSub>();
        String code = "";
        for (OcContractSubDomain ocContractSubDomain : ocContractSubDomainList) {
            OcContractSub ocContractSub = this.createOcContractSub(ocContractSubDomain);
            code = ocContractSub.getContractSubCode();
            ocContractSubList.add(ocContractSub);
        }
        this.saveContractSubBatchModel(ocContractSubList);
        return code;
    }

    @Override
    public void updateContractSubState(Integer contractSubId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractSubModel(contractSubId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSubStateByCode(String tenantCode, String contractSubCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractSubModelByCode(tenantCode, contractSubCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSub(OcContractSubDomain ocContractSubDomain) throws ApiException {
        String msg = this.checkContractSub(ocContractSubDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSub.checkContractSub", msg);
        }
        OcContractSub oldOcContractSub = this.getContractSubModelById(ocContractSubDomain.getContractSubId());
        if (null == oldOcContractSub) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSub.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractSub ocContractSub = this.makeContractSub(ocContractSubDomain, oldOcContractSub);
        this.setContractSubUpdataDefault(ocContractSub);
        this.updateContractSubModel(ocContractSub);
    }

    @Override
    public OcContractSub getContractSub(Integer contractSubId) {
        return this.getContractSubModelById(contractSubId);
    }

    @Override
    public void deleteContractSub(Integer contractSubId) throws ApiException {
        this.deleteContractSubModel(contractSubId);
    }

    @Override
    public QueryResult<OcContractSub> queryContractSubPage(Map<String, Object> map) {
        List<OcContractSub> ocContractSubList = this.queryContractSubModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractSub(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractSubList);
        return queryResult;
    }

    @Override
    public OcContractSub getContractSubByCode(String tenantCode, String contractSubCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSubCode", contractSubCode);
        return this.getContractSubModelByCode(map);
    }

    @Override
    public void deleteContractSubByCode(String tenantCode, String contractSubCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSubCode", contractSubCode);
        this.delContractSubModelByCode(map);
    }

    @Override
    public String saveContractSublist(OcContractSublistDomain ocContractSublistDomain) throws ApiException {
        OcContractSublist ocContractSublist = this.createOcContractSublist(ocContractSublistDomain);
        this.saveContractSublistModel(ocContractSublist);
        return ocContractSublist.getContractSublistCode();
    }

    @Override
    public String saveContractSublistBatch(List<OcContractSublistDomain> ocContractSublistDomainList) throws ApiException {
        if (null == ocContractSublistDomainList || ocContractSublistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractSublist> ocContractSublistList = new ArrayList<OcContractSublist>();
        String code = "";
        for (OcContractSublistDomain ocContractSublistDomain : ocContractSublistDomainList) {
            OcContractSublist ocContractSublist = this.createOcContractSublist(ocContractSublistDomain);
            code = ocContractSublist.getContractSublistCode();
            ocContractSublistList.add(ocContractSublist);
        }
        this.saveContractSublistBatchModel(ocContractSublistList);
        return code;
    }

    @Override
    public void updateContractSublistState(Integer contractSublistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractSublistModel(contractSublistId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSublistStateByCode(String tenantCode, String contractSublistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractSublistModelByCode(tenantCode, contractSublistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSublist(OcContractSublistDomain ocContractSublistDomain) throws ApiException {
        String msg = this.checkContractSublist(ocContractSublistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSublist.checkContractSublist", msg);
        }
        OcContractSublist oldOcContractSublist = this.getContractSublistModelById(ocContractSublistDomain.getContractSublistId());
        if (null == oldOcContractSublist) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.updateContractSublist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractSublist ocContractSublist = this.makeContractSublist(ocContractSublistDomain, oldOcContractSublist);
        this.setContractSublistUpdataDefault(ocContractSublist);
        this.updateContractSublistModel(ocContractSublist);
    }

    @Override
    public OcContractSublist getContractSublist(Integer contractSublistId) {
        return this.getContractSublistModelById(contractSublistId);
    }

    @Override
    public void deleteContractSublist(Integer contractSublistId) throws ApiException {
        this.deleteContractSublistModel(contractSublistId);
    }

    @Override
    public QueryResult<OcContractSublist> queryContractSublistPage(Map<String, Object> map) {
        List<OcContractSublist> ocContractSublistList = this.queryContractSublistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractSublist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractSublistList);
        return queryResult;
    }

    @Override
    public OcContractSublist getContractSublistByCode(String tenantCode, String contractSublistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSublistCode", contractSublistCode);
        return this.getContractSublistModelByCode(map);
    }

    @Override
    public void deleteContractSublistByCode(String tenantCode, String contractSublistCode) throws ApiException {
        if (StringUtils.isBlank((String)contractSublistCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcContractSubServiceImpl.deleteContractSublistByCode.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSublistCode", contractSublistCode);
        this.delContractSublistModelByCode(map);
    }

    @Override
    public List<OcContractSublist> queryContractSublistByContractCode(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        return this.queryContractSublistModelPage(map);
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    @Override
    public void updateContracSubPay(String contractSubCode, String tenantCode, String contractBillcode) {
        this.logger.error("contractSubCode----" + contractSubCode);
        if (StringUtils.isBlank((String)contractSubCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSubCode", contractSubCode);
        OcContractSub ocContractSub = this.getContractSubModelByCode(map);
        if (null == ocContractSub || 1 == ocContractSub.getDataState()) {
            return;
        }
        BigDecimal contractSubPmoney = ocContractSub.getContractSubGmoney();
        this.updateStateContractSubPayModelByCode(tenantCode, contractSubCode, 1, 0, contractSubPmoney);
        if (StringUtils.isNotBlank((String)contractBillcode)) {
            this.ocContractService.updateContractPay(contractBillcode, tenantCode, contractSubPmoney);
        }
        DisUtil.set((String)("ocContract-state-" + contractSubCode + tenantCode), (String)String.valueOf(1), (int)10);
    }

    @Override
    public void updateContracSubPate(String contractSubCode, String tenantCode, String ptradeSeqno) {
        if (StringUtils.isBlank((String)contractSubCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)ptradeSeqno)) {
            return;
        }
        this.updateContractSubPateModelByCode(tenantCode, contractSubCode, ptradeSeqno);
    }

    public static void main(String[] args) {
    }
}

