/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yqbsoft.laser.service.contract.biz.OrderPaymentFlowService;
import com.yqbsoft.laser.service.contract.domain.BizPaymentFlow;
import com.yqbsoft.laser.service.contract.enums.PayChannelsEnum;
import com.yqbsoft.laser.service.contract.requery.PayCallbackRequery;
import com.yqbsoft.laser.service.contract.requery.PayOrderRequery;
import com.yqbsoft.laser.service.contract.requery.PayRequest;
import com.yqbsoft.laser.service.contract.result.PaymentResult;
import com.yqbsoft.laser.service.contract.service.OrderPaymentService;
import com.yqbsoft.laser.service.contract.utils.FlowNoGenerator;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service(value="orderPaymentService")
public class OrderPaymentServiceImpl
extends BaseServiceImpl
implements OrderPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OrderPaymentServiceImpl.class);
    private final Environment env;
    private final OrderPaymentFlowService orderPaymentFlowService;
    private final InternalRouter internalRouter;
    private static final String ACTION_PAYMENT_REQ = "middle.payment.pay";

    @Override
    public String orderPayment(PayOrderRequery req) throws Exception {
        PaymentResult pr;
        String orderNo = req.getOrderNo();
        String traceId = UUID.randomUUID().toString();
        log.info("[Payment][{}] \u5f00\u59cb\u5904\u7406\u652f\u4ed8\u8bf7\u6c42, orderNo={}", (Object)traceId, (Object)orderNo);
        BizPaymentFlow exist = this.orderPaymentFlowService.getProcessingPaymentFlow(orderNo);
        if (exist != null) {
            log.info("[Payment][{}] \u5df2\u5b58\u5728\u652f\u4ed8\u6d41\u6c34\uff0c\u76f4\u63a5\u8fd4\u56de", (Object)traceId);
            return Optional.ofNullable(exist.getQrCodeUrl()).orElse(exist.getPayUrl());
        }
        long amountFen = req.getAmount().multiply(BigDecimal.valueOf(100L)).longValue();
        String flowNo = FlowNoGenerator.generate("PAY");
        PayRequest payRequest = PayRequest.builder().merchantCode(req.getMerchantCode()).outTradeNo(flowNo).amount(amountFen).notifyUrl(req.getNotifyUrl()).channel(PayChannelsEnum.CMB.getCode()).subject(req.getSubject()).tradeType("QR_CODE").build();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("payRequest", JSONObject.toJSONString((Object)payRequest));
        log.info("[Payment][{}] \u53d1\u8d77\u5185\u90e8\u652f\u4ed8\u8c03\u7528: {}", (Object)traceId, (Object)ACTION_PAYMENT_REQ);
        Object resultObj = this.internalRouter.inInvoke(ACTION_PAYMENT_REQ, "1.0", "0", paramMap);
        String resultStr = String.valueOf(resultObj);
        try {
            pr = (PaymentResult)JSONObject.parseObject((String)resultStr, PaymentResult.class);
            log.info("[Payment][{}] \u652f\u4ed8\u8fd4\u56de\u7ed3\u679c: {}", (Object)traceId, (Object)JSONObject.toJSONString((Object)pr));
        }
        catch (Exception e) {
            log.error("[Payment][{}] \u8fd4\u56de\u89e3\u6790\u5931\u8d25: {}", new Object[]{traceId, e.getMessage(), e});
            throw new RuntimeException("\u652f\u4ed8\u8fd4\u56de\u89e3\u6790\u5931\u8d25");
        }
        BizPaymentFlow flow = BizPaymentFlow.builder().flowNo(flowNo).orderNo(orderNo).customerCode(req.getCustomerCode()).merchantCode(req.getMerchantCode()).flowType(BizPaymentFlow.FlowType.PAYMENT).channel(pr.getChannel()).payType(payRequest.getTradeType()).currency("CNY").amount(amountFen).traceId(traceId).paymentOrderNo(pr.getPaymentOrderNo()).qrCodeUrl(pr.getQrCodeContent()).remark(pr.getRawResponse()).build();
        if (pr.isSuccess()) {
            flow.setStatus(BizPaymentFlow.FlowStatus.PROCESSING);
            this.orderPaymentFlowService.createPaymentFlow(flow);
            String finalQr = this.rewriteQrUrl(pr.getQrCodeContent());
            log.info("[Payment][{}] \u652f\u4ed8\u6d41\u6c34\u521b\u5efa\u6210\u529f, QR={}", (Object)traceId, (Object)finalQr);
            return finalQr;
        }
        flow.setStatus(BizPaymentFlow.FlowStatus.FAIL);
        this.orderPaymentFlowService.createPaymentFlow(flow);
        log.error("[Payment][{}] \u652f\u4ed8\u4e1a\u52a1\u5931\u8d25: {}, {}", new Object[]{traceId, pr.getErrorCode(), pr.getErrorMessage()});
        throw new RuntimeException(pr.getErrorMessage());
    }

    private String rewriteQrUrl(String original) {
        if (original == null) {
            return null;
        }
        String profile = this.env.getProperty("spring.profiles.active", "");
        if (!profile.contains("dev")) {
            return original;
        }
        String originDomain = "https://qr.95516.com";
        String targetDomain = "http://payment-uat.cs.cmburl.cn";
        if (original.startsWith(originDomain)) {
            return targetDomain + original.substring(originDomain.length());
        }
        return original;
    }

    @Override
    public BizPaymentFlow payCallback(PayCallbackRequery payCallbackRequery) throws Exception {
        log.info("=====OrderPaymentServiceImpl==payCallback======={}", (Object)payCallbackRequery);
        BizPaymentFlow flow = this.orderPaymentFlowService.getPaymentFlowByNo(payCallbackRequery.getFlowNo());
        flow.setPaymentOrderNo(payCallbackRequery.getPaymentOrderNo());
        flow.setStatus(BizPaymentFlow.FlowStatus.SUCCESS);
        flow.setUpdatedAt(LocalDateTime.now());
        this.orderPaymentFlowService.update(flow);
        return flow;
    }

    public OrderPaymentServiceImpl(Environment env, OrderPaymentFlowService orderPaymentFlowService, InternalRouter internalRouter) {
        this.env = env;
        this.orderPaymentFlowService = orderPaymentFlowService;
        this.internalRouter = internalRouter;
    }
}

