/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.PriceSheetItemMapper;
import com.yqbsoft.laser.service.contract.dao.PriceSheetMapper;
import com.yqbsoft.laser.service.contract.domain.PriceSheetDomain;
import com.yqbsoft.laser.service.contract.domain.PriceSheetItemDomain;
import com.yqbsoft.laser.service.contract.model.PriceSheet;
import com.yqbsoft.laser.service.contract.model.PriceSheetItem;
import com.yqbsoft.laser.service.contract.service.PricingOrderService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

public class PricingOrderServiceImpl
extends BaseServiceImpl
implements PricingOrderService {
    private PriceSheetMapper priceSheetMapper;
    private PriceSheetItemMapper priceSheetItemMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PriceSheet save(PriceSheetDomain priceSheetDomain) throws Exception {
        boolean isNew;
        PriceSheet priceSheet = new PriceSheet();
        BeanUtils.copyProperties((Object)priceSheetDomain, (Object)priceSheet, (String[])new String[]{"items"});
        boolean bl = isNew = priceSheet.getId() == null;
        if (isNew) {
            this.priceSheetMapper.insert(priceSheet);
        } else {
            this.priceSheetMapper.updateByPrimaryKeySelective(priceSheet);
        }
        List<PriceSheetItemDomain> domainItems = priceSheetDomain.getItems();
        if (domainItems != null && !domainItems.isEmpty()) {
            List<PriceSheetItem> priceSheetItems = domainItems.stream().map(domainItem -> {
                PriceSheetItem it = new PriceSheetItem();
                BeanUtils.copyProperties((Object)domainItem, (Object)it);
                it.setPriceSheetId(priceSheet.getId());
                return it;
            }).collect(Collectors.toList());
            if (!isNew) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("priceSheetId", priceSheet.getId());
                this.priceSheetItemMapper.delByCode(param);
            }
            priceSheet.setItems(priceSheetItems);
            this.insertItems(priceSheet);
        }
        return priceSheet;
    }

    private void insertItems(PriceSheet priceSheet) {
        if (priceSheet.getItems() != null && !priceSheet.getItems().isEmpty()) {
            this.priceSheetItemMapper.insertBatch(priceSheet.getItems());
        }
    }

    @Override
    public SupQueryResult<PriceSheet> list(Map<String, Object> param) throws Exception {
        List<PriceSheet> list = this.priceSheetMapper.query(param);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.priceSheetMapper.count(param));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(list);
        return queryResult;
    }

    @Override
    public PriceSheet getById(Long id) throws Exception {
        PriceSheet priceSheet = this.priceSheetMapper.selectByPrimaryKey(id);
        if (priceSheet == null) {
            throw new IllegalArgumentException("\u6279\u4ef7\u5355\u4e0d\u5b58\u5728! id=" + id);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("priceSheetId", id);
        List<PriceSheetItem> items = this.priceSheetItemMapper.query(map);
        priceSheet.setItems(items);
        return priceSheet;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PriceSheet audit(PriceSheetDomain priceSheetDomain) throws Exception {
        PriceSheet priceSheet = new PriceSheet();
        BeanUtils.copyProperties((Object)priceSheetDomain, (Object)priceSheet);
        this.priceSheetMapper.updateByPrimaryKeySelective(priceSheet);
        return priceSheet;
    }

    @Override
    public int existsUnfinishedPriceSheet(Long reportId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reportId", reportId);
        return this.priceSheetMapper.existsUnfinishedPriceByReportId(map);
    }

    @Override
    public List<PriceSheetItem> getPriceSheetItemBySheetIds(String joinedIds) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fuzzy", false);
        map.put("reportItemIdStr", joinedIds);
        return this.priceSheetItemMapper.query(map);
    }

    public void setPriceSheetMapper(PriceSheetMapper priceSheetMapper) {
        this.priceSheetMapper = priceSheetMapper;
    }

    public void setPriceSheetItemMapper(PriceSheetItemMapper priceSheetItemMapper) {
        this.priceSheetItemMapper = priceSheetItemMapper;
    }
}

