/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.biz;

import com.yqbsoft.laser.service.contract.dao.BizPaymentFlowMapper;
import com.yqbsoft.laser.service.contract.domain.BizPaymentFlow;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderPaymentFlowService {
    private static final Logger log = LoggerFactory.getLogger(OrderPaymentFlowService.class);
    private final BizPaymentFlowMapper orderPaymentFlowMapper;

    public BizPaymentFlow createPaymentFlow(BizPaymentFlow flow) {
        if (flow.getStatus() == null) {
            flow.setStatus(BizPaymentFlow.FlowStatus.INIT);
        }
        this.orderPaymentFlowMapper.insert(flow);
        log.info("[PaymentFlow] \u521b\u5efa\u652f\u4ed8\u6d41\u6c34: {}", (Object)flow);
        return flow;
    }

    public BizPaymentFlow createRefundFlow(BizPaymentFlow flow) {
        flow.setFlowType(BizPaymentFlow.FlowType.REFUND);
        flow.setStatus(BizPaymentFlow.FlowStatus.INIT);
        this.orderPaymentFlowMapper.insert(flow);
        log.info("[PaymentFlow] \u521b\u5efa\u9000\u6b3e\u6d41\u6c34: {}", (Object)flow);
        return flow;
    }

    public void updateStatus(Long flowId, String status, String traceId) {
        String tid = Optional.ofNullable(traceId).orElse(UUID.randomUUID().toString());
        log.info("[{}] \u66f4\u65b0\u652f\u4ed8/\u9000\u6b3e\u6d41\u6c34\u72b6\u6001: flowId={}, status={}", new Object[]{tid, flowId, status});
        this.orderPaymentFlowMapper.updateStatus(flowId, status);
    }

    public List<BizPaymentFlow> getFlowsByOrderNo(String orderNo) {
        return this.orderPaymentFlowMapper.selectByOrderNo(orderNo);
    }

    public BizPaymentFlow getProcessingPaymentFlow(String orderNo, String channel) {
        return this.orderPaymentFlowMapper.selectProcessingPayByOrderNo(orderNo, channel);
    }

    public Long getTotalPaidAmount(String orderNo) {
        return this.orderPaymentFlowMapper.selectTotalPaidAmountByOrderNo(orderNo);
    }

    public Long getTotalRefundedAmount(String orderNo) {
        return this.orderPaymentFlowMapper.selectTotalRefundedAmountByOrderNo(orderNo);
    }

    public void update(BizPaymentFlow flow) {
        this.orderPaymentFlowMapper.update(flow);
    }

    public BizPaymentFlow getPaymentFlowByNo(String flowNo) {
        return this.orderPaymentFlowMapper.selectByFlowNo(flowNo);
    }

    public OrderPaymentFlowService(BizPaymentFlowMapper orderPaymentFlowMapper) {
        this.orderPaymentFlowMapper = orderPaymentFlowMapper;
    }
}

