/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.enums;

import java.util.Arrays;

public enum OrderStatusEnum {
    TO_SUBMIT(1, "\u5f85\u63d0\u4ea4"),
    PRICE_APPROVING(2, "\u4ef7\u683c\u5ba1\u6279\u4e2d"),
    TO_PAY(3, "\u5f85\u4ed8\u6b3e"),
    IN_DELIVER(4, "\u4ea4\u4ed8\u4e2d"),
    CANCEL_APPROVING(5, "\u8ba2\u5355\u53d6\u6d88\u5ba1\u6279\u4e2d"),
    COMPLETED(6, "\u5df2\u5b8c\u6210"),
    CANCELED(-1, "\u5df2\u53d6\u6d88");

    private final int code;
    private final String desc;

    private OrderStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static OrderStatusEnum of(Integer code) {
        if (code == null) {
            return null;
        }
        return Arrays.stream(OrderStatusEnum.values()).filter(e -> e.code == code).findFirst().orElse(null);
    }

    public static String getDescByCode(Integer code) {
        OrderStatusEnum status = OrderStatusEnum.of(code);
        return status != null ? status.getDesc() : "";
    }

    public boolean isFinalStatus() {
        return this == COMPLETED || this == CANCELED;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

