/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractCtrlMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractCtrlCflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractCtrlDomain;
import com.yqbsoft.laser.service.contract.engine.ContractPutThread;
import com.yqbsoft.laser.service.contract.engine.ContractService;
import com.yqbsoft.laser.service.contract.model.OcContractCtrl;
import com.yqbsoft.laser.service.contract.service.OcContractCtrlService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.impl.OcContractServiceImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractCtrlServiceImpl
extends BaseServiceImpl
implements OcContractCtrlService {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractCtrlServiceImpl";
    private OcContractCtrlMapper ocContractCtrlMapper;

    public void setOcContractCtrlMapper(OcContractCtrlMapper ocContractCtrlMapper) {
        this.ocContractCtrlMapper = ocContractCtrlMapper;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractCtrlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractCtrl(OcContractCtrlDomain ocContractCtrlDomain) {
        if (null == ocContractCtrlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractCtrlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractCtrlDefault(OcContractCtrl ocContractCtrl) {
        if (null == ocContractCtrl) {
            return;
        }
        if (null == ocContractCtrl.getDataState()) {
            ocContractCtrl.setDataState(0);
        }
        if (null == ocContractCtrl.getGmtCreate()) {
            ocContractCtrl.setGmtCreate(this.getSysDate());
        }
        ocContractCtrl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContractCtrl.getContractCtrlSeqno())) {
            ocContractCtrl.setContractCtrlSeqno(this.createUUIDString());
        }
    }

    private int getContractCtrlMaxCode() {
        int code = 0;
        try {
            return this.ocContractCtrlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractCtrlServiceImpl.getContractCtrlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractCtrlUpdataDefault(OcContractCtrl ocContractCtrl) {
        if (null == ocContractCtrl) {
            return;
        }
        ocContractCtrl.setGmtModified(this.getSysDate());
    }

    private void saveContractCtrlModel(OcContractCtrl ocContractCtrl) throws ApiException {
        if (null == ocContractCtrl) {
            return;
        }
        try {
            this.ocContractCtrlMapper.insert(ocContractCtrl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.saveContractCtrlModel.ex", (Throwable)e);
        }
    }

    private OcContractCtrl getContractCtrlModelById(Integer contractCtrlId) {
        if (null == contractCtrlId) {
            return null;
        }
        try {
            return this.ocContractCtrlMapper.selectByPrimaryKey(contractCtrlId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractCtrlServiceImpl.getContractCtrlModelById", (Throwable)e);
            return null;
        }
    }

    public OcContractCtrl getContractCtrlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractCtrlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractCtrlServiceImpl.getContractCtrlModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delContractCtrlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractCtrlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.delContractCtrlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.delContractCtrlModelByCode.num");
        }
    }

    private void deleteContractCtrlModel(Integer contractCtrlId) throws ApiException {
        if (null == contractCtrlId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractCtrlMapper.deleteByPrimaryKey(contractCtrlId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.deleteContractCtrlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.deleteContractCtrlModel.num");
        }
    }

    private void updateContractCtrlModel(OcContractCtrl ocContractCtrl) throws ApiException {
        if (null == ocContractCtrl) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractCtrlMapper.updateByPrimaryKeySelective(ocContractCtrl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateContractCtrlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateContractCtrlModel.num");
        }
    }

    private void updateStateContractCtrlModel(Integer contractCtrlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractCtrlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractCtrlId", contractCtrlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractCtrlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateStateContractCtrlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateStateContractCtrlModel.null");
        }
    }

    private void updateUStateByBillCodeModel(String contractBillcode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractCtrlMapper.updateUStateByBillCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateUStateByBillCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateUStateByBillCodeModel.null");
        }
    }

    private OcContractCtrl makeContractCtrl(OcContractCtrlDomain ocContractCtrlDomain, OcContractCtrl ocContractCtrl) {
        if (null == ocContractCtrlDomain) {
            return null;
        }
        if (null == ocContractCtrl) {
            ocContractCtrl = new OcContractCtrl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractCtrl, (Object)ocContractCtrlDomain);
            return ocContractCtrl;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractCtrlServiceImpl.makeContractCtrl", (Throwable)e);
            return null;
        }
    }

    private List<OcContractCtrl> queryContractCtrlModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractCtrlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractCtrlServiceImpl.queryContractCtrlModel", (Throwable)e);
            return null;
        }
    }

    private int countContractCtrl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractCtrlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractCtrlServiceImpl.countContractCtrl", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveContractCtrl(OcContractCtrlDomain ocContractCtrlDomain) throws ApiException {
        String msg = this.checkContractCtrl(ocContractCtrlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.saveContractCtrl.checkContractCtrl", msg);
        }
        OcContractCtrl ocContractCtrl = this.makeContractCtrl(ocContractCtrlDomain, null);
        this.setContractCtrlDefault(ocContractCtrl);
        this.saveContractCtrlModel(ocContractCtrl);
        return ocContractCtrl.getContractCtrlSeqno();
    }

    @Override
    public void updateContractCtrlState(Integer contractCtrlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractCtrlModel(contractCtrlId, dataState, oldDataState);
    }

    @Override
    public void updateContractCtrl(OcContractCtrlDomain ocContractCtrlDomain) throws ApiException {
        String msg = this.checkContractCtrl(ocContractCtrlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateContractCtrl.checkContractCtrl", msg);
        }
        OcContractCtrl oldOcContractCtrl = this.getContractCtrlModelById(ocContractCtrlDomain.getContractCtrlId());
        if (null == oldOcContractCtrl) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateContractCtrl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractCtrl ocContractCtrl = this.makeContractCtrl(ocContractCtrlDomain, oldOcContractCtrl);
        this.setContractCtrlUpdataDefault(ocContractCtrl);
        this.updateContractCtrlModel(ocContractCtrl);
    }

    @Override
    public OcContractCtrl getContractCtrl(Integer contractCtrlId) {
        return this.getContractCtrlModelById(contractCtrlId);
    }

    @Override
    public void deleteContractCtrl(Integer contractCtrlId) throws ApiException {
        this.deleteContractCtrlModel(contractCtrlId);
    }

    @Override
    public QueryResult<OcContractCtrl> queryContractCtrlPage(Map<String, Object> map) {
        List<OcContractCtrl> ocContractCtrlList = this.queryContractCtrlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractCtrl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractCtrlList);
        return queryResult;
    }

    @Override
    public OcContractCtrl getContractCtrlByCode(Map<String, Object> map) {
        return this.getContractCtrlModelByCode(map);
    }

    @Override
    public OcContractCtrl getContractCtrlByBillCode(String contractBillcode, String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        List<OcContractCtrl> list = this.queryContractCtrlModelPage(map);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void delContractCtrlByCode(Map<String, Object> map) throws ApiException {
        this.delContractCtrlModelByCode(map);
    }

    @Override
    public void updateContractCtrlCflow(OcContractCtrlCflowDomain ocContractCtrlCflowDomain) {
        if (null == ocContractCtrlCflowDomain) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateContractCtrlCflow.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractCtrlSeqno", ocContractCtrlCflowDomain.getContractCtrlSeqno());
        map.put("tenantCode", ocContractCtrlCflowDomain.getTenantCode());
        OcContractCtrl ocContractCtrl = this.getContractCtrlModelByCode(map);
        if (null == ocContractCtrl) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.updateContractCtrlCflow.modelnull", ((Object)map).toString());
        }
        ocContractCtrl.setCflowCode(ocContractCtrlCflowDomain.getCflowCode());
        ocContractCtrl.setCflowNodeCode(ocContractCtrlCflowDomain.getCflowNodeCode());
        ocContractCtrl.setCflowPprocessCode(ocContractCtrlCflowDomain.getCflowPprocessCode());
        if (null != ocContractCtrlCflowDomain.getDataState()) {
            ocContractCtrl.setDataState(ocContractCtrlCflowDomain.getDataState());
        }
        this.updateContractCtrlModel(ocContractCtrl);
    }

    @Override
    public void updateContractCtrluStateByBillCode(String contractBillcode, String tenantCode, Integer dataState, Integer oldDataState) {
        this.updateUStateByBillCodeModel(contractBillcode, tenantCode, dataState, oldDataState);
    }

    public ContractService getContractService() {
        return OcContractServiceImpl.getContractService();
    }

    @Override
    public void loadContractCtrlProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcContractCtrl> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getContractService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getContractService().getPage());
                result = this.queryContractCtrlPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getContractService().addPutPool(new ContractPutThread(this.getContractService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), result.getRows()));
                    if (result.getRows().size() == this.getContractService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getContractService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractCtrlServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }
}

