/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.dao.CrpUrechargeMapper;
import com.yqbsoft.laser.service.crp.domain.CrpChannelsendDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeReDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargelistDomain;
import com.yqbsoft.laser.service.crp.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.crp.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.crp.enums.URechargeListTypeEnum;
import com.yqbsoft.laser.service.crp.es.SendPollThread;
import com.yqbsoft.laser.service.crp.es.SendPutThread;
import com.yqbsoft.laser.service.crp.es.SendService;
import com.yqbsoft.laser.service.crp.model.CrpChannelsend;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.model.CrpUrecharge;
import com.yqbsoft.laser.service.crp.model.CrpUrechargelist;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeBaseService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargelistService;
import com.yqbsoft.laser.service.crp.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpUrechargeServiceImpl
extends BaseServiceImpl
implements CrpUrechargeService {
    private static final String SYS_CODE = "service.crp.CrpUrechargeServiceImpl";
    private CrpUrechargeMapper crpUrechargeMapper;
    private CrpChannelsendService crpChannelsendService;
    private CrpUrechargelistService crpUrechargelistService;
    private CrpRechargeService crpRechargeService;
    private static SendService sendService;
    private static final Object lock;

    public CrpRechargeService getCrpRechargeService() {
        if (null == this.crpRechargeService) {
            this.crpRechargeService = (CrpRechargeService)ApplicationContextUtil.getService((String)"crpRechargeService");
        }
        return this.crpRechargeService;
    }

    public CrpChannelsendService getCrpChannelsendService() {
        return this.crpChannelsendService;
    }

    public void setCrpChannelsendService(CrpChannelsendService crpChannelsendService) {
        this.crpChannelsendService = crpChannelsendService;
    }

    public void setCrpUrechargeMapper(CrpUrechargeMapper crpUrechargeMapper) {
        this.crpUrechargeMapper = crpUrechargeMapper;
    }

    public CrpUrechargelistService getCrpUrechargelistService() {
        return this.crpUrechargelistService;
    }

    public void setCrpUrechargelistService(CrpUrechargelistService crpUrechargelistService) {
        this.crpUrechargelistService = crpUrechargelistService;
    }

    private Date getSysDate() {
        try {
            return this.crpUrechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpUrechargeDomain crpUrechargeDomain) {
        if (null == crpUrechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpUrechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return;
        }
        if (null == crpUrecharge.getDataState()) {
            crpUrecharge.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crpUrecharge.getGmtCreate()) {
            crpUrecharge.setGmtCreate(date);
        }
        crpUrecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crpUrecharge.getUrechargeCode())) {
            crpUrecharge.setUrechargeCode(this.getNo(null, "CrpUrecharge", "crpUrecharge", crpUrecharge.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpUrechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return;
        }
        crpUrecharge.setGmtModified(this.getSysDate());
    }

    private void saveCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        try {
            this.crpUrechargeMapper.insert(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpUrecharge> crpUrechargeList) throws ApiException {
        if (null == crpUrechargeList || crpUrechargeList.isEmpty()) {
            return;
        }
        try {
            this.crpUrechargeMapper.insertBatch(crpUrechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpUrecharge getCrpModelById(Integer urechargeId) {
        if (null == urechargeId) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.selectByPrimaryKey(urechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCrpModelByUserInfoCode(String tenantCode, String userInfoCode, String rechargeMode) {
        if (null == userInfoCode) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.selectByUserInfoCode(tenantCode, userInfoCode, rechargeMode);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCModelByUserInfoCode(String tenantCode, String userInfoCode, String fchannelPmodeCode, String rechargeType) {
        if (null == userInfoCode) {
            return null;
        }
        try {
            List<CrpUrecharge> crpUrecharges = this.crpUrechargeMapper.selectCByUserInfoCode(tenantCode, userInfoCode, fchannelPmodeCode, rechargeType);
            if (crpUrecharges.size() > 1) {
                this.logger.error("selectCByUserInfoCode.total not one");
            }
            return crpUrecharges.get(0);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer urechargeId) throws ApiException {
        if (null == urechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.deleteByPrimaryKey(urechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateByPrimaryKey(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateByPrimaryKeyCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateByPrimaryKeySelective(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer urechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == urechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargeId", urechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateAvailableQuotaModel(Integer urechargeId, BigDecimal quota, BigDecimal allMoney) throws ApiException {
        if (null == urechargeId || null == quota) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargeId", urechargeId);
        map.put("quota", quota);
        map.put("allMoney", allMoney);
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateAvailableQuota(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateAvailableQuotaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateAvailableQuotaModel.null");
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String urechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpUrecharge makeCrp(CrpUrechargeDomain crpUrechargeDomain, CrpUrecharge crpUrecharge) {
        if (null == crpUrechargeDomain) {
            return null;
        }
        if (null == crpUrecharge) {
            crpUrecharge = new CrpUrecharge();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crpUrecharge, (Object)crpUrechargeDomain);
            return crpUrecharge;
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpUrechargeReDomain makeCrpUrechargeReDomain(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return null;
        }
        CrpUrechargeReDomain crpUrechargeReDomain = new CrpUrechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargeReDomain, (Object)crpUrecharge);
            return crpUrechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.makeCrpUrechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrecharge> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpUrechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrechargeReDomain> queryCrpUModelPageList(Map<String, Object> parammap) {
        try {
            return this.crpUrechargeMapper.queryCrpURechargePageList(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.queryCrpModelPageList", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private int countCrpURechargeRe(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargeMapper.countCrpURechargeRe(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpUrecharge createCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, null);
        this.setCrpDefault(crpUrecharge);
        return crpUrecharge;
    }

    private List<CrpChannelsend> buidPmChannelsend(List<CrpUrecharge> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpUrecharge promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getUrechargeCode());
            pmChannelsendDomain.setChannelsendType("crpUrecharge");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public String saveCrpUrechargeByUserinfo(UmUserinfoDomain umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            return "error";
        }
        CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
        crpUrechargeDomain.setAppmanageIcode(umUserinfo.getAppmanageIcode());
        crpUrechargeDomain.setRechargeAllmoney(BigDecimal.ZERO);
        crpUrechargeDomain.setRechargeBmoney(BigDecimal.ZERO);
        crpUrechargeDomain.setRechargeUmoney(BigDecimal.ZERO);
        crpUrechargeDomain.setRechargeSmoney(BigDecimal.ZERO);
        crpUrechargeDomain.setRechargeMode("0");
        crpUrechargeDomain.setUserinfoCode(umUserinfo.getUserinfoCode());
        crpUrechargeDomain.setUserinfoName(umUserinfo.getUserinfoCompname());
        crpUrechargeDomain.setTenantCode(umUserinfo.getTenantCode());
        this.saveCrpUrechargeRe(crpUrechargeDomain);
        return "success";
    }

    @Override
    public List<CrpChannelsend> saveCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        CrpUrecharge crpUrecharge = this.createCrpUrecharge(crpUrechargeDomain);
        this.saveCrpModel(crpUrecharge);
        return null;
    }

    public CrpUrecharge saveCrpUrechargeRe(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        CrpUrecharge crpUrecharge = this.createCrpUrecharge(crpUrechargeDomain);
        this.saveCrpModel(crpUrecharge);
        return crpUrecharge;
    }

    @Override
    public List<CrpChannelsend> saveCrpUrechargeBatch(List<CrpUrechargeDomain> crpUrechargeDomainList) throws ApiException {
        if (null == crpUrechargeDomainList || crpUrechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpChannelsend> crpUrechargeList = new ArrayList<CrpChannelsend>();
        for (CrpUrechargeDomain crpUrechargeDomain : crpUrechargeDomainList) {
            List<CrpChannelsend> list = this.saveCrpUrecharge(crpUrechargeDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            crpUrechargeList.addAll(list);
        }
        return crpUrechargeList;
    }

    private List<CrpChannelsend> buidPmChannelsendStr(List<CrpUrecharge> crpUrechargeList, String dri) {
        if (ListUtil.isEmpty(crpUrechargeList)) {
            return null;
        }
        ArrayList<CrpChannelsendDomain> crpChannelsendDomainArrayList = new ArrayList<CrpChannelsendDomain>();
        for (CrpUrecharge crpUrecharge : crpUrechargeList) {
            CrpChannelsendDomain crpChannelsendDomain = new CrpChannelsendDomain();
            crpChannelsendDomain.setChannelsendOpcode(crpUrecharge.getUrechargeCode());
            crpChannelsendDomain.setChannelsendType("crpUrecharge");
            crpChannelsendDomain.setChannelsendDir(dri);
            crpChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)crpUrecharge));
            crpChannelsendDomain.setTenantCode(crpUrecharge.getTenantCode());
            crpChannelsendDomainArrayList.add(crpChannelsendDomain);
        }
        List<CrpChannelsend> pmChannelsendList = this.crpChannelsendService.saveCrpBatch(crpChannelsendDomainArrayList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeState(Integer urechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModel(urechargeId, dataState, oldDataState, map);
        CrpUrecharge orgDepartemp = this.getCrpUrecharge(urechargeId);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateAvailableQuota(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        CrpUrecharge crpUrecharge = this.getCrpUrecharge(crpUrechargeDomain.getUrechargeId());
        crpUrecharge.setRechargeAllmoney(crpUrecharge.getRechargeAllmoney().add(crpUrechargeDomain.getRechargeAllmoney()));
        crpUrecharge.setRechargeSmoney(crpUrecharge.getRechargeSmoney().add(crpUrechargeDomain.getRechargeAllmoney()));
        crpUrecharge.setRechargePeriod(crpUrechargeDomain.getRechargePeriod());
        crpUrecharge.setRechargeName3(crpUrechargeDomain.getRechargeName3());
        crpUrecharge.setRechargeName4(crpUrechargeDomain.getRechargeName4());
        crpUrecharge.setRechargeName8(crpUrechargeDomain.getRechargeName8());
        crpUrecharge.setRechargeName9(crpUrechargeDomain.getRechargeName9());
        crpUrecharge.setRechargeName10(crpUrechargeDomain.getRechargeName10());
        crpUrecharge.setRechargeName5(crpUrechargeDomain.getRechargeName5());
        crpUrecharge.setRechargeState(crpUrechargeDomain.getRechargeState());
        crpUrecharge.setRechargeUrl(crpUrechargeDomain.getRechargeUrl());
        crpUrecharge.setBankcardCode(crpUrechargeDomain.getBankcardCode());
        crpUrecharge.setBankcodeName(crpUrechargeDomain.getBankcodeName());
        crpUrecharge.setRechargeUrl2(crpUrechargeDomain.getBankcodeName());
        crpUrecharge.setRechargeMode(crpUrechargeDomain.getRechargeMode());
        String contractTypeName = null;
        contractTypeName = StringUtils.isBlank((String)crpUrechargeDomain.getBankcodeName()) ? "\u65b0\u589e\u989d\u5ea6" : crpUrechargeDomain.getBankcodeName();
        String rechargeType = URechargeListTypeEnum.UPDATE.getCode();
        String getddflag = FlagSettingUtils.getUrl(crpUrecharge.getTenantCode(), "CrpBalance", "CrpBalance");
        if (StringUtils.isNotBlank((String)getddflag) && StringUtils.equals((CharSequence)"Ax", (CharSequence)crpUrechargeDomain.getRechargeUrl4())) {
            rechargeType = "10";
        }
        this.setCrpUpdataDefault(crpUrecharge);
        crpUrecharge.setRechargeOpcode(crpUrechargeDomain.getRechargeOpcode());
        crpUrecharge.setQuota(crpUrechargeDomain.getRechargeAllmoney());
        crpUrecharge.setAllMoney(crpUrechargeDomain.getRechargeAllmoney());
        crpUrecharge.setRechargeName8(crpUrecharge.getRechargeName8());
        this.handlerCrpURecharge(crpUrecharge, rechargeType, contractTypeName);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> changeAvailableQuota(CrpUrecharge crpUrecharge, Map<String, Object> map) throws ApiException {
        BigDecimal quota = new BigDecimal(map.get("quota").toString());
        String quotaType = map.get("quotaType").toString();
        String rechargeOpno = map.get("contractBillcode").toString();
        crpUrecharge.setQuota(quota);
        this.logger.error("service.crp.CrpUrechargeServiceImpl.changeAvailableQuota.map" + JsonUtil.buildNonDefaultBinder().toJson(map));
        String contractTypeName = (String)map.get("rechargeRemark");
        if (null != map.get("contractType") && StringUtils.isNotBlank((String)map.get("contractType").toString())) {
            String contractType = map.get("contractType").toString();
            if (StringUtils.isNotBlank((String)contractType) && contractType.equals("00")) {
                contractTypeName = "\u6b63\u5f0f\u8ba2\u5355";
            } else if (StringUtils.isNotBlank((String)contractType) && contractType.equals("zy00")) {
                contractTypeName = "\u76f4\u8425\u8ba2\u5355";
            } else if (StringUtils.isNotBlank((String)contractType) && contractType.equals("80")) {
                contractTypeName = "\u9884\u552e\u8ba2\u5355";
            } else if (StringUtils.isNotBlank((String)contractType) && contractType.equals("85")) {
                contractTypeName = "\u9884\u552e\u8f6c\u6b63\u5f0f";
            } else if (StringUtils.isNotBlank((String)contractType) && contractType.equals("50")) {
                contractTypeName = "\u8fd0\u8d39\u8ba2\u5355";
            } else if (StringUtils.isNotBlank((String)contractType) && contractType.equals("86")) {
                contractTypeName = "\u6b63\u5f0f\u8ba2\u5355";
            }
        }
        crpUrecharge.setRechargeName10(contractTypeName);
        crpUrecharge.setBankcardCode("contract");
        crpUrecharge.setRechargeRemark(contractTypeName);
        crpUrecharge.setRechargeSmoney(quota);
        this.handlerCrpURecharge(crpUrecharge, quotaType, rechargeOpno, contractTypeName);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    private void handlerCrpURecharge(CrpUrecharge crpUrecharge, String rechargeType, String contractTypeName) {
        this.handlerCrpURecharge(crpUrecharge, rechargeType, null, contractTypeName);
    }

    private void handlerCrpURecharge(CrpUrecharge crpUrecharge, String rechargeType, String rechargeOpno, String contractTypeName) {
        block11: {
            CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
            try {
                BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpUrecharge);
                crpUrechargelistDomain.setRechargeAllmoney(crpUrecharge.getQuota() == null ? crpUrecharge.getRechargeSmoney() : crpUrecharge.getQuota());
                crpUrechargelistDomain.setUrechargeCode(crpUrecharge.getUrechargeCode());
                String getddflag = FlagSettingUtils.getUrl(crpUrecharge.getTenantCode(), "CrpBalance", "CrpBalance");
                if (StringUtils.isNotBlank((String)getddflag) && StringUtils.isNotBlank((String)crpUrecharge.getRechargeName10()) && crpUrecharge.getRechargeName10().equals("\u6388\u4fe1\u8fd4\u8fd8")) {
                    crpUrechargelistDomain.setUrechargelistDir("0");
                }
                crpUrechargelistDomain.setRechargeSmoney(crpUrecharge.getQuota() == null ? crpUrecharge.getRechargeSmoney() : crpUrecharge.getQuota());
                if (!"568457092274532359".equals(crpUrecharge.getTenantCode())) {
                    crpUrechargelistDomain.setRechargeType(rechargeType);
                }
                if (StringUtils.isBlank((String)rechargeOpno)) {
                    crpUrechargelistDomain.setRechargeOpno(crpUrecharge.getRechargeOpcode());
                } else {
                    crpUrechargelistDomain.setRechargeOpno(rechargeOpno);
                }
                if (!crpUrechargelistDomain.getRechargeAllmoney().equals(BigDecimal.valueOf(0L))) {
                    crpUrechargelistDomain.setRechargeName10(contractTypeName);
                    if (StringUtils.isBlank((String)crpUrechargelistDomain.getUrechargelistDir())) {
                        crpUrechargelistDomain.setUrechargelistDir("1");
                    }
                    this.logger.error("service.crp.CrpUrechargeServiceImpl.handlerCrpURecharge" + JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelistDomain));
                    this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
                    this.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
                    break block11;
                }
                HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
                stringObjectMap.put("tenantCode", crpUrecharge.getTenantCode());
                stringObjectMap.put("rechargeName8", crpUrecharge.getRechargeName8().toString());
                stringObjectMap.put("rechargeType", crpUrecharge.getRechargeType());
                QueryResult<CrpUrechargelist> crpUrechargelists = this.crpUrechargelistService.queryCrpUrechargelistPage(stringObjectMap);
                if (null == crpUrechargelists || ListUtil.isEmpty((Collection)crpUrechargelists.getList())) {
                    throw new ApiException("service.crp.CrpUrechargeServiceImpl.crpUrechargelists.null", "\u6570\u636e\u4e3a\u7a7a" + stringObjectMap);
                }
                CrpUrechargelist crpUrechargelist = (CrpUrechargelist)crpUrechargelists.getList().get(0);
                CrpUrechargelistDomain crpUrechargelistDomain1 = new CrpUrechargelistDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain1, (Object)crpUrechargelist);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                crpUrechargelistDomain1.setRechargeState(crpUrecharge.getRechargeState());
                crpUrechargelistDomain1.setRechargeName3(crpUrecharge.getRechargeName3());
                crpUrechargelistDomain1.setRechargeName4(crpUrecharge.getRechargeName4());
                crpUrechargelistDomain1.setTenantCode(crpUrecharge.getTenantCode());
                crpUrechargelistDomain1.setUrechargelistId(crpUrechargelist.getUrechargelistId());
                this.crpUrechargelistService.updateCrpUrechargelist(crpUrechargelistDomain1);
            }
            catch (Exception e) {
                this.logger.error("service.crp.CrpUrechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
            }
        }
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeStateByCode(String tenantCode, String urechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModelByCode(tenantCode, urechargeCode, dataState, oldDataState, map);
        CrpUrecharge orgDepartemp = this.getCrpUrechargeByCode(tenantCode, urechargeCode);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpUrecharge oldCrpUrecharge = this.getCrpModelById(crpUrechargeDomain.getUrechargeId());
        if (null == oldCrpUrecharge) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, oldCrpUrecharge);
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateCrpModel(crpUrecharge);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeByPriKey(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpUrechargeByPriKey.checkCrp", msg);
        }
        CrpUrecharge oldCrpUrecharge = this.getCrpModelById(crpUrechargeDomain.getUrechargeId());
        if (null == oldCrpUrecharge) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpUrechargeByPriKey.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, oldCrpUrecharge);
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateByPrimaryKeyCrpModel(crpUrecharge);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public CrpUrecharge getCrpUrecharge(Integer urechargeId) {
        if (null == urechargeId) {
            return null;
        }
        return this.getCrpModelById(urechargeId);
    }

    @Override
    public List<CrpChannelsend> deleteCrpUrecharge(Integer urechargeId) throws ApiException {
        CrpUrecharge orgDepartemp = this.getCrpUrecharge(urechargeId);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        this.deleteCrpModel(urechargeId);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public QueryResult<CrpUrecharge> queryCrpUrechargePage(Map<String, Object> map) {
        List<CrpUrecharge> crpUrechargeList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargeList);
        return queryResult;
    }

    @Override
    public QueryResult<CrpUrechargeReDomain> queryCrpURechargePageList(Map<String, Object> map) {
        List<CrpUrechargeReDomain> crpUrechargeList = this.queryCrpUModelPageList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrpURechargeRe(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargeList);
        return queryResult;
    }

    @Override
    public CrpUrecharge getCrpUrechargeByCode(String tenantCode, String urechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public CrpUrecharge selectByUserInfoCode(String tenantCode, String userInfoCode, String rechargeMode) throws ApiException {
        if (null == userInfoCode) {
            return null;
        }
        return this.getCrpModelByUserInfoCode(tenantCode, userInfoCode, rechargeMode);
    }

    @Override
    public CrpUrecharge selectCByUserInfoCode(String tenantCode, String userInfoCode, String fchannelPmodeCode, String rechargeType) throws ApiException {
        if (null == userInfoCode) {
            return null;
        }
        return this.getCModelByUserInfoCode(tenantCode, userInfoCode, fchannelPmodeCode, rechargeType);
    }

    @Override
    public List<CrpChannelsend> deleteCrpUrechargeByCode(String tenantCode, String urechargeCode) throws ApiException {
        CrpUrecharge orgDepartemp = this.getCrpUrechargeByCode(tenantCode, urechargeCode);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        this.delCrpModelByCode(map);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public Map<String, Object> deductibleCrp(BigDecimal goodsPmoney, String tenantCode, String userinfoCode) throws ApiException {
        if (null == goodsPmoney || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.deductibleCrp", (Object)("goodsPmoney:" + goodsPmoney + "tenantCode:" + tenantCode + "userinfoCode:" + userinfoCode));
            return null;
        }
        HashMap<String, Object> iamap = new HashMap<String, Object>();
        CrpUrecharge crpUrecharge = this.selectByUserInfoCode(tenantCode, userinfoCode, "0");
        if (null == crpUrecharge) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.deductibleCrp", (Object)("goodsPmoney:" + goodsPmoney + "tenantCode:" + tenantCode + "userinfoCode:" + userinfoCode));
            return null;
        }
        BigDecimal rechargeSmoney = crpUrecharge.getRechargeSmoney();
        if (null == rechargeSmoney) {
            rechargeSmoney = new BigDecimal(0);
        }
        BigDecimal disamount = new BigDecimal(0);
        disamount = rechargeSmoney.compareTo(goodsPmoney) > -1 ? goodsPmoney : rechargeSmoney;
        iamap.put("dataState", "0");
        iamap.put("disamount", disamount);
        return iamap;
    }

    @Override
    public void sendupdateCreditRepaymentMoneyCrp(Map<String, Object> map) {
        this.updateCreditMoneys(map);
    }

    public void updateCreditMoneys(Map<String, Object> map) {
        int i = 0;
        try {
            this.logger.error("map---->", map);
            i = this.crpUrechargeMapper.updateCreditMoney(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCreditMoney.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCreditMoney.null");
        }
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeDeail(CrpUrecharge urecharge) throws ApiException {
        CrpUrecharge crpUrecha = this.getCrpUrecharge(urecharge.getUrechargeId());
        BigDecimal oldAllMoney = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((String)crpUrecha.getRechargeName10())) {
            oldAllMoney = new BigDecimal(crpUrecha.getRechargeName10());
        }
        oldAllMoney = oldAllMoney.add(new BigDecimal(crpUrecha.getRechargeName10()));
        urecharge.setRechargeName10(oldAllMoney.toString());
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain, (Object)urecharge);
            crpUrechargelistDomain.setUrechargelistDir("1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateCrpModel(urecharge);
        List<CrpChannelsend> channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        this.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return channelsends;
    }

    @Override
    public List<CrpChannelsend> updateSmoneyByCode(String tenantCode, BigDecimal rechargeSmoney, String urechargelistCode, String memo) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || null == rechargeSmoney || StringUtils.isBlank((String)urechargelistCode) || StringUtils.isBlank((String)memo)) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl\u53c2\u6570\u4e3a\u7a7a");
        }
        this.crpUrechargelistService.updateCrpUrechargelistSmoney(tenantCode, rechargeSmoney, urechargelistCode, memo);
        CrpUrechargelist crpUrechargelist = this.crpUrechargelistService.getCrpUrechargelistByCode(tenantCode, urechargelistCode);
        if (null == crpUrechargelist || StringUtils.isBlank((String)crpUrechargelist.getUrechargeCode())) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrecharge crpUrecharge = this.getCrpUrechargeByCode(tenantCode, crpUrechargelist.getUrechargeCode());
        if (null == crpUrecharge) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl\u6570\u636e\u4e3a\u7a7a1");
        }
        crpUrecharge.setRechargeSmoney(rechargeSmoney);
        ArrayList<CrpUrecharge> crpUrechargeList = new ArrayList<CrpUrecharge>();
        this.updateCrpModel(crpUrecharge);
        crpUrechargeList.add(crpUrecharge);
        return this.buidPmChannelsend(crpUrechargeList, "edit");
    }

    @Override
    public void autoSend() {
        this.loadDb(null);
    }

    private void loadDb(Map<String, Object> map) {
        try {
            HashMap<String, Object> objMap = new HashMap<String, Object>();
            if (null != map && null != map.get("userinfoCode") || null != map.get("tenantCode")) {
                objMap.put("userinfoCode", map.get("userinfoCode"));
                objMap.put("tenantCode", map.get("tenantCode"));
            }
            objMap.put("order", true);
            objMap.put("dataState", 0);
            objMap.put("orderStr", "STR_TO_DATE(RECHARGE_NAME4,'%Y-%m-%d') asc");
            objMap.put("rechargeName4Str", "date");
            int startRow = 0;
            boolean flag = true;
            QueryResult<CrpUrecharge> result = null;
            do {
                startRow = CrpUrechargeServiceImpl.getSendService().getStartRow();
                objMap.put("startRow", startRow);
                objMap.put("rows", CrpUrechargeServiceImpl.getSendService().getPage());
                result = this.queryCrpUrechargePage(objMap);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    CrpUrechargeServiceImpl.getSendService().addPutPool(new SendPutThread(CrpUrechargeServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != CrpUrechargeServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(100L);
            } while (flag);
            CrpUrechargeServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((CrpUrechargeBaseService)SpringApplicationContextUtil.getBean((String)"crpUrechargeBaseService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargemonery(CrpUrecharge crpUrecharge) throws ApiException {
        BigDecimal newMoney;
        BigDecimal oldMoney;
        if (null == crpUrecharge) {
            throw new ApiException("service.crp.CrpUrechargeServiceImplupdateCrpUrechargemonery.", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (EmptyUtil.isEmpty((Object)crpUrecharge.getUrechargeId()) || StringUtils.isBlank((String)crpUrecharge.getRechargeUrl3())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateCrpUrechargemonery", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrecharge));
            throw new ApiException("service.crp.CrpUrechargeServiceImplupdateCrpUrechargemonery.", "\u53c2\u6570\u4e3a\u7a7a");
        }
        CrpUrecharge crpUrecharge1 = this.getCrpUrecharge(crpUrecharge.getUrechargeId());
        if (StringUtils.isBlank((String)crpUrecharge1.getRechargeUrl3())) {
            crpUrecharge1.setRechargeUrl3("0");
        }
        if ((oldMoney = new BigDecimal(crpUrecharge1.getRechargeUrl3())).compareTo(newMoney = new BigDecimal(crpUrecharge.getRechargeUrl3())) < 0) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateCrpUrechargemonery.newMoney", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrecharge1));
            throw new ApiException("service.crp.CrpUrechargeServiceImplupdateCrpUrechargemonery.", "\u6570\u636e\u9519\u8bef");
        }
        BigDecimal ulMoney = oldMoney.subtract(newMoney);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrecharge1.getTenantCode());
        map.put("urechargeCode", crpUrecharge1.getUrechargeCode());
        map.put("rechargeUrl3", ulMoney.toString());
        this.updateUlmoneyByCodes(map);
        return null;
    }

    @Override
    public CrpUrecharge queryCrpURechargeMoney(Map<String, Object> map) {
        try {
            return this.crpUrechargeMapper.queryCrpURechargeMoney(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.queryCrpURechargeMoney", (Throwable)e);
            return null;
        }
    }

    @Override
    public String updateCrpUrechargemoneryByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map) || null == map.get("userinfoCode")) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateCrpUrechargemoneryByCode", map);
            return "error";
        }
        this.loadDb(map);
        return "success";
    }

    @Override
    public String updateRefundmoneryByCode(CrpUrechargelistDomain crpUrechargelistDomain) {
        if (null == crpUrechargelistDomain || StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeName9())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelistDomain));
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        map.put("rechargeOpno", crpUrechargelistDomain.getRechargeOpno());
        map.put("urechargelistDir", crpUrechargelistDomain.getUrechargelistDir());
        QueryResult<CrpUrechargelist> queryResult = this.crpUrechargelistService.queryCrpUrechargelistPage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode", (Object)"queryResult is null");
            return "error";
        }
        CrpUrechargelist crpUrechargelist = (CrpUrechargelist)queryResult.getList().get(0);
        if (StringUtils.isBlank((String)crpUrechargelist.getRechargeName10()) || StringUtils.isBlank((String)crpUrechargelist.getRechargeOpno2())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode.crpUrechargelist", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelist));
            return "error";
        }
        BigDecimal money = new BigDecimal(crpUrechargelist.getRechargeName10());
        BigDecimal allMoney = new BigDecimal(crpUrechargelist.getRechargeOpno2());
        BigDecimal refundMoney = new BigDecimal(crpUrechargelist.getRechargeName9());
        BigDecimal refundSmoney = refundMoney.divide(allMoney, 8, RoundingMode.HALF_UP).multiply(money);
        crpUrechargelist.setUrechargelistId(null);
        crpUrechargelist.setUrechargelistCode(null);
        CrpUrechargelistDomain crpUrechargelistDomain1 = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain1, (Object)crpUrechargelist);
            crpUrechargelistDomain1.setUrechargelistDir("0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CrpUrecharge crpUrecharge = this.getCrpUrechargeByCode(crpUrechargelist.getTenantCode(), crpUrechargelist.getUrechargeCode());
        if (null == crpUrecharge) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode.crpUrecharge", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelist));
            return "error";
        }
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain1);
        crpUrecharge.setRechargeSmoney(crpUrecharge.getRechargeSmoney().add(refundSmoney));
        this.updateCrpModel(crpUrecharge);
        return "success";
    }

    private void updateCrpModeByModified(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByCodeAndModified(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private void updateStateMoneyByCodeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateMoneyByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateMoneyByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateMoneyByCodeModel.null", map.toString());
        }
    }

    private void updateUrechargeByCodeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateUrechargeByCodeModel(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateUrechargeByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateUrechargeByCodeModel.null", map.toString());
        }
    }

    private void updateStateMoneyByNegativeCodeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateMoneyByNegativeCodeModel(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateMoneyByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateStateMoneyByCodeModel.null", map.toString());
        }
    }

    private void updateUlmoneyByCodes(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateUlmoneyByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateUlmoneyByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateUlmoneyByCode.null");
        }
    }

    private boolean lockUrechargeData(Map<String, Object> map) {
        if (map.isEmpty()) {
            return false;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.lockDataByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.lockGoodsData", map.toString(), (Throwable)e);
        }
        return i > 0;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrecharges(Map<String, Object> map, BigDecimal money) throws ApiException {
        if (MapUtil.isEmpty(map) || null == money || "".equals(money) || null != map.get("rechargeOpcode") || null != map.get("rechargeRemark")) {
            throw new ApiException("service.crp.CrpUrechargeServiceImplupdateCrpUrecharges.urechargePage", JsonUtil.buildNonNullBinder().toJson(map) + "," + money);
        }
        String contractBillcode = map.get("rechargeOpcode").toString();
        String rechargeRemark = map.get("rechargeRemark").toString();
        BigDecimal payMoney = new BigDecimal(map.get("money").toString());
        map.remove("rechargeOpcode");
        map.remove("money");
        Boolean flags = true;
        QueryResult<CrpUrecharge> urechargePage = this.queryCrpUrechargePage(map);
        if (null == urechargePage || ListUtil.isEmpty((Collection)urechargePage.getList())) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail.urechargePage", JsonUtil.buildNonNullBinder().toJson(map) + "," + money);
        }
        CrpUrecharge urecharge = (CrpUrecharge)urechargePage.getList().get(0);
        BigDecimal newMoney = urecharge.getRechargeSmoney().subtract(money);
        if (newMoney.compareTo(BigDecimal.ZERO) <= 0) {
            newMoney = BigDecimal.ZERO;
            money = urecharge.getRechargeSmoney();
        }
        urecharge.setRechargeSmoney(newMoney);
        urecharge.setRechargeName10(money.toString());
        CrpUrecharge crpUrecha = this.getCrpUrecharge(urecharge.getUrechargeId());
        BigDecimal oldAllMoney = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((String)crpUrecha.getRechargeName10())) {
            oldAllMoney = new BigDecimal(crpUrecha.getRechargeName10());
        }
        if (StringUtils.isBlank((String)crpUrecha.getRechargeName10())) {
            crpUrecha.setRechargeName10("0");
        }
        oldAllMoney = oldAllMoney.add(new BigDecimal(crpUrecha.getRechargeName10()));
        urecharge.setRechargeName10(oldAllMoney.toString());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((String)urecharge.getRechargeUrl4())) {
            hashMap.put("rechargeUrl4Str", "1");
        } else {
            Integer integer = Integer.valueOf(urecharge.getRechargeUrl4());
            integer = integer + 1;
            hashMap.put("rechargeUrl4Str", integer.toString());
        }
        hashMap.put("tenantCode", urecharge.getTenantCode());
        hashMap.put("rechargeSmoney", urecharge.getRechargeSmoney());
        hashMap.put("rechargeName10", urecharge.getRechargeName10());
        hashMap.put("urechargeCode", urecharge.getUrechargeCode());
        hashMap.put("rechargeUrl4", urecharge.getRechargeUrl4());
        this.updateCrpModeByModified(hashMap);
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("contractBillcode", contractBillcode);
        objectMap.put("tenantCode", map.get("tenantCode"));
        if ("sgSendgoods".equals(rechargeRemark) && null != map.get("sendGoods")) {
            SgSendgoodsReDomain sendgoodsReDomain = (SgSendgoodsReDomain)map.get("sendGoods");
            if (null == sendgoodsReDomain) {
                throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpUrecharges.sendgoodsReDomain", JsonUtil.buildNonNullBinder().toJson(map));
            }
            HashMap<String, String> invokeMap = new HashMap<String, String>();
            invokeMap.put("sgSendgoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)sendgoodsReDomain));
            this.getInternalRouter().inInvoke("sg.sendgoods.updateSendgoods", objectMap);
        }
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain, (Object)urecharge);
            crpUrechargelistDomain.setUrechargelistDir("1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<CrpChannelsend> channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        this.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return channelsends;
    }

    @Override
    public String updateCrpUrechargesToOrder(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || null == map.get("crpUrechargelist") || "".equals(map.get("crpUrechargelist")) || null == map.get("crpUrechargelistCopy") || "".equals(map.get("crpUrechargelistCopy")) || EmptyUtil.isEmpty((Object)map.get("crpUrecharge"))) {
            throw new ApiException("service.crp.CrpUrechargeServiceImplupdateCrpUrechargesToOrder.map", JsonUtil.buildNonNullBinder().toJson(map));
        }
        String crpUrechargelist = JsonUtil.buildNonDefaultBinder().toJson(map.get("crpUrechargelist"));
        CrpUrechargelist crpUrechargelist1 = (CrpUrechargelist)JsonUtil.buildNonDefaultBinder().getJsonToObject(crpUrechargelist, CrpUrechargelist.class);
        String crpUrechargelistCopy = JsonUtil.buildNonDefaultBinder().toJson(map.get("crpUrechargelistCopy"));
        CrpUrechargelist crpUrechargelistCopy1 = (CrpUrechargelist)JsonUtil.buildNonDefaultBinder().getJsonToObject(crpUrechargelistCopy, CrpUrechargelist.class);
        String crpUrechargeCopy = JsonUtil.buildNonDefaultBinder().toJson(map.get("crpUrecharge"));
        CrpUrecharge crpUrecharge = (CrpUrecharge)JsonUtil.buildNonDefaultBinder().getJsonToObject(crpUrechargeCopy, CrpUrecharge.class);
        String uMoney = crpUrechargelistCopy1.getRechargeUrl4();
        if (StringUtils.isBlank((String)uMoney)) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail", JsonUtil.buildNonNullBinder().toJson(map));
        }
        BigDecimal newMoney = crpUrecharge.getRechargeSmoney().subtract(new BigDecimal(uMoney));
        if (newMoney.compareTo(BigDecimal.ZERO) < 0) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpRechargeDeail.urechargePage1", JsonUtil.buildNonNullBinder().toJson(map) + newMoney);
        }
        crpUrecharge.setRechargeSmoney(new BigDecimal(uMoney));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("tenantCode", crpUrecharge.getTenantCode());
        hashMap.put("rechargeSmoney", crpUrecharge.getRechargeSmoney());
        hashMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
        hashMap.put("type", "1");
        this.updateCrpModeByModified(hashMap);
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crpUrechargelistDomain, (Object)crpUrechargelistCopy1);
            crpUrechargelistDomain.setUrechargeCode(crpUrecharge.getUrechargeCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        this.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return "success";
    }

    @Override
    public void updateUlmoneyByCode(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("rechargeUrl3")) || EmptyUtil.isEmpty((Object)map.get("tenantCode")) || EmptyUtil.isEmpty((Object)map.get("urechargeCode"))) {
            throw new ApiException("service.crp.CrpUrechargeServiceImplupdateUlmoneyByCode.map", JsonUtil.buildNonNullBinder().toJson(map));
        }
        this.updateUlmoneyByCodes(map);
    }

    @Override
    public void updateCrpUrechargeAndList(CrpUrechargeReDomain crpUrechargeReDomain) throws ApiException {
        String msg = this.checkCrp(crpUrechargeReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpUrechargeAndList.checkCrp", msg);
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeReDomain, null);
        HashMap<String, Object> crpMap = new HashMap<String, Object>();
        crpMap.put("tenantCode", crpUrecharge.getTenantCode());
        crpMap.put("rechargeSmoney", crpUrecharge.getRechargeSmoney());
        crpMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
        crpMap.put("type", "5");
        this.logger.error("service.crp.CrpUrechargeServiceImpl.updateCrpUrechargeAndList.", (Object)JsonUtil.buildNormalBinder().toJson(crpMap));
        this.updateCrpModeByModified(crpMap);
    }

    @Override
    public void updateUrechargeBlanceByCode(Map<String, Object> map) throws ApiException {
        if (EmptyUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("tenantCode")) || EmptyUtil.isEmpty((Object)map.get("urechargeCode"))) {
            throw new ApiException("service.crp.CrpUrechargeServiceImplupdateUrechargeBlanceByCode.map", JsonUtil.buildNonNullBinder().toJson(map));
        }
        this.updateCrpModeByModified(map);
    }

    @Override
    public String updateCrpURechargeStr(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        if (null == crpUrechargelistDomain || StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeUrl4())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrechargelistDomain));
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpURechargeStr.crpUrechargelistDomain");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        map.put("rechargeType", crpUrechargelistDomain.getRechargeOpno2());
        map.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
        QueryResult<CrpUrecharge> queryResult = this.queryCrpUrechargePage(map);
        if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpURechargeStr.queryResult", JsonUtil.getNotDefJsonUtil().toJson(map));
        }
        BigDecimal uMoney = new BigDecimal(crpUrechargelistDomain.getRechargeUrl4());
        CrpUrecharge crpUrecharge = (CrpUrecharge)queryResult.getList().get(0);
        BigDecimal crpMoney = crpUrecharge.getRechargeSmoney().subtract(uMoney);
        if (crpMoney.compareTo(BigDecimal.ZERO) < 0) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.updateRefundmoneryByCode", (Object)(JsonUtil.buildNonDefaultBinder().toJson((Object)crpUrecharge) + "," + crpMoney));
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.updateCrpURechargeStr.queryResult", JsonUtil.getNotDefJsonUtil().toJson(map));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("tenantCode", crpUrecharge.getTenantCode());
        hashMap.put("rechargeSmoney", uMoney);
        hashMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
        hashMap.put("type", "1");
        this.updateCrpModeByModified(hashMap);
        return "success";
    }

    @Override
    public String saveOrUpdateCrpUrecharge(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        String dir;
        if (null == crpUrechargelistDomain || StringUtils.isBlank((String)crpUrechargelistDomain.getUserinfoCode()) || StringUtils.isBlank((String)crpUrechargelistDomain.getTenantCode())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.saveOrUpdateCrpUrecharge.null");
            return "";
        }
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeMode())) {
            crpUrechargelistDomain.setRechargeMode("0");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        map.put("rechargeMode", crpUrechargelistDomain.getRechargeMode());
        map.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
        List<CrpUrecharge> crpUrechargeList = this.queryCrpModelPage(map);
        String getddflag = FlagSettingUtils.getUrl(crpUrechargelistDomain.getTenantCode(), "CrpBalance", "CrpBalance");
        BigDecimal rechargeSmoney = BigDecimal.ZERO;
        rechargeSmoney = StringUtils.isNotBlank((String)getddflag) ? crpUrechargelistDomain.getRechargeAllmoney() : crpUrechargelistDomain.getRechargeSmoney();
        if (null == rechargeSmoney) {
            rechargeSmoney = BigDecimal.ZERO;
            crpUrechargelistDomain.setRechargeSmoney(rechargeSmoney);
        }
        if (StringUtils.isBlank((String)(dir = crpUrechargelistDomain.getUrechargelistDir()))) {
            dir = "0";
        }
        if ("1".equals(dir)) {
            rechargeSmoney = rechargeSmoney.multiply(new BigDecimal("-1"));
        }
        String type = "0";
        String rechargeType = crpUrechargelistDomain.getRechargeType();
        if ("0".equals(rechargeType)) {
            type = "3";
        } else if ("1".equals(rechargeType) || "2".equals(rechargeType)) {
            type = "1";
        } else if ("10".equals(rechargeType)) {
            type = "2";
        } else if ("6".equals(rechargeType)) {
            type = "0";
        }
        CrpUrecharge crpUrecharge = null;
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        BigDecimal allMoney = rechargeSmoney;
        if ("3".equals(type) && (da.compareTo(crpUrechargelistDomain.getRechargeStart()) < 0 || da.compareTo(crpUrechargelistDomain.getRechargeEnd()) > 0)) {
            this.logger.info("service.crp.CrpUrechargeServiceImpl.crpUrechargelistDomain.rechargeStart", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
            rechargeSmoney = BigDecimal.ZERO;
            allMoney = BigDecimal.ZERO;
        }
        if (ListUtil.isEmpty(crpUrechargeList)) {
            CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
            try {
                BeanUtils.copyAllPropertys((Object)crpUrechargeDomain, (Object)crpUrechargelistDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            crpUrechargeDomain.setRechargeAllmoney(rechargeSmoney);
            crpUrechargeDomain.setRechargeSmoney(rechargeSmoney);
            if (BigDecimal.ZERO.compareTo(rechargeSmoney) == 0) {
                crpUrechargeDomain.setRechargeEnd(null);
            }
            if ("-1".equals(crpUrechargelistDomain.getRechargeName10())) {
                crpUrechargeDomain.setRechargeSmoney(BigDecimal.ZERO);
                crpUrechargeDomain.setRechargeEnd(null);
            }
            crpUrecharge = this.saveCrpUrechargeRe(crpUrechargeDomain);
        } else {
            HashMap<String, Object> updatemap = new HashMap<String, Object>();
            crpUrecharge = crpUrechargeList.get(0);
            if (type.equals("3")) {
                if (EmptyUtil.isEmpty((Object)crpUrecharge.getRechargeEnd()) || crpUrechargelistDomain.getRechargeEnd().compareTo(crpUrecharge.getRechargeEnd()) > 0) {
                    updatemap.put("rechargeEnd", crpUrechargelistDomain.getRechargeEnd());
                }
                if ("-1".equals(crpUrechargelistDomain.getRechargeName10())) {
                    this.logger.error("service.crp.CrpUrechargeServiceImpl.rechargeName10.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
                    type = "7";
                    updatemap.put("allRechargeMoney", allMoney);
                    rechargeSmoney = BigDecimal.ZERO;
                    crpUrechargelistDomain.setRechargeEnd(null);
                }
            }
            updatemap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            updatemap.put("rechargeMode", crpUrechargelistDomain.getRechargeMode());
            if (StringUtils.isBlank((String)getddflag)) {
                updatemap.put("rechargeType", crpUrechargelistDomain.getRechargeType());
            }
            updatemap.put("urechargeCode", crpUrecharge.getUrechargeCode());
            updatemap.put("rechargeSmoney", rechargeSmoney);
            updatemap.put("rechargeStart", crpUrechargelistDomain.getRechargeStart());
            updatemap.put("rechargeEnd", crpUrechargelistDomain.getRechargeEnd());
            updatemap.put("type", type);
            this.logger.info("service.crp.CrpUrechargeServiceImpl.crpUrechargelistDomain.updateStateMoneyByCodeModel", (Object)JsonUtil.buildNormalBinder().toJson(updatemap));
            if (StringUtils.isNotBlank((String)getddflag)) {
                this.updateStateMoneyByNegativeCodeModel(updatemap);
            } else {
                this.updateStateMoneyByCodeModel(updatemap);
            }
        }
        return crpUrecharge.getUrechargeCode();
    }

    @Override
    public String saveOrUpdateCrpUrechargeToTime(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        String dir;
        if (null == crpUrechargelistDomain || StringUtils.isBlank((String)crpUrechargelistDomain.getUserinfoCode()) || StringUtils.isBlank((String)crpUrechargelistDomain.getTenantCode())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.saveOrUpdateCrpUrechargeToTime.null");
            return "";
        }
        if ("-1".equals(crpUrechargelistDomain.getRechargeName10())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.saveOrUpdateCrpUrechargeToTime.null", (Object)JsonUtil.buildNonNullBinder().toJson((Object)crpUrechargelistDomain));
            return "";
        }
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeMode())) {
            crpUrechargelistDomain.setRechargeMode("0");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        map.put("rechargeMode", crpUrechargelistDomain.getRechargeMode());
        map.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
        List<CrpUrecharge> crpUrechargeList = this.queryCrpModelPage(map);
        if (ListUtil.isEmpty(crpUrechargeList)) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.saveOrUpdateCrpUrechargeToTime.crpUrechargeList", map);
            throw new ApiException("service.crp.CrpUrechargeServiceImpl.saveOrUpdateCrpUrechargeToTime.null");
        }
        BigDecimal rechargeSmoney = crpUrechargelistDomain.getRechargeSmoney();
        BigDecimal rechargeAllmoney = crpUrechargelistDomain.getRechargeAllmoney();
        if (EmptyUtil.isEmpty((Object)rechargeAllmoney)) {
            rechargeAllmoney = BigDecimal.ZERO;
            crpUrechargelistDomain.setRechargeAllmoney(rechargeAllmoney);
        }
        if (EmptyUtil.isEmpty((Object)rechargeSmoney)) {
            rechargeSmoney = BigDecimal.ZERO;
            crpUrechargelistDomain.setRechargeSmoney(rechargeSmoney);
        }
        if (StringUtils.isBlank((String)(dir = crpUrechargelistDomain.getUrechargelistDir()))) {
            dir = "0";
        }
        if ("1".equals(dir)) {
            rechargeSmoney = rechargeSmoney.multiply(new BigDecimal("-1"));
            rechargeAllmoney = rechargeAllmoney.multiply(new BigDecimal("-1"));
        }
        String type = "7";
        CrpUrecharge crpUrecharge = null;
        crpUrecharge = crpUrechargeList.get(0);
        HashMap<String, Object> updatemap = new HashMap<String, Object>();
        updatemap.put("type", type);
        if ("1".equals(dir)) {
            updatemap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            updatemap.put("rechargeMode", crpUrechargelistDomain.getRechargeMode());
            updatemap.put("urechargeCode", crpUrecharge.getUrechargeCode());
            updatemap.put("rechargeSmoney", rechargeSmoney);
            updatemap.put("allRechargeMoney", rechargeAllmoney);
            if (!EmptyUtil.isEmpty((Object)crpUrecharge.getRechargeEnd()) && crpUrechargelistDomain.getRechargeEnd().compareTo(crpUrecharge.getRechargeEnd()) == 0) {
                updatemap.put("endtype", "7");
            }
            this.updateStateMoneyByCodeModel(updatemap);
        } else if ("0".equals(dir)) {
            updatemap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            updatemap.put("rechargeMode", crpUrechargelistDomain.getRechargeMode());
            updatemap.put("urechargeCode", crpUrecharge.getUrechargeCode());
            updatemap.put("rechargeSmoney", rechargeSmoney);
            updatemap.put("allRechargeMoney", rechargeAllmoney);
            if (EmptyUtil.isEmpty((Object)crpUrecharge.getRechargeEnd()) || crpUrechargelistDomain.getRechargeEnd().compareTo(crpUrecharge.getRechargeEnd()) > 0) {
                updatemap.put("rechargeEnd", crpUrechargelistDomain.getRechargeEnd());
            }
            if ("-1".equals(crpUrechargelistDomain.getRechargeName10())) {
                updatemap.remove("rechargeSmoney");
                updatemap.remove("rechargeEnd");
            }
            this.updateStateMoneyByCodeModel(updatemap);
        }
        this.logger.error("updatemap=====", (Object)JsonUtil.buildNormalBinder().toJson(updatemap));
        return crpUrecharge.getUrechargeCode();
    }

    @Override
    public void saveUrechargeBlance(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        Date start = crpUrechargelistDomain.getRechargeStart();
        Date end = crpUrechargelistDomain.getRechargeEnd();
        if (start.compareTo(da) > 0 || end.compareTo(da) < 0) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.saveCrpUrechargelistToBlance", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
            return;
        }
        if (!"0".equals(crpUrechargelistDomain.getRechargeName10())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.saveCrpUrechargelistToBlance.rechargeName5", (Object)JsonUtil.buildNormalBinder().toJson((Object)crpUrechargelistDomain));
            return;
        }
        HashMap map = new HashMap();
        HashMap<String, Object> stringObjectMap = new HashMap<String, Object>();
        stringObjectMap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        stringObjectMap.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
        stringObjectMap.put("rechargeMode", crpUrechargelistDomain.getRechargeMode());
        QueryResult<CrpUrecharge> queryResult = this.queryCrpUrechargePage(stringObjectMap);
        if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            CrpUrecharge crpUrecharge = (CrpUrecharge)queryResult.getList().get(0);
            BigDecimal decimal = BigDecimal.ZERO;
            if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeUrl4())) {
                crpUrechargelistDomain.setRechargeUrl4("0");
            }
            decimal = new BigDecimal(crpUrechargelistDomain.getRechargeUrl4());
            HashMap<String, Object> uMap = new HashMap<String, Object>();
            uMap.put("tenantCode", crpUrecharge.getTenantCode());
            uMap.put("urechargeCode", crpUrecharge.getUrechargeCode());
            uMap.put("userinfoCode", crpUrecharge.getUserinfoCode());
            uMap.put("rechargeSmoney", decimal);
            if ("25".equals(crpUrechargelistDomain.getRechargeType())) {
                uMap.put("type", "51");
            } else if ("26".equals(crpUrechargelistDomain.getRechargeType())) {
                uMap.put("type", "52");
            }
            this.updateUrechargeBlanceByCode(uMap);
        }
    }

    @Override
    public String updateCrpUrechargeByContract(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        String dir;
        BigDecimal rechargeSmoney = crpUrechargelistDomain.getRechargeSmoney();
        if (null == rechargeSmoney) {
            rechargeSmoney = BigDecimal.ZERO;
            crpUrechargelistDomain.setRechargeSmoney(rechargeSmoney);
        }
        if (StringUtils.isBlank((String)(dir = crpUrechargelistDomain.getUrechargelistDir()))) {
            dir = "0";
        }
        if ("1".equals(dir)) {
            rechargeSmoney = rechargeSmoney.multiply(new BigDecimal("-1"));
        }
        String type = "0";
        HashMap<String, Object> updatemap = new HashMap<String, Object>();
        updatemap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        updatemap.put("urechargeCode", crpUrechargelistDomain.getUrechargeCode());
        updatemap.put("rechargeSmoney", rechargeSmoney);
        updatemap.put("type", type);
        this.logger.info("service.crp.CrpUrechargeServiceImpl.crpUrechargelistDomain.updateStateMoneyByCodeModel", (Object)JsonUtil.buildNormalBinder().toJson(updatemap));
        this.updateStateMoneyByCodeModel(updatemap);
        return "success";
    }

    @Override
    public String saveOrUpdateCrpUrechargeB2B(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        String dir;
        if (null == crpUrechargelistDomain || StringUtils.isBlank((String)crpUrechargelistDomain.getUrechargeCode()) || StringUtils.isBlank((String)crpUrechargelistDomain.getTenantCode())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.saveOrUpdateCrpUrechargeB2B.null");
            return "";
        }
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeMode())) {
            crpUrechargelistDomain.setRechargeMode("0");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        map.put("urechargeCode", crpUrechargelistDomain.getUrechargeCode());
        List<CrpUrecharge> crpUrechargeList = this.queryCrpModelPage(map);
        BigDecimal rechargeSmoney = BigDecimal.ZERO;
        rechargeSmoney = crpUrechargelistDomain.getRechargeSmoney();
        if (null == rechargeSmoney) {
            rechargeSmoney = BigDecimal.ZERO;
            crpUrechargelistDomain.setRechargeSmoney(rechargeSmoney);
        }
        if (StringUtils.isBlank((String)(dir = crpUrechargelistDomain.getUrechargelistDir()))) {
            dir = "0";
        }
        if ("1".equals(dir)) {
            rechargeSmoney = rechargeSmoney.multiply(new BigDecimal("-1"));
        }
        String type = "0";
        String rechargeType = crpUrechargelistDomain.getRechargeType();
        if ("0".equals(rechargeType)) {
            type = "0";
        } else if ("2".equals(rechargeType)) {
            type = "2";
        } else if ("3".equals(rechargeType)) {
            type = "3";
        } else if ("4".equals(rechargeType) || "5".equals(rechargeType) || "6".equals(rechargeType)) {
            type = "4";
        }
        CrpUrecharge crpUrecharge = null;
        if (ListUtil.isEmpty(crpUrechargeList)) {
            CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
            try {
                BeanUtils.copyAllPropertys((Object)crpUrechargeDomain, (Object)crpUrechargelistDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            crpUrechargeDomain.setRechargeAllmoney(rechargeSmoney);
            crpUrechargeDomain.setRechargeSmoney(rechargeSmoney);
            crpUrecharge = this.saveCrpUrechargeRe(crpUrechargeDomain);
        } else {
            HashMap<String, Object> updatemap = new HashMap<String, Object>();
            crpUrecharge = crpUrechargeList.get(0);
            updatemap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            updatemap.put("urechargeCode", crpUrecharge.getUrechargeCode());
            updatemap.put("rechargeSmoney", rechargeSmoney);
            updatemap.put("type", type);
            this.logger.info("service.crp.CrpUrechargeServiceImpl.crpUrechargelistDomain.updateStateMoneyByCodeModel", (Object)JsonUtil.buildNormalBinder().toJson(updatemap));
            this.updateUrechargeByCodeModel(updatemap);
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("tenantCode", crpUrecharge.getTenantCode());
            map1.put("userinfoCode", crpUrecharge.getUserinfoCode());
            map1.put("rechargeType", crpUrecharge.getRechargeType());
            map1.put("channelCode", crpUrecharge.getChannelCode());
            map1.put("order", true);
            map1.put("orderStr", "RECHARGE_END  asc, RECHARGE_ID asc");
            List<CrpRecharge> crpRecharges = this.getCrpRechargeService().queryBmoney(map1);
            this.logger.info("service.crp.CrpUrechargeServiceImpl.crpUrechargelistDomain.getCrpRechargeService", (Object)JsonUtil.buildNormalBinder().toJson(map1));
            if (ListUtil.isNotEmpty(crpRecharges)) {
                CrpRecharge crpRecharge = crpRecharges.get(0);
                HashMap<String, Object> crpmap = new HashMap<String, Object>();
                crpmap.put("tenantCode", crpRecharge.getTenantCode());
                crpmap.put("rechargeCode", crpRecharge.getRechargeCode());
                crpmap.put("rechargeMoney", rechargeSmoney);
                crpmap.put("type", type);
                this.logger.info("service.crp.CrpUrechargeServiceImpl.crpUrechargelistDomain.updateStateByCodeAndModifiedByCode", (Object)JsonUtil.buildNormalBinder().toJson(crpmap));
                this.getCrpRechargeService().updateStateByCodeAndModifiedByCode(crpmap);
            } else {
                QueryResult<CrpRecharge> crpRechargeQueryResult = this.getCrpRechargeService().queryCrpPage(map1);
                if (ListUtil.isNotEmpty((Collection)crpRechargeQueryResult.getList())) {
                    CrpRecharge crpRecharge = crpRecharges.get(0);
                    HashMap<String, Object> crpmap = new HashMap<String, Object>();
                    crpmap.put("tenantCode", crpRecharge.getTenantCode());
                    crpmap.put("rechargeCode", crpRecharge.getRechargeCode());
                    crpmap.put("rechargeMoney", rechargeSmoney);
                    crpmap.put("type", type);
                    this.logger.info("service.crp.CrpUrechargeServiceImpl.crpUrechargelistDomain.updateStateByCodeAndModifiedByCode.str", (Object)JsonUtil.buildNormalBinder().toJson(crpmap));
                    this.getCrpRechargeService().updateStateByCodeAndModifiedByCode(crpmap);
                }
            }
        }
        return crpUrecharge.getUrechargeCode();
    }

    @Override
    public String saveApplyforOrUpdateCrpUrechargeB2B(CrpUrechargelistDomain crpUrechargelistDomain) throws ApiException {
        String dir;
        if (null == crpUrechargelistDomain || StringUtils.isBlank((String)crpUrechargelistDomain.getTenantCode())) {
            this.logger.error("service.crp.CrpUrechargeServiceImpl.saveApplyforOrUpdateCrpUrechargeB2B.null");
            return "";
        }
        if (StringUtils.isBlank((String)crpUrechargelistDomain.getRechargeMode())) {
            crpUrechargelistDomain.setRechargeMode("0");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", crpUrechargelistDomain.getTenantCode());
        map.put("userinfoCode", crpUrechargelistDomain.getUserinfoCode());
        map.put("rechargeType", crpUrechargelistDomain.getRechargeType());
        map.put("channelCode", crpUrechargelistDomain.getChannelCode());
        List<CrpUrecharge> crpUrechargeList = this.queryCrpModelPage(map);
        BigDecimal rechargeSmoney = BigDecimal.ZERO;
        rechargeSmoney = crpUrechargelistDomain.getRechargeSmoney();
        if (null == rechargeSmoney) {
            rechargeSmoney = BigDecimal.ZERO;
            crpUrechargelistDomain.setRechargeSmoney(rechargeSmoney);
        }
        if (StringUtils.isBlank((String)(dir = crpUrechargelistDomain.getUrechargelistDir()))) {
            dir = "0";
        }
        if ("1".equals(dir)) {
            rechargeSmoney = rechargeSmoney.multiply(new BigDecimal("-1"));
        }
        String type = "10";
        CrpUrecharge crpUrecharge = null;
        if (ListUtil.isEmpty(crpUrechargeList)) {
            CrpUrechargeDomain crpUrechargeDomain = new CrpUrechargeDomain();
            try {
                BeanUtils.copyAllPropertys((Object)crpUrechargeDomain, (Object)crpUrechargelistDomain);
            }
            catch (Exception exception) {
                // empty catch block
            }
            crpUrechargeDomain.setRechargeAllmoney(rechargeSmoney);
            crpUrechargeDomain.setRechargeSmoney(rechargeSmoney);
            crpUrecharge = this.saveCrpUrechargeRe(crpUrechargeDomain);
        } else {
            HashMap<String, Object> updatemap = new HashMap<String, Object>();
            crpUrecharge = crpUrechargeList.get(0);
            updatemap.put("rechargeName10", crpUrechargelistDomain.getRechargeName10());
            updatemap.put("rechargeName2", crpUrechargelistDomain.getRechargeName2());
            updatemap.put("rechargeName4", crpUrechargelistDomain.getRechargeName4());
            updatemap.put("rechargeStart", crpUrechargelistDomain.getRechargeStart());
            updatemap.put("rechargeEnd", crpUrechargelistDomain.getRechargeEnd());
            updatemap.put("tenantCode", crpUrechargelistDomain.getTenantCode());
            updatemap.put("urechargeCode", crpUrecharge.getUrechargeCode());
            updatemap.put("rechargeSmoney", rechargeSmoney);
            updatemap.put("type", type);
            this.logger.info("service.crp.CrpUrechargeServiceImpl.saveApplyforOrUpdateCrpUrechargeB2B.updateStateMoneyByCodeModel", (Object)JsonUtil.buildNormalBinder().toJson(updatemap));
            this.updateUrechargeByCodeModel(updatemap);
        }
        return crpUrecharge.getUrechargeCode();
    }

    static {
        lock = new Object();
    }
}

