/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.dao.CrpUrechargePeriodMapper;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargePeriodDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargePeriodReDomain;
import com.yqbsoft.laser.service.crp.model.CrpUrechargePeriod;
import com.yqbsoft.laser.service.crp.service.CrpUrechargePeriodService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpUrechargePeriodServiceImpl
extends BaseServiceImpl
implements CrpUrechargePeriodService {
    private static final String SYS_CODE = "service.crp.CrpUrechargePeriodServiceImpl";
    private CrpUrechargePeriodMapper crpUrechargePeriodMapper;

    public void setCrpUrechargePeriodMapper(CrpUrechargePeriodMapper crpUrechargePeriodMapper) {
        this.crpUrechargePeriodMapper = crpUrechargePeriodMapper;
    }

    private Date getSysDate() {
        try {
            return new Date();
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargePeriodServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpUrechargePeriodDomain crpUrechargePeriodDomain) {
        if (null == crpUrechargePeriodDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpUrechargePeriodDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpUrechargePeriod crpUrechargePeriod) {
        if (null == crpUrechargePeriod) {
            return;
        }
        if (null == crpUrechargePeriod.getDataState()) {
            crpUrechargePeriod.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crpUrechargePeriod.getGmtCreate()) {
            crpUrechargePeriod.setGmtCreate(date);
        }
        crpUrechargePeriod.setGmtModified(date);
        if (StringUtils.isBlank((String)crpUrechargePeriod.getUrechargePeriodCode())) {
            crpUrechargePeriod.setUrechargePeriodCode(this.getNo(null, "CrpUrechargePeriod", "crpUrechargePeriod", crpUrechargePeriod.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpUrechargePeriodMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargePeriodServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpUrechargePeriod crpUrechargePeriod) {
        if (null == crpUrechargePeriod) {
            return;
        }
        crpUrechargePeriod.setGmtModified(this.getSysDate());
    }

    private void saveCrpModel(CrpUrechargePeriod crpUrechargePeriod) throws ApiException {
        if (null == crpUrechargePeriod) {
            return;
        }
        try {
            this.crpUrechargePeriodMapper.insert(crpUrechargePeriod);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpUrechargePeriod> crpUrechargePeriodList) throws ApiException {
        if (null == crpUrechargePeriodList || crpUrechargePeriodList.isEmpty()) {
            return;
        }
        try {
            this.crpUrechargePeriodMapper.insertBatch(crpUrechargePeriodList);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpUrechargePeriod getCrpModelById(Integer urechargePeriodId) {
        if (null == urechargePeriodId) {
            return null;
        }
        try {
            return this.crpUrechargePeriodMapper.selectByPrimaryKey(urechargePeriodId);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargePeriodServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrechargePeriod getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpUrechargePeriodMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargePeriodServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargePeriodMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer urechargePeriodId) throws ApiException {
        if (null == urechargePeriodId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargePeriodMapper.deleteByPrimaryKey(urechargePeriodId);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpUrechargePeriod crpUrechargePeriod) throws ApiException {
        if (null == crpUrechargePeriod) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargePeriodMapper.updateByPrimaryKey(crpUrechargePeriod);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer urechargePeriodId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == urechargePeriodId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargePeriodId", urechargePeriodId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargePeriodMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String urechargePeriodCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)urechargePeriodCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargePeriodCode", urechargePeriodCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargePeriodMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpUrechargePeriod makeCrp(CrpUrechargePeriodDomain crpUrechargePeriodDomain, CrpUrechargePeriod crpUrechargePeriod) {
        if (null == crpUrechargePeriodDomain) {
            return null;
        }
        if (null == crpUrechargePeriod) {
            crpUrechargePeriod = new CrpUrechargePeriod();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargePeriod, (Object)crpUrechargePeriodDomain);
            return crpUrechargePeriod;
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargePeriodServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpUrechargePeriodReDomain makeCrpUrechargePeriodReDomain(CrpUrechargePeriod crpUrechargePeriod) {
        if (null == crpUrechargePeriod) {
            return null;
        }
        CrpUrechargePeriodReDomain crpUrechargePeriodReDomain = new CrpUrechargePeriodReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargePeriodReDomain, (Object)crpUrechargePeriod);
            return crpUrechargePeriodReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargePeriodServiceImpl.makeCrpUrechargePeriodReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrechargePeriod> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpUrechargePeriodMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargePeriodServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargePeriodMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crp.CrpUrechargePeriodServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpUrechargePeriod createCrpUrechargePeriod(CrpUrechargePeriodDomain crpUrechargePeriodDomain) {
        String msg = this.checkCrp(crpUrechargePeriodDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpUrechargePeriod crpUrechargePeriod = this.makeCrp(crpUrechargePeriodDomain, null);
        this.setCrpDefault(crpUrechargePeriod);
        return crpUrechargePeriod;
    }

    @Override
    public String saveCrpUrechargePeriod(CrpUrechargePeriodDomain crpUrechargePeriodDomain) throws ApiException {
        CrpUrechargePeriod crpUrechargePeriod = this.createCrpUrechargePeriod(crpUrechargePeriodDomain);
        this.saveCrpModel(crpUrechargePeriod);
        return crpUrechargePeriod.getUrechargePeriodCode();
    }

    @Override
    public String saveCrpUrechargePeriodBatch(List<CrpUrechargePeriodDomain> crpUrechargePeriodDomainList) throws ApiException {
        if (null == crpUrechargePeriodDomainList || crpUrechargePeriodDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpUrechargePeriod> crpUrechargePeriodList = new ArrayList<CrpUrechargePeriod>();
        String code = "";
        for (CrpUrechargePeriodDomain crpUrechargePeriodDomain : crpUrechargePeriodDomainList) {
            CrpUrechargePeriod crpUrechargePeriod = this.createCrpUrechargePeriod(crpUrechargePeriodDomain);
            code = crpUrechargePeriod.getUrechargePeriodCode();
            crpUrechargePeriodList.add(crpUrechargePeriod);
        }
        this.saveCrpBatchModel(crpUrechargePeriodList);
        return code;
    }

    @Override
    public void updateCrpUrechargePeriodState(Integer urechargePeriodId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == urechargePeriodId) {
            return;
        }
        this.updateStateCrpModel(urechargePeriodId, dataState, oldDataState, map);
    }

    @Override
    public void updateCrpUrechargePeriodStateByCode(String tenantCode, String urechargePeriodCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)urechargePeriodCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCrpModelByCode(tenantCode, urechargePeriodCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCrpUrechargePeriod(CrpUrechargePeriodDomain crpUrechargePeriodDomain) throws ApiException {
        String msg = this.checkCrp(crpUrechargePeriodDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpUrechargePeriod oldCrpUrechargePeriod = this.getCrpModelById(crpUrechargePeriodDomain.getUrechargePeriodId());
        if (null == oldCrpUrechargePeriod) {
            throw new ApiException("service.crp.CrpUrechargePeriodServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrechargePeriod crpUrechargePeriod = this.makeCrp(crpUrechargePeriodDomain, oldCrpUrechargePeriod);
        this.setCrpUpdataDefault(crpUrechargePeriod);
        this.updateCrpModel(crpUrechargePeriod);
    }

    @Override
    public CrpUrechargePeriod getCrpUrechargePeriod(Integer urechargePeriodId) {
        if (null == urechargePeriodId) {
            return null;
        }
        return this.getCrpModelById(urechargePeriodId);
    }

    @Override
    public void deleteCrpUrechargePeriod(Integer urechargePeriodId) throws ApiException {
        if (null == urechargePeriodId) {
            return;
        }
        this.deleteCrpModel(urechargePeriodId);
    }

    @Override
    public QueryResult<CrpUrechargePeriod> queryCrpUrechargePeriodPage(Map<String, Object> map) {
        List<CrpUrechargePeriod> crpUrechargePeriodList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargePeriodList);
        return queryResult;
    }

    @Override
    public CrpUrechargePeriod getCrpUrechargePeriodByCode(String tenantCode, String urechargePeriodCode) throws ApiException {
        if (StringUtils.isBlank((String)urechargePeriodCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargePeriodCode", urechargePeriodCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public void deleteCrpUrechargePeriodByCode(String tenantCode, String urechargePeriodCode) throws ApiException {
        if (StringUtils.isBlank((String)urechargePeriodCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargePeriodCode", urechargePeriodCode);
        this.delCrpModelByCode(map);
    }
}

