/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaIfbStatisticsMapper;
import com.yqbsoft.laser.service.data.domain.DaIfbStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.DaIfbStatisticsReDomain;
import com.yqbsoft.laser.service.data.model.DaIfbStatistics;
import com.yqbsoft.laser.service.data.service.DaIfbStatisticsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaIfbStatisticsServiceImpl
extends BaseServiceImpl
implements DaIfbStatisticsService {
    private static final String SYS_CODE = SYS_CODE + ".DaIfbStatisticsServiceImpl";
    private DaIfbStatisticsMapper daIfbStatisticsMapper;

    public void setDaIfbStatisticsMapper(DaIfbStatisticsMapper daIfbStatisticsMapper) {
        this.daIfbStatisticsMapper = daIfbStatisticsMapper;
    }

    private Date getSysDate() {
        try {
            return this.daIfbStatisticsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkIfbStatistics(DaIfbStatisticsDomain daIfbStatisticsDomain) {
        if (null == daIfbStatisticsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daIfbStatisticsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setIfbStatisticsDefault(DaIfbStatistics daIfbStatistics) {
        if (null == daIfbStatistics) {
            return;
        }
        if (null == daIfbStatistics.getDataState()) {
            daIfbStatistics.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daIfbStatistics.getGmtCreate()) {
            daIfbStatistics.setGmtCreate(date);
        }
        daIfbStatistics.setGmtModified(date);
        if (StringUtils.isBlank((String)daIfbStatistics.getIfstCode())) {
            daIfbStatistics.setIfstCode(this.getNo(null, "DaIfbStatistics", "daIfbStatistics", daIfbStatistics.getTenantCode()));
        }
    }

    private int getIfbStatisticsMaxCode() {
        int code = 0;
        try {
            return this.daIfbStatisticsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getIfbStatisticsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setIfbStatisticsUpdataDefault(DaIfbStatistics daIfbStatistics) {
        if (null == daIfbStatistics) {
            return;
        }
        daIfbStatistics.setGmtModified(this.getSysDate());
    }

    private void saveIfbStatisticsModel(DaIfbStatistics daIfbStatistics) throws ApiException {
        if (null == daIfbStatistics) {
            return;
        }
        try {
            this.daIfbStatisticsMapper.insert(daIfbStatistics);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveIfbStatisticsModel.ex", (Throwable)e);
        }
    }

    private void saveIfbStatisticsBatchModel(List<DaIfbStatistics> daIfbStatisticsList) throws ApiException {
        if (null == daIfbStatisticsList || daIfbStatisticsList.isEmpty()) {
            return;
        }
        try {
            this.daIfbStatisticsMapper.insertBatch(daIfbStatisticsList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveIfbStatisticsBatchModel.ex", (Throwable)e);
        }
    }

    private DaIfbStatistics getIfbStatisticsModelById(Integer ifstId) {
        if (null == ifstId) {
            return null;
        }
        try {
            return this.daIfbStatisticsMapper.selectByPrimaryKey(ifstId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getIfbStatisticsModelById", (Throwable)e);
            return null;
        }
    }

    private DaIfbStatistics getIfbStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daIfbStatisticsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getIfbStatisticsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delIfbStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daIfbStatisticsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delIfbStatisticsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delIfbStatisticsModelByCode.num");
        }
    }

    private void deleteIfbStatisticsModel(Integer ifstId) throws ApiException {
        if (null == ifstId) {
            return;
        }
        int i = 0;
        try {
            i = this.daIfbStatisticsMapper.deleteByPrimaryKey(ifstId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteIfbStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteIfbStatisticsModel.num");
        }
    }

    private void updateIfbStatisticsModel(DaIfbStatistics daIfbStatistics) throws ApiException {
        if (null == daIfbStatistics) {
            return;
        }
        int i = 0;
        try {
            i = this.daIfbStatisticsMapper.updateByPrimaryKey(daIfbStatistics);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateIfbStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateIfbStatisticsModel.num");
        }
    }

    private void updateStateIfbStatisticsModel(Integer ifstId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ifstId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ifstId", ifstId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daIfbStatisticsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateIfbStatisticsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateIfbStatisticsModel.null");
        }
    }

    private void updateStateIfbStatisticsModelByCode(String tenantCode, String ifstCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ifstCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ifstCode", ifstCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daIfbStatisticsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateIfbStatisticsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateIfbStatisticsModelByCode.null");
        }
    }

    private DaIfbStatistics makeIfbStatistics(DaIfbStatisticsDomain daIfbStatisticsDomain, DaIfbStatistics daIfbStatistics) {
        if (null == daIfbStatisticsDomain) {
            return null;
        }
        if (null == daIfbStatistics) {
            daIfbStatistics = new DaIfbStatistics();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daIfbStatistics, (Object)daIfbStatisticsDomain);
            return daIfbStatistics;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeIfbStatistics", (Throwable)e);
            return null;
        }
    }

    private DaIfbStatisticsReDomain makeDaIfbStatisticsReDomain(DaIfbStatistics daIfbStatistics) {
        if (null == daIfbStatistics) {
            return null;
        }
        DaIfbStatisticsReDomain daIfbStatisticsReDomain = new DaIfbStatisticsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daIfbStatisticsReDomain, (Object)daIfbStatistics);
            return daIfbStatisticsReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaIfbStatisticsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaIfbStatistics> queryIfbStatisticsModelPage(Map<String, Object> parammap) {
        try {
            return this.daIfbStatisticsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryIfbStatisticsModel", (Throwable)e);
            return null;
        }
    }

    private int countIfbStatistics(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daIfbStatisticsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countIfbStatistics", (Throwable)e);
        }
        return i;
    }

    private DaIfbStatistics createDaIfbStatistics(DaIfbStatisticsDomain daIfbStatisticsDomain) {
        String msg = this.checkIfbStatistics(daIfbStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveIfbStatistics.checkIfbStatistics", msg);
        }
        DaIfbStatistics daIfbStatistics = this.makeIfbStatistics(daIfbStatisticsDomain, null);
        this.setIfbStatisticsDefault(daIfbStatistics);
        return daIfbStatistics;
    }

    @Override
    public String saveIfbStatistics(DaIfbStatisticsDomain daIfbStatisticsDomain) throws ApiException {
        DaIfbStatistics daIfbStatistics = this.createDaIfbStatistics(daIfbStatisticsDomain);
        this.saveIfbStatisticsModel(daIfbStatistics);
        return daIfbStatistics.getIfstCode();
    }

    @Override
    public String saveIfbStatisticsBatch(List<DaIfbStatisticsDomain> daIfbStatisticsDomainList) throws ApiException {
        if (null == daIfbStatisticsDomainList || daIfbStatisticsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaIfbStatistics> daIfbStatisticsList = new ArrayList<DaIfbStatistics>();
        String code = "";
        for (DaIfbStatisticsDomain daIfbStatisticsDomain : daIfbStatisticsDomainList) {
            DaIfbStatistics daIfbStatistics = this.createDaIfbStatistics(daIfbStatisticsDomain);
            code = daIfbStatistics.getIfstCode();
            daIfbStatisticsList.add(daIfbStatistics);
        }
        this.saveIfbStatisticsBatchModel(daIfbStatisticsList);
        return code;
    }

    @Override
    public void updateIfbStatisticsState(Integer ifstId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ifstId) {
            return;
        }
        this.updateStateIfbStatisticsModel(ifstId, dataState, oldDataState, map);
    }

    @Override
    public void updateIfbStatisticsStateByCode(String tenantCode, String ifstCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ifstCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateIfbStatisticsModelByCode(tenantCode, ifstCode, dataState, oldDataState, map);
    }

    @Override
    public void updateIfbStatistics(DaIfbStatisticsDomain daIfbStatisticsDomain) throws ApiException {
        String msg = this.checkIfbStatistics(daIfbStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateIfbStatistics.checkIfbStatistics", msg);
        }
        DaIfbStatistics oldDaIfbStatistics = this.getIfbStatisticsModelById(daIfbStatisticsDomain.getIfstId());
        if (null == oldDaIfbStatistics) {
            throw new ApiException(SYS_CODE + ".updateIfbStatistics.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaIfbStatistics daIfbStatistics = this.makeIfbStatistics(daIfbStatisticsDomain, oldDaIfbStatistics);
        this.setIfbStatisticsUpdataDefault(daIfbStatistics);
        this.updateIfbStatisticsModel(daIfbStatistics);
    }

    @Override
    public DaIfbStatistics getIfbStatistics(Integer ifstId) {
        if (null == ifstId) {
            return null;
        }
        return this.getIfbStatisticsModelById(ifstId);
    }

    @Override
    public void deleteIfbStatistics(Integer ifstId) throws ApiException {
        if (null == ifstId) {
            return;
        }
        this.deleteIfbStatisticsModel(ifstId);
    }

    @Override
    public QueryResult<DaIfbStatistics> queryIfbStatisticsPage(Map<String, Object> map) {
        List<DaIfbStatistics> daIfbStatisticsList = this.queryIfbStatisticsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countIfbStatistics(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daIfbStatisticsList);
        return queryResult;
    }

    @Override
    public DaIfbStatistics getIfbStatisticsByCode(String tenantCode, String ifstCode) throws ApiException {
        if (StringUtils.isBlank((String)ifstCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ifstCode", ifstCode);
        return this.getIfbStatisticsModelByCode(map);
    }

    @Override
    public void deleteIfbStatisticsByCode(String tenantCode, String ifstCode) throws ApiException {
        if (StringUtils.isBlank((String)ifstCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ifstCode", ifstCode);
        this.delIfbStatisticsModelByCode(map);
    }
}

